/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiixLanguage
implements Serializable {
    public static final Locale OLD_US_ENGLISH = new Locale("US", "en");
    public static final Locale US_ENGLISH = Locale.US;
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale DEFAULT_LOCALE = new Locale("", "");
    public static final Locale OLD_FR_FRENCH = new Locale("FR", "fr");
    public static final Locale FR_FRENCH = Locale.FRANCE;
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale ARABIC = new Locale("ar", "");
    public static final Locale IN_BENGALI = new Locale("bn", "");
    public static final Locale BR_PORTUGUESE = new Locale("pt", "BR");
    public static final Locale BULGARIAN = new Locale("bg", "");
    public static final Locale OLD_BULGARIAN = new Locale("bg", "bd");
    public static final Locale CA_FRENCH = Locale.CANADA_FRENCH;
    public static final Locale CATALAN = new Locale("ca", "");
    public static final Locale CROATIAN = new Locale("hr", "");
    public static final Locale OLD_CROATIAN = new Locale("co", "");
    public static final Locale CZEH = new Locale("cs", "");
    public static final Locale DANISH = new Locale("da", "");
    public static final Locale DUTCH = new Locale("nl", "");
    public static final Locale EGYPTIAN = new Locale("ar", "EG");
    public static final Locale GB_ENGLISH = new Locale("en", "GB");
    public static final Locale ESTONIAN = new Locale("et", "");
    public static final Locale FINNISH = new Locale("fi", "");
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale GREEK = new Locale("el", "");
    public static final Locale HEBREW = new Locale("iw", "");
    public static final Locale HUNGARIAN = new Locale("hu", "");
    public static final Locale ICELANDIC = new Locale("is", "");
    public static final Locale INDONESIAN = new Locale("id", "");
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale JAPANESE = Locale.JAPANESE;
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale AR_SPANISH = new Locale("es", "");
    public static final Locale LATVIAN = new Locale("lv", "");
    public static final Locale LITHUANIAN = new Locale("lt", "");
    public static final Locale MALAY = new Locale("ms", "");
    public static final Locale MX_SPANISH = new Locale("es", "MX");
    public static final Locale NORWEGIAN = new Locale("no", "");
    public static final Locale POLISH = new Locale("pl", "");
    public static final Locale PORTUGUESE = new Locale("pt", "");
    public static final Locale ROMANIAN = new Locale("ro", "");
    public static final Locale RUSSIAN = new Locale("ru", "");
    public static final Locale SMP_CHIN = Locale.SIMPLIFIED_CHINESE;
    public static final Locale SLOVAK = new Locale("sk", "");
    public static final Locale SLOVENIAN = new Locale("sl", "");
    public static final Locale SPANISH = new Locale("es", "ES");
    public static final Locale SWEDISH = new Locale("sv", "");
    public static final Locale TAMIL = new Locale("ta", "");
    public static final Locale THAI = new Locale("th", "");
    public static final Locale TR_CHIN = Locale.TRADITIONAL_CHINESE;
    public static final Locale TURKISH = new Locale("tr", "");
    public static final Locale UKRANINAN = new Locale("uk", "");
    public static final Locale VIETNAMESE = new Locale("vi", "");
    static final Locale[] m_oSupportedLanguages = new Locale[]{ENGLISH, FRENCH, ARABIC, IN_BENGALI, BR_PORTUGUESE, BULGARIAN, CA_FRENCH, CATALAN, CROATIAN, CZEH, DANISH, DUTCH, EGYPTIAN, GB_ENGLISH, ESTONIAN, FINNISH, GERMAN, GREEK, HEBREW, HUNGARIAN, ICELANDIC, INDONESIAN, ITALIAN, JAPANESE, KOREAN, AR_SPANISH, LATVIAN, LITHUANIAN, MALAY, MX_SPANISH, NORWEGIAN, POLISH, PORTUGUESE, ROMANIAN, RUSSIAN, SMP_CHIN, SLOVAK, SLOVENIAN, SPANISH, SWEDISH, THAI, TR_CHIN, TURKISH, UKRANINAN, VIETNAMESE};
    private static Hashtable m_oSupportedLangTable = null;
    static final Locale[] m_oOldSupportedLanguages = new Locale[]{OLD_US_ENGLISH, OLD_FR_FRENCH, OLD_BULGARIAN, OLD_CROATIAN, US_ENGLISH, FR_FRENCH};
    static final Locale[] m_oOUISupportedLanguages = new Locale[]{AR_SPANISH, BR_PORTUGUESE, ENGLISH, FRENCH, GERMAN, ITALIAN, JAPANESE, KOREAN, SMP_CHIN, TR_CHIN};
    private static Hashtable m_oldSupportTable;
    public static String ALL_LANGS;

    public static Locale getLocaleInstance(Locale l) {
        Locale lorg;
        if (m_oSupportedLangTable == null) {
            m_oSupportedLangTable = new Hashtable(45, 1.0f);
            for (int i = 0; i < m_oSupportedLanguages.length; ++i) {
                m_oSupportedLangTable.put(m_oSupportedLanguages[i].toString(), m_oSupportedLanguages[i]);
            }
        }
        if (l != null && (lorg = (Locale)m_oSupportedLangTable.get(l.toString())) != null) {
            return lorg;
        }
        return l;
    }

    public static Locale[] getSupportedLanguages() {
        return m_oOUISupportedLanguages;
    }

    public static Locale[] getLanguages() {
        return m_oSupportedLanguages;
    }

    public static Locale[] getOldLanguages() {
        return m_oOldSupportedLanguages;
    }

    public static String[] getUpdatedLangs23(String[] asSelLangs) {
        String[] asOUISelLangs = asSelLangs;
        boolean bFoundSpanish = false;
        boolean bFoundFrench = false;
        boolean bAddES = true;
        boolean bAddESES = true;
        boolean bAddFR = true;
        boolean bAddFRCA = true;
        String sFrench = FRENCH.toString();
        String sFrenchCA = CA_FRENCH.toString();
        String sSpanish = SPANISH.toString();
        String sSpanishAR = AR_SPANISH.toString();
        int delta = 0;
        if (asSelLangs != null) {
            for (int i = 0; i < asSelLangs.length; ++i) {
                if (asSelLangs[i].equals(sFrench)) {
                    bFoundFrench = true;
                    bAddFR = false;
                    continue;
                }
                if (asSelLangs[i].equals(sFrenchCA)) {
                    bFoundFrench = true;
                    bAddFRCA = false;
                    continue;
                }
                if (asSelLangs[i].equals(sSpanishAR)) {
                    bFoundSpanish = true;
                    bAddES = false;
                    continue;
                }
                if (!asSelLangs[i].equals(sSpanish)) continue;
                bFoundSpanish = true;
                bAddESES = false;
            }
            if (bFoundSpanish) {
                if (bAddES) {
                    ++delta;
                }
                if (bAddESES) {
                    ++delta;
                }
            }
            if (bFoundFrench) {
                if (bAddFR) {
                    ++delta;
                }
                if (bAddFRCA) {
                    ++delta;
                }
            }
            if (delta > 0) {
                asOUISelLangs = new String[asSelLangs.length + delta];
                System.arraycopy(asSelLangs, 0, asOUISelLangs, 0, asSelLangs.length);
                int offset = asSelLangs.length;
                if (bFoundSpanish) {
                    if (bAddESES) {
                        asOUISelLangs[offset] = sSpanish;
                        ++offset;
                    }
                    if (bAddES) {
                        asOUISelLangs[offset] = sSpanishAR;
                        ++offset;
                    }
                }
                if (bFoundFrench) {
                    if (bAddFR) {
                        asOUISelLangs[offset] = sFrench;
                        ++offset;
                    }
                    if (bAddFRCA) {
                        asOUISelLangs[offset] = sFrenchCA;
                        ++offset;
                    }
                }
            }
        }
        return asOUISelLangs;
    }

    public static String getDisplayName(Locale l) {
        return OiixResourceBundle.getString("S_LANGUAGE_" + l.toString());
    }

    public static Locale getLocaleFromDisplayName(String sOther) {
        for (int i = 0; i < m_oSupportedLanguages.length; ++i) {
            String sLang = OiixResourceBundle.getString("S_LANGUAGE_" + m_oSupportedLanguages[i].toString());
            if (!sLang.equals(sOther)) continue;
            return m_oSupportedLanguages[i];
        }
        return Locale.getDefault();
    }

    public static Locale getCompatibleLocale(Locale l) {
        if (m_oldSupportTable == null) {
            m_oldSupportTable = OiixLanguage.buildOldSupportTable();
        }
        return (Locale)m_oldSupportTable.get(l);
    }

    private static Hashtable buildOldSupportTable() {
        Hashtable<Locale, Locale> table = new Hashtable<Locale, Locale>();
        table.put(OLD_US_ENGLISH, ENGLISH);
        table.put(US_ENGLISH, ENGLISH);
        table.put(OLD_FR_FRENCH, FRENCH);
        table.put(FR_FRENCH, FRENCH);
        table.put(OLD_BULGARIAN, BULGARIAN);
        table.put(OLD_CROATIAN, CROATIAN);
        return table;
    }

    public static String toEncStr(Locale loc) {
        return loc.getLanguage() + ":" + loc.getCountry() + ":" + loc.getVariant();
    }

    public static Locale fromEncStr(String str) {
        int[] colPos;
        colPos = new int[]{str.indexOf(":"), str.indexOf(":", colPos[0] + 1)};
        String lang = str.substring(0, colPos[0]);
        String country = str.substring(colPos[0] + 1, colPos[1]);
        String variant = str.substring(colPos[1] + 1);
        Locale loc = variant.equals("") ? new Locale(lang, country) : new Locale(lang, country, variant);
        return loc;
    }

    public static String vectToStr(Vector vLocales) {
        int nSize = vLocales.size();
        if (nSize == m_oSupportedLanguages.length) {
            return ALL_LANGS;
        }
        StringBuffer sbLangs = new StringBuffer();
        for (int i = 0; i < nSize; ++i) {
            Locale l = (Locale)vLocales.elementAt(i);
            sbLangs.append(l.toString());
            if (i >= nSize - 1) continue;
            sbLangs.append(" ");
        }
        return sbLangs.toString();
    }

    public static Vector strToVect(String sLangs) {
        Vector<Locale> vLangs = new Vector<Locale>();
        if (sLangs == null || sLangs.trim().length() == 0) {
            return vLangs;
        }
        if (sLangs.equals(ALL_LANGS)) {
            Locale[] aLoc = m_oSupportedLanguages;
            for (int i = 0; i < m_oSupportedLanguages.length; ++i) {
                vLangs.addElement(OiixLanguage.getLocaleInstance(m_oSupportedLanguages[i]));
            }
            return vLangs;
        }
        sLangs = sLangs.trim();
        StringTokenizer st = new StringTokenizer(sLangs, " ");
        while (st.hasMoreTokens()) {
            String sLang = st.nextToken();
            String sCountry = "";
            int n = -1;
            n = sLang.indexOf("_");
            if (n != -1) {
                sCountry = sLang.substring(n + 1);
                sLang = sLang.substring(0, n);
            }
            Locale l = new Locale(sLang, sCountry);
            l = OiixLanguage.getLocaleInstance(l);
            vLangs.addElement(l);
        }
        return vLangs;
    }

    public static String[] getStringArray(Vector oVect) {
        int i = 0;
        if (oVect == null) {
            return null;
        }
        i = oVect.size();
        String[] strList = new String[i];
        for (int j = 0; j < i; ++j) {
            strList[j] = oVect.elementAt(j).toString();
        }
        return strList;
    }

    public static Vector getLangsVector(Object oValue) {
        String[] origVal = null;
        Vector<Locale> v = null;
        if (!(oValue instanceof String[])) {
            return v;
        }
        origVal = (String[])oValue;
        v = new Vector<Locale>();
        for (int i = 0; i < origVal.length; ++i) {
            int nIndex = origVal[i].indexOf(95);
            Locale l = null;
            if (nIndex != -1) {
                String sLang = origVal[i].substring(0, nIndex);
                String sCountry = origVal[i].substring(nIndex + 1, origVal[i].length());
                l = new Locale(sLang, sCountry);
            } else {
                l = new Locale(origVal[i], "");
            }
            v.addElement(OiixLanguage.getLocaleInstance(l));
        }
        return v;
    }

    public static Locale getDefaultLocale() {
        Locale langMatch;
        int i;
        Locale defLocale = Locale.getDefault();
        Locale[] supportedLocale = m_oSupportedLanguages;
        String defLangCode = defLocale.getLanguage();
        Vector<Locale> langMatchList = new Vector<Locale>();
        for (int i2 = 0; i2 < supportedLocale.length; ++i2) {
            if (!defLangCode.equals(supportedLocale[i2].getLanguage())) continue;
            langMatchList.addElement(supportedLocale[i2]);
        }
        int size = langMatchList.size();
        if (size == 1) {
            return (Locale)langMatchList.elementAt(0);
        }
        String defCountry = defLocale.getCountry();
        Vector<Locale> langCountryMatch = new Vector<Locale>();
        for (i = 0; i < size; ++i) {
            langMatch = (Locale)langMatchList.elementAt(i);
            if (langMatch.getCountry().length() != 0 && !defCountry.equals(langMatch.getCountry())) continue;
            langCountryMatch.addElement(langMatch);
        }
        size = langCountryMatch.size();
        if (size == 1) {
            return (Locale)langCountryMatch.elementAt(0);
        }
        for (i = 0; i < size; ++i) {
            langMatch = (Locale)langCountryMatch.elementAt(i);
            if (!langMatch.equals(defLocale)) continue;
            return langMatch;
        }
        return ENGLISH;
    }

    public static int getFontStyle(int suggestedStyle) {
        String sCurrentLang = Locale.getDefault().getLanguage();
        if (sCurrentLang.equals(JAPANESE.getLanguage()) || sCurrentLang.equals(KOREAN.getLanguage()) || sCurrentLang.equals(SMP_CHIN.getLanguage())) {
            return 0;
        }
        return suggestedStyle;
    }

    static {
        ALL_LANGS = "ALL_LANGS";
    }
}

