/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixMessageHeader;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiixManifest {
    private Vector entries = new Vector();
    static final boolean debug = false;

    public OiixManifest() {
    }

    public OiixManifest(byte[] bytes) throws IOException {
        this(new ByteArrayInputStream(bytes));
    }

    public OiixManifest(InputStream is) throws IOException {
        while (is.available() != 0) {
            OiixMessageHeader m = new OiixMessageHeader(is);
            this.entries.addElement(m);
        }
    }

    public OiixManifest(String[] files) throws IOException {
        OiixMessageHeader globals = new OiixMessageHeader();
        globals.add("Manifest-Version", "1.0");
        this.addEntry(globals);
        this.addFiles(null, files);
    }

    public void addEntry(OiixMessageHeader entry) {
        this.entries.addElement(entry);
    }

    public OiixMessageHeader getEntry(String name) {
        Enumeration enum_1 = this.entries();
        while (enum_1.hasMoreElements()) {
            OiixMessageHeader mh = (OiixMessageHeader)enum_1.nextElement();
            String nameVal = mh.findValue("Name");
            if (nameVal == null || !nameVal.equals(name)) continue;
            return mh;
        }
        return null;
    }

    public OiixMessageHeader entryAt(int i) {
        return (OiixMessageHeader)this.entries.elementAt(i);
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public void addFiles(File dir, String[] files) throws IOException {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = dir == null ? new File(files[i]) : new File(dir, files[i]);
            if (file.isDirectory()) {
                this.addFiles(file, file.list());
                continue;
            }
            this.addFile(file);
        }
    }

    public void addFile(File f) throws IOException {
        OiixMessageHeader mh = new OiixMessageHeader();
        mh.add("Name", f.getPath());
        this.addEntry(mh);
    }

    public void stream(OutputStream os, Vector extraFiles) throws IOException {
        OiixMessageHeader globals = (OiixMessageHeader)this.entries.elementAt(0);
        if (globals.findValue("Manifest-Version") == null) {
            throw new IOException(OiixResourceBundle.getString("S_MANIFEST_FILE_REQ") + OiixResourceBundle.getString("S_MANIFEST_VERSION_HEADER"));
        }
        PrintWriter ps = new PrintWriter(os);
        globals.print(ps);
        for (int i = 1; i < this.entries.size(); ++i) {
            OiixMessageHeader mh = (OiixMessageHeader)this.entries.elementAt(i);
            mh.print(ps);
            String name = mh.findValue("name");
            if (extraFiles == null || name == null) continue;
            extraFiles.addElement(name);
        }
    }

    public static boolean isManifestName(String name) {
        if (name.charAt(0) == '/') {
            name = name.substring(1, name.length());
        }
        return (name = name.toUpperCase()).equals("META-INF/MANIFEST.MF");
    }
}

