/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.sysman.oii.oiin.OiinNetOps;

public class OiixNetOps {
    public static String getFullHostName() {
        OiinNetOps oNetOps = OiinNetOps.getNetOps();
        return oNetOps.getHostName();
    }

    public static String getMachineName(String hostName) {
        String retVal = hostName;
        int dotPos = hostName.indexOf(46);
        if (dotPos != -1) {
            retVal = hostName.substring(0, dotPos);
        }
        return retVal;
    }

    public static String getHostNameForIPAddress(String ipaddress) throws UnknownHostException {
        String retVal = null;
        InetAddress iaddr = InetAddress.getByName(ipaddress);
        retVal = iaddr.getHostName();
        if (retVal.equals(ipaddress)) {
            throw new UnknownHostException(retVal);
        }
        return retVal;
    }

    public static String getHostIPAddress() {
        OiinNetOps oNetOps = OiinNetOps.getNetOps();
        return oNetOps.getHostAddress();
    }

    public static String getIPAddressForHostName(String hostname) throws UnknownHostException {
        String retVal = null;
        InetAddress iaddr = InetAddress.getByName(hostname);
        retVal = iaddr.getHostAddress();
        return retVal;
    }

    public static String getDomainName(String hostName) {
        String retVal = "";
        int dotPos = hostName.indexOf(46);
        if (dotPos != -1) {
            retVal = hostName.substring(dotPos + 1);
        }
        return retVal;
    }

    public static String[] getAllHostNames() {
        OiinNetOps oNetOps = OiinNetOps.getNetOps();
        return oNetOps.getAllHostNames();
    }

    public static String[] getAllIPAddressesForHostName(String hostname) throws UnknownHostException {
        String[] retStrs = null;
        InetAddress[] iaddrs = InetAddress.getAllByName(hostname);
        int numaddrs = iaddrs.length;
        retStrs = new String[numaddrs];
        for (int i = 0; i < numaddrs; ++i) {
            retStrs[i] = iaddrs[i].getHostAddress();
        }
        return retStrs;
    }
}

