/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.ewt.alert.Alert;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.LWButton;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifm.OiifmMnemonicOps;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiixOCMLibraryUtils {
    public static final int HGAP = 5;
    public static final int VGAP = 5;
    public static final int FHGAP = 10;
    public static final String MAKE_RESOURCES = "makeResources";
    public static final int TITLE_SIZE = 20;
    public static final int SUBTITLE_SIZE = 11;
    public static final int RADIO_SIZE = 11;
    public static final int NOTE_SIZE = 11;
    public static final int DEFAULT_SIZE = 11;
    public static final String DEFAULT_FONT_NAME = OiixResourceBundle.getFont();
    public static Font font_radio = new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle(0), 11);
    public static Font font_plain = new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle(0), 11);
    public static Font font_note = new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle(0), 11);
    public static Font font_subtitle = new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle(0), 11);
    public static Font font_title = new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle(1), 20);
    public static Font font_little = new Font(DEFAULT_FONT_NAME, OiixLanguage.getFontStyle(0), 10);
    public static Color blackColor;
    public static Color _defaultForegroundColor;
    public static Color _defaultBackgroundColor;
    private static String DLG_NAME;
    private static StringBuffer resourceSB;
    private static StringBuffer sb;

    private OiixOCMLibraryUtils() {
    }

    public static String getMessage(String format) {
        return OiixOCMLibraryUtils.getMessage(format, new Object[0]);
    }

    public static void showErrorMessage(String title, String msg) {
        Alert alert = new Alert(msg, 0, 1);
        alert.setTitle(title);
        alert.runAlert();
    }

    public static void showSuccessMessage(String title, String msg) {
        Alert alert = new Alert(msg, 1, 1);
        alert.setTitle(title);
        alert.runAlert();
    }

    public static String getMessage(String format, Object[] args) {
        try {
            MessageFormat formatter = new MessageFormat(format);
            return formatter.format(args);
        }
        catch (Exception ex) {
            return format;
        }
    }

    public static void setText(JCheckBox cb, String txt) {
        cb.setLabel(txt);
        OiifmMnemonicOps.processMnemonic(cb);
    }

    public static void setText(JLabel lbl, String txt) {
        lbl.setText(txt);
        OiifmMnemonicOps.processMnemonic(lbl);
    }

    public static void setText(JButton but, String txt) {
        but.setLabel(txt);
        OiifmMnemonicOps.processMnemonic(but);
    }

    public static void processMnemonic(AbstractButton btn) {
        int iKeyCode = StringUtils.getMnemonicKeyCode((String)btn.getText());
        btn.setText(StringUtils.stripMnemonic((String)btn.getText()));
        btn.setMnemonic(iKeyCode);
    }

    private static boolean processMnemonic(LWComponent item, String label) {
        int index;
        boolean changed = false;
        if (item != null && (index = StringUtils.getMnemonicIndex((String)label)) != -1) {
            item.setMnemonicIndex(index);
            changed = true;
        }
        return changed;
    }

    public static void processMnemonic(LWLabel lbl) {
        int iKeyCode = StringUtils.getMnemonicKeyCode((String)lbl.getText());
        lbl.setText(StringUtils.stripMnemonic((String)lbl.getText()));
        String label = lbl.getText();
        if (label != null && OiixOCMLibraryUtils.processMnemonic((LWComponent)lbl, label)) {
            lbl.setText(StringUtils.stripMnemonic((String)label));
        }
    }

    public static void setText(Component comp, String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return;
        }
        if (comp instanceof JCheckBox) {
            OiixOCMLibraryUtils.setText((JCheckBox)comp, txt.trim());
        } else if (comp instanceof JLabel) {
            OiixOCMLibraryUtils.setText((JLabel)comp, txt.trim());
        } else if (comp instanceof JButton) {
            OiixOCMLibraryUtils.setText((JButton)comp, txt.trim());
        }
    }

    public static PushButton mkPushButton(String text) {
        PushButton but = new PushButton(text);
        but.setFont(font_plain);
        OiixOCMLibraryUtils.setText(but, text);
        but.setRightmost(true);
        but.setLeftmost(true);
        return but;
    }

    public static JButton mkButton(String text) {
        JButton but = new JButton(text);
        but.setFont(font_plain);
        OiixOCMLibraryUtils.setText(but, text);
        return but;
    }

    public static MultiLineLabel mkMllLabel(String text) {
        MultiLineLabel mllb = new MultiLineLabel(WordWrapper.getTextWrapper(), text);
        mllb.setPreferredAspectRatio(0.0f);
        mllb.setForeground(Color.black);
        mllb.setFont(font_plain);
        return mllb;
    }

    public static JCheckBox mkCb(String text, boolean startState) {
        return OiixOCMLibraryUtils.mkCb(text, startState, null);
    }

    public static JCheckBox mkCb(String text, boolean startState, ButtonGroup radioGroup) {
        JCheckBox cb = new JCheckBox(text, startState);
        if (radioGroup != null) {
            radioGroup.add(cb);
        }
        cb.setForeground(blackColor);
        cb.setFont(font_subtitle);
        OiixOCMLibraryUtils.setText(cb, cb.getLabel());
        return cb;
    }

    public static void fire(JCheckBox box) {
        boolean is = box.isSelected();
        int eventType = 1;
        if (!is) {
            eventType = 2;
        }
        ItemEvent evt = new ItemEvent(box, 701, box.getLabel(), eventType);
        box.dispatchEvent(evt);
    }

    public static JLabel mkSubTitleLabel(String text) {
        JLabel lbl = new JLabel(text);
        lbl.setForeground(blackColor);
        lbl.setFont(font_subtitle);
        return lbl;
    }

    public static JLabel mkNoteLabel(String text) {
        JLabel lbl = new JLabel(text);
        lbl.setForeground(blackColor);
        lbl.setFont(font_note);
        return lbl;
    }

    public static void setText(LWCheckbox cb, String txt) {
        cb.setLabel(txt);
        OiifmMnemonicOps.processMnemonic(cb);
    }

    public static void setText(LWLabel lbl, String txt) {
        lbl.setText(txt);
        OiixOCMLibraryUtils.processMnemonic(lbl);
    }

    public static void setText(PushButton but, String txt) {
        but.setLabel(txt);
        OiifmMnemonicOps.processMnemonic(but);
    }

    public static void setText(LWComponent comp, String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return;
        }
        if (comp instanceof LWLabel) {
            OiixOCMLibraryUtils.setText((LWLabel)comp, txt.trim());
        } else if (comp instanceof LWButton) {
            OiixOCMLibraryUtils.setText((PushButton)comp, txt.trim());
        }
    }

    public static LWLabel mkEwtLabel(String text) {
        return OiixOCMLibraryUtils.mkEwtLabel(text, null);
    }

    public static LWLabel mkEwtLabel(String text, LWComponent target) {
        LWLabel lbl = new LWLabel(text);
        lbl.setForeground(blackColor);
        lbl.setFont(font_plain);
        if (target != null) {
            lbl.setLabelFor((Component)target);
        }
        OiixOCMLibraryUtils.setText(lbl, text);
        return lbl;
    }

    public static JLabel mkLabel(String text) {
        return OiixOCMLibraryUtils.mkLabel(text, null);
    }

    public static JLabel mkLabel(String text, Component target) {
        JLabel lbl = new JLabel(text);
        lbl.setForeground(blackColor);
        lbl.setFont(font_plain);
        if (target != null) {
            lbl.setLabelFor(target);
        }
        OiixOCMLibraryUtils.setText(lbl, text);
        return lbl;
    }

    public static JPanel mkBorderPanel(int hgap, int vgap) {
        return new JPanel(new BorderLayout(hgap, vgap));
    }

    public static void addComponent(Component src, Container dest, GridBagLayout gbl, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets) {
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbl.setConstraints(src, gbc);
        dest.add(src);
    }

    public static void setDialog(String name) {
        DLG_NAME = name;
        sb = new StringBuffer();
        resourceSB = new StringBuffer();
        sb.append("\t<DIALOG EXT_NAME_ID=\"" + DLG_NAME + "\" DESC_ID=\"" + DLG_NAME + "_desc\" ENTRY_POINT=\"" + DLG_NAME + "\">\n");
        sb.append("\t\t<ARGUMENT_LIST>\n");
        OiixOCMLibraryUtils.argLine("TitleLabel", "FALSE", name);
    }

    public static void endDialog() {
        sb.append("\t\t</ARGUMENT_LIST>\n");
        sb.append("\t</DIALOG>\n");
        try {
            FileOutputStream fos = new FileOutputStream(DLG_NAME + ".xml");
            fos.write(sb.toString().getBytes());
            fos.flush();
            fos.close();
            FileOutputStream fosResource = new FileOutputStream(DLG_NAME + "_libRes.properties");
            fosResource.write(resourceSB.toString().getBytes());
            fosResource.flush();
            fosResource.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void argBoolLine(String title, String val) {
        sb.append("\t\t\t<ARGUMENT NAME=\"" + title + "\" DESC_ID=\"" + DLG_NAME + "_" + title + "_desc" + "\" EXT_NAME_ID=\"" + DLG_NAME + "_" + title + "_name" + "\" TYPE=\"" + "java.lang.Boolean" + "\" IN-OUT=\"" + "TRUE" + "\" />\n");
        resourceSB.append(DLG_NAME + "_" + title + "_name" + "=" + title + "\n");
        resourceSB.append(DLG_NAME + "_" + title + "_desc" + "=" + val + "\n");
    }

    public static void argBoolLine(String title, String val, String inOut) {
        sb.append("\t\t\t<ARGUMENT NAME=\"" + title + "\" DESC_ID=\"" + DLG_NAME + "_" + title + "_desc" + "\" EXT_NAME_ID=\"" + DLG_NAME + "_" + title + "_name" + "\" TYPE=\"" + "java.lang.Boolean" + "\" IN-OUT=\"" + inOut + "\" />\n");
        resourceSB.append(DLG_NAME + "_" + title + "_name" + "=" + title + "\n");
        resourceSB.append(DLG_NAME + "_" + title + "_desc" + "=" + val + "\n");
    }

    public static void argLine(String title, String inOut, String val) {
        sb.append("\t\t\t<ARGUMENT NAME=\"" + title + "\" DESC_ID=\"" + DLG_NAME + "_" + title + "_desc" + "\" EXT_NAME_ID=\"" + DLG_NAME + "_" + title + "_name" + "\" TYPE=\"" + "java.lang.String" + "\" IN-OUT=\"" + inOut + "\" />\n");
        resourceSB.append(DLG_NAME + "_" + title + "_name" + "=" + title + "\n");
        resourceSB.append(DLG_NAME + "_" + title + "_desc" + "=" + val + "\n");
    }

    public static void argSLLine(String title, String inOut, String val) {
        sb.append("\t\t\t<ARGUMENT NAME=\"" + title + "\" DESC_ID=\"" + DLG_NAME + "_" + title + "_desc" + "\" EXT_NAME_ID=\"" + DLG_NAME + "_" + title + "_name" + "\" TYPE=\"" + "[Ljava.lang.String;" + "\" IN-OUT=\"" + inOut + "\" />\n");
        resourceSB.append(DLG_NAME + "_" + title + "_name" + "=" + title + "\n");
        resourceSB.append(DLG_NAME + "_" + title + "_desc" + "=" + val + "\n");
    }

    static {
        _defaultForegroundColor = blackColor = Color.black;
        _defaultBackgroundColor = Color.gray;
        DLG_NAME = null;
    }
}

