/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import HTTPClient.ParseException;
import HTTPClient.URI;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLPeerUnverifiedException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.sysman.ccr.collector.install.ConfigResponse;
import oracle.sysman.ccr.collector.install.ConnectionException;
import oracle.sysman.ccr.collector.install.InvalidValueException;
import oracle.sysman.ccr.collector.install.NetworkConfiguration;
import oracle.sysman.ccr.collector.install.ProxyInfo;
import oracle.sysman.ccr.collector.install.RepeaterEndPoint;
import oracle.sysman.ccr.netmgr.EndPoint;
import oracle.sysman.ccr.netmgr.HTTPServerException;
import oracle.sysman.ccr.netmgr.NetworkException;
import oracle.sysman.ccr.netmgr.OCMEndPoint;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiStageAreaControl;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.osd.win32.OiipwWin32NativeCalls;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixOCMException;
import oracle.sysman.oii.oiix.OiixOCMNetworkException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawner;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class OiixOCMValidation {
    public static final int INVALID_PORT = -1;
    public static final String NON_SHARED_OCM_FILE_FOR_UPGRADE = "ccr" + File.separator + "bin" + File.separator + "emCCR";
    public static final String SHARED_OCM_SINGLE_HOST_MULTI_INST = "ccr" + File.separator + "config" + File.separator + "default" + File.separator + "uplinkreg.bin";
    public static final String SHARED_OCM_SINGLE_INST_MULTI_HOST = "ccr" + File.separator + "hosts";
    public static final String ORACLE_CONFIG_HOME_ENV_VAR = "ORACLE_CONFIG_HOME";
    private static String BROWSER_REGKEY_ROOT = "HKEY_CLASSES_ROOT";
    private static String BROWSER_REGKEY_LOCAL_MACHINE = "HKEY_LOCAL_MACHINE";
    private static String BROWSER_REGKEY_HTML = ".html";
    private static String BROWSER_REGKEY_COMMAND = "shell\\open\\command";
    private static NetworkConfiguration oNetworkConfig = null;
    private EndPoint oEndPoint = null;

    public boolean isDirectConnectionAvailable() {
        if (Boolean.getBoolean("oracle.installer.ocm.noDirectConnection")) {
            OiiolTextLogger.writeToLogAndConsole("noDirectConnection property is set, so not checking for direct connection");
            return false;
        }
        boolean result = false;
        oNetworkConfig = null;
        try {
            if (this.testInstallProxyConnection("", -1, "", "")) {
                result = true;
            }
        }
        catch (OiixOCMException oiixOCMException) {
            // empty catch block
        }
        return result;
    }

    public boolean testRepeaterConnection(String sRepeaterURL) throws OiixOCMException {
        this.debug("Testing Repeater Connection");
        boolean retVal = false;
        if (null == oNetworkConfig) {
            oNetworkConfig = new NetworkConfiguration();
        }
        try {
            oNetworkConfig.setRepeaterURI(new URI(sRepeaterURL));
            retVal = this.testInstallProxyConnection("", -1, "", "");
            if (!retVal) {
                throw new OiixOCMException("Testing Repeater Connection Failed");
            }
        }
        catch (InvalidValueException e) {
            throw new OiixOCMException(e.getMessage());
        }
        catch (ParseException e) {
            throw new OiixOCMException(e.getMessage());
        }
        catch (Throwable e) {
            throw new OiixOCMException(e.getMessage());
        }
        return retVal;
    }

    public boolean testRepeaterConnectionWithProxy(String sRepeaterURL, String proxyHost, int proxyPort, String proxyUser, String proxyPwd) throws OiixOCMException {
        this.debug("Testing Repeater Connection with Proxy");
        boolean retVal = false;
        if (null == oNetworkConfig) {
            oNetworkConfig = new NetworkConfiguration();
        }
        try {
            oNetworkConfig.setRepeaterURI(new URI(sRepeaterURL));
            retVal = this.testInstallProxyConnection(proxyHost, proxyPort, proxyUser, proxyPwd);
        }
        catch (InvalidValueException e) {
            throw new OiixOCMException(e.getMessage());
        }
        catch (ParseException e) {
            throw new OiixOCMException(e.getMessage());
        }
        catch (Throwable e) {
            throw new OiixOCMException(e.getMessage());
        }
        return retVal;
    }

    public void setRepeater(String sRepeaterURI) throws OiixOCMException {
        if (null == oNetworkConfig) {
            oNetworkConfig = new NetworkConfiguration();
        }
        try {
            oNetworkConfig.setRepeaterURI(new URI(sRepeaterURI));
        }
        catch (InvalidValueException e) {
            throw new OiixOCMException(e.getMessage());
        }
        catch (ParseException e) {
            throw new OiixOCMException(e.getMessage());
        }
        catch (Throwable e) {
            throw new OiixOCMException(e.getMessage());
        }
    }

    public boolean isRepeaterAvailable() {
        if (Boolean.getBoolean("oracle.installer.disableOCMConfigurationWithRepeater")) {
            return false;
        }
        try {
            Class<?> oclass = Class.forName("oracle.sysman.ccr.collector.install.NetworkConfiguration");
            Class[] oParams = new Class[]{Class.forName("HTTPClient.URI")};
            oclass.getMethod("setRepeaterURI", oParams);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean testInstallProxyConnection(String proxyHostname, int proxyPort, String proxyUsername, String proxyPassword) throws OiixOCMException {
        this.debug("Testing OCM Connection.");
        if (null == oNetworkConfig) {
            oNetworkConfig = new NetworkConfiguration();
        }
        if (proxyHostname != null) {
            try {
                this.debug("Proxy host is not null so setting proxy host.");
                oNetworkConfig.setProxyHost(proxyHostname);
            }
            catch (UnknownHostException e) {
                this.debug(e.getMessage());
                throw new OiixOCMException(e.getMessage());
            }
        }
        if (proxyPort != -1) {
            try {
                this.debug("Proxy port is not null so setting proxy port.");
                oNetworkConfig.setProxyPort(proxyPort);
            }
            catch (InvalidValueException e) {
                this.debug(e.getMessage());
                throw new OiixOCMException(e.getMessage());
            }
        }
        if (proxyUsername != null && proxyPassword != null) {
            this.debug("Setting the Proxy credentials");
            oNetworkConfig.setProxyCreds(proxyUsername, proxyPassword.getBytes());
        }
        if (proxyHostname != null && proxyPort != -1) {
            try {
                this.debug("Testing the connection using proxy information");
                this.oEndPoint = oNetworkConfig.testProxyConnection();
                if (this.oEndPoint != null) {
                    this.debug("Testing the connection using proxy information successful");
                    return true;
                }
                throw new OiixOCMException("Unable to connect to the given proxy server and port ");
            }
            catch (ConnectionException e) {
                this.debug(e.getMessage());
                throw new OiixOCMException(e.getMessage());
            }
            catch (Exception e) {
                this.debug(e.getMessage());
                throw new OiixOCMException(e.getMessage());
            }
        }
        this.debug("Testing the connection without proxy information");
        try {
            this.oEndPoint = oNetworkConfig.testConnection();
            if (this.oEndPoint != null) {
                this.debug("Test connection is successful ..");
                return true;
            }
        }
        catch (SSLPeerUnverifiedException e) {
            throw new OiixOCMException(e.getMessage());
        }
        catch (UnknownHostException e) {
            throw new OiixOCMException(e.getMessage());
        }
        catch (IOException e) {
            throw new OiixOCMException(e.getMessage());
        }
        catch (Exception e) {
            throw new OiixOCMException(e.getMessage());
        }
        catch (Throwable e) {
            throw new OiixOCMException(e.getMessage());
        }
        return false;
    }

    public EndPoint getConnection() {
        if (this.getNetWorkConfigObject() != null) {
            this.oEndPoint = this.getNetWorkConfigObject().getConnection();
        }
        return this.oEndPoint;
    }

    public NetworkConfiguration getNetWorkConfigObject() {
        return oNetworkConfig;
    }

    public void debug(String msg) {
        if ("TRUE".equalsIgnoreCase(System.getProperty("oracle.installer.debug"))) {
            OiixFunctionOps.addToLog(msg);
        }
    }

    public boolean isEmailValid(String email) throws OiixOCMException {
        String errEmptyEmail = OiixResourceBundle.getString("S_OCM_METALINK_USERNAME_EMPTY");
        String errInvalidEmail = OiixResourceBundle.getString("S_OCM_INVALID_EMAIL_FORMAT");
        if ((email = email.trim()) == null || email.trim().length() == 0) {
            throw new OiixOCMException(errEmptyEmail);
        }
        Pattern p = Pattern.compile("^[A-Za-z0-9._%+\\-]+@[A-Za-z0-9.\\-]+\\.[A-Za-z]{2,4}$");
        Matcher m = p.matcher(email);
        boolean matchFound = m.matches();
        if (!matchFound) {
            throw new OiixOCMException(errInvalidEmail);
        }
        return matchFound;
    }

    public boolean testMetaLinkconnection(String metalinkUser, String metaLinkPassword) throws OiixOCMNetworkException, OiixOCMException {
        String cipher = null;
        String errmsg = "";
        this.debug("The value of metalinkUser " + metalinkUser);
        if (metalinkUser.trim().length() != 0 && metaLinkPassword.trim().length() != 0) {
            try {
                if (null == oNetworkConfig) {
                    oNetworkConfig = new NetworkConfiguration();
                }
                if (null == this.getConnection()) {
                    this.oEndPoint = oNetworkConfig.testConnection();
                }
                this.debug("Calling authenticateMetalinkUser to validate the Metalink credentials");
                if (this.getConnection() != null) {
                    OCMEndPoint ocmendPoint = new OCMEndPoint(this.getConnection());
                    cipher = ocmendPoint.authenticateUser(metalinkUser, metaLinkPassword.getBytes());
                }
            }
            catch (HTTPServerException hse) {
                this.debug(hse.getMessage());
                errmsg = hse.getMessage();
                throw new OiixOCMNetworkException(errmsg);
            }
            catch (NetworkException ne) {
                this.debug(ne.getMessage());
                errmsg = ne.getMessage();
                throw new OiixOCMException(errmsg);
            }
            catch (Exception e) {
                this.debug(e.getMessage());
                errmsg = e.getMessage();
                throw new OiixOCMException(errmsg);
            }
            catch (Throwable e) {
                this.debug(e.getMessage());
                errmsg = e.getMessage();
                throw new OiixOCMException(errmsg);
            }
            if (cipher != null) {
                this.debug("Test Metalink successful");
                return true;
            }
            this.debug("Test Metalink unsuccessful");
            throw new OiixOCMException(errmsg);
        }
        return false;
    }

    public boolean isCompAvailableInStage(String sStageLoc, String sCompName) {
        Enumeration stagedComps;
        OiiiStageInventory stageInv;
        boolean bResult = false;
        OiiiStageAreaControl oiStageControl = null;
        try {
            oiStageControl = new OiiiStageAreaControl(sStageLoc, null);
        }
        catch (IOException e) {
            OiiolTextLogger.appendText(e.getMessage());
        }
        catch (OiitTargetLockNotAvailableException e) {
            OiiolTextLogger.appendText(e.getMessage());
        }
        if (null != oiStageControl && null != (stageInv = oiStageControl.getStageInventory()) && null != (stagedComps = stageInv.getAllComps(0, OiixPlatform.getCurrentPlatform()))) {
            int j = 0;
            while (stagedComps.hasMoreElements()) {
                OiiiStageCompInvEntry scie_forStagedComps = (OiiiStageCompInvEntry)stagedComps.nextElement();
                if (null != scie_forStagedComps && scie_forStagedComps.getCompInstallID().getName().equalsIgnoreCase(sCompName)) {
                    bResult = true;
                    break;
                }
                ++j;
            }
        }
        return bResult;
    }

    public boolean isCollectorScheduledForOH(String OH, String[] tobeIncludedList) {
        Vector vTopLevelCompsIDs;
        int size;
        boolean bResult = true;
        if (null == OH || null == tobeIncludedList) {
            return bResult;
        }
        Vector includeCompsVector = OiixVectorOps.strArr2Vect(tobeIncludedList);
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        OiiiInstallInventory instInv = iac.getInstallInventory();
        int OHIndex = 0;
        if (null != OH && instInv.getHomeWithLocation(OH) != null) {
            OHIndex = instInv.getHomeWithLocation(OH).getIndex();
        }
        int n = size = (vTopLevelCompsIDs = instInv.getTopLevelComps(OHIndex)) != null ? vTopLevelCompsIDs.size() : 0;
        if (size > 0) {
            bResult = false;
        }
        for (int i = 0; i < size; ++i) {
            OiiiCompInstallID id = (OiiiCompInstallID)vTopLevelCompsIDs.elementAt(i);
            if (includeCompsVector.contains(id.getName())) {
                bResult = true;
                break;
            }
            bResult = false;
        }
        return bResult;
    }

    public boolean isOCMAvailableForUpgrade(String sOH) {
        boolean bResult = false;
        String sEnv = OiixEnvironmentOps.getEnv(ORACLE_CONFIG_HOME_ENV_VAR);
        OiiolTextLogger.appendText("The ORACLE_CONFIG_HOME env var is set to " + sEnv);
        if (null != sEnv && sEnv.trim().length() > 0 && OiixFunctionOps.existsFile(sEnv).booleanValue()) {
            String sFile2Check = sEnv + File.separator + SHARED_OCM_SINGLE_HOST_MULTI_INST;
            if (null != sFile2Check && OiixFunctionOps.existsFile(sFile2Check).booleanValue()) {
                OiiolTextLogger.appendText("The file " + sFile2Check + " is present, so upgrade is set to true");
                bResult = true;
            }
        } else if (null != sOH) {
            String sFile2Check = sOH + File.separator + NON_SHARED_OCM_FILE_FOR_UPGRADE;
            if (this.isWindowsPlatform()) {
                sFile2Check = sFile2Check + ".bat";
            }
            if (null != sFile2Check && OiixFunctionOps.existsFile(sFile2Check).booleanValue()) {
                OiiolTextLogger.appendText("Since the file " + sFile2Check + " is present, upgrade is true");
                bResult = true;
            }
        }
        return bResult;
    }

    public RepeaterEndPoint[] getRepeaterEndPointsFromAgentHome() {
        OiiiInstallAreaControl iac = OiiiInstallAreaControl.getInstallAreaControl();
        if (null == iac) {
            return null;
        }
        OiiiInstallInventory instInv = iac.getInstallInventory();
        if (null == instInv) {
            return null;
        }
        Vector vInstalledHomes = instInv.getHomes();
        Vector<String> vAgentHomes = new Vector<String>();
        for (int i = 0; i < vInstalledHomes.size(); ++i) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)vInstalledHomes.elementAt(i);
            String homeLoc = homeInfo.getLocation();
            int homeIndex = homeInfo.getIndex();
            Vector vInvEntries = instInv.getCompInvEntries("oracle.sysman.top.agent", homeIndex);
            if (vInvEntries == null || vInvEntries.size() == 0) continue;
            if (OiiolTextLogger.isLogLevelTrace()) {
                OiiolTextLogger.writeToLogAndConsole("[OiixOCMValidation.getRepeaterEndPointsFromAgentHome] agent home discovered:" + homeLoc);
            }
            vAgentHomes.add(homeLoc);
        }
        if (null == oNetworkConfig) {
            oNetworkConfig = new NetworkConfiguration();
        }
        OiiolTextLogger.appendText("[OiixOCMValidation.getRepeaterEndPointsFromAgentHome] passing the agentHomes to getRepeaterEndPoints", OiiolTextLogger.LOG_TRACE);
        return NetworkConfiguration.getRepeaterEndPoints((String[])OiixVectorOps.vect2StrArr(vAgentHomes));
    }

    private boolean getRepeaterInfoFromEndPoint(RepeaterEndPoint endPoint, Map varMap) {
        try {
            String sRepeaterURL = endPoint.getConnectionURL().toString();
            ProxyInfo proxyInfo = endPoint.getProxyInfo();
            if (OiiolTextLogger.isLogLevelTrace()) {
                OiiolTextLogger.writeToLogAndConsole("[OiixOCMValidation.getRepeaterInfoFromEndPoint] testing repeater URL:" + sRepeaterURL);
            }
            if (null != proxyInfo) {
                String sProxyPort;
                String sProxyHost = proxyInfo.getProxyHost();
                if (this.testRepeaterConnectionWithProxy(sRepeaterURL, sProxyHost, new Integer(sProxyPort = proxyInfo.getProxyPort()), null, null)) {
                    if (OiiolTextLogger.isLogLevelTrace()) {
                        OiiolTextLogger.writeToLogAndConsole("[OiixOCMValidation.getRepeaterInfoFromEndPoint] setting repeaterURL and proxy from agent home");
                    }
                    varMap.put("COLLECTOR_SUPPORTHUB_URL", sRepeaterURL);
                    varMap.put("PROXY_HOST", sProxyHost);
                    varMap.put("PROXY_PORT", sProxyPort);
                    return true;
                }
            } else if (this.testRepeaterConnection(sRepeaterURL)) {
                if (OiiolTextLogger.isLogLevelTrace()) {
                    OiiolTextLogger.writeToLogAndConsole("[OiixOCMValidation.getRepeaterInfoFromEndPoint] setting repeaterURL from agent home");
                }
                varMap.put("COLLECTOR_SUPPORTHUB_URL", sRepeaterURL);
                return true;
            }
        }
        catch (OiixOCMException e) {
            OiiolTextLogger.appendText(e.getMessage(), OiiolTextLogger.LOG_TRACE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Map setRepeaterFromAgentHome() {
        RepeaterEndPoint[] endPoints = this.getRepeaterEndPointsFromAgentHome();
        if (null == endPoints) {
            return null;
        }
        if (OiiolTextLogger.isLogLevelTrace()) {
            OiiolTextLogger.writeToLogAndConsole("[OiixOCMValidation.setRepeaterFromAgentHome] Number of RepeaterEndPoints=" + endPoints.length);
        }
        HashMap varsMap = new HashMap();
        for (int i = 0; i < endPoints.length; ++i) {
            if (!this.getRepeaterInfoFromEndPoint(endPoints[i], varsMap)) continue;
            return varsMap;
        }
        return null;
    }

    public String getHostNameSansDomain(String hostNameWithDomain) {
        String hostNameSansDomain = null;
        hostNameSansDomain = hostNameWithDomain != null && hostNameWithDomain.indexOf(".") != -1 ? hostNameWithDomain.substring(0, hostNameWithDomain.indexOf(".")) : hostNameWithDomain;
        return hostNameSansDomain;
    }

    public void showBrowserLinkForWindows(String sLink) throws Exception {
        String m_browser = "";
        m_browser = this.getWin32BrowserCommand();
        if (null != m_browser) {
            OiixSpawner oSpawner = new OiixSpawner();
            String[] args = new String[]{sLink};
            oSpawner.beginExecute(m_browser, args, null);
        }
    }

    public String getWin32BrowserCommand() throws Exception {
        String sHtmlKey = OiipwWin32NativeCalls.RegGetValue(BROWSER_REGKEY_ROOT, BROWSER_REGKEY_HTML, "");
        if (sHtmlKey.equals("")) {
            return "";
        }
        String sCommandKeyName = sHtmlKey + "\\" + BROWSER_REGKEY_COMMAND;
        String sCommand = OiipwWin32NativeCalls.RegGetValue(BROWSER_REGKEY_ROOT, sCommandKeyName, "");
        if (sCommand.equals("")) {
            return sCommand;
        }
        int index = sCommand.indexOf("\"%1\"");
        if (index != -1) {
            sCommand = sCommand.substring(0, index);
        }
        return sCommand;
    }

    public boolean isWindowsPlatform() {
        int curPlat = OiixPlatform.getCurrentPlatform();
        boolean bRet = curPlat == 615 || curPlat == 50 || curPlat == 912 || curPlat == 208 || curPlat == 233;
        return bRet;
    }

    private String checkIfBrowserPresentForWindows(String browserName) throws Exception {
        boolean regKeyExists = OiipwWin32NativeCalls.RegKeyExists(BROWSER_REGKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths");
        if (!regKeyExists) {
            throw new Exception("No key");
        }
        String sCommand = "";
        String[] exes = OiipwWin32NativeCalls.RegGetAllSubkeys(BROWSER_REGKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths");
        if (null != exes && exes.length > 0) {
            for (int k = 0; k < exes.length; ++k) {
                if (!exes[k].equalsIgnoreCase(browserName + ".exe")) continue;
                sCommand = OiipwWin32NativeCalls.RegGetValue(BROWSER_REGKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\App Paths\\" + exes[k], "");
                break;
            }
        }
        if (sCommand.equals("")) {
            return sCommand;
        }
        int index = sCommand.indexOf("\"%1\"");
        if (index != -1) {
            sCommand = sCommand.substring(0, index);
        }
        return sCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OiiiOracleHomeInfo getOracleHomeInfoForOH(String oh) {
        OiicStandardInventorySession oSession = new OiicStandardInventorySession("1", "1");
        OiiiOracleHomeInfo oHomeInfo = null;
        try {
            try {
                if (System.getProperty("oracle.installer.oui_loc", null) == null) {
                    System.setProperty("oracle.installer.oui_loc", oh + File.separator + "oui" + File.separator);
                }
                oSession.initSession(0);
                OiiiInstallInventory inv = oSession.getInstallAreaControl().getInstallInventory();
                oHomeInfo = inv.getHomeWithLocation(oh);
            }
            catch (Exception e) {
                e.printStackTrace();
                Object var6_7 = null;
                oSession.endSession();
            }
            Object var6_6 = null;
            oSession.endSession();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            oSession.endSession();
            throw throwable;
        }
        return oHomeInfo;
    }

    public boolean isHomeShared(String oH) {
        Vector nodeList;
        boolean retVal = false;
        OiiiOracleHomeInfo oHInfo = null;
        oHInfo = this.getOracleHomeInfoForOH(oH);
        if (null != oHInfo && null != (nodeList = oHInfo.getNodeList()) && nodeList.size() > 1) {
            try {
                System.setProperty("oracle.installer.oui_loc", oH + File.separator + "oui" + File.separator);
                System.setProperty("oracle.installer.invPtrLoc", oH + File.separator + "oraInst.loc");
                String sNativeVolName = OiixPathOps.getNativeForm(oH);
                String[] nodeListStrArray = nodeList.toArray(new String[nodeList.size()]);
                retVal = Cluster.isSharedPath((String)sNativeVolName, (String[])nodeListStrArray);
                System.out.println("Is " + sNativeVolName + " shared ? " + retVal);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void openURL(String url) throws Exception {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
            Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url);
            return;
        } else if (this.isWindowsPlatform()) {
            String sCmd;
            String sDefBrowser = this.getWin32BrowserCommand();
            if (null != sDefBrowser) {
                File fBrowser;
                int indexQuote;
                if (sDefBrowser.startsWith("\"") && (indexQuote = sDefBrowser.indexOf("\"", 1)) != -1) {
                    sDefBrowser = sDefBrowser.substring(1, indexQuote);
                }
                if ((fBrowser = new File(sDefBrowser)).isFile() && fBrowser.exists()) {
                    Runtime.getRuntime().exec(new String[]{sDefBrowser, url});
                    return;
                }
            }
            String[] browsers = new String[]{"iexplore", "firefox", "opera", "netscape"};
            String browserList = System.getProperty("oracle.installer.supportedBrowsers", null);
            if (null != browserList) {
                browsers = OiixFunctionOps.explodeString(browserList, ",");
            }
            String browser = null;
            for (int count = 0; !(count >= browsers.length || browser != null || (browser = (sCmd = this.checkIfBrowserPresentForWindows(browsers[count]))) != null && browser.trim().length() > 0 && new File(browser).exists()); ++count) {
                browser = null;
            }
            if (browser == null || browser != null && browser.trim().length() == 0) {
                throw new Exception("Could not find web browser");
            }
            if (!new File(browser).exists()) throw new Exception("browser not found");
            Runtime.getRuntime().exec(new String[]{browser, url});
            return;
        } else {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
            String browserList = System.getProperty("oracle.installer.supportedBrowsers", null);
            if (null != browserList) {
                browsers = OiixFunctionOps.explodeString(browserList, ",");
            }
            String browser = null;
            for (int count = 0; count < browsers.length && browser == null; ++count) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                browser = browsers[count];
            }
            if (browser == null) {
                throw new Exception("Could not find web browser");
            }
            Runtime.getRuntime().exec(new String[]{browser, url});
        }
    }

    static {
        ConfigResponse.init();
    }
}

