/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Vector;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiixPathOps {
    public static final int ROUND = 0;
    public static final int CEIL = 1;
    public static final int FLOOR = 2;
    public static final char standardSeparatorChar = '/';
    private static HashMap s_oCanonicalPathCache;

    private static String cacheCanonicalPath(String sPath, String sCanonicalPath) {
        if (s_oCanonicalPathCache == null) {
            s_oCanonicalPathCache = new HashMap();
        }
        s_oCanonicalPathCache.put(sPath, sCanonicalPath);
        return sCanonicalPath;
    }

    public static void dispose() {
        s_oCanonicalPathCache = null;
    }

    private static String getCanonicalPathFromCache(String sPath) {
        if (s_oCanonicalPathCache != null) {
            return (String)s_oCanonicalPathCache.get(sPath);
        }
        return null;
    }

    private static String getCanonicalPathImpl(String sPath) throws IOException {
        String sCanonicalPath = OiixPathOps.getCanonicalPathFromCache(sPath);
        if (sCanonicalPath == null) {
            File oFile = new File(sPath);
            sCanonicalPath = oFile.getCanonicalPath();
            OiixPathOps.cacheCanonicalPath(sPath, sCanonicalPath);
        }
        return sCanonicalPath;
    }

    public static String getFileCanonicalPath(String sPath) throws IOException {
        return OiixPathOps.getCanonicalPathImpl(sPath);
    }

    public static String getStandardForm(String nativePath) {
        return nativePath.replace(File.separatorChar, '/');
    }

    public static String getNativeForm(String stdPath) {
        if (!OiixPathOps.isHttpLocation(stdPath)) {
            String retPath = stdPath.replace('/', File.separatorChar);
            return retPath;
        }
        return stdPath;
    }

    public static String getCanonicalPath(String path) throws IOException {
        String natPath = OiixPathOps.getNativeForm(path);
        return OiixPathOps.getStandardForm(OiixPathOps.getCanonicalPathImpl(natPath));
    }

    public static String getStandardCanonicalPath(String path) {
        return OiixPathOps.getStandardForm(OiixPathOps.getNativeCanonicalPath(path));
    }

    public static String getNativeCanonicalPath(String path) {
        String sPath = "";
        try {
            File pathFil = new File(path);
            sPath = pathFil.getCanonicalPath();
        }
        catch (IOException e) {
            sPath = path;
        }
        return OiixPathOps.getNativeForm(sPath);
    }

    public static String getAbsolutePath(String path) {
        String natPath = OiixPathOps.getNativeForm(path);
        File pathFil = new File(natPath);
        return OiixPathOps.getStandardForm(pathFil.getAbsolutePath());
    }

    public static String unEscape(String path) {
        String[] escapeChars = new String[]{"\r", "\n", "\b", "\f", "\t", "'", "\""};
        String[] unescapeChars = new String[]{"\\r", "\\n", "\\b", "\\f", "\\t", "\\'", "\\\""};
        int len = escapeChars.length;
        for (int i = 0; i < len; ++i) {
            int pos = path.indexOf(escapeChars[i]);
            if (pos == -1) continue;
            String firstHalf = path.substring(0, pos);
            String secondHalf = path.substring(pos + escapeChars[i].length(), path.length());
            path = firstHalf + unescapeChars[i] + secondHalf;
        }
        return path;
    }

    public static String getUnexpandedCanonicalPath(String path) {
        String aPath = path;
        boolean bhttp = true;
        boolean bUNCPath = false;
        if (!OiixPathOps.isHttpLocation(aPath)) {
            File f = new File(path);
            aPath = f.getAbsolutePath();
            if (aPath.startsWith("\\\\")) {
                bUNCPath = true;
            }
            bhttp = false;
        } else {
            aPath = aPath.substring(7);
        }
        String str = OiixPathOps.resolveDotDot(aPath.replace('\\', '/'));
        if (!bhttp) {
            str = str.replace('/', File.separatorChar);
            if (bUNCPath) {
                str = '\\' + str;
            }
        } else {
            if (str.startsWith(File.separator)) {
                str = str.substring(1);
            }
            str = "http://" + str;
        }
        return str;
    }

    private static String resolveDotDot(String path) {
        StringBuffer absPath = new StringBuffer(path);
        int len = absPath.length();
        Vector<StringBuffer> parts = new Vector<StringBuffer>();
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            char ch = absPath.charAt(i);
            if (ch != '/') {
                temp.append(ch);
                continue;
            }
            if (temp.length() > 0) {
                parts.addElement(temp);
            }
            temp = new StringBuffer();
        }
        if (temp.length() > 0) {
            parts.addElement(temp);
        }
        len = parts.size();
        StringBuffer finalStr = new StringBuffer();
        int skipNum = 0;
        for (int i = len - 1; i >= 0; --i) {
            StringBuffer part = (StringBuffer)parts.elementAt(i);
            String str = part.toString();
            if (str.equals("..")) {
                ++skipNum;
                continue;
            }
            if (skipNum > 0) {
                --skipNum;
                continue;
            }
            if (str.equals(".")) continue;
            if (finalStr.length() > 0) {
                finalStr.insert(0, "/");
            }
            finalStr.insert(0, part);
        }
        File fl = new File(path);
        String realCanonicalPath = "";
        try {
            realCanonicalPath = fl.getCanonicalPath();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (realCanonicalPath.endsWith("" + File.separatorChar)) {
            finalStr.append("/");
        }
        if (realCanonicalPath.startsWith("" + File.separatorChar)) {
            finalStr.insert(0, "/");
        }
        return finalStr.toString();
    }

    public static boolean isHttpLocation(String sourceRoot) {
        boolean bHttp = false;
        if (sourceRoot != null && sourceRoot.length() > 7 && sourceRoot.substring(0, 7).equalsIgnoreCase("http://")) {
            bHttp = true;
        }
        return bHttp;
    }

    public static String getParentDir(String path) {
        int pathLen;
        int lastSepPos = (path = OiixPathOps.getStandardForm(path)).lastIndexOf(47, (pathLen = path.length()) - 2);
        if (lastSepPos != -1) {
            if (lastSepPos != 0) {
                return path.substring(0, lastSepPos);
            }
            return "/";
        }
        return null;
    }

    public static String getFileName(String path) {
        int pathLen = path.length();
        int lastSepPos = path.lastIndexOf(47, pathLen - 2);
        return path.substring(lastSepPos + 1);
    }

    public static String directorify(String path) {
        if (!path.endsWith("/")) {
            path = path + '/';
        }
        return path;
    }

    public static String concatPath(String dir, String filename) {
        char firstChar;
        if (filename.length() > 0 && ((firstChar = filename.charAt(0)) == '/' || firstChar == File.separatorChar)) {
            filename = filename.substring(1);
        }
        return OiixPathOps.directorify(dir) + filename;
    }

    public static String getDiskSpaceString(long bytes, int roundType) {
        double kb = 1024.0;
        double meg = kb * kb;
        double gb = meg * kb;
        if (bytes >= 0L && (double)bytes < meg) {
            long numKB;
            switch (roundType) {
                case 0: {
                    numKB = Math.round((double)bytes / kb);
                    break;
                }
                case 1: {
                    numKB = (long)Math.ceil((double)bytes / kb);
                    break;
                }
                case 2: {
                    numKB = (long)Math.floor((double)bytes / kb);
                    break;
                }
                default: {
                    numKB = (long)((double)bytes / kb);
                }
            }
            String str = OiixResourceBundle.getString("S_KB");
            Object[] strarr = new String[]{"" + numKB};
            return MessageFormat.format(str, strarr);
        }
        if ((double)bytes >= meg && (double)bytes < gb) {
            long numMegs;
            switch (roundType) {
                case 0: {
                    numMegs = Math.round((double)bytes / meg);
                    break;
                }
                case 1: {
                    numMegs = (long)Math.ceil((double)bytes / meg);
                    break;
                }
                case 2: {
                    numMegs = (long)Math.floor((double)bytes / meg);
                    break;
                }
                default: {
                    numMegs = (long)((double)bytes / meg);
                }
            }
            String str = OiixResourceBundle.getString("S_MB");
            Object[] strarr = new String[]{"" + numMegs};
            return MessageFormat.format(str, strarr);
        }
        if ((double)bytes >= gb) {
            double numGigs = bytes;
            String s = Double.toString(numGigs /= gb);
            int decimalIndex = s.indexOf(".");
            if (decimalIndex != -1) {
                int lastIndex = decimalIndex + 3 <= s.length() ? decimalIndex + 3 : s.length();
                s = s.substring(0, lastIndex);
            }
            String str = OiixResourceBundle.getString("S_GB");
            Object[] strarr = new String[]{"" + s};
            return MessageFormat.format(str, strarr);
        }
        return OiixResourceBundle.getString("S_NOT_AVAIL");
    }

    public static String stripQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static Vector replacePaths(Vector vPaths, String origPath, String subsPath) {
        if (vPaths == null) {
            return null;
        }
        Vector<String> newPaths = new Vector<String>();
        for (int i = 0; i < vPaths.size(); ++i) {
            String path = (String)vPaths.elementAt(i);
            String newPath = OiixFunctionOps.replaceStr(path, origPath, subsPath);
            newPaths.add(newPath);
        }
        return newPaths;
    }
}

