/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixProgressComputor;
import oracle.sysman.oii.oiix.OiixProgressListener;

public class OiixProgressUpdator {
    private OiixProgressComputor m_oProgressComputor = null;
    private OiixProgressListener m_oProgress = null;
    private int m_iProgressRange = 100;
    private OiixProgressUpdatingWorker m_oWorker = null;
    private Thread m_oWorkerThread = null;

    public OiixProgressUpdator(OiixProgressListener oProgress, OiixProgressComputor oComputor, int iRange) {
        this.m_oProgress = oProgress;
        this.m_oProgressComputor = oComputor;
        this.m_iProgressRange = iRange;
    }

    public void start() {
        if (this.m_oWorker == null) {
            this.m_oWorker = new OiixProgressUpdatingWorker(this.m_oProgress, this.m_oProgressComputor, this.m_iProgressRange);
            this.m_oWorkerThread = new Thread(this.m_oWorker);
            this.m_oWorkerThread.start();
        }
    }

    public void stop() {
        if (this.m_oWorker != null) {
            this.m_oWorker.stopOperation();
            while (this.m_oWorkerThread.isAlive()) {
            }
            this.m_oWorker = null;
            this.m_oWorkerThread = null;
        }
    }

    class OiixProgressUpdatingWorker
    implements Runnable {
        private boolean m_bStopped = false;
        private boolean m_bSuspended = false;
        private OiixProgressComputor m_oProgressComputor = null;
        private OiixProgressListener m_oProgress = null;
        private int m_iProgressRange = 100;
        private long m_lCurrentInterval;
        private int m_nCountBeforeIntervalUpdates = 0;
        private long m_lMinSleepTime = Long.getLong("oracle.installer.progress.minSleepIntervalMillis", 3000L);

        public OiixProgressUpdatingWorker(OiixProgressListener oProgress, OiixProgressComputor oComputor, int iRange) {
            this.m_oProgress = oProgress;
            this.m_oProgressComputor = oComputor;
            this.m_iProgressRange = iRange;
            this.m_nCountBeforeIntervalUpdates = this.m_iProgressRange / 2;
        }

        public void run() {
            this.m_lCurrentInterval = this.m_oProgressComputor.getInitialInterval();
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("Init interval:" + this.m_lCurrentInterval, OiiolTextLogger.LOG_TRACE);
            }
            int iProgressStep = this.getProgressStep(this.m_lCurrentInterval, this.m_lMinSleepTime);
            if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                OiiolTextLogger.appendText("Progress step:" + iProgressStep, OiiolTextLogger.LOG_TRACE);
            }
            while (!this.isStopped() && this.m_iProgressRange > 1) {
                if (!this.isSuspended()) {
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                        OiiolTextLogger.appendText("Adding percentage:" + iProgressStep, OiiolTextLogger.LOG_TRACE);
                    }
                    this.m_oProgress.addPercentage(iProgressStep);
                    --this.m_nCountBeforeIntervalUpdates;
                    --this.m_iProgressRange;
                    if (this.m_nCountBeforeIntervalUpdates == 0) {
                        this.m_lCurrentInterval = this.m_oProgressComputor.getNextInterval();
                        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                            OiiolTextLogger.appendText("Current interval:" + this.m_lCurrentInterval, OiiolTextLogger.LOG_TRACE);
                        }
                        iProgressStep = this.getProgressStep(this.m_lCurrentInterval, this.m_lMinSleepTime);
                        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                            OiiolTextLogger.appendText("Progress step:" + iProgressStep, OiiolTextLogger.LOG_TRACE);
                        }
                        this.m_nCountBeforeIntervalUpdates = this.m_iProgressRange / 2;
                        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                            OiiolTextLogger.appendText("m_iProgressRange:" + this.m_iProgressRange + ":m_nCountBeforeIntervalUpdates:" + this.m_nCountBeforeIntervalUpdates, OiiolTextLogger.LOG_TRACE);
                        }
                    }
                }
                try {
                    if (this.m_lCurrentInterval >= this.m_lMinSleepTime) {
                        long lSmallInterval = this.m_lCurrentInterval / this.m_lMinSleepTime;
                        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                            OiiolTextLogger.appendText("Sleep small interval:" + lSmallInterval, OiiolTextLogger.LOG_TRACE);
                        }
                        int i = 0;
                        while ((long)i < lSmallInterval) {
                            if (!this.isStopped()) {
                                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                                    OiiolTextLogger.appendText(">>>Sleeping for:" + this.m_lMinSleepTime, OiiolTextLogger.LOG_TRACE);
                                }
                                Thread.sleep(this.m_lMinSleepTime);
                                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                                    OiiolTextLogger.appendText("<<<Slept for:" + this.m_lMinSleepTime, OiiolTextLogger.LOG_TRACE);
                                }
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_TRACE) {
                        OiiolTextLogger.appendText(">>>Sleeping for:" + this.m_lCurrentInterval, OiiolTextLogger.LOG_TRACE);
                    }
                    Thread.sleep(this.m_lCurrentInterval);
                    if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_TRACE) continue;
                    OiiolTextLogger.appendText(">>>Slept for:" + this.m_lCurrentInterval, OiiolTextLogger.LOG_TRACE);
                }
                catch (InterruptedException e) {
                    this.stopOperation();
                }
            }
            this.m_oProgress.addPercentage(this.m_iProgressRange);
        }

        void suspendOperation(boolean bSuspend) {
            this.m_bSuspended = bSuspend;
        }

        boolean isSuspended() {
            return this.m_bSuspended;
        }

        void stopOperation() {
            this.m_bStopped = true;
        }

        boolean isStopped() {
            return this.m_bStopped;
        }

        private int getProgressStep(long interval, long minSleepTime) {
            return 1;
        }
    }
}

