/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.util.Vector;
import oracle.bali.share.sort.Comparator;

public abstract class OiixSearch {
    public static final int ITEM_NOT_FOUND = -1;
    public static final int SEARCH_NOT_POSSIBLE = -2;
    public static final int ITEM_NOT_INSERTED = -1;

    public static int bSearch(Object key, Vector items, Comparator comparator) {
        int index;
        if (items == null || key == null || comparator == null) {
            index = -1;
        } else {
            int nitems = items.size();
            index = OiixSearch.bSearchInternal(key, items, comparator);
            if (index >= nitems || comparator.compare(key, items.elementAt(index)) != 0) {
                index = -1;
            }
        }
        return index;
    }

    public static int bSearchAndInsert(Object key, Vector items, Comparator comparator) {
        return OiixSearch.bSearchAndInsert(key, items, comparator, true);
    }

    public static int bSearchAndInsert(Object key, Vector items, Comparator comparator, boolean bErrOnDuplicate) {
        int index;
        if (items == null || key == null || comparator == null) {
            index = -1;
        } else {
            int nitems = items.size();
            index = OiixSearch.bSearchInternal(key, items, comparator);
            if (index >= nitems || comparator.compare(key, items.elementAt(index)) != 0) {
                items.insertElementAt(key, index);
            } else if (bErrOnDuplicate) {
                index = -1;
            }
        }
        return index;
    }

    private static int bSearchInternal(Object key, Vector items, Comparator comparator) {
        int first = 0;
        int last = items.size() - 1;
        int i = 0;
        int compres = 0;
        while (last >= first) {
            i = (first + last) / 2;
            compres = comparator.compare(key, items.elementAt(i));
            if (compres < 0) {
                last = i - 1;
                continue;
            }
            if (compres == 0) break;
            first = i + 1;
        }
        if (compres > 0) {
            return i + 1;
        }
        return i;
    }
}

