/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.util.Random;
import java.util.Vector;
import oracle.bali.share.sort.Comparator;

public abstract class OiixSort {
    private static final int S_INSERTION_LIMIT = 9;
    private static final Random S_RANDOM = new Random();

    public static void qSort(Vector items, Comparator comparator) {
        if (items != null) {
            int nItems = items.size();
            OiixSort.qSortInternal(items, 0, nItems - 1, comparator);
        }
    }

    public static int[] indirectQSort(Vector items, Comparator comparator) {
        if (items != null && items.size() > 0) {
            int numItems = items.size();
            int[] indices = new int[numItems];
            for (int i = 0; i < numItems; ++i) {
                indices[i] = i;
            }
            OiixSort.qSortInternal(items, indices, 0, numItems - 1, comparator);
            return indices;
        }
        return new int[0];
    }

    private static int getRandomPartionIndex(int first, int last) {
        int partitionIndex = S_RANDOM.nextInt();
        if ((partitionIndex %= last - first + 1) < 0) {
            partitionIndex = -partitionIndex;
        }
        return partitionIndex + first;
    }

    private static void insertionSort(Vector items, int first, int last, Comparator comparator) {
        block0: for (int i = first + 1; i <= last; ++i) {
            Object belowObject;
            Object currObject;
            int j = i;
            while (comparator.compare(currObject = items.elementAt(j), belowObject = items.elementAt(j - 1)) < 0) {
                items.setElementAt(belowObject, j);
                items.setElementAt(currObject, j - 1);
                if (--j != first) continue;
                continue block0;
            }
        }
    }

    private static void qSortInternal(Vector items, int first, int last, Comparator comparator) {
        if (last - first > 9) {
            int partition = OiixSort.qSortPartition(items, first, last, comparator);
            OiixSort.qSortInternal(items, first, partition, comparator);
            OiixSort.qSortInternal(items, partition + 1, last, comparator);
        } else {
            OiixSort.insertionSort(items, first, last, comparator);
        }
    }

    private static void swap(Vector items, int i, int j) {
        Object temp1 = items.elementAt(i);
        Object temp2 = items.elementAt(j);
        items.setElementAt(temp2, i);
        items.setElementAt(temp1, j);
    }

    private static void swap(int[] indices, int i, int j) {
        int temp = indices[i];
        indices[i] = indices[j];
        indices[j] = temp;
    }

    private static int qSortPartition(Vector items, int first, int last, Comparator comparator) {
        int partitionIndex = OiixSort.getRandomPartionIndex(first, last);
        OiixSort.swap(items, first, partitionIndex);
        Object partitionValue = items.elementAt(first);
        int i = first - 1;
        int j = last + 1;
        while (true) {
            if (comparator.compare(items.elementAt(--j), partitionValue) > 0) {
                continue;
            }
            while (comparator.compare(items.elementAt(++i), partitionValue) < 0) {
            }
            if (i >= j) break;
            OiixSort.swap(items, i, j);
        }
        return j;
    }

    private static void insertionSort(Vector items, int[] indices, int first, int last, Comparator comparator) {
        block0: for (int i = first + 1; i <= last; ++i) {
            int j = i;
            do {
                int currIndex = indices[j];
                int belowIndex = indices[j - 1];
                if (comparator.compare(items.elementAt(currIndex), items.elementAt(belowIndex)) >= 0) continue block0;
                indices[j] = belowIndex;
                indices[j - 1] = currIndex;
            } while (--j != first);
        }
    }

    private static void qSortInternal(Vector items, int[] indices, int first, int last, Comparator comparator) {
        if (last - first > 9) {
            int partition = OiixSort.qSortPartition(items, indices, first, last, comparator);
            OiixSort.qSortInternal(items, indices, first, partition, comparator);
            OiixSort.qSortInternal(items, indices, partition + 1, last, comparator);
        } else {
            OiixSort.insertionSort(items, indices, first, last, comparator);
        }
    }

    private static int qSortPartition(Vector items, int[] indices, int first, int last, Comparator comparator) {
        int partitionIndex = OiixSort.getRandomPartionIndex(first, last);
        OiixSort.swap(indices, first, partitionIndex);
        Object partitionValue = items.elementAt(indices[first]);
        int i = first - 1;
        int j = last + 1;
        while (true) {
            if (comparator.compare(items.elementAt(indices[--j]), partitionValue) > 0) {
                continue;
            }
            while (comparator.compare(items.elementAt(indices[++i]), partitionValue) < 0) {
            }
            if (i >= j) break;
            OiixSort.swap(indices, i, j);
        }
        return j;
    }
}

