/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiil.OiilNativeException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgEnvironment;
import oracle.sysman.oii.oiip.oiipg.OiipgSpawn;
import oracle.sysman.oii.oiix.OiixBufferOutputStream;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawnException;

public final class OiixSpawner {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 0x1000000;
    private static final int CHUNK_LENGTH = 512;
    private static final int PROCESS_FAILURE = -1;
    private List m_resultOut = null;
    private List m_resultErr = null;
    private ByteArrayOutputStream m_baErrStream = null;
    private int m_resultCode = -1;
    private Process m_process = null;
    StreamReader m_outputReader = null;
    StreamReader m_errorReader = null;
    Thread m_outputThread = null;
    Thread m_errorThread = null;
    private boolean m_modifiedCmdExec = false;
    private String m_sJavaHome = OiipgEnvironment.getEnv("JAVA_HOME");
    private static final String S_LOG_DELIMITER = "----------------------------------";
    private boolean m_bLogOutput = true;

    public OiixSpawner(OutputStream outStream, OutputStream errStream) {
        this.m_resultOut = new ArrayList(1);
        this.m_resultOut.add(outStream);
        this.m_resultErr = new ArrayList(1);
        this.m_resultErr.add(errStream);
    }

    public OiixSpawner(List outStreams, List errStreams) {
        this.m_resultOut = outStreams;
        this.m_resultErr = errStreams;
    }

    public OiixSpawner() {
        this(System.out, System.err);
    }

    public void setLogOutput(boolean bLogOutput) {
        this.m_bLogOutput = bLogOutput;
    }

    private final void init() {
        this.m_process = null;
        this.m_resultCode = -1;
    }

    private void setResultCode(int resultCode) {
        this.m_resultCode = resultCode;
    }

    public boolean isPresentStatusFailed() {
        return this.m_resultCode == -1;
    }

    public void sendInputToProcess(Process proc, String cmd) throws OiixSpawnException {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(proc.getOutputStream()));
            bufferedWriter.write(cmd);
            bufferedWriter.newLine();
            bufferedWriter.flush();
        }
        catch (Exception e) {
            throw new OiixSpawnException(e.toString());
        }
    }

    private void startCollectingProcessResult() throws OiixSpawnException {
        if (this.m_bLogOutput) {
            OiiolTextLogger.appendRawText(OiiolTextLogger.NEW_LINE);
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_START_SPAWN_LOG"));
            OiiolTextLogger.appendText(S_LOG_DELIMITER);
            OiiolTextLogger.appendRawText(OiiolTextLogger.NEW_LINE);
        }
        OutputStream[] outStreams = new OutputStream[this.m_resultOut.size()];
        this.m_outputReader = new StreamReader(this.m_process, false, this.m_resultOut.toArray(outStreams), this.m_bLogOutput);
        this.m_outputThread = new Thread(this.m_outputReader);
        this.m_outputThread.start();
        if (this.m_modifiedCmdExec) {
            this.m_resultErr.add(this.m_baErrStream);
        }
        OutputStream[] errStreams = new OutputStream[this.m_resultErr.size()];
        this.m_errorReader = new StreamReader(this.m_process, true, this.m_resultErr.toArray(errStreams), this.m_bLogOutput);
        this.m_errorThread = new Thread(this.m_errorReader);
        this.m_errorThread.start();
    }

    private void completeCollectingProcessResult() throws OiixSpawnException {
        Exception threadExcep;
        try {
            if (this.m_outputThread != null) {
                this.m_outputThread.join();
            }
            if (this.m_errorThread != null) {
                this.m_errorThread.join();
            }
        }
        catch (InterruptedException e) {
            throw new OiixSpawnException(e.toString());
        }
        if (this.m_bLogOutput) {
            OiiolTextLogger.appendText(OiixResourceBundle.getString("S_END_SPAWN_LOG"));
            OiiolTextLogger.appendText(S_LOG_DELIMITER);
        }
        if (this.m_outputReader != null && (threadExcep = this.m_outputReader.getException()) != null) {
            throw new OiixSpawnException(threadExcep.toString());
        }
        if (this.m_errorReader != null && (threadExcep = this.m_errorReader.getException()) != null) {
            throw new OiixSpawnException(threadExcep.toString());
        }
    }

    public synchronized void asyncExec(String cmd) throws OiixSpawnException {
        block5: {
            this.init();
            OiipgSpawn pgSp = new OiipgSpawn();
            try {
                try {
                    pgSp.asyncExec(cmd);
                }
                catch (IOException ioe) {
                    String modCmd = new OiipgSpawn().modifyCmdLine(cmd);
                    if (!modCmd.equals(cmd)) {
                        pgSp.asyncExec(modCmd);
                        break block5;
                    }
                    throw ioe;
                }
            }
            catch (Exception e) {
                throw new OiixSpawnException(e.toString());
            }
        }
    }

    public void execute(String cmd) throws OiixSpawnException {
        this.execute(cmd, null, null);
    }

    public synchronized void execute(String cmd, String[] cmdLineArgs, String[] envp) throws OiixSpawnException {
        this.execute(cmd, cmdLineArgs, envp, false);
    }

    synchronized void execute(String cmd, String[] cmdLineArgs, String[] envp, boolean bUseCommandArray) throws OiixSpawnException {
        this.beginExecute(cmd, cmdLineArgs, envp, bUseCommandArray);
        this.awaitCompletion();
    }

    public synchronized void execute(String[] cmd) throws OiixSpawnException {
        String sCmd = cmd[0];
        String[] sCmdArgs = null;
        int len = cmd.length;
        if (len > 1) {
            sCmdArgs = new String[len - 1];
            System.arraycopy(cmd, 1, sCmdArgs, 0, len - 1);
        }
        this.execute(sCmd, sCmdArgs, null, true);
    }

    public void beginExecute(String cmd) throws OiixSpawnException {
        this.beginExecute(cmd, null, null);
    }

    public void beginExecute(String cmd, String[] cmdLineArgs) throws OiixSpawnException {
        this.beginExecute(cmd, cmdLineArgs, null);
    }

    public void beginExecute(String cmd, String[] cmdLineArgs, String[] envp) throws OiixSpawnException {
        this.beginExecute(cmd, cmdLineArgs, envp, false);
    }

    public void beginExecute(String cmd, String[] cmdLineArgs, String[] envp, boolean bUseCommandArray) throws OiixSpawnException {
        if (this.m_process != null) {
            String errString = OiixResourceBundle.getString("S_SPAWNER_ALREADY_IN_USE");
            throw new OiixSpawnException(MessageFormat.format(errString, cmd));
        }
        this.init();
        try {
            block5: {
                Runtime rt = Runtime.getRuntime();
                try {
                    this.execRunTime(cmd, cmdLineArgs, envp, bUseCommandArray);
                }
                catch (IOException ioe) {
                    OiiolTextLogger.appendText("Exception occured during spawning :" + ioe.getMessage());
                    boolean bModSuccess = this.modifyAndExecCommand(cmd, cmdLineArgs, envp);
                    if (bModSuccess) break block5;
                    throw ioe;
                }
            }
            this.startCollectingProcessResult();
        }
        catch (Exception e) {
            this.m_process = null;
            throw new OiixSpawnException(e.toString());
        }
    }

    private boolean modifyAndExecCommand(String cmd, String[] cmdLineArgs, String[] envp) throws IOException, OiilNativeException {
        boolean bRet = true;
        String modCmd = "";
        OiipgSpawn pg = new OiipgSpawn();
        if (cmdLineArgs == null) {
            modCmd = OiipgSpawn.getAssociatedCommand(cmd);
            if (modCmd.equals(cmd)) {
                modCmd = pg.modifyCmdLine(cmd);
            }
        } else {
            File f;
            if (cmdLineArgs.length == 1 && (f = new File(OiixPathOps.stripQuotes(cmdLineArgs[0]))).exists()) {
                modCmd = OiipgSpawn.getAssociatedCommand(cmdLineArgs[0]);
            }
            if (modCmd.equals("") || modCmd.equals(cmdLineArgs[0])) {
                modCmd = pg.modifyCmdLine(this.getCommand(cmd, cmdLineArgs));
            }
        }
        if (!modCmd.equals("")) {
            OiiolTextLogger.appendText("Spawning the modified command :" + modCmd);
            this.execRunTime(modCmd, null, envp, false);
            this.m_modifiedCmdExec = true;
            this.m_baErrStream = new ByteArrayOutputStream();
        } else {
            bRet = false;
        }
        return bRet;
    }

    private String getCommand(String sCmd, String[] sArgs) {
        String cmdLine = sCmd;
        if (sArgs != null) {
            for (int i = 0; i < sArgs.length; ++i) {
                cmdLine = cmdLine + " " + sArgs[i];
            }
        }
        return cmdLine;
    }

    private String[] getCommandArray(String sCmd, String[] sArgs) {
        String[] cmdArray = null;
        int iLen = 1 + (sArgs == null ? 0 : sArgs.length);
        cmdArray = new String[iLen];
        cmdArray[0] = sCmd;
        if (sArgs != null) {
            System.arraycopy(sArgs, 0, cmdArray, 1, sArgs.length);
        }
        return cmdArray;
    }

    private void execRunTime(String cmd, String[] cmdLineArgs, String[] envp, boolean bUseCommandArray) throws IOException {
        Runtime rt = Runtime.getRuntime();
        this.unsetJavaHome();
        this.m_process = bUseCommandArray ? rt.exec(this.getCommandArray(cmd, cmdLineArgs), envp) : rt.exec(this.getCommand(cmd, cmdLineArgs), envp);
        this.resetJavaHome();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitCompletion() throws OiixSpawnException {
        try {
            this.completeCollectingProcessResult();
            try {
                OiipgSpawn pgs;
                int ret = this.m_process.waitFor();
                if (this.m_modifiedCmdExec && (pgs = new OiipgSpawn()).checkForErr(this.m_baErrStream.toString())) {
                    throw new OiixSpawnException();
                }
                this.setResultCode(ret);
            }
            catch (Exception e) {
                throw new OiixSpawnException(e.getMessage());
            }
            Object var4_4 = null;
            this.m_process = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.m_process = null;
            throw throwable;
        }
    }

    public void killProcess() {
        if (this.m_process != null) {
            this.m_process.destroy();
        }
    }

    public synchronized int getResultCode() {
        return this.m_resultCode;
    }

    private void unsetJavaHome() {
        this.m_sJavaHome = OiipgEnvironment.getEnv("JAVA_HOME");
        OiipgEnvironment.setEnv("JAVA_HOME", "", false, true);
    }

    public int asyncRuntimeExec(String[] sCommand) {
        int retVal = 0;
        try {
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(sCommand, null);
            if (p != null) {
                retVal = p.exitValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private void resetJavaHome() {
        OiipgEnvironment.setEnv("JAVA_HOME", this.m_sJavaHome, false, true);
    }

    private void killAfter(int msecs) {
        new Thread(new ProcessKiller(this, msecs)).start();
    }

    private class ProcessKiller
    implements Runnable {
        private OiixSpawner m_spawner;
        private int m_runTime;

        ProcessKiller(OiixSpawner spawner, int runTime) {
            this.m_spawner = spawner;
            this.m_runTime = runTime;
        }

        public void run() {
            try {
                Thread.currentThread();
                Thread.sleep(this.m_runTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_spawner.killProcess();
            System.out.println("Killed process");
        }
    }

    private class StreamReader
    implements Runnable {
        private Process m_proc = null;
        private Exception m_e = null;
        private boolean m_readErr = false;
        private OutputStream[] m_writeStreams = null;
        private boolean m_bLog;

        StreamReader(Process p, boolean readErr, OutputStream[] writeStreams, boolean bLog) {
            this.m_proc = p;
            this.m_readErr = readErr;
            this.m_writeStreams = writeStreams;
            this.m_bLog = bLog;
        }

        public Exception getException() {
            return this.m_e;
        }

        public void run() {
            char[] chunk = new char[512];
            try {
                int count;
                InputStreamReader localizedInputStream = new InputStreamReader(this.m_readErr ? this.m_proc.getErrorStream() : this.m_proc.getInputStream());
                while ((count = localizedInputStream.read(chunk, 0, chunk.length)) >= 0) {
                    String str = new String(chunk, 0, count);
                    for (int i = 0; i < this.m_writeStreams.length; ++i) {
                        if (this.m_writeStreams[i] == null) continue;
                        if (this.m_writeStreams[i] instanceof OiixBufferOutputStream) {
                            OiixBufferOutputStream bufStream = (OiixBufferOutputStream)this.m_writeStreams[i];
                            bufStream.write(str);
                            continue;
                        }
                        this.m_writeStreams[i].write(str.getBytes());
                    }
                    if (!this.m_bLog) continue;
                    OiiolTextLogger.appendRawText(str);
                }
            }
            catch (Exception e) {
                this.m_e = e;
            }
        }
    }
}

