/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixInvalidDataException;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixLanguage;
import oracle.sysman.oii.oiix.OiixOraparam;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class OiixUtilityOps {
    public static final String TIMESTAMP_PROPERTY = "oracle.installer.timestamp";

    static Class getClassForName(String sName) throws OiixInvalidDataException {
        try {
            return Class.forName(sName);
        }
        catch (ClassNotFoundException exception) {
            try {
                return OiixJarClassLoader.getClass(sName);
            }
            catch (ClassNotFoundException e2) {
                Object[] args = new Object[]{sName};
                throw new OiixInvalidDataException(OiixResourceBundle.getString("S_INVALID_ELEMENT_TYPE_SPECIFIED", args));
            }
        }
    }

    static void validateElementType(Object oObject, Class oClass) throws OiixInvalidDataException {
        if (!oClass.isInstance(oObject)) {
            Object[] args = new Object[]{oObject, oObject.getClass().getName(), oClass.getName()};
            throw new OiixInvalidDataException(OiixResourceBundle.getString("S_ELEMENT_TYPE_INCORRECT", args));
        }
    }

    public static Boolean booleanValueOf(boolean bValue) {
        return bValue ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String getSessionTimeStamp() {
        String sTimeStamp = System.getProperty(TIMESTAMP_PROPERTY);
        if (sTimeStamp == null) {
            sTimeStamp = OiixUtilityOps.getTimeStamp();
        }
        return sTimeStamp;
    }

    public static String getTimeStamp() {
        Date d = new Date();
        SimpleDateFormat df = new SimpleDateFormat(OiixResourceBundle.getString("S_DATE_FORMAT"), OiixLanguage.ENGLISH);
        return df.format(d);
    }

    public static boolean displayStackTraceInformation(Throwable ex) {
        if (null == ex) {
            OiiolTextLogger.appendText("Null stack trace reference!");
            return false;
        }
        if (OiiolTextLogger.getLogLevel() == OiiolTextLogger.LOG_TRACE) {
            StackTraceElement[] stackElements = ex.getStackTrace();
            OiiolTextLogger.appendText("*********************START*******************************");
            StringBuffer sbuf = new StringBuffer();
            for (int lcv = 0; lcv < stackElements.length; ++lcv) {
                sbuf.append("\n" + stackElements[lcv].toString());
            }
            OiiolTextLogger.appendText(sbuf.toString());
            OiiolTextLogger.appendText("*********************END*******************************");
        }
        return true;
    }

    public static String geVC8CommandLine() {
        String scratchPath = System.getProperty("oracle.installer.scratchPath");
        String startupLocation = System.getProperty("oracle.installer.startup_location");
        String MSVCREDIST_LOC = OiixOraparam.getOraparamProfileString("MSVCREDIST_LOC", null);
        String MSVCREDIST_FLAGS = OiixOraparam.getOraparamProfileString("MSVCREDIST_FLAGS", null);
        String EXT_BIN = OiixOraparam.getOraparamProfileString("EXT_BIN", null);
        String EXT_BIN_FOR_SCRATCH = "/ext/bin";
        String cmdToRun = "";
        if (MSVCREDIST_FLAGS != null && MSVCREDIST_LOC != null && EXT_BIN != null) {
            if (System.getProperty("oracle.installer.bootstrap") != null && System.getProperty("oracle.installer.bootstrap").equalsIgnoreCase("true")) {
                cmdToRun = OiixPathOps.getNativeForm(OiixPathOps.concatPath(scratchPath, EXT_BIN_FOR_SCRATCH));
                cmdToRun = OiixPathOps.getNativeForm(OiixPathOps.concatPath(cmdToRun, MSVCREDIST_LOC));
                cmdToRun = cmdToRun + " " + MSVCREDIST_FLAGS;
                return cmdToRun;
            }
            cmdToRun = OiixPathOps.getNativeForm(OiixPathOps.concatPath(startupLocation, EXT_BIN));
            cmdToRun = OiixPathOps.getNativeForm(OiixPathOps.concatPath(cmdToRun, MSVCREDIST_LOC));
            cmdToRun = cmdToRun + " " + MSVCREDIST_FLAGS;
            return cmdToRun;
        }
        OiiolTextLogger.appendText("Although flag to installVC8 is set from orapram.ini, the location of exe and flag not found. Not installing VC8 runtime now.");
        return null;
    }
}

