/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class OiixZipInputStream
extends ZipInputStream {
    byte[] buffer = new byte[1024];
    private RandomAccessFile zipfile;

    public OiixZipInputStream(InputStream in, String zipName) {
        super(in);
        try {
            this.zipfile = new RandomAccessFile(zipName, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (in == null) {
            throw new NullPointerException("in is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getPermissionInfo() {
        HashMap<String, Integer> permissionInfo;
        block13: {
            permissionInfo = new HashMap<String, Integer>();
            boolean found = false;
            long pos = this.zipfile.length() - 22L;
            if (pos >= 0L) {
                this.zipfile.seek(pos);
                byte[] a = new byte[4];
                int count = this.zipfile.read(a);
                while (count != -1) {
                    if (OiixZipInputStream.getLong(a, 0) == 101010256L) {
                        found = true;
                        break;
                    }
                    this.zipfile.seek(--pos);
                    count = this.zipfile.read(a);
                }
            }
            if (!found) {
                throw new ZipException("The unzipping file is not a ZIP archive");
            }
            this.zipfile.seek(pos + 16L);
            byte[] firstCENHeader = new byte[4];
            this.zipfile.readFully(firstCENHeader);
            this.zipfile.seek(OiixZipInputStream.getLong(firstCENHeader, 0));
            byte[] cenData = new byte[42];
            byte[] cenHdrSig = new byte[4];
            this.zipfile.readFully(cenHdrSig);
            long sig = OiixZipInputStream.getLong(cenHdrSig, 0);
            while (sig == 33639248L) {
                this.zipfile.readFully(cenData);
                int fileNameLen = OiixZipInputStream.getShort(cenData, 24);
                int extraLen = OiixZipInputStream.getShort(cenData, 26);
                int commentLen = OiixZipInputStream.getShort(cenData, 28);
                long externalAtt = OiixZipInputStream.getLong(cenData, 34);
                byte[] fileName = new byte[fileNameLen];
                this.zipfile.readFully(fileName);
                this.zipfile.skipBytes(extraLen + commentLen);
                int permInfo = (int)(externalAtt >> 16 & 0xFFFFL);
                String name = OiixZipInputStream.getUTF8String(fileName, 0, fileNameLen);
                permissionInfo.put(name, new Integer(permInfo));
                this.zipfile.readFully(cenHdrSig);
                sig = OiixZipInputStream.getLong(cenHdrSig, 0);
            }
            Object var19_17 = null;
            try {
                this.zipfile.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            break block13;
            {
                catch (IOException e) {
                    e.printStackTrace();
                    Object var19_18 = null;
                    try {
                        this.zipfile.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var19_19 = null;
                try {
                    this.zipfile.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
        return permissionInfo;
    }

    protected static final int getShort(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    protected static final long getLong(byte[] b, int off) {
        return (long)OiixZipInputStream.getShort(b, off) | (long)OiixZipInputStream.getShort(b, off + 2) << 16;
    }

    private static String getUTF8String(byte[] b, int off, int len) {
        int count = 0;
        int max = off + len;
        int i = off;
        block10: while (i < max) {
            int c = b[i++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    continue block10;
                }
                case 12: 
                case 13: {
                    if ((b[i++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    continue block10;
                }
                case 14: {
                    if ((b[i++] & 0xC0) != 128 || (b[i++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    continue block10;
                }
            }
            throw new IllegalArgumentException();
        }
        if (i != max) {
            throw new IllegalArgumentException();
        }
        char[] cs = new char[count];
        i = 0;
        block11: while (off < max) {
            int c = b[off++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cs[i++] = (char)c;
                    continue block11;
                }
                case 12: 
                case 13: {
                    cs[i++] = (char)((c & 0x1F) << 6 | b[off++] & 0x3F);
                    continue block11;
                }
                case 14: {
                    int t = (b[off++] & 0x3F) << 6;
                    cs[i++] = (char)((c & 0xF) << 12 | t | b[off++] & 0x3F);
                    continue block11;
                }
            }
            throw new IllegalArgumentException();
        }
        return new String(cs, 0, count);
    }
}

