/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiix;

import oracle.sysman.oii.oiif.oiifr.OiifrAPIProgressActionListener;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPhases;
import oracle.sysman.oii.oiix.OiixProgressListener;

class ProgressHandler
implements OiifrAPIProgressActionListener,
OiixProgressListener {
    private int m_curPhase = 0;
    private long m_totalBytes = 0L;
    private boolean m_useNewProgress = false;
    private long m_currentBytes = 0L;
    private long m_adTotalBytes = 0L;
    private int m_percent = 0;

    private void updatePercentage(int percent) {
        this.m_percent = percent;
    }

    public void onCancel() {
        System.out.println("\n User selected Cancel and it was done successfully");
    }

    public void setTotalBytes(long bytes) {
        this.m_totalBytes = bytes;
    }

    public void setStatus(String status) {
        System.out.println("\n" + status);
    }

    public void addBytes(int bytes) {
        if (bytes == 0) {
            return;
        }
        this.m_useNewProgress = true;
        if (this.m_totalBytes > 0L) {
            this.m_currentBytes += (long)bytes;
            double dPercent = (double)this.m_currentBytes * 100.0 / (double)this.m_totalBytes;
            int percent = dPercent < 50.0 ? (int)Math.ceil(dPercent) : (int)dPercent;
            percent = Math.min(percent, 99);
            this.setPercentage(percent);
        } else {
            this.setPercentage(100);
        }
    }

    private void setProgressPercentage(int newPercent) {
        int currentPercent = this.m_percent;
        if (currentPercent >= newPercent) {
            return;
        }
        this.updatePercentage(newPercent);
    }

    private void setPercentage(int newPercent) {
        int currentPercent = this.m_percent;
        if (currentPercent >= newPercent) {
            return;
        }
        this.setProgressPercentage(newPercent);
    }

    public void removeBytes(int bytes) {
    }

    public void onDoneProgress() {
        this.updatePercentage(100);
    }

    public void addPercentage(int percent) {
        int value = this.m_percent + percent;
        this.m_currentBytes += (long)percent * this.m_totalBytes / 100L;
        value = Math.min(value, 99);
        this.updatePercentage(value);
    }

    public void onCurrentComponent(String Comp) {
        System.out.println("\n Component : " + Comp);
        Object[] msgArr = new String[]{Comp};
        int iPhaseIdx = OiifrProgressPhases.getPhaseIndex(this.m_curPhase);
        System.out.println("\n" + OiifrProgressPhases.getComponentInProgressString(this.m_curPhase, msgArr));
    }

    public void setPhases(int phases, int lastPhase) {
        System.out.println("\n the number of phases are : " + phases);
        System.out.println("\n the last phase is  : " + lastPhase);
    }

    public void onStartDeinstall() {
        System.out.println("\n Starting deinstall");
    }

    public void onDoneDeinstall() {
        System.out.println("\n Done deinstall");
    }

    public void onStartPhase(int phase) {
        int iPhaseIdx = OiifrProgressPhases.getPhaseIndex(phase);
        this.m_curPhase = phase;
        System.out.println("\n" + OiifrProgressPhases.getPhaseInProgressString(phase));
    }

    public void onDonePhase(int phase) {
        int iPhaseIdx = OiifrProgressPhases.getPhaseIndex(phase);
        System.out.println("\n" + OiifrProgressPhases.getPhaseDoneString(phase));
    }

    public void onSuspend() {
        System.out.println("\n The operation has been suspended temporarily");
    }

    public void onResume() {
        System.out.println("\n The operation has been resumed");
    }

    public boolean isNewProgressUsed() {
        return false;
    }

    public void setTitle(String status) {
    }
}

