/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiiz;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiLibInvEntry;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodDepException;
import oracle.sysman.oii.oiio.oiiod.OiiodDepNode;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oii.oiiz.OiizCDCompInfo;
import oracle.sysman.oii.oiiz.OiizCallback;
import oracle.sysman.oii.oiiz.OiizResourceBundle;
import oracle.sysman.oii.oiiz.OiizStageVerifier;

public class OiizCDStager {
    private OiiiStageInventory m_stageInv;
    private OiizCallback m_oCallBack;
    private OiizStageVerifier m_oStageVerifier;
    private boolean m_bError;

    public OiizCDStager(OiizStageVerifier oStageVerifier, OiizCallback callBack) {
        this.m_oStageVerifier = oStageVerifier;
        this.m_stageInv = oStageVerifier.getStageInv();
        this.m_oCallBack = callBack;
    }

    public boolean isError() {
        return this.m_bError;
    }

    public void verifyExistingDisks() throws IOException {
        this.callBack(OiizResourceBundle.getString("S_VERIFYING_EXISTING_DISKS"));
        int nMaxDisk = 1;
        Enumeration vAllComps = this.m_stageInv.getAllComps(0);
        while (vAllComps.hasMoreElements()) {
            OiiiStageCompInvEntry invEntry = (OiiiStageCompInvEntry)vAllComps.nextElement();
            nMaxDisk = Math.max(nMaxDisk, invEntry.getDiskNumber());
        }
        String sJarLocation = OiixPathOps.getParentDir(OiixPathOps.getStandardForm(this.m_oStageVerifier.getLocation()));
        String sErrDisks = "";
        if (nMaxDisk > 1) {
            boolean bError = false;
            for (int i = 1; i <= nMaxDisk; ++i) {
                Object[] args;
                String sDirName = OiixPathOps.concatPath(sJarLocation, "../../") + "Disk" + i;
                File f = new File(sDirName);
                if (f.exists()) continue;
                if (bError) {
                    args = new String[]{sErrDisks, "Disk" + i};
                    sErrDisks = OiizResourceBundle.getString("S_MISSING_DISK_NEXT", args);
                    continue;
                }
                args = new String[]{"Disk" + i};
                sErrDisks = OiizResourceBundle.getString("S_MISSING_DISK_FIRST", args);
                bError = true;
            }
            if (bError) {
                Object[] args = new String[]{sErrDisks};
                throw new IOException(OiizResourceBundle.getString("S_MISSING_DISK_ERROR", args));
            }
        }
    }

    public Vector calculateOrdering() {
        return this.calculateOrdering(null);
    }

    public Vector calculateOrdering(String[] sBootStrapcomp) {
        ArrayList<String> sBootStrapcompList = new ArrayList<String>();
        if (sBootStrapcomp != null) {
            for (int i = 0; i < sBootStrapcomp.length; ++i) {
                sBootStrapcompList.add(sBootStrapcomp[i].trim());
            }
        }
        Vector v = new Vector();
        if (this.m_stageInv == null) {
            return v;
        }
        Vector vTopComps = this.m_oStageVerifier.getTopLevelComps();
        int nSize = vTopComps.size();
        if (nSize > 0) {
            int i;
            Object[] ids = new OiiiCompInstallID[nSize];
            vTopComps.copyInto(ids);
            OiiiStageCompInvEntry invEntry = this.m_stageInv.getStageCompInvEntry((OiiiCompInstallID)ids[0], new Vector());
            OiiodDepEngine depEngine = new OiiodDepEngine(this.m_oStageVerifier);
            depEngine.setErrListener(this.m_oStageVerifier);
            depEngine.setInventories(this.m_stageInv, new OiiiInstallInventory());
            depEngine.setCurrentPlatform(0);
            depEngine.setExecutePreReq(false);
            depEngine.setCurrentTLIDs((OiiiCompInstallID[])ids);
            try {
                depEngine.buildCompArray();
            }
            catch (OiiodDepException exp) {
                this.m_bError = true;
            }
            v = depEngine.getOrderedComps();
            boolean isTopLevelPatchSet = false;
            for (int i2 = 0; i2 < ids.length; ++i2) {
                if (((OiiiCompInstallID)ids[i2]).getCompType() != 4) continue;
                isTopLevelPatchSet = true;
                break;
            }
            Enumeration vAllComps = this.m_stageInv.getAllComps(0);
            OiiodDepNode oNode = null;
            Vector<OiiiCompInstallID> vUnusedAll = new Vector<OiiiCompInstallID>();
            Vector<OiiiCompInstallID> vUnusedComps = new Vector<OiiiCompInstallID>();
            Vector<OiiiCompInstallID> vUnusedOthers = new Vector<OiiiCompInstallID>();
            Vector vUnusedCompsDepNodes = new Vector();
            Vector<OiiiStageCompInvEntry> vUnusedCompsInvEntries = new Vector<OiiiStageCompInvEntry>();
            Vector<OiiiCompInstallID> vBootstrapComp = new Vector<OiiiCompInstallID>();
            Vector<OiiiCompInstallID> vJDK = new Vector<OiiiCompInstallID>();
            Vector<OiiiCompInstallID> vJRE = new Vector<OiiiCompInstallID>();
            OiiiCompInstallID[] oOUICompIds = new OiiiCompInstallID[4];
            boolean ctr = true;
            while (vAllComps.hasMoreElements()) {
                OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)vAllComps.nextElement();
                OiiiCompInstallID cid = scie.getCompInstallID();
                switch (cid.getCompType()) {
                    case 1: {
                        oNode = depEngine.getDepNode(cid);
                        break;
                    }
                    case 2: {
                        oNode = depEngine.getDepPatchNode(cid);
                        break;
                    }
                    case 4: {
                        oNode = depEngine.getPatchSetNode(cid);
                    }
                }
                String compName = cid.getName().toLowerCase();
                if (oNode == null) {
                    if (compName.equals("oracle.swd.oui")) {
                        oOUICompIds[0] = cid;
                    } else if (compName.equals("oracle.swd.opatch")) {
                        oOUICompIds[1] = cid;
                    } else if (compName.equals("oracle.swd.oui.core")) {
                        oOUICompIds[2] = cid;
                    } else if (compName.equals("oracle.swd.oui.core.min")) {
                        oOUICompIds[3] = cid;
                    } else if (compName.equals("oracle.swd.jre")) {
                        vJRE.add(cid);
                    } else if (compName.equals("oracle.jdk")) {
                        vJDK.insertElementAt(cid, 0);
                    } else if ("oracle.jre".equals(compName)) {
                        vJDK.insertElementAt(cid, 1);
                    } else if (compName.equals("oracle.java.j2ee.core")) {
                        vJDK.addElement(cid);
                    } else {
                        int idx = OiixVectorOps.vectIndexOf(vUnusedAll, (Object)cid);
                        if (idx == -1) {
                            if (isTopLevelPatchSet) {
                                if (cid.getCompType() == 1) {
                                    vUnusedComps.addElement(cid);
                                    vUnusedCompsInvEntries.addElement(scie);
                                } else {
                                    vUnusedOthers.addElement(cid);
                                }
                            } else {
                                v.insertElementAt(cid, 0);
                            }
                            vUnusedAll.addElement(cid);
                        }
                    }
                }
                if (!sBootStrapcompList.contains(compName)) continue;
                vBootstrapComp.add(cid);
            }
            if (isTopLevelPatchSet) {
                int i3;
                for (int i4 = 0; i4 < vUnusedComps.size(); ++i4) {
                    OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)vUnusedCompsInvEntries.elementAt(i4);
                    try {
                        vUnusedCompsDepNodes.addElement(depEngine.createComp(scie, null));
                        continue;
                    }
                    catch (OiiodDepException e) {
                        this.m_bError = true;
                    }
                }
                depEngine.setDepNodes(vUnusedCompsDepNodes);
                try {
                    depEngine.sortCompNodes();
                }
                catch (OiiodDepException e) {
                    this.m_bError = true;
                }
                vUnusedCompsDepNodes = depEngine.getDepNodes();
                for (i3 = 0; i3 < vUnusedCompsDepNodes.size(); ++i3) {
                    OiiodDepNode unUsedCompsDepNode = (OiiodDepNode)vUnusedCompsDepNodes.elementAt(i3);
                    v.addElement(unUsedCompsDepNode.getCompInstallID());
                }
                for (i3 = 0; i3 < vUnusedOthers.size(); ++i3) {
                    v.insertElementAt(vUnusedOthers.elementAt(i3), 0);
                }
            }
            for (i = 0; i < oOUICompIds.length; ++i) {
                if (oOUICompIds[i] == null) continue;
                v.addElement(oOUICompIds[i]);
            }
            if (vJRE.size() > 0) {
                v.addAll(vJRE);
            }
            if (vBootstrapComp.size() > 0) {
                for (i = 0; i < vBootstrapComp.size(); ++i) {
                    if (!v.contains(vBootstrapComp.elementAt(i))) continue;
                    v.remove(vBootstrapComp.elementAt(i));
                }
                v.addAll(vBootstrapComp);
            }
            for (i = 0; i < vJDK.size(); ++i) {
                v.addElement(vJDK.elementAt(i));
            }
        } else {
            Enumeration vAllComps = this.m_stageInv.getAllComps(0);
            while (vAllComps.hasMoreElements()) {
                OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)vAllComps.nextElement();
                OiiiCompInstallID cid = scie.getCompInstallID();
                int idx = OiixVectorOps.vectIndexOf(v, (Object)cid);
                if (idx != -1) continue;
                v.addElement(cid);
            }
        }
        return v;
    }

    private long getInstallFilesSize() {
        Hashtable<String, String> oInstallJars = new Hashtable<String, String>();
        long nTotalSize = 0L;
        String sProdJarLocation = this.m_oStageVerifier.getLocation();
        File f = new File(sProdJarLocation);
        nTotalSize += f.length();
        String sStageLocation = f.getParent();
        String sRespFilesDir = OiixPathOps.concatPath(sStageLocation, "Response");
        File fResp = new File(OiixPathOps.getNativeForm(sRespFilesDir));
        if (fResp.exists() && fResp.isDirectory()) {
            nTotalSize += OiixFileOps.getTotalFileSize(fResp, true);
        }
        Enumeration vAllComps = this.m_stageInv.getAllComps(0);
        while (vAllComps.hasMoreElements()) {
            OiiiStageCompInvEntry scie = (OiiiStageCompInvEntry)vAllComps.nextElement();
            if (scie.isStageVersionPreX("2.0")) {
                if (scie.getCompInstallID().getCompType() == 4) continue;
                String compInsPath = OiixPathOps.concatPath(scie.getLocation(), "compIns.jar");
                compInsPath = OiixPathOps.concatPath(sStageLocation, compInsPath);
                f = new File(compInsPath);
                nTotalSize += f.length();
                String helpPath = OiixPathOps.concatPath(scie.getLocation(), "help");
                helpPath = OiixPathOps.concatPath(sStageLocation, helpPath);
                f = new File(helpPath);
                nTotalSize += OiixFileOps.getTotalFileSize(f, true);
                String compResPath = OiixPathOps.concatPath(scie.getLocation(), "resources");
                compResPath = OiixPathOps.concatPath(sStageLocation, compResPath);
                f = new File(compResPath);
                nTotalSize += OiixFileOps.getTotalFileSize(f, true);
                continue;
            }
            String sJarName = scie.getJarName();
            if (oInstallJars.containsKey(sJarName)) continue;
            String sJarPath = OiixPathOps.concatPath(sStageLocation, scie.getInstallDefnLoc());
            sJarPath = OiixPathOps.concatPath(sJarPath, sJarName);
            f = new File(sJarPath);
            nTotalSize += f.length();
            oInstallJars.put(sJarName, sJarName);
        }
        for (int i = 0; i < 3; ++i) {
            Vector v = this.m_stageInv.getAllLibsVect(i);
            int nLibs = v.size();
            for (int j = 0; j < nLibs; ++j) {
                OiiiLibInvEntry lie = (OiiiLibInvEntry)v.elementAt(j);
                String sLibLocation = lie.getLocation();
                sLibLocation = OiixPathOps.concatPath(sStageLocation, sLibLocation);
                f = new File(sLibLocation);
                nTotalSize += f.length();
            }
        }
        return nTotalSize;
    }

    private long getJreOuiSpace(Vector vOrder) {
        OiiiCompInstallID id;
        long nTotalSize = 0L;
        int nOrderSize = vOrder.size();
        for (int i = nOrderSize - 1; i >= 0 && ((id = (OiiiCompInstallID)vOrder.elementAt(i)).getName().toLowerCase().equals("oracle.swd.jre") || id.getName().toLowerCase().equals("oracle.swd.oui") || id.getName().toLowerCase().equals("oracle.swd.oui.core")); --i) {
            OiiiStageCompInvEntry oEntry = this.m_stageInv.getStageCompInvEntry(id, new Vector());
            nTotalSize += this.getCompDataFileSizes(oEntry);
        }
        return nTotalSize;
    }

    public long getCompDataFileSizes(OiiiStageCompInvEntry oComp) {
        String sProdJarLocation = this.m_oStageVerifier.getLocation();
        File f = new File(sProdJarLocation);
        String sStageLocation = f.getParent();
        long nSize = 0L;
        if (oComp.getCompInstallID().getCompType() == 4) {
            return nSize;
        }
        String sDataLocation = OiiiTargetAreaControl.genDataFilesLocation(oComp.getLocation(), oComp.getDiskNumber());
        sDataLocation = OiixPathOps.concatPath(sStageLocation, sDataLocation);
        sDataLocation = OiixPathOps.getNativeForm(sDataLocation);
        return OiixFileOps.getTotalFileSize(new File(sDataLocation), true);
    }

    public int allotSpace(long nFirstDiskSize, long nRestDiskSize, Vector vOrder, Hashtable diskComps, Vector changedComps) throws IOException {
        int nDiskCount = 1;
        int nSize = vOrder.size();
        Vector<OiiiStageCompInvEntry> vComps = new Vector<OiiiStageCompInvEntry>(10, 10);
        diskComps.put(new Integer(nDiskCount), vComps);
        long installSize = this.getInstallFilesSize();
        long minFirstDiskSize = installSize + this.getJreOuiSpace(vOrder);
        if (minFirstDiskSize > nFirstDiskSize) {
            String sMsg = OiizResourceBundle.getString("S_FIRST_CD_SIZE_SMALL_ERROR");
            Float oMinFirstDisk = new Float((double)minFirstDiskSize / 1024.0 / 1024.0);
            Object[] objs = new Object[]{oMinFirstDisk};
            DecimalFormat oDecFormat = new DecimalFormat();
            oDecFormat.setMaximumFractionDigits(2);
            MessageFormat oMsgFormat = new MessageFormat(sMsg);
            oMsgFormat.setFormat(0, oDecFormat);
            sMsg = oMsgFormat.format(objs);
            throw new IOException(sMsg);
        }
        long totalSize = installSize;
        boolean atLeastOneAlloted = false;
        for (int i = nSize - 1; i >= 0; --i) {
            OiiiCompInstallID id = (OiiiCompInstallID)vOrder.elementAt(i);
            Vector vInvEntries = this.m_stageInv.getCompInvEntries(id);
            if (vInvEntries == null) continue;
            for (int j = 0; j < vInvEntries.size(); ++j) {
                OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)vInvEntries.elementAt(j);
                long nFileSize = this.getCompDataFileSizes(oEntry);
                if (!atLeastOneAlloted && nDiskCount == 1 && installSize + nFileSize > nFirstDiskSize || nDiskCount > 1 && nFileSize > nRestDiskSize) {
                    String sMsg = OiizResourceBundle.getString("S_CD_SIZE_SMALL_ERROR");
                    Object[] objs = new Object[]{oEntry.getFullDisplayName(false), new Long(nFileSize)};
                    sMsg = MessageFormat.format(sMsg, objs);
                    throw new IOException(sMsg);
                }
                if (nDiskCount == 1 && totalSize + nFileSize > nFirstDiskSize || nDiskCount > 1 && totalSize + nFileSize > nRestDiskSize) {
                    vComps = new Vector();
                    atLeastOneAlloted = false;
                    diskComps.put(new Integer(++nDiskCount), vComps);
                    totalSize = nFileSize;
                } else {
                    atLeastOneAlloted = true;
                    totalSize += nFileSize;
                }
                vComps.addElement(oEntry);
                if (oEntry.getDiskNumber() == nDiskCount) continue;
                OiizCDCompInfo info = new OiizCDCompInfo(oEntry, oEntry.getDiskNumber(), nDiskCount, nFileSize);
                changedComps.addElement(info);
                oEntry.setDiskNumber(nDiskCount);
            }
        }
        return nDiskCount;
    }

    private void moveDirRecurse(String fromLoc, String toLoc) throws IOException {
        File fFrom = new File(fromLoc);
        File fToLoc = new File(toLoc);
        OiixFileOps.mkdirs(fToLoc);
        if (!fToLoc.exists()) {
            String sMsg = OiizResourceBundle.getString("S_ERROR_CREATEDIR");
            Object[] obj = new Object[]{toLoc};
            sMsg = MessageFormat.format(sMsg, obj);
            throw new IOException(sMsg);
        }
        String[] fileList = fFrom.list();
        if (fileList != null) {
            String fromLocDir = OiixPathOps.directorify(OiixPathOps.getStandardForm(fromLoc));
            String toLocDir = OiixPathOps.directorify(OiixPathOps.getStandardForm(toLoc));
            for (int i = 0; i < fileList.length; ++i) {
                String filePath = OiixPathOps.concatPath(fromLocDir, fileList[i]);
                filePath = OiixPathOps.getNativeForm(filePath);
                String toFile = toLocDir + fileList[i];
                File f1 = new File(filePath);
                if (f1.isDirectory() && !fileList[i].equals("locks")) {
                    this.moveDirRecurse(filePath, toFile);
                    continue;
                }
                if (fileList[i].equals("locks") || f1.renameTo(new File(OiixPathOps.getNativeForm(toFile)))) continue;
                String sMsg = OiizResourceBundle.getString("S_ERROR_MOVEDIR");
                Object[] obj = new Object[]{filePath, toFile};
                sMsg = MessageFormat.format(sMsg, obj);
                throw new IOException(sMsg);
            }
        }
        fFrom.delete();
    }

    private void deleteParentDirs(String sLoc) {
        File f = new File(sLoc);
        String[] files = f.list();
        if (files == null || files.length == 0) {
            sLoc = f.getParent();
            f.delete();
            this.deleteParentDirs(sLoc);
        }
    }

    public String rearrangeComps(Vector vChangedComps, int nDisk) throws IOException {
        int nSize = vChangedComps.size();
        String sProdJarLocation = this.m_oStageVerifier.getLocation();
        File f = new File(sProdJarLocation);
        String sStageLocation = f.getParent();
        f = new File(sStageLocation);
        if (nSize == 0) {
            return sStageLocation;
        }
        String sRoot = f.getParent();
        if (sRoot != null) {
            File fRoot;
            if (nDisk > 1 && !(fRoot = new File(sRoot)).getName().equalsIgnoreCase("Disk1")) {
                String sDisk1 = OiixPathOps.concatPath(OiixPathOps.getStandardForm(sRoot), "Disk1");
                sDisk1 = OiixPathOps.getNativeForm(sDisk1);
                File fDisk1 = new File(sDisk1);
                OiixFileOps.mkdirs(fDisk1);
                if (!fDisk1.exists()) {
                    String sMsg = OiizResourceBundle.getString("S_ERROR_CREATEDIR");
                    Object[] obj = new Object[]{sDisk1};
                    sMsg = MessageFormat.format(sMsg, obj);
                    throw new IOException(sMsg);
                }
                String sCBMsg = OiizResourceBundle.getString("S_MOVE_PROG_MSG2");
                Object[] sLocs = new Object[]{sStageLocation, sDisk1};
                sCBMsg = MessageFormat.format(sCBMsg, sLocs);
                this.callBack(sCBMsg);
                String sNewStage = OiixPathOps.concatPath(OiixPathOps.getStandardForm(sDisk1), "stage");
                sNewStage = OiixPathOps.getNativeForm(sNewStage);
                this.moveDirRecurse(sStageLocation, sNewStage);
                String sProdLoc = OiixPathOps.concatPath(OiixPathOps.getStandardForm(sNewStage), "products.xml");
                sProdLoc = OiixPathOps.getNativeForm(sProdLoc);
                f = new File(sProdLoc);
                sProdJarLocation = OiixPathOps.getNativeForm(sProdJarLocation);
                File fProdFile = new File(sProdJarLocation);
                if (!f.renameTo(fProdFile)) {
                    String sMsg = OiizResourceBundle.getString("S_ERROR_MOVEFILE");
                    Object[] obj = new Object[]{sProdLoc, sProdJarLocation};
                    sMsg = MessageFormat.format(sMsg, obj);
                    throw new IOException(sMsg);
                }
                sStageLocation = sNewStage;
            }
            String sStageLocationDir = OiixPathOps.directorify(OiixPathOps.getStandardForm(sStageLocation));
            for (int i = 0; i < nSize; ++i) {
                OiizCDCompInfo oCompInfo = (OiizCDCompInfo)vChangedComps.elementAt(i);
                OiiiStageCompInvEntry oComp = oCompInfo.getInvEntry();
                String sDataLocation = OiiiTargetAreaControl.genDataFilesLocation(oComp.getLocation(), oComp.getDiskNumber());
                sDataLocation = OiixPathOps.concatPath(sStageLocationDir, sDataLocation);
                sDataLocation = OiixPathOps.getNativeForm(sDataLocation);
                String sCompLocation = OiiiTargetAreaControl.genDataFilesLocation(oComp.getLocation(), oCompInfo.getOldDiskNumber());
                sCompLocation = OiixPathOps.concatPath(sStageLocationDir, sCompLocation);
                sCompLocation = OiixPathOps.getNativeForm(sCompLocation);
                String sCBMsg = OiizResourceBundle.getString("S_MOVE_PROG_MSG1");
                Object[] sLocs = new Object[]{oComp.getFullDisplayName(false), "" + oCompInfo.getOldDiskNumber(), "" + oComp.getDiskNumber()};
                sCBMsg = MessageFormat.format(sCBMsg, sLocs);
                this.callBack(sCBMsg);
                this.moveDirRecurse(sCompLocation, sDataLocation);
                if (oCompInfo.getOldDiskNumber() == 1) continue;
                this.deleteParentDirs(sCompLocation);
            }
        }
        return sStageLocation;
    }

    private void callBack(String msg) {
        if (this.m_oCallBack != null) {
            this.m_oCallBack.appendToMessage(msg);
        }
    }
}

