/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiiz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiConfigAggregateXMLHandler;
import oracle.sysman.oii.oiii.OiiiConfigAggregateXMLReader;
import oracle.sysman.oii.oiii.OiiiConfigAggregateXMLWriter;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiPatchInstallID;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiii.OiiiStageInventory;
import oracle.sysman.oii.oiii.OiiiStagePatchInvEntry;
import oracle.sysman.oii.oiii.OiiiTargetAreaControl;
import oracle.sysman.oii.oiil.OiilXMLHelper;
import oracle.sysman.oii.oiio.oiiod.OiiodDepEngine;
import oracle.sysman.oii.oiio.oiiod.OiiodDepException;
import oracle.sysman.oii.oiio.oiiod.OiiodDepNode;
import oracle.sysman.oii.oiio.oiiod.OiiodDepRuleNode;
import oracle.sysman.oii.oiis.OiisConfigAggregate;
import oracle.sysman.oii.oiis.OiisConfigToolDetails;
import oracle.sysman.oii.oiis.OiisPatchDepObj;
import oracle.sysman.oii.oiis.OiisPatchDeps;
import oracle.sysman.oii.oiis.OiisPatchSetContents;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixJarOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiiz.OiizCallback;
import oracle.sysman.oii.oiiz.OiizResourceBundle;
import oracle.sysman.oii.oiiz.OiizStageVerifier;
import org.xml.sax.SAXException;

public class OiizConfigMasterGenerator {
    private static boolean s_debug = false;
    private OiiiStageInventory m_stageInv;
    private OiizCallback m_oCallBack;
    private OiizStageVerifier m_oStageVerifier;
    private String m_sStageLoc;
    private Hashtable configXMLJarInfo = new Hashtable();
    private Hashtable configXMLs = new Hashtable();
    private Hashtable m_vAggActions = new Hashtable();
    private Hashtable m_hAggTypes = new Hashtable();
    private OiiiConfigAggregateXMLHandler handler = null;
    private OiiiConfigAggregateXMLWriter writer = null;
    private static int JARNAME = 0;
    private static int CONTENTLOC = 1;
    private static String AGGREGATE_PRIORITIES = "[AGGREGATE_PRIORITIES]";
    private StringBuffer m_sDepPropFileContents = new StringBuffer();
    private Hashtable m_IDsToPSets = new Hashtable();
    private String m_sUserPropFile = null;

    public OiizConfigMasterGenerator(OiizStageVerifier oStageVerifier, OiizCallback callBack) {
        this.m_oStageVerifier = oStageVerifier;
        this.m_stageInv = oStageVerifier.getStageInv();
        this.m_oCallBack = callBack;
        this.m_sStageLoc = this.m_oStageVerifier.getLocationDir();
    }

    public boolean updateConfigMaster(Vector vCompIDs, String sUserPropFile) {
        boolean bResult = true;
        String sWarn = OiizResourceBundle.getString("S_WARNING");
        if (null != vCompIDs && vCompIDs.size() > 0) {
            if (this.m_stageInv == null) {
                bResult = false;
            } else {
                int selectedIDsize;
                Vector vInvComps = this.m_stageInv.getAllCompsVect(0);
                if (null != vCompIDs && (selectedIDsize = vCompIDs.size()) > 0) {
                    for (int i = 0; i < selectedIDsize; ++i) {
                        OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)vCompIDs.elementAt(i);
                        OiiiCompInstallID compID = oEntry.getCompInstallID();
                        if (!oEntry.isTopLevel()) continue;
                        this.initialize();
                        String versionString = compID.getVersion().toString();
                        versionString = versionString.replace('.', '_');
                        String sPropFile = this.m_sStageLoc + File.separator + compID.getName() + "." + versionString + "_dep_default.properties";
                        if (sUserPropFile != null && sUserPropFile.trim().length() != 0) {
                            File file = new File(sUserPropFile);
                            if (!file.exists()) {
                                Object[] sArgs = new String[]{sUserPropFile, sPropFile};
                                this.m_oCallBack.appendToMessage(sWarn + OiizResourceBundle.getString("S_UPDATE_CONFIG_PROP_FILE_NOEXISTS", sArgs));
                                Object[] sArgs1 = new String[]{sPropFile};
                                this.m_oCallBack.appendToMessage(OiizResourceBundle.getString("S_UPDATE_CONFIG_WITH_DEF_PROP_FILE", sArgs1));
                            } else {
                                sPropFile = sUserPropFile;
                                Object[] sArg = new String[]{sPropFile};
                                this.m_oCallBack.appendToMessage(OiizResourceBundle.getString("S_UPDATE_CONFIG_USER_PROP_FILE", sArg));
                            }
                        } else {
                            Object[] sMarg = new String[]{sPropFile};
                            this.m_oCallBack.appendToMessage(OiizResourceBundle.getString("S_UPDATE_CONFIG_WITH_DEF_PROP_FILE", sMarg));
                        }
                        this.m_vAggActions = this.readFromPropFile(sPropFile);
                        if (null != this.m_vAggActions && this.m_vAggActions.size() > 0) {
                            String sMasterAggregateFullName = this.m_sStageLoc + File.separator + compID.getName() + "." + versionString + ".xml";
                            boolean bMasterXMLPresent = this.fileExists(sMasterAggregateFullName);
                            if (bMasterXMLPresent) {
                                this.callBack(OiizResourceBundle.getString("S_MASTER_XML_PRESENT"));
                                try {
                                    String sBackupFilename = this.m_sStageLoc + File.separator + compID.getName() + "." + versionString + "_" + System.currentTimeMillis() + ".bak";
                                    sBackupFilename = OiixFileOps.backUpFile(sMasterAggregateFullName, sBackupFilename);
                                    Object[] sArg = new String[]{sBackupFilename};
                                    this.callBack(OiizResourceBundle.getString("S_BACKUP_CURRENT_XML", sArg));
                                }
                                catch (IOException e) {
                                    this.callBack(sWarn + OiizResourceBundle.getString("S_COULD_BACKUP_XML"));
                                }
                            } else {
                                this.callBack(OiizResourceBundle.getString("S_NEW_MASTER_XML"));
                            }
                            try {
                                this.writer = new OiiiConfigAggregateXMLWriter(sMasterAggregateFullName, compID.getName(), false, false);
                                this.writer.updateReferences();
                                this.callBack(OiizResourceBundle.getString("S_WRITE_ACTION"));
                                this.updateActionsinXML();
                                Object[] sArgs = new String[]{sMasterAggregateFullName};
                                this.callBack(OiizResourceBundle.getString("S_WRITE_MASTER_XML", sArgs));
                                this.writer.updateXML();
                            }
                            catch (IOException ie) {
                                this.m_oStageVerifier.processError(ie.getMessage(), null);
                            }
                            catch (SAXException se) {
                                this.m_oStageVerifier.processError(se.getMessage(), null);
                            }
                            continue;
                        }
                        this.callBack(sWarn + OiizResourceBundle.getString("S_PROP_FILE_NONEXISTS"));
                    }
                }
                bResult = true;
            }
        } else {
            this.m_oCallBack.appendToMessage(OiizResourceBundle.getString("S_NO_TOPLEVEL_FOR_REGEN"));
            bResult = false;
        }
        return bResult;
    }

    public boolean updateConfigMasterForSingleComp(OiiiStageCompInvEntry oEntry, OiiiCompInstallID oCompID, String sUserPropFile) {
        boolean bResult = true;
        if (null != oCompID) {
            if (this.m_stageInv == null) {
                bResult = false;
            } else {
                if (oEntry.isTopLevel()) {
                    this.initialize();
                    String versionString = oCompID.getVersion().toString();
                    versionString = versionString.replace('.', '_');
                    String sWarn = OiizResourceBundle.getString("S_WARNING");
                    String sPropFile = this.m_sStageLoc + File.separator + oCompID.getName() + "." + versionString + "_dep_default.properties";
                    if (sUserPropFile != null && sUserPropFile.trim().length() != 0) {
                        File file = new File(sUserPropFile);
                        if (!file.exists()) {
                            Object[] sArgs = new String[]{sUserPropFile, sPropFile};
                            this.m_oCallBack.appendToMessage(sWarn + OiizResourceBundle.getString("S_UPDATE_CONFIG_PROP_FILE_NOEXISTS", sArgs));
                            Object[] sArgs1 = new String[]{sPropFile};
                            this.m_oCallBack.appendToMessage(OiizResourceBundle.getString("S_UPDATE_CONFIG_WITH_DEF_PROP_FILE", sArgs1));
                        } else {
                            sPropFile = sUserPropFile;
                            Object[] sArg = new String[]{sPropFile};
                            this.m_oCallBack.appendToMessage(OiizResourceBundle.getString("S_UPDATE_CONFIG_USER_PROP_FILE", sArg));
                        }
                    } else {
                        Object[] sMarg = new String[]{sPropFile};
                        this.m_oCallBack.appendToMessage(OiizResourceBundle.getString("S_UPDATE_CONFIG_WITH_DEF_PROP_FILE", sMarg));
                    }
                    this.m_vAggActions = this.readFromPropFile(sPropFile);
                    if (null != this.m_vAggActions && this.m_vAggActions.size() > 0) {
                        String sMasterAggregateFullName = this.m_sStageLoc + File.separator + oCompID.getName() + "." + versionString + ".xml";
                        boolean bMasterXMLPresent = this.fileExists(sMasterAggregateFullName);
                        if (bMasterXMLPresent) {
                            this.callBack(OiizResourceBundle.getString("S_MASTER_XML_PRESENT"));
                            try {
                                String sBackupFilename = this.m_sStageLoc + File.separator + oCompID.getName() + "." + versionString + "_" + System.currentTimeMillis() + ".bak";
                                sBackupFilename = OiixFileOps.backUpFile(sMasterAggregateFullName, sBackupFilename);
                                Object[] sArg = new String[]{sBackupFilename};
                                this.callBack(OiizResourceBundle.getString("S_BACKUP_CURRENT_XML", sArg));
                            }
                            catch (IOException e) {
                                this.callBack(sWarn + OiizResourceBundle.getString("S_COULD_BACKUP_XML"));
                            }
                        } else {
                            this.callBack(OiizResourceBundle.getString("S_NEW_MASTER_XML"));
                        }
                        try {
                            this.writer = new OiiiConfigAggregateXMLWriter(sMasterAggregateFullName, oCompID.getName(), false, false);
                            this.writer.updateReferences();
                            this.callBack(OiizResourceBundle.getString("S_WRITE_ACTION"));
                            this.updateActionsinXML();
                            Object[] sArgs = new String[]{sMasterAggregateFullName};
                            this.callBack(OiizResourceBundle.getString("S_WRITE_MASTER_XML", sArgs));
                            this.writer.updateXML();
                        }
                        catch (IOException ie) {
                            this.m_oStageVerifier.processError(ie.getMessage(), null);
                        }
                        catch (SAXException se) {
                            this.m_oStageVerifier.processError(se.getMessage(), null);
                        }
                    } else {
                        this.callBack(sWarn + OiizResourceBundle.getString("S_PROP_FILE_NONEXISTS"));
                    }
                }
                bResult = true;
            }
        } else {
            this.m_oCallBack.appendToMessage(OiizResourceBundle.getString("S_NO_TOPLEVEL_FOR_REGEN"));
            bResult = false;
        }
        return bResult;
    }

    public boolean generateConfigMaster(Vector vCompIDs) {
        boolean bResult = false;
        if (null != vCompIDs && vCompIDs.size() > 0) {
            this.m_oCallBack.appendToMessage("(Re)Generation of Master XML for Selected Components Started...");
            if (this.m_stageInv == null) {
                bResult = false;
            } else {
                int selectedIDsize;
                if (null != vCompIDs && (selectedIDsize = vCompIDs.size()) > 0) {
                    for (int i = 0; i < selectedIDsize; ++i) {
                        OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)vCompIDs.elementAt(i);
                        OiiiCompInstallID compID = oEntry.getCompInstallID();
                        if (!oEntry.isTopLevel()) continue;
                        this.initialize();
                        this.callBack("Generating the MASTER XML for " + compID.getName());
                        try {
                            if (compID.getCompType() == 1) {
                                Vector platList = oEntry.getPlatforms();
                                if (platList.size() > 0) {
                                    for (int pCount = 0; pCount < platList.size(); ++pCount) {
                                        this.getConfigXMLsFromStage(compID, this.configXMLs, (Integer)platList.elementAt(pCount));
                                    }
                                }
                            } else if (compID.getCompType() == 4) {
                                this.getConfigXMLsFromStage(compID, this.configXMLs, 0);
                            }
                        }
                        catch (Exception e) {
                            if (null != e) {
                                this.callBack(e.getMessage());
                            }
                            this.callBack("Error occured while trying to get the configuration details from the stage area");
                        }
                        this.callBack("Retrieving the Configuration Aggregate XML data from the staging area");
                        this.callBack("Printing the configuration aggregate xml data");
                        this.printConfigXMLTable();
                        String tmpLoc = System.getProperty("oracle.installer.scratchPath");
                        if (null != tmpLoc) {
                            this.callBack("Extracting the Jar contents to " + tmpLoc);
                            this.retrieveConfigAggregates();
                            this.callBack("Checking if the Master XML is present in the Staging area");
                            String versionString = compID.getVersion().toString();
                            versionString = versionString.replace('.', '_');
                            String sMasterAggregateFullName = this.m_sStageLoc + File.separator + compID.getName() + "." + versionString + ".xml";
                            boolean bMasterXMLPresent = this.fileExists(sMasterAggregateFullName);
                            if (bMasterXMLPresent) {
                                this.callBack("Master XML already present");
                                try {
                                    String sBackupFilename = this.m_sStageLoc + File.separator + compID.getName() + "." + versionString + "_" + System.currentTimeMillis() + ".bak";
                                    sBackupFilename = OiixFileOps.backUpFile(sMasterAggregateFullName, sBackupFilename);
                                    this.callBack("Current Master XML backed up to " + sBackupFilename);
                                }
                                catch (Exception e) {
                                    this.callBack("Couldn't create a back up existing master XML");
                                }
                            } else {
                                this.callBack("Creating a new Master XML ");
                            }
                            try {
                                this.writer = new OiiiConfigAggregateXMLWriter(sMasterAggregateFullName, compID.getName(), false, false);
                                this.writer.setPlatforms(OiilXMLHelper.platVect2String(compID.getPlatforms(), " "));
                                this.callBack("Writing actions to XML");
                                this.addActions2XML();
                                this.callBack("Writing the Master XML to the file " + sMasterAggregateFullName);
                                this.writer.generateXML();
                                this.write2PropFile(compID.getName() + "." + versionString);
                            }
                            catch (IOException ie) {
                                this.m_oStageVerifier.processError(ie.getMessage(), null);
                            }
                            catch (SAXException se) {
                                this.m_oStageVerifier.processError(se.getMessage(), null);
                            }
                            continue;
                        }
                        this.callBack("No temp location specified ");
                    }
                }
                bResult = true;
            }
        } else {
            this.m_oCallBack.appendToMessage(OiizResourceBundle.getString("S_NO_TOPLEVEL_FOR_REGEN"));
            bResult = false;
        }
        return bResult;
    }

    private void addActions2XML() {
        if (null != this.m_vAggActions && !this.m_vAggActions.isEmpty()) {
            Enumeration eKeys = this.m_vAggActions.keys();
            while (eKeys.hasMoreElements()) {
                String sActionType = (String)eKeys.nextElement();
                Hashtable hList = (Hashtable)this.m_vAggActions.get(sActionType);
                this.writer.addActionsToMaster(sActionType, hList, this.m_hAggTypes);
            }
        }
    }

    private void updateActionsinXML() {
        if (null != this.m_vAggActions && !this.m_vAggActions.isEmpty()) {
            Enumeration eKeys = this.m_vAggActions.keys();
            while (eKeys.hasMoreElements()) {
                String sActionType = (String)eKeys.nextElement();
                Hashtable hList = (Hashtable)this.m_vAggActions.get(sActionType);
                this.writer.updateActionsToMaster(sActionType, hList, this.m_hAggTypes);
            }
        }
    }

    private boolean fileExists(String sFileName) {
        File fMaster;
        boolean bResult = false;
        if (null != sFileName && (fMaster = new File(sFileName)).exists()) {
            bResult = true;
        }
        return bResult;
    }

    private void retrieveConfigAggregates() {
        String sConfigAggregateFullName = null;
        String sConfigXMLName = null;
        String sTmpLoc = OiixPathOps.getNativeForm(System.getProperty("oracle.installer.scratchPath"));
        String sConfigXMLLoc = null;
        Enumeration configKeys = this.configXMLs.keys();
        if (null != configKeys) {
            String configJarName = "";
            int iOrderno = 0;
            while (configKeys.hasMoreElements()) {
                sConfigXMLName = (String)configKeys.nextElement();
                iOrderno = (Integer)this.configXMLs.get(sConfigXMLName);
                sConfigXMLLoc = this.getLocInfo((String)this.configXMLJarInfo.get(sConfigXMLName), CONTENTLOC);
                if (((String)this.configXMLJarInfo.get(sConfigXMLName)).compareToIgnoreCase(sConfigXMLLoc) != 0) {
                    try {
                        configJarName = (String)this.configXMLJarInfo.get(sConfigXMLName);
                        configJarName = OiixPathOps.getStandardForm(this.getLocInfo(configJarName, JARNAME));
                        String sFileToExtract = OiixPathOps.getStandardForm(sConfigXMLLoc + sConfigXMLName);
                        OiixJarOps.extractFile(sFileToExtract, configJarName, sTmpLoc);
                    }
                    catch (Exception e) {
                        this.callBack("Error while extracting the file to temporary location \n ");
                    }
                    sConfigAggregateFullName = sTmpLoc + File.separator + sConfigXMLName;
                } else {
                    sConfigAggregateFullName = sConfigXMLLoc + sConfigXMLName;
                }
                this.callBack("retrieving aggregate " + sConfigAggregateFullName);
                if (null == sConfigAggregateFullName) continue;
                try {
                    sConfigAggregateFullName = this.convertSlashes(sConfigAggregateFullName);
                    sConfigAggregateFullName = OiixPathOps.getNativeForm(sConfigAggregateFullName);
                    this.callBack("Parsing " + sConfigAggregateFullName);
                    OiisConfigAggregate oConfigAggr = OiiiConfigAggregateXMLReader.loadConfigAggregate(sConfigAggregateFullName, false);
                    if (null == oConfigAggr) continue;
                    this.addActions2Pool(oConfigAggr.getID(), oConfigAggr.getActions(), iOrderno);
                    this.m_hAggTypes.put(oConfigAggr.getID(), oConfigAggr.getAggregateType());
                    this.callBack("Aggregate " + oConfigAggr.getID() + "  retrieved");
                }
                catch (Exception e) {
                    this.callBack(e);
                }
            }
        }
    }

    private void addActions2Pool(String sID, Hashtable hactions, int iOrderno) {
        if (null != hactions && !hactions.isEmpty()) {
            this.callBack("Adding actions to a common pool");
            Enumeration ekeys = hactions.keys();
            while (ekeys.hasMoreElements()) {
                String sActionId = (String)ekeys.nextElement();
                String sActionType = (String)hactions.get(sActionId);
                Hashtable vPooledActions = new Hashtable();
                if (this.m_vAggActions.containsKey(sActionType)) {
                    vPooledActions = (Hashtable)this.m_vAggActions.get(sActionType);
                }
                vPooledActions.put(sID, new Integer(iOrderno).toString());
                this.m_vAggActions.put(sActionType, vPooledActions);
            }
        }
    }

    private String convertSlashes(String sFilename) {
        String sResult = null;
        if (null != sFilename) {
            sResult = sFilename.replace('/', File.separatorChar);
        }
        return sResult;
    }

    private void initialize() {
        this.configXMLJarInfo = new Hashtable();
        this.configXMLs = new Hashtable();
        this.m_sDepPropFileContents = new StringBuffer();
        this.m_vAggActions = new Hashtable();
        this.m_hAggTypes = new Hashtable();
    }

    private void printConfigXMLTable() {
        Enumeration configKeys;
        if (null != this.configXMLs && null != (configKeys = this.configXMLs.keys())) {
            String configKeyXMLName = "";
            int configXMLOrder = 0;
            while (configKeys.hasMoreElements()) {
                configKeyXMLName = (String)configKeys.nextElement();
                configXMLOrder = (Integer)this.configXMLs.get(configKeyXMLName);
                this.callBack("CONFIG NAME : " + configKeyXMLName + " ORDER : " + configXMLOrder + " LOCATION  : " + this.configXMLJarInfo.get(configKeyXMLName));
            }
        }
    }

    private void extractConfigXMLFiles(String tempLocation) {
        Enumeration configKeys;
        if (null != this.configXMLs && null != (configKeys = this.configXMLs.keys())) {
            String configKeyXMLName = "";
            String configJarName = "";
            while (configKeys.hasMoreElements()) {
                configKeyXMLName = (String)configKeys.nextElement();
                configJarName = (String)this.configXMLJarInfo.get(configKeyXMLName);
                if (null == (configJarName = this.getLocInfo(configJarName, JARNAME)) || !configJarName.endsWith(".jar")) continue;
                try {
                    OiixJarOps.extractFiles(configJarName, tempLocation);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getLocInfo(String sJarContents, int infoType) {
        StringTokenizer strTok;
        String sResult = sJarContents;
        if (null != sJarContents && null != (strTok = new StringTokenizer(sJarContents, "=")) && strTok.countTokens() == 2) {
            if (infoType == JARNAME) {
                sResult = (String)strTok.nextElement();
            } else if (infoType == CONTENTLOC) {
                strTok.nextElement();
                sResult = (String)strTok.nextElement() + File.separator;
            }
        }
        return sResult;
    }

    private void getConfigXMLsFromStage(OiiiCompInstallID oCompId, Hashtable compXMLs, int iPlat) throws Exception {
        OiiodDepEngine depEngine = new OiiodDepEngine(this.m_oStageVerifier, true);
        depEngine.setErrListener(this.m_oStageVerifier);
        depEngine.setInventories(this.m_stageInv, new OiiiInstallInventory());
        depEngine.setCurrentPlatform(iPlat);
        depEngine.setExecutePreReq(false);
        OiiiCompInstallID[] compids = new OiiiCompInstallID[]{oCompId};
        depEngine.setCurrentTLIDs(compids);
        try {
            depEngine.buildCompArray();
        }
        catch (OiiodDepException exp) {
            // empty catch block
        }
        for (int i = 0; i < compids.length; ++i) {
            if (compids[i].getCompType() == 1) {
                OiiodDepNode oNode = depEngine.getDepNode(compids[i]);
                this.processDepGraph("", oNode, 0, compXMLs);
                continue;
            }
            if (compids[i].getCompType() != 4) continue;
            OiisPatchSetContents pcontents = this.m_stageInv.getStageCompInvEntry(compids[i]).getPatchSetContents();
            Vector vAllPatches = pcontents.getContainedPatches();
            int nPatSize = vAllPatches.size();
            for (int zi = 0; zi < nPatSize; ++zi) {
                OiiiPatchInstallID oPatchID = (OiiiPatchInstallID)vAllPatches.elementAt(zi);
                OiiiStagePatchInvEntry oEntry = (OiiiStagePatchInvEntry)this.m_stageInv.getStageCompInvEntry(oPatchID);
                this.processPatchDeps(oPatchID, oEntry, 0, compXMLs);
            }
        }
    }

    private void processPatchDeps(OiiiCompInstallID oPatchID, OiiiStagePatchInvEntry oEntry, int ordernum, Hashtable configXMLs) {
        int iorderNumber = ordernum + 1;
        if (null != oPatchID && null != oEntry) {
            Vector configTools;
            System.out.println("Patch Name : " + oPatchID.getName() + " Patch Version : " + oPatchID.getVersion().getVerString());
            if (null != oEntry.getCompProperties() && null != (configTools = oEntry.getCompProperties().getConfigToolDetails()) && configTools.size() > 0) {
                for (int ll = 0; ll < configTools.size(); ++ll) {
                    OiisConfigToolDetails cftool = (OiisConfigToolDetails)configTools.elementAt(ll);
                    if (!oEntry.isTopLevel()) {
                        configXMLs.put(cftool.getAggregateName(), new Integer(iorderNumber));
                        this.configXMLJarInfo.put(cftool.getAggregateName(), this.m_sStageLoc + File.separator + oEntry.getJarName() + "=" + OiiiTargetAreaControl.genPackageNameDir(oEntry.getCompInstallID()));
                        continue;
                    }
                    if (iorderNumber == 1) continue;
                    configXMLs.put(cftool.getAggregateName(), new Integer(iorderNumber));
                    this.configXMLJarInfo.put(cftool.getAggregateName(), this.m_sStageLoc + File.separator);
                }
            }
            System.out.println("Config tool count : " + oEntry.getCompProperties().getConfigToolCount());
            OiisPatchDeps pdeps = oEntry.getPatchDeps();
            if (null != pdeps && null != pdeps.getDepObjs() && pdeps.getDepObjs().size() > 0) {
                Vector vs = pdeps.getDepObjs();
                System.out.println("This patch has some dependees");
                for (int ki = 0; ki < vs.size(); ++ki) {
                    OiiiCompInstallID pid;
                    OiisPatchDepObj pobj = (OiisPatchDepObj)vs.elementAt(ki);
                    if (null == pobj || (pid = pobj.getCurDepId()).getCompType() != 2 || null == pid) continue;
                    OiiiStagePatchInvEntry pentry = (OiiiStagePatchInvEntry)this.m_stageInv.getStageCompInvEntry(pid);
                    this.processPatchDeps(pid, pentry, iorderNumber, configXMLs);
                }
            }
        }
    }

    private void processDepGraph(String sTab, OiiodDepNode oNode, int oNum, Hashtable configXMLs) {
        Vector configTools;
        sTab = sTab + "  ";
        int iorderNumber = oNum + 1;
        if (null != oNode && null != oNode.getStageInvEntry() && null != oNode.getStageInvEntry().getCompProperties() && oNode.getStageInvEntry().getCompProperties().getConfigToolCount() > 0 && null != (configTools = oNode.getStageInvEntry().getCompProperties().getConfigToolDetails()) && configTools.size() > 0) {
            for (int ll = 0; ll < configTools.size(); ++ll) {
                OiisConfigToolDetails cftool = (OiisConfigToolDetails)configTools.elementAt(ll);
                if (!oNode.getStageInvEntry().isTopLevel()) {
                    configXMLs.put(cftool.getAggregateName(), new Integer(iorderNumber));
                    this.configXMLJarInfo.put(cftool.getAggregateName(), this.m_sStageLoc + File.separator + oNode.getStageInvEntry().getJarName() + "=" + OiiiTargetAreaControl.genPackageNameDir(oNode.getCompInstallID()));
                    continue;
                }
                if (iorderNumber == 1) continue;
                configXMLs.put(cftool.getAggregateName(), new Integer(iorderNumber));
                this.configXMLJarInfo.put(cftool.getAggregateName(), this.m_sStageLoc + File.separator);
            }
        }
        if (null != oNode) {
            Vector vNodes = oNode.getRules();
            int nNodes = vNodes.size();
            for (int i = 0; i < nNodes; ++i) {
                OiiodDepRuleNode oRule = (OiiodDepRuleNode)vNodes.elementAt(i);
                Vector vComps = oRule.getDepNodes();
                int nComps = vComps.size();
                for (int j = 0; j < nComps; ++j) {
                    OiiodDepNode oChildNode = (OiiodDepNode)vComps.elementAt(j);
                    System.out.println(sTab + "  " + oChildNode.toString() + " : " + oChildNode.getVersion().getVerString() + " : " + oChildNode.getCompInstallID().getName() + " order number " + iorderNumber);
                    this.processDepGraph(sTab + "  ", oChildNode, iorderNumber, configXMLs);
                }
            }
        }
    }

    private void callBack(Exception exp) {
        String sError = OiizResourceBundle.getString("S_ERROR");
        if (exp.getMessage() != null) {
            this.callBack(sError + exp.getMessage());
        } else {
            exp.printStackTrace();
        }
    }

    private void callBack(String msg) {
        if (this.m_oCallBack != null) {
            this.m_oCallBack.appendToMessage(msg);
        }
    }

    private void write2PropFile(String sCompname) {
        StringBuffer newList = new StringBuffer();
        this.m_sDepPropFileContents.append(AGGREGATE_PRIORITIES + "\n");
        this.m_sDepPropFileContents.append("actionlist={");
        String s = null;
        String name = null;
        if (null != this.m_vAggActions && !this.m_vAggActions.isEmpty()) {
            Enumeration eKeys = this.m_vAggActions.keys();
            while (eKeys.hasMoreElements()) {
                name = (String)eKeys.nextElement();
                Hashtable list = (Hashtable)this.m_vAggActions.get(name);
                if (null != list && !list.isEmpty()) {
                    newList.append("[" + name + "]\n");
                    Enumeration eKeys1 = list.keys();
                    while (eKeys1.hasMoreElements()) {
                        String s2 = (String)eKeys1.nextElement();
                        String s3 = (String)list.get(s2);
                        newList.append(s2 + "=" + s3 + "\n");
                    }
                }
                if (null == s) {
                    s = "";
                }
                s = s + name + ",";
            }
        }
        if (null != s) {
            s = s.substring(0, s.length() - 1);
            this.m_sDepPropFileContents.append(s);
        }
        this.m_sDepPropFileContents.append("}\n");
        if (null != newList) {
            this.m_sDepPropFileContents.append(newList);
        }
        try {
            String sFileName = this.m_sStageLoc + File.separator + sCompname + "_dep_default.properties";
            File fName = new File(sFileName);
            if (fName.exists()) {
                String sBackupFileName = this.m_sStageLoc + File.separator + sCompname + "_dep_bak.properties";
                try {
                    sBackupFileName = OiixFileOps.backUpFile(sFileName, sBackupFileName);
                    this.callBack("Copying " + sFileName + " to " + sBackupFileName);
                }
                catch (IOException e) {
                    this.callBack("Couldn't backup " + sFileName + ". Overwriting the same");
                }
            }
            this.callBack("The default order numbers are generated in " + sFileName);
            OutputStreamWriter fp = new OutputStreamWriter(new FileOutputStream(sFileName));
            fp.write(this.m_sDepPropFileContents.toString(), 0, this.m_sDepPropFileContents.length());
            fp.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Hashtable readFromPropFile(String sFilename) {
        Hashtable hAggActions = new Hashtable();
        Hashtable<String, String> hAggs = new Hashtable<String, String>();
        String sActionname = null;
        try {
            boolean bProceed = false;
            BufferedReader bReader = new BufferedReader(new FileReader(sFilename));
            String str = bReader.readLine();
            if (str.equals(AGGREGATE_PRIORITIES)) {
                bProceed = true;
            }
            StringTokenizer strToken = null;
            if (bProceed && (str = bReader.readLine()).startsWith("actionlist={") && str.endsWith("}")) {
                if (null != (str = str.substring(str.indexOf("{", 0) + 1, str.length() - 1))) {
                    strToken = new StringTokenizer(str, ",");
                    while (strToken.hasMoreTokens()) {
                        String sActionType = strToken.nextToken();
                        if (hAggActions.containsKey(sActionType)) continue;
                        hAggActions.put(sActionType, new Hashtable());
                    }
                }
                if (!hAggActions.isEmpty()) {
                    bProceed = true;
                }
            }
            if (bProceed) {
                while ((str = bReader.readLine()) != null) {
                    if (str.startsWith("[") && str.endsWith("]")) {
                        str = str.substring(str.indexOf("[") + 1, str.indexOf("]"));
                        if (null == sActionname) {
                            sActionname = str;
                            continue;
                        }
                        if (null != hAggs && !hAggs.isEmpty()) {
                            hAggActions.put(sActionname, hAggs);
                            hAggs = new Hashtable();
                        }
                        sActionname = str;
                        continue;
                    }
                    if (str.indexOf("=") <= 0) continue;
                    strToken = new StringTokenizer(str, "=");
                    String scomp = strToken.nextToken();
                    String sToken = strToken.nextToken();
                    hAggs.put(scomp, sToken);
                }
            }
            if (null != sActionname && sActionname.length() > 0 && null != hAggs && !hAggs.isEmpty()) {
                if (hAggActions.containsKey(sActionname)) {
                    hAggActions.put(sActionname, hAggs);
                }
                hAggs = new Hashtable();
            }
            bReader.close();
        }
        catch (IOException e) {
            this.callBack(e);
        }
        return hAggActions;
    }

    private void setUserPropFile(String sFileName) {
        this.m_sUserPropFile = sFileName;
    }

    private String getUserPropFile() {
        return this.m_sUserPropFile;
    }

    public void generateAndUpdateConfigMaster(Vector vCompIDs, String sPropFile) {
        Vector vCompIdTemp = new Vector();
        this.generateConfigMaster(vCompIDs);
        StringTokenizer sToken = new StringTokenizer(sPropFile, ",");
        String sVersion = "";
        String sName = "";
        while (sToken.hasMoreElements()) {
            String sWarn;
            String sMsg;
            String sPFile = (String)sToken.nextElement();
            boolean bFound = false;
            for (int i = 0; i < vCompIDs.size(); ++i) {
                OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)vCompIDs.elementAt(i);
                OiiiCompInstallID compId = oEntry.getCompInstallID();
                sName = compId.getName();
                sVersion = compId.getVersion().getVerString().replace('.', '_');
                String sUserPropFile = new File(sPFile).getName();
                if (!sUserPropFile.startsWith(sName)) continue;
                bFound = true;
                this.updateConfigMasterForSingleComp(oEntry, compId, sPFile);
            }
            if (bFound) continue;
            String sFileName = new File(sPFile).getName();
            if (!sFileName.endsWith(".properties")) {
                Object[] fExtn = new String[]{sFileName};
                String sMsg2 = OiizResourceBundle.getString("S_INVALID_FILE_EXTN", fExtn);
                String sWarn2 = OiizResourceBundle.getString("S_WARNING");
                this.callBack(sWarn2 + sMsg2);
                continue;
            }
            boolean bStartWith = false;
            for (int i = 0; i < vCompIDs.size(); ++i) {
                OiiiStageCompInvEntry oEntry = (OiiiStageCompInvEntry)vCompIDs.elementAt(i);
                OiiiCompInstallID compId = oEntry.getCompInstallID();
                sName = compId.getName();
                sVersion = compId.getVersion().getVerString().replace('.', '_');
                if (!sFileName.startsWith(sName)) continue;
                bStartWith = true;
            }
            if (!bStartWith) {
                Object[] sArgs1 = new String[]{sFileName};
                sMsg = OiizResourceBundle.getString("S_INVALID_FILE_FORMAT", sArgs1);
                sWarn = OiizResourceBundle.getString("S_WARNING");
                this.callBack(sWarn + sMsg);
                continue;
            }
            Object[] sArgs = new String[]{sFileName.substring(0, sFileName.indexOf(".properties"))};
            sMsg = OiizResourceBundle.getString("S_WARN_REG_UPDATE", sArgs);
            sWarn = OiizResourceBundle.getString("S_WARNING");
            this.callBack(sWarn + sMsg);
        }
    }
}

