/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oii.oiiz;

import java.util.BitSet;
import java.util.Locale;
import java.util.Vector;
import oracle.sysman.oii.oiii.OiiiStageCompInvEntry;
import oracle.sysman.oii.oiis.OiisFileSizeInfo;
import oracle.sysman.oii.oiis.OiisLangIndexMapping;

class OiizInterCompLangIdxMap {
    protected OiiiStageCompInvEntry oEntryA;
    protected OiiiStageCompInvEntry oEntryB;
    protected int[] m_aiLangIndexMap;
    protected int[] m_aiLangSetIndexMap;
    private boolean m_bIdenticalEntries = false;
    private boolean m_bSourceAllLangs = false;

    OiizInterCompLangIdxMap(OiiiStageCompInvEntry e1, OiiiStageCompInvEntry e2) {
        this.oEntryA = e1;
        this.oEntryB = e2;
        if (e1 == e2) {
            this.m_aiLangIndexMap = null;
            this.m_aiLangSetIndexMap = null;
            this.m_bIdenticalEntries = true;
        } else {
            this.initialize();
        }
    }

    private void initialize() {
        this.initLangIndexMap();
        this.initLangSetIndexMap();
        this.m_aiLangIndexMap = null;
    }

    private void initLangIndexMap() {
        OiisLangIndexMapping oLangIndMapA = this.getSourceLangIndexMapping();
        OiisLangIndexMapping oLangIndMapB = this.getTargetLangIndexMapping();
        Locale[] aoLangsA = oLangIndMapA == null ? null : oLangIndMapA.getLangs();
        int nLangsB = oLangIndMapB.getLangs().length;
        this.m_aiLangIndexMap = new int[aoLangsA.length];
        Vector<Locale> vUnlistedLangs = new Vector<Locale>(aoLangsA.length);
        for (int i = 0; i < aoLangsA.length; ++i) {
            this.m_aiLangIndexMap[i] = oLangIndMapB.indexOfLang(aoLangsA[i]);
            if (this.m_aiLangIndexMap[i] != -1) continue;
            this.m_aiLangIndexMap[i] = nLangsB + vUnlistedLangs.size();
            vUnlistedLangs.addElement(aoLangsA[i]);
        }
        int sz = vUnlistedLangs.size();
        if (sz > 0) {
            Locale[] x = new Locale[sz];
            for (int i = 0; i < sz; ++i) {
                x[i] = (Locale)vUnlistedLangs.elementAt(i);
            }
            oLangIndMapB.addLangs(x);
        }
    }

    private void initLangSetIndexMap() {
        OiisLangIndexMapping oLangIndMapA = this.getSourceLangIndexMapping();
        OiisLangIndexMapping oLangIndMapB = this.getTargetLangIndexMapping();
        Vector vLangSetsA = this.getLangSets(this.oEntryA);
        if (vLangSetsA != null) {
            int nLangSetsA = vLangSetsA.size();
            this.m_aiLangSetIndexMap = new int[nLangSetsA];
            Locale[] aoLangsB = oLangIndMapB.getLangs();
            for (int i = 0; i < nLangSetsA; ++i) {
                int idx;
                BitSet bsB;
                BitSet bsA = (BitSet)vLangSetsA.elementAt(i);
                if (bsA != null) {
                    int nbsALength = bsA.length();
                    bsB = new BitSet(aoLangsB.length);
                    for (int j = 0; j < nbsALength; ++j) {
                        if (!bsA.get(j)) continue;
                        bsB.set(this.m_aiLangIndexMap[j]);
                    }
                } else {
                    bsB = null;
                }
                this.m_aiLangSetIndexMap[i] = idx = oLangIndMapB.addLangSet(bsB);
            }
        } else {
            this.m_bSourceAllLangs = true;
        }
    }

    int getLangSetIdxMap(int idx) {
        if (this.m_aiLangSetIndexMap == null) {
            if (this.m_bIdenticalEntries) {
                return idx;
            }
            if (this.m_bSourceAllLangs) {
                return 0;
            }
            System.err.println("This is is not expected. Pl. file a bug.");
            return -1;
        }
        return this.m_aiLangSetIndexMap[idx];
    }

    OiiiStageCompInvEntry getMappedComponent() {
        return this.oEntryA;
    }

    OiiiStageCompInvEntry getMappingComponent() {
        return this.oEntryB;
    }

    private Vector getLangSets(OiiiStageCompInvEntry scie) {
        if (scie.isStageVersionPreX("2.2.0.3.0")) {
            OiisFileSizeInfo fsi = scie.getFileSizeInfo();
            return fsi.getLangSets();
        }
        return scie.getLangIndexMapping().getLangSets();
    }

    private OiisLangIndexMapping getLangIndexMapping(OiiiStageCompInvEntry scie) {
        OiisLangIndexMapping langIdxMap = null;
        if (scie.isStageVersionPreX("2.2.0.3.0")) {
            OiisFileSizeInfo fsi = scie.getFileSizeInfo();
            langIdxMap = fsi.getLangIndexMapping();
        } else {
            langIdxMap = scie.getLangIndexMapping();
        }
        return langIdxMap;
    }

    OiisLangIndexMapping getTargetLangIndexMapping() {
        return this.getLangIndexMapping(this.oEntryB);
    }

    OiisLangIndexMapping getSourceLangIndexMapping() {
        return this.getLangIndexMapping(this.oEntryA);
    }
}

