/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oix.oixp;

import oracle.sysman.oix.oixp.OixpIXmlParser;
import oracle.sysman.oix.oixp.OixpXmlParserCreationException;

public class OixpXmlParserFactory {
    private static final String[] KNOWN_PARSERS = new String[]{"oracle.sysman.oix.oixs.OixsSAXXmlParser", "oracle.sysman.oix.oixl.OixlLarkXmlParser"};
    private static final String PARSER_PROP = "oix.xml.parser.name";
    private static String s_parserClassName = OixpXmlParserFactory.initParserClassName();

    private static String initParserClassName() {
        return System.getProperty(PARSER_PROP, KNOWN_PARSERS[0]);
    }

    public static void setParserClassName(String parserClassName) {
        s_parserClassName = parserClassName;
    }

    public static String getParserClassName() {
        return s_parserClassName;
    }

    public static OixpIXmlParser createXmlParser() throws OixpXmlParserCreationException {
        return OixpXmlParserFactory.createXmlParser(true);
    }

    public static OixpIXmlParser createXmlParser(boolean tryAll) throws OixpXmlParserCreationException {
        OixpIXmlParser parser = null;
        Throwable threx = null;
        String parserClassName = s_parserClassName;
        int i = 0;
        while (parser == null) {
            try {
                if (i == 0 || !parserClassName.equals(s_parserClassName)) {
                    Class<?> parserClass = Class.forName(parserClassName);
                    parser = (OixpIXmlParser)parserClass.newInstance();
                }
            }
            catch (Exception e) {
                threx = e;
            }
            catch (NoClassDefFoundError ncdf) {
                threx = ncdf;
            }
            if (parser == null) {
                System.err.println("Could not create a parser with " + parserClassName);
            }
            if (!tryAll || i >= KNOWN_PARSERS.length) break;
            parserClassName = KNOWN_PARSERS[i];
            ++i;
        }
        if (parser == null && threx != null) {
            throw new OixpXmlParserCreationException(threx.getClass().getName() + ":" + threx.getMessage());
        }
        return parser;
    }
}

