/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oix.oixs;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.oix.oixp.OixpIAttribute;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixs.OixsAttribute;
import org.xml.sax.AttributeList;

public class OixsElement
implements OixpIElement {
    private Hashtable m_attsHashtable;
    private Vector m_children;
    private OixsElement m_parent;
    private Object m_obj;
    private String m_type;

    public OixsElement(String type, AttributeList attList, OixsElement parent) {
        this.m_type = type;
        this.m_parent = parent;
        this.debug("Constructor of element :: " + type);
        this.m_attsHashtable = new Hashtable();
        int numAtts = attList.getLength();
        for (int i = 0; i < numAtts; ++i) {
            String attName = attList.getName(i);
            String attValue = attList.getValue(i);
            OixsAttribute attr = new OixsAttribute(attName, attValue);
            this.m_attsHashtable.put(attName, attr);
            this.debug("Adding attribute : " + attName + ", value : " + attValue);
        }
        this.m_obj = null;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean isEmpty() {
        return this.m_children.isEmpty();
    }

    public OixpIAttribute[] getAllAttributes() {
        int numAttribs = this.m_attsHashtable.size();
        OixpIAttribute[] retAttrArr = new OixpIAttribute[numAttribs];
        Enumeration attrs = this.m_attsHashtable.elements();
        for (int i = 0; i < numAttribs && attrs.hasMoreElements(); ++i) {
            retAttrArr[i] = (OixpIAttribute)attrs.nextElement();
        }
        return retAttrArr;
    }

    public OixpIElement getParent() {
        return this.m_parent;
    }

    public Vector getChildren() {
        return this.m_children;
    }

    public void getChildren(OixsElement child) {
        this.m_children.addElement(child);
    }

    public OixpIAttribute getAttribute(String name) {
        return (OixpIAttribute)this.m_attsHashtable.get(name);
    }

    public String getAttribValue(String name) {
        String value = null;
        OixpIAttribute attrib = this.getAttribute(name);
        if (attrib != null) {
            value = attrib.getValue();
        }
        return value;
    }

    public void setObject(Object obj) {
        this.m_obj = obj;
    }

    public Object getObject() {
        return this.m_obj;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[Element type : " + this.m_type + " :: Attributes => { ");
        Enumeration atts = this.m_attsHashtable.elements();
        while (atts.hasMoreElements()) {
            OixsAttribute attr = (OixsAttribute)atts.nextElement();
            sbuf.append(attr).append(" ");
        }
        sbuf.append("} ]");
        return sbuf.toString();
    }

    public void debug(String msg) {
    }
}

