/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oix.oixs;

import java.util.Vector;
import oracle.sysman.oix.oixp.OixpIHandler;
import oracle.sysman.oix.oixs.OixsElement;
import oracle.sysman.oix.oixs.OixsEndDocumentException;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;

public class OixsHandler
extends HandlerBase {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 8;
    private OixpIHandler m_handlerInterf;
    private Vector m_elementOrder;
    private OixsElement m_curElement;

    public OixsHandler(OixpIHandler handlerInterf) {
        this.m_handlerInterf = handlerInterf;
        this.m_elementOrder = new Vector();
        this.m_curElement = null;
    }

    public void startElement(String name, AttributeList attList) throws SAXException {
        try {
            boolean endVal = false;
            OixsElement element = new OixsElement(name, attList, this.m_curElement);
            this.m_elementOrder.addElement(element);
            this.m_curElement = element;
            endVal = this.m_handlerInterf.doStartTag(element);
            if (endVal) {
                this.endParsing();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void endElement(String name) throws SAXException {
        try {
            boolean endVal = false;
            if (!this.m_curElement.getType().equals(name)) {
                System.out.println("!! Mismatch : doEndTag for " + name + " with current element of " + this.m_curElement.getType());
            }
            endVal = this.m_handlerInterf.doEndTag(this.m_curElement);
            int numOrderEls = this.m_elementOrder.size();
            this.m_elementOrder.removeElementAt(numOrderEls - 1);
            this.m_curElement = !this.m_elementOrder.isEmpty() ? (OixsElement)this.m_elementOrder.lastElement() : null;
            if (endVal) {
                this.endParsing();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            boolean endVal = false;
            String str = new String(ch, start, length);
            endVal = this.m_handlerInterf.doText(this.m_curElement, str);
            if (endVal) {
                this.endParsing();
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void endParsing() throws SAXException {
        OixsEndDocumentException ede = new OixsEndDocumentException();
        throw new SAXException("End of Document", ede);
    }
}

