/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oix.oixs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import oracle.sysman.oix.oixp.OixpIElement;
import oracle.sysman.oix.oixp.OixpIHandler;
import oracle.sysman.oix.oixp.OixpIXmlParser;
import oracle.sysman.oix.oixs.OixsEndDocumentException;
import oracle.sysman.oix.oixs.OixsHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserFactory;

public class OixsSAXXmlParser
implements OixpIXmlParser {
    private static final boolean s_debug = false;
    private static final int s_debugCategory = 8;
    private InputStream m_is;
    private OixpIHandler m_handler;
    private Parser m_parser;

    public OixsSAXXmlParser() throws InstantiationException, ClassNotFoundException, IllegalAccessException, NullPointerException, ClassCastException {
        Properties sysProps = System.getProperties();
        String parserClass = (String)sysProps.get("org.xml.sax.parser");
        if (parserClass == null) {
            parserClass = "oracle.xml.parser.v2.SAXParser";
        }
        sysProps.put("org.xml.sax.parser", parserClass);
        this.m_parser = ParserFactory.makeParser();
    }

    public void setInputStream(InputStream is) {
        this.m_is = is;
    }

    public void setHandler(OixpIHandler handler) {
        this.m_handler = handler;
    }

    public OixpIElement readXML(OixpIHandler handler, File inp) throws IOException {
        OixpIElement retEl;
        block2: {
            retEl = null;
            try {
                OixsHandler docHandler = new OixsHandler(handler);
                this.m_parser.setDocumentHandler(docHandler);
                String uri = OixsSAXXmlParser.fileToURL(inp).toString();
                this.m_parser.parse(uri);
            }
            catch (SAXException e) {
                Exception contEx = e.getException();
                if (contEx instanceof OixsEndDocumentException || contEx instanceof SAXException && ((SAXException)contEx).getException() instanceof OixsEndDocumentException) break block2;
                e.printStackTrace();
                throw new IOException(e.getClass() + ":" + e.getMessage());
            }
        }
        return retEl;
    }

    public OixpIElement readXML(OixpIHandler handler, InputStream is) throws IOException {
        OixpIElement retEl;
        block2: {
            retEl = null;
            try {
                OixsHandler docHandler = new OixsHandler(handler);
                this.m_parser.setDocumentHandler(docHandler);
                this.m_parser.parse(new InputSource(is));
            }
            catch (SAXException e) {
                Exception contEx = e.getException();
                if (contEx instanceof OixsEndDocumentException || contEx instanceof SAXException && ((SAXException)contEx).getException() instanceof OixsEndDocumentException) break block2;
                e.printStackTrace();
                throw new IOException(e.getClass() + ":" + e.getMessage());
            }
        }
        return retEl;
    }

    static URL fileToURL(File file) {
        String path = file.getAbsolutePath();
        String fSep = System.getProperty("file.separator");
        if (fSep != null && fSep.length() == 1) {
            path = path.replace(fSep.charAt(0), '/');
        }
        if (path.length() > 0 && path.charAt(0) != '/') {
            path = '/' + path;
        }
        try {
            return new URL("file", null, path);
        }
        catch (MalformedURLException e) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    public OixpIElement readXML() throws IOException {
        return this.readXML(this.m_handler, this.m_is);
    }
}

