/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oix.oixs;

import java.util.Stack;
import oracle.sysman.oix.oixs.OixsAttributeListImpl;
import oracle.sysman.oix.oixs.OixsElementHandler;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;

public class OixsUnknownElementHandler
extends OixsElementHandler {
    private XMLElement m_element;
    private XMLElement m_currentElement;
    private Stack m_parentElements;

    public OixsUnknownElementHandler() {
        this.m_element = new XMLElement("");
        this.m_parentElements = new Stack();
    }

    public OixsUnknownElementHandler(String sName) {
        this.m_element = new XMLElement(sName);
        this.m_parentElements = new Stack();
    }

    public void startElement(String name, AttributeList attributes, Stack handlers) {
        handlers.push(this);
        this.onStart(name, new OixsAttributeListImpl(attributes));
    }

    public void onStart(String name, AttributeList atts) {
        if (this.m_currentElement == null) {
            this.m_currentElement = new XMLElement(name);
        } else {
            XMLElement parent = this.m_parentElements.push(this.m_currentElement);
            this.m_currentElement = new XMLElement(name);
            parent.appendChild((Node)this.m_currentElement);
        }
        if (atts != null) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attName = atts.getName(i);
                String attValue = atts.getValue(i);
                this.m_currentElement.setAttribute(attName, attValue);
            }
        }
    }

    public void onText(char[] chars, int start, int length) {
        String text = new String(chars, start, length);
        if (this.m_currentElement != null) {
            this.m_currentElement.addText(chars, start, length);
        }
    }

    public void onEnd(String name) {
        if (this.m_parentElements.empty()) {
            if (this.m_currentElement != null) {
                this.m_element.appendChild((Node)this.m_currentElement);
                this.m_currentElement = null;
            }
        } else {
            this.m_currentElement = (XMLElement)this.m_parentElements.pop();
        }
    }

    public XMLElement getElement() {
        return this.m_element;
    }

    public void setElementAttributes(AttributeList atts) {
        if (atts != null && this.m_element != null) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attName = atts.getName(i);
                String attValue = atts.getValue(i);
                this.m_element.setAttribute(attName, attValue);
            }
        }
    }

    void setUnknownElementHandler(String name, AttributeList atts) {
    }
}

