/*
 * Decompiled with CFR 0.152.
 */
package com.sun.trustedsolaris;

import java.io.Serializable;
import java.util.Properties;

public class TsolAttrs
implements Serializable {
    public static final String TSOL_PREFIX = "tsol.";
    public static final String LABEL = "tsol.label";
    public static final String AUDIT_ID = "tsol.auditId";
    public static final String USER_ID = "tsol.userId";
    public static final String ZONE_ID = "tsol.zoneId";
    public static final String FAKE_TSOL_PASS = "__fake__pass_tsol1";
    public static final String FAKE_TSOL_PASS_SALT = "fakesalt";
    public static final String[] properties = new String[]{"tsol.tsol.label", "tsol.tsol.auditId", "tsol.tsol.userId", "tsol.tsol.zoneId"};
    private static boolean txLibraryLoaded = false;
    private static boolean solLibraryLoaded = false;
    private static Throwable initError;
    private boolean imported;
    private boolean incomplete;
    private String label;
    private String auditId;
    private String userId;
    private int zoneId;

    private native String nativeGetLabel();

    private native int nativeGetZoneId();

    private native String nativeGetZoneName();

    private native String nativeGetenv(String var1);

    public TsolAttrs() {
        this.imported = false;
        try {
            if (txLibraryLoaded) {
                this.label = this.nativeGetLabel();
            }
        }
        catch (Exception e) {
            this.incomplete = true;
        }
        if (solLibraryLoaded) {
            try {
                this.auditId = this.nativeGetenv("LOGNAME");
            }
            catch (Exception e) {
                this.incomplete = true;
            }
            try {
                this.userId = this.nativeGetenv("USER");
            }
            catch (Exception e) {
                this.incomplete = true;
            }
        }
        try {
            if (this.userId == null) {
                this.userId = System.getProperty("user.name");
            }
        }
        catch (Exception e) {
            this.incomplete = true;
        }
    }

    public TsolAttrs(Properties properties) {
        this.imported = true;
        try {
            this.label = properties.getProperty(LABEL, null);
        }
        catch (Exception e) {
            this.incomplete = true;
        }
        try {
            this.auditId = properties.getProperty(AUDIT_ID, null);
        }
        catch (Exception e) {
            this.incomplete = true;
        }
        try {
            this.userId = properties.getProperty(USER_ID, null);
        }
        catch (Exception e) {
            this.incomplete = true;
        }
        try {
            String prop = properties.getProperty(ZONE_ID, null);
            this.zoneId = prop == null ? 0 : Integer.parseInt(prop);
        }
        catch (Exception e) {
            this.incomplete = true;
        }
    }

    public boolean isImported() {
        return this.imported;
    }

    public boolean isComplete() {
        return !this.incomplete;
    }

    public void setProperties(Properties properties) {
        String value = this.getLabel();
        if (value != null) {
            properties.setProperty(LABEL, value);
        }
        if ((value = this.getAuditId()) != null) {
            properties.setProperty(AUDIT_ID, value);
        }
        if ((value = this.getUserId()) != null) {
            properties.setProperty(USER_ID, value);
        }
        properties.setProperty(ZONE_ID, String.valueOf(this.getZoneId()));
    }

    public boolean isSystemLabeled() {
        String label = this.getLabel();
        return label != null && label.length() != 0;
    }

    public String getLabel() {
        return this.label;
    }

    public String getAuditId() {
        return this.auditId;
    }

    public String getUserId() {
        return this.userId;
    }

    public int getZoneId() {
        return this.zoneId;
    }

    public boolean isTsol() {
        return this.isSystemLabeled() && !this.isImported() && this.getZoneId() == 0;
    }

    public Throwable getInitError() {
        if (!txLibraryLoaded || !solLibraryLoaded) {
            return initError;
        }
        return null;
    }

    public String toString() {
        return "TsolAttr<txLibraryLoaded=" + txLibraryLoaded + "," + "solLibraryLoaded=" + solLibraryLoaded + "," + "imported=" + this.imported + "," + "incomplete=" + this.incomplete + "," + "label=" + this.label + "," + "auditId=" + this.auditId + "," + "userId=" + this.userId + "," + "zoneId=" + this.zoneId + ">";
    }

    static {
        try {
            System.loadLibrary("solAttrs");
            solLibraryLoaded = true;
        }
        catch (Throwable t) {
            initError = t;
        }
        try {
            System.loadLibrary("tsolAttrs");
            txLibraryLoaded = true;
        }
        catch (Throwable t) {
            initError = t;
        }
    }
}

