/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Properties;

public class GnomeUtility {
    private GnomeUtility() {
    }

    public static boolean isMozillaRunning(String string) throws IOException {
        String string2 = "No running window";
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        Process process = Runtime.getRuntime().exec(new String[]{string, "-remote", "ping()"});
        inputStream = process.getErrorStream();
        inputStreamReader = new InputStreamReader(inputStream);
        bufferedReader = new BufferedReader(inputStreamReader);
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string3.indexOf(string2) == -1) continue;
            bufferedReader.close();
            return false;
        }
        bufferedReader.close();
        return true;
    }

    public static String getMozillaVersionNumber(String string) {
        String string2 = "Mozilla ";
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        String string3 = null;
        try {
            process = runtime.exec(new String[]{string, "-version"});
            inputStream = process.getInputStream();
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string4 = null;
            string4 = bufferedReader.readLine();
            if (string4 != null && string4.indexOf(string2) == 0) {
                string3 = string4.substring(string2.length(), string4.indexOf(44));
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return string3;
    }

    public static String getDefaultMailerPath() throws UnsupportedOperationException {
        String string = "defmailer.properties";
        String string2 = GnomeUtility.nativeGetDefaultMailerPath();
        if (string2 != null) {
            return string2;
        }
        Properties properties = new Properties();
        String string3 = GnomeUtility.getPropFilePath(string);
        if (string3 == null) {
            throw new UnsupportedOperationException("No default mailer is set in GConf, and the property file defining default mailer is not found: " + string);
        }
        try {
            properties.load(new FileInputStream(string3));
            string2 = properties.getProperty("MAILER");
            if (string2 == null) {
                throw new UnsupportedOperationException("The default mailer path is not set in the property file: " + string3);
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new UnsupportedOperationException("Failed to get default mailer path from property file: " + string3);
        }
    }

    private static String getPropFilePath(String string) {
        String string2 = System.getProperty("java.class.path");
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string2));
        streamTokenizer.whitespaceChars(File.pathSeparatorChar, File.pathSeparatorChar);
        streamTokenizer.wordChars(File.separatorChar, File.separatorChar);
        streamTokenizer.ordinaryChar(46);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.ordinaryChar(32);
        streamTokenizer.wordChars(32, 32);
        streamTokenizer.wordChars(95, 95);
        try {
            while (streamTokenizer.nextToken() != -1) {
                String string3;
                File file;
                int n = -1;
                if (streamTokenizer.ttype != -3 || (n = streamTokenizer.sval.indexOf("jdic.jar")) == -1 || !(file = new File(string3 = (string3 = streamTokenizer.sval.substring(0, n)) != null ? string3 + File.separator + string : "." + File.separator + string)).exists()) continue;
                return file.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static native String nativeGetDefaultMailerPath();

    static {
        System.loadLibrary("jdic");
    }
}

