/*
 * Decompiled with CFR 0.152.
 */
package oracle.mail.admin.emconfig;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.ias.repository.SchemaManager;
import oracle.ias.repository.schema.SchemaException;

public class EmailAssocData {
    private static String getInitialEmailDnEntry() {
        return "cn=EMailServerContainer,cn=Products,cn=OracleContext";
    }

    private static String getBaseEmailDnEntry() {
        return "cn=MailStores,cn=um_system,";
    }

    private static String getOracleHome(String[] stringArray) {
        String string = null;
        try {
            string = stringArray[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    private static String getMidtierHost(String[] stringArray) {
        String string = null;
        try {
            string = stringArray[1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    private static String getTargetType(String[] stringArray) {
        String string = null;
        try {
            string = stringArray[2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    private static String getAssocParamsStr(String[] stringArray) {
        String string = null;
        try {
            string = stringArray[3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    private static String getAttributeValue(Attributes attributes, String string) throws NamingException {
        if (attributes == null || string == null || attributes.get(string) == null) {
            return null;
        }
        return (String)attributes.get(string).get();
    }

    private static ArrayList getAssocAttrList(String string) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        ArrayList<String> arrayList = new ArrayList<String>();
        stringTokenizer = new StringTokenizer(string3, ",");
        while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    private static HashMap getCompAssocData(String string, String string2, String string3, InitialDirContext initialDirContext, String string4, String string5) throws NamingException, Exception {
        ArrayList arrayList = EmailAssocData.getAssocAttrList(string5);
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
        } else {
            arrayList = new ArrayList();
        }
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(arrayList.get(i), null);
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        String string6 = "cn=*";
        NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string4, string6, searchControls);
        if (namingEnumeration != null && namingEnumeration.hasMore()) {
            String string7;
            SearchResult searchResult = namingEnumeration.next();
            Attributes attributes = searchResult.getAttributes();
            String string8 = "cn=" + EmailAssocData.getAttributeValue(attributes, "cn");
            String string9 = string8 + "," + string4;
            NamingEnumeration<SearchResult> namingEnumeration2 = initialDirContext.search(string9, string7 = "cn=" + string2 + ":" + "um_system" + ":" + string3 + ":*", searchControls);
            if (namingEnumeration2 != null) {
                SearchResult searchResult2 = namingEnumeration.next();
                Attributes attributes2 = searchResult2.getAttributes();
                String string10 = "";
                Iterator iterator = hashMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String string11 = (String)iterator.next();
                    String string12 = (String)hashMap.get(string11);
                    string10 = EmailAssocData.getAttributeValue(attributes2, string11);
                    if (string10 == null || string10.trim().length() == 0) {
                        string10 = "";
                    }
                    if (string12 != null && string12.trim().length() != 0) continue;
                    hashMap.put(string11, string10);
                }
            }
        }
        return hashMap;
    }

    private static void printCompAssocData(HashMap hashMap, String string) {
        ArrayList arrayList = EmailAssocData.getAssocAttrList(string);
        if (hashMap == null || arrayList == null) {
            System.out.println("em_error=Error retrieving assocaite data");
            return;
        }
        EmailAssocData.processNullValues(hashMap);
        int n = arrayList.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("assoc_result=");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((String)hashMap.get(arrayList.get(i)));
            if (i >= n - 1) continue;
            stringBuffer.append(":");
        }
        System.out.println(stringBuffer.toString());
    }

    private static void processNullValues(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            if (string2 != null && string2.trim().length() != 0) continue;
            hashMap.put(string, "");
        }
    }

    private static boolean sslOnly(String string) throws IOException {
        String string2 = System.getProperty("file.separator");
        String string3 = string + string2 + "config" + string2 + "ias.properties";
        FileInputStream fileInputStream = new FileInputStream(string3);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        String string4 = properties.getProperty("SSLOnly");
        return string4.compareToIgnoreCase("true") == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        InitialContext initialContext = null;
        String string3 = "";
        try {
            String string4 = EmailAssocData.getOracleHome(stringArray);
            String string5 = EmailAssocData.getMidtierHost(stringArray);
            String string6 = EmailAssocData.getTargetType(stringArray);
            string3 = EmailAssocData.getAssocParamsStr(stringArray);
            SchemaManager schemaManager = new SchemaManager(string4);
            string = EmailAssocData.getInitialEmailDnEntry();
            boolean bl = EmailAssocData.sslOnly(string4);
            initialContext = schemaManager.connectAs(string, bl);
            string2 = EmailAssocData.getBaseEmailDnEntry() + string;
            HashMap hashMap = EmailAssocData.getCompAssocData(string4, string5, string6, (InitialDirContext)initialContext, string2, string3);
            EmailAssocData.printCompAssocData(hashMap, string3);
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace();
            System.out.println("em_error=Schema exception occurred while getting the email component associate data.  " + schemaException.getMessage());
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            System.out.println("em_error=Naming exception occurred while getting associate data for the email component associate data.  " + namingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("em_error=Exception occured while opening ias.property.  " + iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("em_error=Exception occurred while getting the email component associate data.  " + exception.getMessage());
        }
        finally {
            try {
                initialContext.close();
            }
            catch (NamingException namingException) {}
        }
    }
}

