/*
 * Decompiled with CFR 0.152.
 */
package oracle.mail.admin.emconfig;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import oracle.ias.repository.SchemaManager;
import oracle.ias.repository.schema.SchemaException;

public class EmailConfigData {
    private static String getInitialEmailDnEntry() {
        return "cn=EMailServerContainer,cn=Products,cn=OracleContext";
    }

    private static String getBaseEmailDnEntry(String string, String string2) {
        return "cn=mailProcessConfig,cn=EMailServer,cn=" + string + ",cn=" + string2 + ",cn=Computers,cn=OracleContext";
    }

    private static String getOracleHome(String[] stringArray) {
        String string = null;
        try {
            string = stringArray[0];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    private static String getMidtierHost(String[] stringArray) {
        String string = null;
        try {
            string = stringArray[1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    private static String getTargetType(String[] stringArray) {
        String string = null;
        try {
            string = stringArray[2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    private static String getConfigScope(String[] stringArray) {
        String string = null;
        try {
            string = stringArray[3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    private static String processDnSpecialChars(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("/") == -1) {
            return string;
        }
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            int n;
            string2 = string.charAt(i) != '/' ? string2 + string.charAt(i) : ((n = i - 1) >= 0 && string.charAt(n) != '\\' ? string2 + "\\" + string.charAt(i) : string2 + string.charAt(i));
        }
        return string2;
    }

    private static String getAttributeValue(Attributes attributes, String string) throws NamingException {
        if (attributes == null || string == null || attributes.get(string) == null) {
            return null;
        }
        return (String)attributes.get(string).get();
    }

    private static String getFilter(String string, String string2) {
        if (string2 == null || string2.trim().length() == 0) {
            return "";
        }
        return "cn = " + string + ":um_system:" + string2;
    }

    private static HashMap getCompConfigData(String string, String string2, InitialDirContext initialDirContext, String string3, String string4, String string5) throws NamingException, Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string6 = EmailConfigData.getFilter(string2, string4);
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        if (string5.equals("server")) {
            SearchResult searchResult;
            Attributes attributes;
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string3, string6, searchControls);
            if (namingEnumeration != null && (attributes = (searchResult = namingEnumeration.next()).getAttributes()) != null) {
                NamingEnumeration<? extends Attribute> namingEnumeration2 = attributes.getAll();
                while (namingEnumeration2.hasMore()) {
                    BasicAttribute basicAttribute = (BasicAttribute)namingEnumeration2.next();
                    String string7 = basicAttribute.getID();
                    if (!string7.matches("^orclmail.*")) continue;
                    int n = basicAttribute.size();
                    if (n <= 1) {
                        hashMap.put(string7, basicAttribute.get());
                        continue;
                    }
                    NamingEnumeration<?> namingEnumeration3 = basicAttribute.getAll();
                    String string8 = "";
                    while (namingEnumeration3.hasMore()) {
                        String string9 = (String)namingEnumeration3.next();
                        if (string8.equals("")) {
                            string8 = string9;
                            continue;
                        }
                        string8 = string8 + "," + string9;
                    }
                    hashMap.put(string7, string8);
                }
                namingEnumeration2.close();
            }
            namingEnumeration.close();
        } else if (string5.equals("instance")) {
            string6 = string6 + ":*";
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string3, string6, searchControls);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                String[] stringArray = searchResult.toString().split(",", 2);
                String string10 = stringArray[0];
                String[] stringArray2 = string10.split(":", 4);
                String string11 = stringArray2[3];
                arrayList.add(string11);
                Attributes attributes = searchResult.getAttributes();
                if (attributes != null) {
                    NamingEnumeration<? extends Attribute> namingEnumeration4 = attributes.getAll();
                    while (namingEnumeration4.hasMore()) {
                        BasicAttribute basicAttribute = (BasicAttribute)namingEnumeration4.next();
                        String string12 = basicAttribute.getID();
                        if (!string12.matches("^orclmail.*")) continue;
                        int n = basicAttribute.size();
                        if (n <= 1) {
                            hashMap2.put(string12, basicAttribute.get());
                            continue;
                        }
                        NamingEnumeration<?> namingEnumeration5 = basicAttribute.getAll();
                        String string13 = "";
                        while (namingEnumeration5.hasMore()) {
                            String string14 = (String)namingEnumeration5.next();
                            if (string13.equals("")) {
                                string13 = string14;
                                continue;
                            }
                            string13 = string13 + "," + string14;
                        }
                        hashMap2.put(string12, string13);
                    }
                    namingEnumeration4.close();
                }
                hashMap.put(string11, hashMap2);
                hashMap2 = new HashMap();
            }
            namingEnumeration.close();
        } else if (string5.equals("mailstore")) {
            String string15 = "cn=MailStores,cn=um_system,cn=EMailServerContainer,cn=Products,cn=OracleContext";
            searchControls.setSearchScope(1);
            string6 = "cn=*";
            NamingEnumeration<SearchResult> namingEnumeration = initialDirContext.search(string15, string6, searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
                boolean bl = false;
                String[] stringArray = searchResult.toString().split(":", 2);
                String string16 = stringArray[0].replaceAll("cn=", "");
                String string17 = "cn=" + EmailConfigData.getAttributeValue(attributes, "cn");
                String string18 = string17 + "," + string15;
                String string19 = EmailConfigData.getFilter(string2, string4) + ":*";
                NamingEnumeration<SearchResult> namingEnumeration6 = initialDirContext.search(string18, string19, searchControls);
                while (namingEnumeration6.hasMore()) {
                    bl = true;
                    SearchResult searchResult2 = namingEnumeration6.next();
                    Attributes attributes2 = searchResult2.getAttributes();
                    String[] stringArray3 = searchResult2.toString().split(",", 2);
                    String string20 = stringArray3[0];
                    String[] stringArray4 = string20.split(":");
                    String string21 = stringArray4[3];
                    hashMap3.put("mailinstanceid", string21);
                    if (attributes2 == null) continue;
                    NamingEnumeration<? extends Attribute> namingEnumeration7 = attributes2.getAll();
                    while (namingEnumeration7.hasMore()) {
                        BasicAttribute basicAttribute = (BasicAttribute)namingEnumeration7.next();
                        String string22 = basicAttribute.getID();
                        if (!string22.matches("^orclmail.*")) continue;
                        int n = basicAttribute.size();
                        if (n <= 1) {
                            hashMap3.put(string22, basicAttribute.get());
                            continue;
                        }
                        NamingEnumeration<?> namingEnumeration8 = basicAttribute.getAll();
                        String string23 = "";
                        while (namingEnumeration8.hasMore()) {
                            String string24 = (String)namingEnumeration8.next();
                            if (string23.equals("")) {
                                string23 = string24;
                                continue;
                            }
                            string23 = string23 + "," + string24;
                        }
                        hashMap3.put(string22, string23);
                    }
                    namingEnumeration7.close();
                }
                namingEnumeration6.close();
                if (!bl) continue;
                hashMap.put(string16, hashMap3);
            }
            namingEnumeration.close();
        }
        return hashMap;
    }

    private static void printCompConfigData(HashMap hashMap, String string, String string2) {
        if (hashMap == null) {
            System.out.println("em_error=Error retrieving " + string + " config data");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.equals("server")) {
            EmailConfigData.processNullValues(hashMap);
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)hashMap.get(string3);
                stringBuffer.append("em_result=");
                stringBuffer.append(string3);
                stringBuffer.append("|");
                stringBuffer.append(string4);
                stringBuffer.append("\n");
            }
        } else if (string2.equals("instance")) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string5 = (String)iterator.next();
                HashMap hashMap2 = (HashMap)hashMap.get(string5);
                EmailConfigData.processNullValues(hashMap2);
                Iterator iterator2 = hashMap2.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string6 = (String)iterator2.next();
                    String string7 = (String)hashMap2.get(string6);
                    stringBuffer.append("em_result=");
                    stringBuffer.append(string5);
                    stringBuffer.append("|");
                    stringBuffer.append(string6);
                    stringBuffer.append("|");
                    stringBuffer.append(string7);
                    stringBuffer.append("\n");
                }
            }
        } else if (string2.equals("mailstore")) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string8 = (String)iterator.next();
                HashMap hashMap3 = (HashMap)hashMap.get(string8);
                EmailConfigData.processNullValues(hashMap3);
                String string9 = (String)hashMap3.get("mailinstanceid");
                hashMap3.remove("mailinstanceid");
                Iterator iterator3 = hashMap3.keySet().iterator();
                while (iterator3.hasNext()) {
                    String string10 = (String)iterator3.next();
                    String string11 = (String)hashMap3.get(string10);
                    stringBuffer.append("em_result=");
                    stringBuffer.append(string8);
                    stringBuffer.append("|");
                    stringBuffer.append(string9);
                    stringBuffer.append("|");
                    stringBuffer.append(string10);
                    stringBuffer.append("|");
                    stringBuffer.append(string11);
                    stringBuffer.append("\n");
                }
            }
        }
        System.out.println(stringBuffer.toString());
    }

    private static void processNullValues(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            if (string2 != null && string2.trim().length() != 0) continue;
            hashMap.put(string, "");
        }
    }

    private static boolean sslOnly(String string) throws IOException {
        String string2 = System.getProperty("file.separator");
        String string3 = string + string2 + "config" + string2 + "ias.properties";
        FileInputStream fileInputStream = new FileInputStream(string3);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        String string4 = properties.getProperty("SSLOnly");
        return string4.compareToIgnoreCase("true") == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        InitialContext initialContext = null;
        String string3 = "";
        String string4 = "";
        try {
            String string5 = EmailConfigData.getOracleHome(stringArray);
            String string6 = EmailConfigData.getMidtierHost(stringArray);
            string3 = EmailConfigData.getTargetType(stringArray);
            string4 = EmailConfigData.getConfigScope(stringArray);
            SchemaManager schemaManager = new SchemaManager(string5);
            string = EmailConfigData.getInitialEmailDnEntry();
            boolean bl = EmailConfigData.sslOnly(string5);
            initialContext = schemaManager.connectAs(string, bl);
            string2 = EmailConfigData.getBaseEmailDnEntry(string5, string6);
            string2 = EmailConfigData.processDnSpecialChars(string2);
            if (string3 == null) {
                string3 = "";
            }
            HashMap hashMap = EmailConfigData.getCompConfigData(string5, string6, (InitialDirContext)initialContext, string2, string3, string4);
            EmailConfigData.printCompConfigData(hashMap, string3, string4);
        }
        catch (SchemaException schemaException) {
            schemaException.printStackTrace();
            System.out.println("em_error=Schema exception occurred while getting config data for " + string3 + ".  " + schemaException.getMessage());
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            System.out.println("em_error=Naming exception occurred while getting config data for " + string3 + ".  " + namingException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println("em_error=Exception occured while opening ias.property.  " + iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("em_error=Exception occurred while getting config data for " + string3 + ".  " + exception.getMessage());
        }
        finally {
            try {
                initialContext.close();
            }
            catch (NamingException namingException) {}
        }
    }
}

