/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StringContent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import oracle.xml.differ.BranchOffset;
import oracle.xml.differ.LeafOffset;
import oracle.xml.differ.Offset;
import oracle.xml.differ.SViewConstants;
import oracle.xml.differ.XMLHandler;
import oracle.xml.differ.XMLTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLStyledDocument
extends DefaultStyledDocument
implements Serializable,
XMLHandler,
SViewConstants {
    protected SimpleAttributeSet tagSAS;
    protected SimpleAttributeSet attributeNameSAS;
    protected SimpleAttributeSet attributeValueSAS;
    protected SimpleAttributeSet commentDataSAS;
    protected SimpleAttributeSet errorAncestorSAS;
    protected SimpleAttributeSet errorNodeSAS;
    protected SimpleAttributeSet piNameSAS;
    protected SimpleAttributeSet piDataSAS;
    protected SimpleAttributeSet pcdataSAS;
    protected SimpleAttributeSet cdataSAS;
    protected SimpleAttributeSet symbolSAS;
    protected SimpleAttributeSet dtdSAS;
    protected SimpleAttributeSet dtdintSAS;
    private Hashtable nodeBranchOffset;
    private String content;
    private BranchOffset rootDocumentOffset;
    private Vector tagOffsets;
    private Vector attributeNameOffsets;
    private Vector attributeValueOffsets;
    private Vector commentDataOffsets;
    private Vector errorAncestorOffsets;
    private Vector errorNodeOffsets;
    private Vector piNameOffsets;
    private Vector piDataOffsets;
    private Vector pcdataOffsets;
    private Vector cdataOffsets;
    private Vector ignorableWhiteSpaceOffsets;
    private Vector symbolOffsets;
    private Vector dtdOffsets;
    private Vector dtdinternalOffsets;
    private StringBuffer xmlContentBuffer;
    private Stack stack;
    private BranchOffset currentParentOffsets;
    private BranchOffset currentChildOffsets;
    protected int previousOffset;
    private Node currentNode;

    protected XMLStyledDocument() {
        super(new StyleContext());
        this.content = "";
        this.initAttrib();
        this.initOffsets();
        try {
            this.insertString(0, this.content, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected XMLStyledDocument(Document document, boolean bl) {
        this.initAttrib();
        this.initOffsets();
        XMLTokenizer xMLTokenizer = new XMLTokenizer();
        xMLTokenizer.setXMLHandler(this);
        xMLTokenizer.setIntDTDDisp(bl);
        xMLTokenizer.tokenize(document);
        this.format();
    }

    protected void setDocument(Document document) {
        try {
            this.remove(0, this.getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initOffsets();
        XMLTokenizer xMLTokenizer = new XMLTokenizer();
        xMLTokenizer.setXMLHandler(this);
        xMLTokenizer.tokenize(document);
        this.format();
    }

    protected void initAttrib() {
        this.tagSAS = new SimpleAttributeSet();
        this.attributeNameSAS = new SimpleAttributeSet();
        this.attributeValueSAS = new SimpleAttributeSet();
        this.piNameSAS = new SimpleAttributeSet();
        this.piDataSAS = new SimpleAttributeSet();
        this.pcdataSAS = new SimpleAttributeSet();
        this.cdataSAS = new SimpleAttributeSet();
        this.commentDataSAS = new SimpleAttributeSet();
        this.errorAncestorSAS = new SimpleAttributeSet();
        this.errorNodeSAS = new SimpleAttributeSet();
        this.symbolSAS = new SimpleAttributeSet();
        this.dtdSAS = new SimpleAttributeSet();
        this.dtdintSAS = new SimpleAttributeSet();
        StyleConstants.setForeground(this.tagSAS, Color.blue);
        StyleConstants.setForeground(this.attributeValueSAS, Color.red);
        StyleConstants.setBold(this.piNameSAS, true);
        StyleConstants.setForeground(this.piDataSAS, Color.gray);
        StyleConstants.setForeground(this.cdataSAS, Color.red);
        StyleConstants.setForeground(this.commentDataSAS, new Color(50, 128, 0));
        StyleConstants.setItalic(this.commentDataSAS, true);
        StyleConstants.setForeground(this.dtdSAS, Color.pink);
        StyleConstants.setItalic(this.dtdSAS, true);
        StyleConstants.setForeground(this.dtdintSAS, Color.pink);
        StyleConstants.setItalic(this.dtdintSAS, true);
    }

    protected void format() {
        this.formatTags();
        this.formatAttributeNames();
        this.formatAttributeValues();
        this.formatCommentData();
        this.formatErrorAncestor();
        this.formatErrorNode();
        this.formatPINames();
        this.formatPIData();
        this.formatPCDATA();
        this.formatCDATA();
        this.formatSymbols();
        this.formatDTD();
        this.formatDTDInt();
    }

    protected void formatAttributeNames() {
        Offset[] offsetArray = this.getAttributeNameOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.attributeNameSAS, true);
            }
        }
    }

    protected void formatAttributeValues() {
        Offset[] offsetArray = this.getAttributeValueOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.attributeValueSAS, true);
            }
        }
    }

    protected void formatCDATA() {
        Offset[] offsetArray = this.getCDATAOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.cdataSAS, true);
            }
        }
    }

    protected void formatCommentData() {
        Offset[] offsetArray = this.getCommentDataOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.commentDataSAS, true);
            }
        }
    }

    protected void formatErrorAncestor() {
        Offset[] offsetArray = this.getErrorAncestorOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.errorAncestorSAS, true);
            }
        }
    }

    protected void formatErrorNode() {
        Offset[] offsetArray = this.getErrorNodeOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.errorNodeSAS, true);
            }
        }
    }

    protected void formatPCDATA() {
        Offset[] offsetArray = this.getPCDATAOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.pcdataSAS, true);
            }
        }
    }

    protected void formatPIData() {
        Offset[] offsetArray = this.getPIDataOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.piDataSAS, true);
            }
        }
    }

    protected void formatPINames() {
        Offset[] offsetArray = this.getPINameOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.piNameSAS, true);
            }
        }
    }

    protected void formatSymbols() {
        Offset[] offsetArray = this.getSymbolOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.symbolSAS, true);
            }
        }
    }

    protected void formatTags() {
        Offset[] offsetArray = this.getTagOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.tagSAS, true);
            }
        }
    }

    protected void formatDTD() {
        Offset[] offsetArray = this.getDTDOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.dtdSAS, true);
            }
        }
    }

    protected void formatDTDInt() {
        Offset[] offsetArray = this.getDTDInternalOffset();
        if (offsetArray != null) {
            for (int i = 0; i < offsetArray.length; ++i) {
                int n = offsetArray[i].getStartOffset();
                int n2 = offsetArray[i].getEndOffset() - n;
                this.setCharacterAttributes(n, n2, this.dtdintSAS, true);
            }
        }
    }

    public SimpleAttributeSet getAttributeNameSimpleAttrSet() {
        return this.attributeNameSAS;
    }

    protected SimpleAttributeSet getAttributeValueSimpleAttrSet() {
        return this.attributeValueSAS;
    }

    protected SimpleAttributeSet getCDATASimpleAttrSet() {
        return this.cdataSAS;
    }

    protected SimpleAttributeSet getCommentDataSimpleAttrSet() {
        return this.commentDataSAS;
    }

    protected SimpleAttributeSet getErrorAncestorSimpleAttrSet() {
        return this.errorAncestorSAS;
    }

    protected SimpleAttributeSet getErrorNodeSimpleAttrSet() {
        return this.errorNodeSAS;
    }

    protected SimpleAttributeSet getPCDATASimpleAttrSet() {
        return this.pcdataSAS;
    }

    protected SimpleAttributeSet getPIDataSimpleAttrSet() {
        return this.piDataSAS;
    }

    SimpleAttributeSet getPINameSimpleAttrSet() {
        return this.piNameSAS;
    }

    SimpleAttributeSet getSymbolSimpleAttrSet() {
        return this.symbolSAS;
    }

    protected SimpleAttributeSet getTagSimpleAttrSet() {
        return this.tagSAS;
    }

    protected SimpleAttributeSet getDTDSimpleAttrSet() {
        return this.dtdSAS;
    }

    protected SimpleAttributeSet getDTDIntSimpleAttrSet() {
        return this.dtdintSAS;
    }

    void setAttributeNameSimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.attributeNameSAS = simpleAttributeSet;
        this.formatAttributeNames();
    }

    protected void setAttributeValueSimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.attributeValueSAS = simpleAttributeSet;
        this.formatAttributeValues();
    }

    void setCDATASimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.cdataSAS = simpleAttributeSet;
        this.formatCDATA();
    }

    void setCommentDataSimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.commentDataSAS = simpleAttributeSet;
        this.formatCommentData();
    }

    void setErrorAncestorSimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.errorAncestorSAS = simpleAttributeSet;
        this.formatErrorAncestor();
    }

    void setErrorNodeSimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.errorNodeSAS = simpleAttributeSet;
        this.formatErrorNode();
    }

    void setPCDATASimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.pcdataSAS = simpleAttributeSet;
        this.formatPCDATA();
    }

    protected void setPIDataSimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.piDataSAS = simpleAttributeSet;
        this.formatPIData();
    }

    void setPINameSimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.piNameSAS = simpleAttributeSet;
        this.formatPINames();
    }

    void setSymbolSimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.symbolSAS = simpleAttributeSet;
        this.formatSymbols();
    }

    protected void setTagSimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.tagSAS = simpleAttributeSet;
        this.formatTags();
    }

    protected void setDTDSimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.dtdSAS = simpleAttributeSet;
        this.formatDTD();
    }

    protected void setDTDIntSimpleAttrSet(SimpleAttributeSet simpleAttributeSet) {
        this.dtdintSAS = simpleAttributeSet;
        this.formatDTDInt();
    }

    void setDocumentData(Hashtable hashtable, String string, BranchOffset branchOffset, Vector vector, Vector vector2, Vector vector3, Vector vector4, Vector vector5, Vector vector6, Vector vector7, Vector vector8, Vector vector9, Vector vector10, Vector vector11, Vector vector12, Vector vector13, Vector vector14) {
        this.nodeBranchOffset = hashtable;
        this.content = string;
        this.rootDocumentOffset = branchOffset;
        this.tagOffsets = vector;
        this.attributeNameOffsets = vector2;
        this.attributeValueOffsets = vector3;
        this.commentDataOffsets = vector9;
        this.errorAncestorOffsets = vector13;
        this.errorNodeOffsets = vector14;
        this.piNameOffsets = vector4;
        this.piDataOffsets = vector5;
        this.pcdataOffsets = vector6;
        this.cdataOffsets = vector7;
        this.ignorableWhiteSpaceOffsets = vector8;
        this.symbolOffsets = vector10;
        this.dtdOffsets = vector11;
        this.dtdinternalOffsets = vector12;
        this.getAttributeNameOffset();
        this.getAttributeValueOffset();
        this.getCDATAOffset();
        this.getCommentDataOffset();
        this.getErrorAncestorOffset();
        this.getErrorNodeOffset();
        this.getIgnorableWhiteSpaceOffset();
        this.getPCDATAOffset();
        this.getPIDataOffset();
        this.getPINameOffset();
        this.getDTDOffset();
        this.getDTDInternalOffset();
    }

    Offset[] getAttributeNameOffset() {
        return this.getAOffset(this.attributeNameOffsets);
    }

    Offset[] getAttributeValueOffset() {
        return this.getAOffset(this.attributeValueOffsets);
    }

    Offset[] getCDATAOffset() {
        return this.getAOffset(this.cdataOffsets);
    }

    Offset[] getCommentDataOffset() {
        return this.getAOffset(this.commentDataOffsets);
    }

    Offset[] getErrorAncestorOffset() {
        return this.getAOffset(this.errorAncestorOffsets);
    }

    Offset[] getErrorNodeOffset() {
        return this.getAOffset(this.errorNodeOffsets);
    }

    public String getContentString() {
        return this.content;
    }

    StringContent getStringContent() {
        StringContent stringContent = new StringContent(this.content.length());
        try {
            stringContent.insertString(0, this.content);
        }
        catch (Exception exception) {
            return null;
        }
        return stringContent;
    }

    public Document getDOMDocument() {
        return (Document)this.rootDocumentOffset.getUserObject();
    }

    Offset[] getIgnorableWhiteSpaceOffset() {
        return this.getAOffset(this.ignorableWhiteSpaceOffsets);
    }

    Node getNode(int n) {
        BranchOffset branchOffset = this.rootDocumentOffset.getSubBranchOffsetAt(n);
        if (branchOffset != null) {
            return (Node)branchOffset.getUserObject();
        }
        return null;
    }

    Offset[] getPCDATAOffset() {
        return this.getAOffset(this.pcdataOffsets);
    }

    Offset[] getPIDataOffset() {
        return this.getAOffset(this.piDataOffsets);
    }

    Offset[] getPINameOffset() {
        return this.getAOffset(this.piNameOffsets);
    }

    Offset getOffset(Node node) {
        Offset offset = (Offset)this.nodeBranchOffset.get(node);
        return (Offset)this.nodeBranchOffset.get(node);
    }

    Offset[] getAOffset(Vector vector) {
        if (vector == null) {
            return null;
        }
        Object[] objectArray = new Offset[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    Offset[] getSymbolOffset() {
        return this.getAOffset(this.symbolOffsets);
    }

    Offset[] getTagOffset() {
        return this.getAOffset(this.tagOffsets);
    }

    Offset[] getDTDOffset() {
        return this.getAOffset(this.dtdOffsets);
    }

    Offset[] getDTDInternalOffset() {
        return this.getAOffset(this.dtdinternalOffsets);
    }

    protected void create_() {
        this.content = this.xmlContentBuffer.toString();
        try {
            this.insertString(0, this.content, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rootDocumentOffset = this.currentChildOffsets;
    }

    public synchronized void handleNode(Object object, int n) {
        this.currentNode = (Node)object;
    }

    public synchronized void handleXMLDocumentPosition(int n, int n2) {
        switch (n) {
            case 2: {
                this.xmlContentBuffer.append("\n");
                this.create_();
                return;
            }
            case 17: 
            case 19: {
                this.stack.push(this.currentParentOffsets);
                this.currentParentOffsets = this.currentChildOffsets;
                return;
            }
            case 18: 
            case 20: {
                this.currentChildOffsets = this.currentParentOffsets;
                this.currentParentOffsets = (BranchOffset)this.stack.pop();
                return;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 21: {
                this.currentChildOffsets = new BranchOffset(this.currentNode);
                if (this.currentParentOffsets != null) {
                    this.currentParentOffsets.addSuboffset(this.currentChildOffsets);
                }
                this.nodeBranchOffset.put(this.currentNode, this.currentChildOffsets);
                return;
            }
        }
    }

    public synchronized void handleXMLToken(String string, int n, int n2) {
        this.xmlContentBuffer.append(string);
        LeafOffset leafOffset = new LeafOffset(this.previousOffset, n2);
        this.currentChildOffsets.addSuboffset(leafOffset);
        this.previousOffset = n2;
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                if (this.tagOffsets == null) {
                    this.tagOffsets = new Vector();
                }
                this.tagOffsets.addElement(leafOffset);
                return;
            }
            case 4: {
                if (this.attributeNameOffsets == null) {
                    this.attributeNameOffsets = new Vector();
                }
                this.attributeNameOffsets.addElement(leafOffset);
                return;
            }
            case 5: {
                if (this.attributeValueOffsets == null) {
                    this.attributeValueOffsets = new Vector();
                }
                this.attributeValueOffsets.addElement(leafOffset);
                return;
            }
            case 7: {
                if (this.piNameOffsets == null) {
                    this.piNameOffsets = new Vector();
                }
                this.piNameOffsets.addElement(leafOffset);
                return;
            }
            case 8: {
                if (this.piDataOffsets == null) {
                    this.piDataOffsets = new Vector();
                }
                this.piDataOffsets.addElement(leafOffset);
                return;
            }
            case 9: {
                if (this.pcdataOffsets == null) {
                    this.pcdataOffsets = new Vector();
                }
                this.pcdataOffsets.addElement(leafOffset);
                return;
            }
            case 10: {
                if (this.cdataOffsets == null) {
                    this.cdataOffsets = new Vector();
                }
                this.cdataOffsets.addElement(leafOffset);
                return;
            }
            case 11: {
                if (this.ignorableWhiteSpaceOffsets == null) {
                    this.ignorableWhiteSpaceOffsets = new Vector();
                }
                this.ignorableWhiteSpaceOffsets.addElement(leafOffset);
                return;
            }
            case 6: {
                if (this.commentDataOffsets == null) {
                    this.commentDataOffsets = new Vector();
                }
                this.commentDataOffsets.addElement(leafOffset);
                return;
            }
            case 49: {
                if (this.errorAncestorOffsets == null) {
                    this.errorAncestorOffsets = new Vector();
                }
                this.errorAncestorOffsets.addElement(leafOffset);
                return;
            }
            case 50: {
                if (this.errorNodeOffsets == null) {
                    this.errorNodeOffsets = new Vector();
                }
                this.errorNodeOffsets.addElement(leafOffset);
                return;
            }
            case 23: {
                if (this.dtdOffsets == null) {
                    this.dtdOffsets = new Vector();
                }
                this.dtdOffsets.addElement(leafOffset);
                return;
            }
            case 24: {
                if (this.dtdinternalOffsets == null) {
                    this.dtdinternalOffsets = new Vector();
                }
                this.dtdinternalOffsets.addElement(leafOffset);
                return;
            }
        }
        if (this.symbolOffsets == null) {
            this.symbolOffsets = new Vector();
        }
        this.symbolOffsets.addElement(leafOffset);
    }

    protected void initOffsets() {
        this.stack = new Stack();
        this.nodeBranchOffset = new Hashtable();
        this.currentChildOffsets = null;
        this.currentParentOffsets = null;
        this.previousOffset = 0;
        this.xmlContentBuffer = new StringBuffer();
        this.tagOffsets = null;
        this.attributeNameOffsets = null;
        this.attributeValueOffsets = null;
        this.commentDataOffsets = null;
        this.errorAncestorOffsets = null;
        this.errorNodeOffsets = null;
        this.piNameOffsets = null;
        this.piDataOffsets = null;
        this.pcdataOffsets = null;
        this.cdataOffsets = null;
        this.ignorableWhiteSpaceOffsets = null;
        this.dtdOffsets = null;
        this.dtdinternalOffsets = null;
    }

    protected void print(LeafOffset leafOffset, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
        System.out.println(leafOffset);
    }

    protected void recursePrint(BranchOffset branchOffset, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t");
        }
        Node node = (Node)branchOffset.getUserObject();
        System.out.println(branchOffset + " userObj nodetype:" + node.getNodeType());
        Enumeration enumeration = branchOffset.suboffsets();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof BranchOffset) {
                    this.recursePrint((BranchOffset)e, n + 1);
                    continue;
                }
                this.print((LeafOffset)e, n + 1);
            }
        }
    }
}

