/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import oracle.xml.jaxb.JaxbConstants;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;

public class JaxbDatatypeConverter
implements JaxbConstants {
    private static final String base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    public static String parseAnySimpleType(String string) {
        if (string != null) {
            return string.trim();
        }
        return null;
    }

    public static Object parseAnySimpleTypeObject(String string) {
        return string;
    }

    public static byte[] parseBase64Binary(String string) {
        int n = 32;
        int n2 = 32;
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < string.length(); ++i) {
            n2 = n;
            n = stringBuffer.charAt(i);
            if (n2 == 13 && n == 10) {
                stringBuffer.deleteCharAt(i);
                stringBuffer.deleteCharAt(i - 1);
                i -= 2;
                continue;
            }
            if (n == 9) {
                stringBuffer.deleteCharAt(i);
                --i;
                continue;
            }
            if (n != 32) continue;
            --i;
        }
        if (string.length() % 4 != 0) {
            return null;
        }
        int n3 = string.length() / 4 * 3;
        if (string.endsWith("==")) {
            n3 -= 2;
        } else if (string.endsWith("=")) {
            --n3;
        }
        byte[] byArray = new byte[n3];
        for (int i = string.length() / 4 - 1; i >= 0; --i) {
            int n4 = (base64Chars.indexOf(string.charAt(i * 4)) & 0x3F) << 18 | (base64Chars.indexOf(string.charAt(i * 4 + 1)) & 0x3F) << 12 | (base64Chars.indexOf(string.charAt(i * 4 + 2)) & 0x3F) << 6 | base64Chars.indexOf(string.charAt(i * 4 + 3)) & 0x3F;
            byArray[i * 3] = (byte)(n4 >> 16 & 0xFF);
            if (string.charAt(i * 4 + 2) == '=') continue;
            byArray[i * 3 + 1] = (byte)(n4 >> 8 & 0xFF);
            if (string.charAt(i * 4 + 3) == '=') continue;
            byArray[i * 3 + 2] = (byte)(n4 & 0xFF);
        }
        return byArray;
    }

    public static boolean parseBoolean(String string) {
        return string != null && (string.equals("true") || string.equals("1"));
    }

    public static byte parseByte(String string) {
        if (string != null) {
            return Byte.valueOf(string);
        }
        return 0;
    }

    public static Byte parseByteObject(String string) {
        if (string != null) {
            return new Byte(string);
        }
        return null;
    }

    public static Calendar parseDate(String string) {
        if (string != null) {
            return JaxbDatatypeConverter.convertStringToCalendar(string);
        }
        return null;
    }

    public static Calendar parseDateTime(String string) {
        if (string != null) {
            return JaxbDatatypeConverter.convertStringToCalendar(string);
        }
        return null;
    }

    public static BigDecimal parseDecimal(String string) {
        if (string != null && (string.indexOf(101) <= 0 || string.indexOf(69) <= 0)) {
            return new BigDecimal(string);
        }
        return null;
    }

    public static double parseDouble(String string) {
        if (string == null) {
            return 0.0;
        }
        double d = string.equals("-INF") ? Double.NEGATIVE_INFINITY : (string.equals("INF") ? Double.POSITIVE_INFINITY : (string.equals("NaN") ? Double.NaN : Double.valueOf(string)));
        return d;
    }

    public static float parseFloat(String string) {
        if (string != null) {
            return Float.valueOf(string).floatValue();
        }
        return 0.0f;
    }

    public static byte[] parseHexBinary(String string) {
        int n = string.length();
        byte[] byArray = string.getBytes();
        for (int i = 0; i < n; ++i) {
            char c = (char)byArray[i];
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue;
            if (c >= 'a' && c < 'f') {
                byArray[i] = (byte)Character.toUpperCase(c);
                continue;
            }
            return null;
        }
        return byArray;
    }

    public static int parseInt(String string) {
        if (string != null) {
            return Integer.valueOf(string.trim());
        }
        return 0;
    }

    public static Integer parseIntegerObject(String string) {
        if (string != null) {
            return new Integer(string);
        }
        return null;
    }

    public static BigInteger parseInteger(String string) {
        if (string != null) {
            return new BigInteger(string);
        }
        return null;
    }

    public static List parseList(String string) {
        if (string == null) {
            int n = 0;
            ArrayList arrayList = new ArrayList(n);
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        if (n == 0) {
            return arrayList;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static long parseLong(String string) {
        if (string != null) {
            return Long.valueOf(string);
        }
        return 0L;
    }

    public static Long parseLongObject(String string) {
        if (string != null) {
            return new Long(string);
        }
        return null;
    }

    public static QName parseQName(String string, NamespaceContext namespaceContext) {
        return new QName(namespaceContext.getNamespaceURI(string), string);
    }

    public static QName parseQName(String string) {
        return new QName(string);
    }

    public static short parseShort(String string) {
        if (string != null) {
            return Short.valueOf(string);
        }
        return 0;
    }

    public static Short parseShortObject(String string) {
        if (string != null) {
            return new Short(string);
        }
        return null;
    }

    public static String parseString(String string) {
        return string;
    }

    public static Calendar parseTime(String string) {
        if (string != null) {
            return JaxbDatatypeConverter.convertStringToCalendar(string);
        }
        return null;
    }

    public static long parseUnsignedInt(String string) {
        if (string != null) {
            return Long.valueOf(string);
        }
        return 0L;
    }

    public static int parseUnsignedShort(String string) {
        if (string != null) {
            return Integer.valueOf(string);
        }
        return 0;
    }

    public static String printAnySimpleType(String string) {
        if (string != null) {
            return string.intern();
        }
        return "";
    }

    public static String printAnySimpleTypeObject(Object object) {
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public static String printBase64Binary(byte[] byArray) {
        byte by;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (n = 0; n < byArray.length - byArray.length % 3; n += 3) {
            by = (byte)(byArray[n] >> 2 & 0x3F);
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(((byArray[n] & 3) << 4) + (byArray[n + 1] >> 4 & 0xF));
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(((byArray[n + 1] & 0xF) << 2) + (byArray[n + 2] >> 6 & 3));
            stringBuffer.append(base64Chars.charAt(by));
            by = (byte)(byArray[n + 2] & 0x3F);
            stringBuffer.append(base64Chars.charAt(by));
        }
        if (byArray.length % 3 != 0) {
            if (byArray.length % 3 == 2) {
                by = (byte)(byArray[n] >> 2 & 0x3F);
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)(((byArray[n] & 3) << 4) + (byArray[n + 1] >> 4 & 0xF));
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)((byArray[n + 1] & 0xF) << 2);
                stringBuffer.append(base64Chars.charAt(by));
                stringBuffer.append("=");
            } else if (byArray.length % 3 == 1) {
                by = (byte)(byArray[n] >> 2 & 0x3F);
                stringBuffer.append(base64Chars.charAt(by));
                by = (byte)((byArray[n] & 3) << 4);
                stringBuffer.append(base64Chars.charAt(by));
                stringBuffer.append("==");
            }
        }
        return stringBuffer.toString();
    }

    public static String printBoolean(boolean bl) {
        return new Boolean(bl).toString();
    }

    public static String printByte(byte by) {
        return Byte.toString(by);
    }

    public static String printByte(Byte by) {
        if (by != null) {
            return by.toString();
        }
        return null;
    }

    public static String printDate(Calendar calendar) {
        return JaxbDatatypeConverter.getLexicalValue(calendar, OXMLSequenceType.TDATE);
    }

    public static String printDateTime(Calendar calendar) {
        return JaxbDatatypeConverter.getLexicalValue(calendar, OXMLSequenceType.TDATETIME);
    }

    public static String printDecimal(BigDecimal bigDecimal) {
        return bigDecimal.toString();
    }

    public static String printDouble(double d) {
        return Double.toString(d);
    }

    public static String printFloat(float f) {
        return Float.toString(f);
    }

    public static String printHexBinary(byte[] byArray) {
        return null;
    }

    public static String printInt(int n) {
        return Integer.toString(n);
    }

    public static String printIntegerObject(Integer n) {
        if (n != null) {
            return n.toString();
        }
        return null;
    }

    public static String printInteger(BigInteger bigInteger) {
        if (bigInteger != null) {
            return bigInteger.toString();
        }
        return null;
    }

    public static String printList(List list) {
        return "";
    }

    public static String printLong(long l) {
        return Long.toString(l);
    }

    public static String printLongObject(Long l) {
        if (l != null) {
            return l.toString();
        }
        return null;
    }

    public static String printQName(QName qName, NamespaceContext namespaceContext) {
        return qName.toString();
    }

    public static String printQName(QName qName) {
        return qName.toString();
    }

    public static String printShort(short s) {
        return Short.toString(s);
    }

    public static String printShortObject(Short s) {
        if (s != null) {
            return s.toString();
        }
        return null;
    }

    public static String printString(String string) {
        return string;
    }

    public static String printTime(Calendar calendar) {
        return JaxbDatatypeConverter.getLexicalValue(calendar, OXMLSequenceType.TTIME);
    }

    public static String printUnsignedInt(long l) {
        return Long.toString(l);
    }

    public static String printUnsignedShort(int n) {
        return Integer.toString(n);
    }

    static Calendar convertStringToCalendar(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        XSDDataValue xSDDataValue = null;
        Calendar calendar = null;
        try {
            if (string.indexOf(45) > 0 && string.indexOf(58) > 0 && string.indexOf(84) > 0) {
                xSDDataValue = new XSDDataValue(7, string);
            } else if (string.indexOf(58) > 0) {
                xSDDataValue = new XSDDataValue(8, string);
            } else if (string.indexOf(45) > 0) {
                xSDDataValue = new XSDDataValue(9, string);
            } else {
                return null;
            }
            calendar = xSDDataValue.getGregorianCalendar();
        }
        catch (Exception exception) {
            return null;
        }
        return calendar;
    }

    static String convertCalendarToString(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer().append(calendar.get(1));
        StringBuffer stringBuffer3 = new StringBuffer().append(calendar.get(2));
        StringBuffer stringBuffer4 = new StringBuffer().append(calendar.get(5));
        StringBuffer stringBuffer5 = new StringBuffer().append(calendar.get(11));
        StringBuffer stringBuffer6 = new StringBuffer().append(calendar.get(12));
        StringBuffer stringBuffer7 = new StringBuffer().append(calendar.get(13));
        if (stringBuffer3.length() == 1) {
            stringBuffer3.insert(0, '0');
        }
        if (stringBuffer4.length() == 1) {
            stringBuffer4.insert(0, '0');
        }
        if (stringBuffer6.length() == 1) {
            stringBuffer6.insert(0, '0');
        }
        if (stringBuffer7.length() == 1) {
            stringBuffer7.insert(0, '0');
        }
        if (calendar.isSet(1)) {
            stringBuffer.append(stringBuffer2.toString()).append('-').append(stringBuffer3.toString()).append('-').append(stringBuffer4.toString());
        }
        if (calendar.isSet(1) && calendar.isSet(11)) {
            stringBuffer.append('T');
        }
        if (calendar.isSet(11)) {
            stringBuffer.append(stringBuffer5.toString()).append(':').append(stringBuffer6.toString()).append(':').append(stringBuffer7.toString());
        }
        return stringBuffer.toString();
    }

    private static String getLexicalValue(Calendar calendar, OXMLSequenceType oXMLSequenceType) {
        GregorianCalendar gregorianCalendar;
        if (calendar == null) {
            return "";
        }
        DataTypeItem dataTypeItem = new DataTypeItem();
        if (calendar instanceof GregorianCalendar) {
            gregorianCalendar = (GregorianCalendar)calendar.clone();
        } else {
            gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(calendar.getTimeInMillis());
        }
        TimeZone timeZone = gregorianCalendar.getTimeZone();
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(timeZone.getOffset(calendar.getTimeInMillis()), timeZone.getID());
        gregorianCalendar.setTimeZone(simpleTimeZone);
        dataTypeItem.setCalendar(oXMLSequenceType, true, gregorianCalendar);
        return dataTypeItem.getLexicalValue();
    }

    private static class DataTypeItem
    extends OXMLItem {
        private DataTypeItem() {
        }

        public void atomize(OXMLSequence oXMLSequence) throws XQException {
        }

        public OXMLSequence atomize() throws XQException {
            return null;
        }

        protected void convert2QName() throws XQException {
        }
    }
}

