/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxb;

import java.io.File;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import oracle.xml.jaxb.JaxbCustomization;
import oracle.xml.jaxb.JaxbDefaultCustomization;
import oracle.xml.jaxb.JaxbError;
import oracle.xml.jaxb.JaxbInterfaceGen;
import oracle.xml.jaxb.JaxbSchemaCompiler;
import oracle.xml.jaxb.JaxbSourceGen;
import oracle.xml.parser.v2.XMLParser;
import org.xml.sax.EntityResolver;

public class oranjaxb {
    private JaxbSchemaCompiler schemaCompiler;
    private JaxbCustomization customization;
    private JaxbInterfaceGen interfaceGen;
    private JaxbSourceGen sourceGen;
    private JaxbDefaultCustomization defaultCus;
    private boolean interfaceOption = false;
    private boolean extensionOption = false;
    private String outputDir = ".";
    private String targetPkg = "";
    private String fileName = null;
    private String entityResolverName = null;
    private EntityResolver entityResolver = null;
    private boolean verbose = true;
    private StringBuffer verboseBuf;
    private JaxbError err = new JaxbError();
    private String defaultCusFile = null;
    private ArrayList bindingFileList = null;
    private static final String newline = System.getProperty("line.separator");
    private static final String usageMessage = "Usage: oracle.xml.jaxb.oranjaxb [-options]" + newline + "where options include: " + newline + " -help                      Prints the help message text" + newline + " -version                   Prints the release version" + newline + " -outputDir <OutputDir>     The directory to generate java source " + newline + " -schema    <SchemaFile>    The input schema file" + newline + " -entityRes <ClassName>     The entity resolver used for schema compilation" + newline + " -targetPkg <targetPkg>     The target package name" + newline + " -bindingFile <bindingFlie> The external bindings file (each binding file " + newline + "                            requires a separate -bindingFile option.) " + newline + " -interface                 Option to generate the interfaces only" + newline + " -defaultCus <FileName>     Generate default customization file" + newline + " -extension                 Allow vendor specific extensions - do not strictly " + newline + "                            follow the compatibility rules specified " + newline + "                            in the Appendix E.2 of JAXB 1.0 Spec " + newline;

    oranjaxb() {
        this.err.setErrorStream(new PrintWriter(System.err));
        this.err.showWarnings(true);
    }

    public static void main(String[] stringArray) {
        oranjaxb oranjaxb2 = new oranjaxb();
        oranjaxb2.processArgs(stringArray);
        oranjaxb2.generate();
    }

    private void processArgs(String[] stringArray) {
        int n = stringArray.length;
        if (n < 1) {
            this.printUsage("");
            System.exit(0);
        }
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("-help")) {
                this.printUsage("");
                continue;
            }
            if (stringArray[i].equals("-version")) {
                String string = XMLParser.getReleaseVersion();
                System.out.println("Release version: " + string);
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-outputDir")) {
                if (i == n - 1) {
                    this.printUsage("Ouput Directory name is missing");
                }
                this.outputDir = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-defaultCus")) {
                if (i == n - 1) {
                    this.printUsage("Default Binding File name is missing");
                }
                this.defaultCusFile = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-targetPkg")) {
                if (i == n - 1) {
                    this.printUsage("Target Package Name is missing");
                }
                this.targetPkg = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-bindingFile")) {
                if (this.bindingFileList == null) {
                    this.bindingFileList = new ArrayList();
                }
                if (i == n - 1) {
                    this.printUsage("External Binding File is missing");
                }
                this.bindingFileList.add(this.fileToURL(stringArray[++i]));
                continue;
            }
            if (stringArray[i].equals("-schema")) {
                if (i == n - 1) {
                    this.printUsage("Input Schema file is missing");
                }
                this.fileName = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-entityRes")) {
                if (i == n - 1) {
                    this.printUsage("Input EntityResolver is missing");
                }
                this.entityResolverName = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-interface")) {
                this.interfaceOption = true;
                continue;
            }
            if (stringArray[i].equals("-extension")) {
                this.extensionOption = true;
                continue;
            }
            if (!stringArray[i].equals("-verbose")) continue;
            this.verbose = true;
        }
        if (this.fileName == null) {
            this.printUsage("Schema file needs to be given as input with the option -schema <fileName> ");
        }
        this.createEntityResolverObj();
    }

    private void createEntityResolverObj() {
        if (this.entityResolverName == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(this.entityResolverName);
            this.entityResolver = (EntityResolver)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private void generate() {
        int n;
        long l = System.currentTimeMillis();
        try {
            String string;
            this.schemaCompiler = new JaxbSchemaCompiler();
            this.schemaCompiler.setError(this.err);
            this.schemaCompiler.setTargetPkg(this.targetPkg);
            this.schemaCompiler.setBindingFileList(this.bindingFileList);
            this.schemaCompiler.setExtension(this.extensionOption);
            this.schemaCompiler.setEntityResolver(this.entityResolver);
            JaxbCustomization jaxbCustomization = new JaxbCustomization();
            jaxbCustomization.setError(this.err);
            this.schemaCompiler.setCustomization(jaxbCustomization);
            Hashtable hashtable = this.schemaCompiler.compile(this.fileToURL(this.fileName));
            this.interfaceGen = new JaxbInterfaceGen();
            this.interfaceGen.setError(this.err);
            this.interfaceGen.setOutputDir(this.outputDir);
            this.interfaceGen.setBindingSchema(hashtable);
            if (this.verbose) {
                this.verboseBuf = new StringBuffer();
                this.interfaceGen.generate(this.verboseBuf);
                System.out.println(this.verboseBuf.toString());
            } else {
                this.interfaceGen.generate();
            }
            if (!this.interfaceOption) {
                this.sourceGen = new JaxbSourceGen();
                this.sourceGen.setError(this.err);
                this.sourceGen.setOutputDir(this.outputDir);
                string = new File(this.fileName).getCanonicalPath();
                n = System.getProperty("file.separator").charAt(0);
                string = string.replace((char)n, '/');
                this.sourceGen.setSchemaLocation(string);
                this.sourceGen.setBindingSchema(hashtable);
                if (this.verbose) {
                    this.verboseBuf = new StringBuffer();
                    this.sourceGen.generate(this.verboseBuf);
                    System.out.println(this.verboseBuf.toString());
                } else {
                    this.sourceGen.generate();
                }
            }
            if (this.defaultCusFile != null) {
                this.defaultCus = new JaxbDefaultCustomization(this.defaultCusFile);
                this.defaultCus.setError(this.err);
                this.defaultCus.setOutputDir(this.outputDir);
                string = new File(this.fileName).getCanonicalPath();
                n = System.getProperty("file.separator").charAt(0);
                string = string.replace((char)n, '/');
                this.defaultCus.setSchemaLocation(string);
                this.defaultCus.setBindingSchema(hashtable);
                this.defaultCus.generateCustomization();
            }
        }
        catch (Exception exception) {
            this.err.error0(32009, 0);
        }
        try {
            int n2 = this.err.getNumMessages();
            if (n2 == 0) {
                System.exit(0);
            }
            this.err.flushErrors();
            for (int i = 0; i < n2; ++i) {
                n = this.err.getMessageType(i);
                if (n != 0 && n != 1) continue;
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printUsage(String string) {
        if (string.equals("")) {
            System.out.println(usageMessage);
        } else {
            System.out.println("Error: " + string + newline + newline + usageMessage);
        }
        System.exit(0);
    }

    private URL fileToURL(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = '/' + string2;
        }
        try {
            return new URL("file", null, string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("Error: Unexpected MalformedURLException");
        }
    }
}

