/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.processes;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import oracle.xml.parser.v2.SAXParser;
import oracle.xml.pipeline.controller.Input;
import oracle.xml.pipeline.controller.Output;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.Process;
import oracle.xml.pipeline.controller.Util;
import org.xml.sax.ContentHandler;

public class SAXParserProcess
extends Process {
    public void initialize() {
        Input input = this.getInput("xmlsource");
        input.supportType(2);
        input.supportType(8);
        Output output = this.getOutput("sax");
        output.supportType(5);
        output.supportType(8);
    }

    public void execute() throws PipelineException {
        Object object;
        Output output = this.getOutput("sax");
        ContentHandler contentHandler = this.getSAXContentHandler(output);
        if (contentHandler == null) {
            this.setProcessStatus((short)2);
            return;
        }
        Source source = this.getInputSource("xmlsource");
        String string = (String)this.getInParamValue("baseURL");
        String string2 = (String)this.getInParamValue("preserveWhitespace");
        String string3 = (String)this.getInParamValue("validationMode");
        int n = 0;
        SAXParser sAXParser = new SAXParser();
        sAXParser.setContentHandler(contentHandler);
        sAXParser.setErrorHandler(this.getSAXErrorHandler(output));
        this.setOutputResult("sax", new SAXResult(contentHandler));
        if (string != null && string.length() != 0) {
            try {
                object = Util.createURL(string);
                sAXParser.setBaseURL((URL)object);
            }
            catch (MalformedURLException malformedURLException) {
                this.error(30004, 17, malformedURLException);
            }
        }
        if (string2 != null) {
            object = Boolean.valueOf(string2);
            sAXParser.setPreserveWhitespace(((Boolean)object).booleanValue());
        }
        if (string3 != null) {
            if (string3.compareTo("PARTIAL_VALIDATION") == 0) {
                n = 1;
            } else if (string3.compareTo("DTD_VALIDATION") == 0) {
                n = 2;
            } else if (string3.compareTo("SCHEMA_VALIDATION") == 0) {
                n = 3;
            }
        }
        sAXParser.setValidationMode(n);
        object = this.getInParamValue("schemaObj");
        if (object != null) {
            sAXParser.setXMLSchema(object);
        }
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            try {
                Closeable closeable = streamSource.getInputStream();
                if (closeable != null) {
                    sAXParser.parse(closeable);
                } else {
                    closeable = streamSource.getReader();
                    if (closeable != null) {
                        sAXParser.parse((Reader)closeable);
                    } else {
                        this.error(30003, 17, new String[]{"xmlsource"});
                    }
                }
                this.convertFromSAX(new SAXResult(contentHandler), output);
            }
            catch (Exception exception) {
                InputStream inputStream = null;
                if (!this.ignoreError(output.getName())) {
                    this.error(30001, 17, exception);
                }
                try {
                    this.info(30000, new String[]{"SAXParserProcess", exception.getMessage()});
                    sAXParser.reset();
                    contentHandler = this.getSAXContentHandler(output);
                    sAXParser.setContentHandler(contentHandler);
                    SAXResult sAXResult = new SAXResult(contentHandler);
                    this.setOutputResult(output.getName(), sAXResult);
                    inputStream = this.getErrorStream(output.getName(), true);
                    sAXParser.setValidationMode(0);
                    sAXParser.parse(inputStream);
                    inputStream.close();
                    this.convertFromSAX(sAXResult, output);
                }
                catch (Exception exception2) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        this.error(30007, 17, iOException);
                    }
                    this.error(30007, 17, exception2);
                }
            }
        } else {
            this.error(30003, 17, new String[]{"StreamSource allowed"});
        }
    }
}

