/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xsql.XSQLConnectionManagerFactory;
import oracle.xml.xsql.XSQLErrorHandler;
import oracle.xml.xsql.XSQLErrorHandlerImpl;
import oracle.xml.xsql.XSQLInitializationException;
import oracle.xml.xsql.XSQLLoggerFactory;
import oracle.xml.xsql.XSQLNamedConnection;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLServletPageRequest;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XSQLConfigManager {
    private static final String DEFAULT_CHARSET = "8859_1";
    private static final String DEFAULT_CONFIG_FILE_NAME = "XSQLConfig.xml";
    private static final String CONFIG_FILE_SYSTEMPARAM = "xsql.config";
    private Hashtable namedConnections = new Hashtable(5);
    private Hashtable userDefinedHandlers = new Hashtable(5);
    private Hashtable userDefinedSerializers = new Hashtable(5);
    private Hashtable noCharsetMimeTypes = new Hashtable(5);
    private Hashtable xslTrustedHosts = new Hashtable(5);
    private boolean dumpPoolAllowed = false;
    private Integer xsqlResultFragmentCacheSize = new Integer(40);
    private Integer xsqlPageCacheSize = new Integer(20);
    private Integer stylesheetPageCacheSize = new Integer(20);
    private Integer stylesheetPoolInitial = new Integer(1);
    private Integer stylesheetPoolIncrement = new Integer(1);
    private Integer stylesheetPoolTimeout = new Integer(60);
    private Integer connectionPoolInitial = new Integer(1);
    private Integer connectionPoolIncrement = new Integer(1);
    private Integer outputBufferSize = new Integer(0);
    private Integer connectionPoolTimeout = new Integer(60);
    private Integer defaultRowPrefetch = new Integer(50);
    private Boolean reloadConfigFileOnError = new Boolean(true);
    private Boolean preserveWhitespace = Boolean.TRUE;
    private String baseCharSet = "8859_1";
    private String configFileNameToUse = null;
    private static final String OWA_FETCHSTYLE_CLOB = "CLOB";
    private static final String OWA_FETCHSTYLE_TABLE = "TABLE";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private String defaultOWAFetchStyle = "CLOB";
    private boolean defaultAllowXSLOverride = false;
    private boolean pageTiming = false;
    private boolean actionTiming = false;
    private boolean allowAnyHost = false;
    private static final String defaultConnManagerFactoryName = "oracle.xml.xsql.XSQLConnectionManagerFactoryImpl";
    private static final String defaultErrorHandlerClassName = "oracle.xml.xsql.XSQLErrorHandlerImpl";
    private XSQLConnectionManagerFactory defaultConnManagerFactory = null;
    private XSQLLoggerFactory xsqlLoggerFactory = null;
    private XSQLErrorHandler currentErrorHandler = new XSQLErrorHandlerImpl();
    private XSQLErrorHandler defaultErrorHandler = null;
    private static boolean loadedConfig = false;
    private static XSQLConfigManager xcm = null;

    public boolean pageTimingInfo() {
        return this.pageTiming;
    }

    public boolean actionTimingInfo() {
        return this.actionTiming;
    }

    public String getBaseCharsetForConversion() {
        return this.baseCharSet;
    }

    public boolean isTrustedHost(String string) {
        if (this.allowAnyHost) {
            return true;
        }
        if (string != null && !string.equals("")) {
            if (string.equals("localhost") || string.equals("127.0.0.1")) {
                return true;
            }
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                String string2 = inetAddress.getHostAddress();
                return this.xslTrustedHosts.get(string2) != null;
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
        return false;
    }

    public boolean defaultAllowClientOverride() {
        return this.defaultAllowXSLOverride;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public boolean isCustomLoggerFactoryProvided() {
        return this.xsqlLoggerFactory != null;
    }

    public XSQLLoggerFactory getLoggerFactory() {
        return this.xsqlLoggerFactory;
    }

    public XSQLConnectionManagerFactory getDefaultConnectionManagerFactory() {
        return this.defaultConnManagerFactory;
    }

    public XSQLErrorHandler getErrorHandler() {
        return this.currentErrorHandler;
    }

    public XSQLErrorHandler getDefaultErrorHandler() {
        if (this.defaultErrorHandler == null) {
            XSQLErrorHandlerImpl xSQLErrorHandlerImpl = new XSQLErrorHandlerImpl();
            this.defaultErrorHandler = xSQLErrorHandlerImpl;
        }
        return this.defaultErrorHandler;
    }

    public int getDefaultRowPrefetch() {
        return this.defaultRowPrefetch;
    }

    public String getDefaultOWAFetchStyle() {
        return this.defaultOWAFetchStyle;
    }

    public int getConnectionPoolTimeout() {
        return this.connectionPoolTimeout * 1000;
    }

    public int getConnectionPoolInitial() {
        return this.connectionPoolInitial;
    }

    public int getConnectionPoolIncrement() {
        return this.connectionPoolIncrement;
    }

    public int getStylesheetPoolTimeout() {
        return this.stylesheetPoolTimeout * 1000;
    }

    public int getStylesheetPoolInitial() {
        return this.stylesheetPoolInitial;
    }

    public int getStylesheetPoolIncrement() {
        return this.stylesheetPoolIncrement;
    }

    public int getXSQLPageCacheSize() {
        return this.xsqlPageCacheSize;
    }

    public int getXSQLResultFragmentCacheSize() {
        return this.xsqlResultFragmentCacheSize;
    }

    public int getStylesheetPageCacheSize() {
        return this.stylesheetPageCacheSize;
    }

    public static XSQLConfigManager getManager() {
        if (xcm == null) {
            xcm = new XSQLConfigManager();
        }
        return xcm;
    }

    public static void insureConfigurationIsLoaded(XSQLPageRequest xSQLPageRequest) {
        if (!loadedConfig) {
            XSQLConfigManager.getManager().reloadConfigFile(xSQLPageRequest);
        }
    }

    public boolean dumpPoolAllowed() {
        return this.dumpPoolAllowed;
    }

    public boolean preserveWhitespace() {
        return this.preserveWhitespace == Boolean.TRUE;
    }

    public boolean ignoreCharsetForMime(String string) {
        return this.noCharsetMimeTypes.get(string) != null;
    }

    public Hashtable getNamedConnections() {
        return this.namedConnections;
    }

    public XSQLNamedConnection getNamedConnection(XSQLPageRequest xSQLPageRequest, String string) {
        XSQLNamedConnection xSQLNamedConnection = (XSQLNamedConnection)this.namedConnections.get(string);
        if (xSQLNamedConnection == null && (this.reloadConfigFileOnError.equals(Boolean.TRUE) || !loadedConfig)) {
            this.reloadConfigFile(xSQLPageRequest);
        }
        return (XSQLNamedConnection)this.namedConnections.get(string);
    }

    public Hashtable getUserDefinedHandlers() {
        return this.userDefinedHandlers;
    }

    public Hashtable getUserDefinedSerializers() {
        return this.userDefinedSerializers;
    }

    private XSQLConfigManager() {
    }

    synchronized void reset() {
        loadedConfig = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void reloadConfigFile(XSQLPageRequest xSQLPageRequest) {
        NodeList nodeList;
        String string;
        Node node;
        Object object;
        Object object2;
        Hashtable<String, String> hashtable;
        Object object3;
        Hashtable<String, String> hashtable2;
        String string2;
        Object object4;
        Object object5;
        Properties properties;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Integer n;
        Object object112;
        Object object12;
        Object object13;
        Object object14;
        Document document;
        block162: {
            document = null;
            Object var3_3 = null;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            InputStream inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            if (this.configFileNameToUse == null) {
                object14 = System.getProperty(CONFIG_FILE_SYSTEMPARAM);
                if (object14 != null) {
                    this.configFileNameToUse = object14;
                }
                if (xSQLPageRequest.getRequestType().equals("Servlet")) {
                    object14 = null;
                    object13 = (XSQLServletPageRequest)xSQLPageRequest;
                    object14 = ((XSQLServletPageRequest)object13).getCustomConfigFileName();
                    if (object14 != null) {
                        this.configFileNameToUse = object14;
                    }
                }
            }
            if (this.configFileNameToUse == null) {
                this.configFileNameToUse = DEFAULT_CONFIG_FILE_NAME;
            }
            try {
                try {
                    inputStream = this.readConfigFileFromClassPath(this.configFileNameToUse);
                    if (inputStream == null) {
                        xSQLPageRequest.signalError(25003, new String[]{this.configFileNameToUse}, null);
                        throw new XSQLInitializationException();
                    }
                    bufferedInputStream = new BufferedInputStream(inputStream);
                    document = XSQLParserHelper.parse(bufferedInputStream, null, printWriter);
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    xSQLPageRequest.signalError(25003, new String[]{this.configFileNameToUse}, null);
                    throw new XSQLInitializationException();
                }
                catch (SAXParseException sAXParseException) {
                    xSQLPageRequest.signalError(25020, new String[]{this.configFileNameToUse}, new Object[]{sAXParseException});
                    throw new XSQLInitializationException();
                }
                catch (SAXException sAXException) {
                    xSQLPageRequest.signalError(25020, new String[]{this.configFileNameToUse}, null);
                    throw new XSQLInitializationException();
                }
                object12 = null;
                if (bufferedInputStream == null) break block162;
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (bufferedInputStream == null) throw throwable;
                try {
                    bufferedInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException object112) {}
            bufferedInputStream.close();
        }
        loadedConfig = true;
        object14 = new Hashtable(5);
        if (document == null) return;
        object13 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/reload-connections-on-error");
        this.reloadConfigFileOnError = new Boolean(((String)object13).equalsIgnoreCase("yes"));
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/result-cache-size"));
            object12 = this.xsqlResultFragmentCacheSize;
            synchronized (object12) {
                this.xsqlResultFragmentCacheSize = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/page-cache-size"));
            object12 = this.xsqlPageCacheSize;
            synchronized (object12) {
                this.xsqlPageCacheSize = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-cache-size"));
            object12 = this.stylesheetPageCacheSize;
            synchronized (object12) {
                this.stylesheetPageCacheSize = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-pool/initial"));
            object12 = this.stylesheetPoolInitial;
            synchronized (object12) {
                this.stylesheetPoolInitial = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-pool/increment"));
            object12 = this.stylesheetPoolIncrement;
            synchronized (object12) {
                this.stylesheetPoolIncrement = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/stylesheet-pool/timeout-seconds"));
            object12 = this.stylesheetPoolTimeout;
            synchronized (object12) {
                this.stylesheetPoolTimeout = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/initial"));
            object12 = this.connectionPoolInitial;
            synchronized (object12) {
                this.connectionPoolInitial = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        object12 = null;
        try {
            object12 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-manager/factory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object12 != null && !((String)object12).equals("")) {
            try {
                object112 = XSQLUtil.classForName((String)object12);
                object10 = (XSQLConnectionManagerFactory)((Class)object112).newInstance();
                if (this.defaultConnManagerFactory != null) {
                    object9 = this.defaultConnManagerFactory;
                    synchronized (object9) {
                        this.defaultConnManagerFactory = object10;
                    }
                } else {
                    this.defaultConnManagerFactory = object10;
                }
            }
            catch (InstantiationException instantiationException) {
                this.customFactoryLoadError((String)object12);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.customFactoryLoadError((String)object12);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.customFactoryLoadError((String)object12);
            }
            catch (ClassCastException classCastException) {
                this.customFactoryLoadError((String)object12);
            }
        }
        if (this.defaultConnManagerFactory == null) {
            try {
                object112 = XSQLUtil.classForName(defaultConnManagerFactoryName);
                object10 = (XSQLConnectionManagerFactory)((Class)object112).newInstance();
                if (this.defaultConnManagerFactory != null) {
                    object9 = this.defaultConnManagerFactory;
                    synchronized (object9) {
                        this.defaultConnManagerFactory = object10;
                    }
                } else {
                    this.defaultConnManagerFactory = object10;
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (this.defaultConnManagerFactory == null) {
            System.err.println("Fatal error. Cannot create connection manager factory: oracle.xml.xsql.XSQLConnectionManagerFactoryImpl");
            throw new RuntimeException("Fatal error. Cannot create connection manager factory: oracle.xml.xsql.XSQLConnectionManagerFactoryImpl");
        }
        object112 = null;
        try {
            object112 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/error-handler/class");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object112 != null && !((String)object112).equals("")) {
            try {
                object10 = XSQLUtil.classForName((String)object112);
                object9 = (XSQLErrorHandler)((Class)object10).newInstance();
                if (this.currentErrorHandler != null) {
                    object8 = this.currentErrorHandler;
                    synchronized (object8) {
                        this.currentErrorHandler = object9;
                    }
                } else {
                    this.currentErrorHandler = object9;
                }
            }
            catch (InstantiationException instantiationException) {
                this.customErrorHandlerError((String)object112);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.customErrorHandlerError((String)object112);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.customErrorHandlerError((String)object112);
            }
            catch (ClassCastException classCastException) {
                this.customErrorHandlerError((String)object112);
            }
        }
        if (this.currentErrorHandler == null) {
            try {
                object10 = XSQLUtil.classForName(defaultErrorHandlerClassName);
                object9 = (XSQLErrorHandler)((Class)object10).newInstance();
                if (this.currentErrorHandler != null) {
                    object8 = this.currentErrorHandler;
                    synchronized (object8) {
                        this.currentErrorHandler = object9;
                    }
                } else {
                    this.currentErrorHandler = object9;
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (this.currentErrorHandler == null) {
            System.err.println("Fatal error. Cannot create error writer: oracle.xml.xsql.XSQLErrorHandlerImpl");
            throw new RuntimeException("Fatal error. Cannot create error writer: oracle.xml.xsql.XSQLErrorHandlerImpl");
        }
        object10 = null;
        try {
            object10 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/logger/factory");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object10 != null && !((String)object10).equals("")) {
            try {
                object9 = XSQLUtil.classForName((String)object10);
                object8 = (XSQLLoggerFactory)((Class)object9).newInstance();
                if (this.xsqlLoggerFactory != null) {
                    object7 = this.xsqlLoggerFactory;
                    synchronized (object7) {
                        this.xsqlLoggerFactory = object8;
                    }
                } else {
                    this.xsqlLoggerFactory = object8;
                }
            }
            catch (InstantiationException instantiationException) {
                this.customLoggerError((String)object10);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.customLoggerError((String)object10);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.customLoggerError((String)object10);
            }
            catch (ClassCastException classCastException) {
                this.customLoggerError((String)object10);
            }
        }
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/increment"));
            object9 = this.stylesheetPoolIncrement;
            synchronized (object9) {
                this.connectionPoolIncrement = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/increment"));
            object9 = this.stylesheetPoolIncrement;
            synchronized (object9) {
                this.connectionPoolIncrement = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/timeout-seconds"));
            object9 = this.connectionPoolTimeout;
            synchronized (object9) {
                this.connectionPoolTimeout = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        object9 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/connection-pool/dump-allowed");
        this.dumpPoolAllowed = ((String)object9).equalsIgnoreCase("yes");
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/processor/default-fetch-size"));
            object8 = this.defaultRowPrefetch;
            synchronized (object8) {
                this.defaultRowPrefetch = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            n = new Integer(XSQLUtil.valueOf(document, "/XSQLConfig/servlet/output-buffer-size"));
            object8 = this.outputBufferSize;
            synchronized (object8) {
                this.outputBufferSize = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        object8 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/timing-info/action");
        object7 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/timing-info/page");
        this.actionTiming = object8 != null && (((String)object8).equalsIgnoreCase("y") || ((String)object8).equalsIgnoreCase("yes"));
        this.pageTiming = object7 != null && (((String)object7).equalsIgnoreCase("y") || ((String)object7).equalsIgnoreCase("yes"));
        XMLNode xMLNode = (XMLNode)document;
        String string3 = XSQLUtil.valueOf(xMLNode, "/XSQLConfig/http/proxyhost");
        if (string3 != null && !xMLNode.equals((Object)"")) {
            object6 = XSQLUtil.valueOf(xMLNode, "/XSQLConfig/http/proxyport");
            if (((String)object6).equals("")) {
                object6 = "80";
            }
            properties = System.getProperties();
            object5 = properties;
            synchronized (object5) {
                properties.put("proxySet", TRUE);
                properties.put("proxyHost", string3);
                properties.put("proxyPort", object6);
            }
        }
        object6 = XSQLUtil.select(document, "/XSQLConfig/servlet/suppress-mime-charset/media-type");
        properties = new Hashtable(5);
        if (object6 != null && object6.getLength() > 0) {
            int n2 = object6.getLength();
            for (int i = 0; i < n2; ++i) {
                object4 = (Element)object6.item(i);
                object4.normalize();
                string2 = object4.getFirstChild().getNodeValue();
                ((Hashtable)properties).put(string2, string2);
            }
            hashtable2 = this.noCharsetMimeTypes;
            synchronized (hashtable2) {
                this.noCharsetMimeTypes = properties;
            }
        }
        this.defaultAllowXSLOverride = !((String)(object5 = XSQLUtil.valueOf(document, "/XSQLConfig/processor/security/stylesheet/defaults/allow-client-style"))).equalsIgnoreCase("no");
        object6 = XSQLUtil.select(document, "/XSQLConfig/processor/security/stylesheet/trusted-hosts/host");
        hashtable2 = new Hashtable<String, String>(5);
        object4 = null;
        string2 = null;
        try {
            object4 = InetAddress.getLocalHost();
            string2 = ((InetAddress)object4).getHostAddress();
            hashtable2.put(string2, "x");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (object6 != null && object6.getLength() > 0) {
            int n3 = object6.getLength();
            for (int i = 0; i < n3; ++i) {
                Element element = (Element)object6.item(i);
                element.normalize();
                object3 = element.getFirstChild().getNodeValue();
                if (object3 == null) continue;
                if (((String)object3).trim().equals("*")) {
                    this.allowAnyHost = true;
                    continue;
                }
                try {
                    object4 = InetAddress.getByName((String)object3);
                    string2 = ((InetAddress)object4).getHostAddress();
                    hashtable2.put(string2, "x");
                    continue;
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            hashtable = this.xslTrustedHosts;
            synchronized (hashtable) {
                this.xslTrustedHosts = hashtable2;
            }
        }
        NodeList nodeList2 = XSQLUtil.select(document, "/XSQLConfig/actiondefs/action");
        hashtable = new Hashtable<String, String>(10);
        if (nodeList2 != null && nodeList2.getLength() > 0) {
            int n4 = nodeList2.getLength();
            for (int i = 0; i < n4; ++i) {
                Element element = (Element)nodeList2.item(i);
                object2 = XSQLUtil.valueOf(element, "elementname");
                object = XSQLUtil.valueOf(element, "handlerclass");
                hashtable.put((String)object2, (String)object);
            }
            object3 = this.userDefinedHandlers;
            synchronized (object3) {
                this.userDefinedHandlers = hashtable;
            }
        }
        if ((node = XSQLUtil.selectFirst(document, "/XSQLConfig/processor/character-set-conversion")) != null) {
            object3 = XSQLUtil.valueOf(node, "default-charset");
            if (object3 != null && !((String)object3).equals("")) {
                this.baseCharSet = object3;
            } else {
                XMLElement xMLElement = (XMLElement)node;
                if (XSQLUtil.selectFirst(xMLElement, "none") != null) {
                    this.baseCharSet = null;
                }
            }
        }
        if ((node = XSQLUtil.selectFirst(document, "/XSQLConfig/processor/owa")) != null && (object3 = XSQLUtil.valueOf(node, "fetch-style")) != null && ((String)object3).equalsIgnoreCase(OWA_FETCHSTYLE_TABLE)) {
            String string4 = this.defaultOWAFetchStyle;
            synchronized (string4) {
                this.defaultOWAFetchStyle = OWA_FETCHSTYLE_TABLE;
            }
        }
        if ((node = XSQLUtil.selectFirst(document, "/XSQLConfig/processor/xml-parsing")) != null && (object3 = XSQLUtil.valueOf(node, "preserve-whitespace")) != null) {
            Boolean bl = this.preserveWhitespace;
            synchronized (bl) {
                this.preserveWhitespace = ((String)object3).equalsIgnoreCase(FALSE) ? Boolean.FALSE : Boolean.TRUE;
            }
        }
        nodeList2 = XSQLUtil.select(document, "/XSQLConfig/serializerdefs/serializer");
        hashtable = new Hashtable<String, String>(5);
        if (nodeList2 != null && nodeList2.getLength() > 0) {
            void var29_88;
            int n5 = nodeList2.getLength();
            boolean bl = false;
            while (var29_88 < n5) {
                object2 = (Element)nodeList2.item((int)var29_88);
                object = XSQLUtil.valueOf((Element)object2, "name");
                string = XSQLUtil.valueOf((Element)object2, "class");
                hashtable.put((String)object, string);
                ++var29_88;
            }
            Hashtable hashtable3 = this.userDefinedSerializers;
            synchronized (hashtable3) {
                this.userDefinedSerializers = hashtable;
            }
        }
        if ((nodeList = XSQLUtil.select(document, "/XSQLConfig/connectiondefs/connection")) != null && nodeList.getLength() > 0) {
            int n6 = nodeList.getLength();
            for (int i = 0; i < n6; ++i) {
                object = (Element)nodeList.item(i);
                string = XSQLUtil.valueOf((Element)object, "@name");
                String string5 = XSQLUtil.valueOf((Element)object, "driver");
                String string6 = XSQLUtil.valueOf((Element)object, "dburl");
                String string7 = XSQLUtil.valueOf((Element)object, "username");
                String string8 = XSQLUtil.valueOf((Element)object, "password");
                String string9 = XSQLUtil.valueOf((Element)object, "autocommit");
                Boolean bl = null;
                if (string9 != null) {
                    if (string9.equalsIgnoreCase(TRUE)) {
                        bl = Boolean.TRUE;
                    } else if (string9.equalsIgnoreCase(FALSE)) {
                        bl = Boolean.FALSE;
                    }
                }
                XSQLNamedConnection xSQLNamedConnection = new XSQLNamedConnection(string5, string6, string7, string8, bl);
                ((Hashtable)object14).put(string, xSQLNamedConnection);
            }
        }
        Hashtable hashtable4 = this.namedConnections;
        synchronized (hashtable4) {
            this.namedConnections = object14;
            return;
        }
    }

    private void customFactoryLoadError(String string) {
        System.err.println("Failed to create custom connection manager factory: " + string + ". Using default.");
    }

    private void customErrorHandlerError(String string) {
        System.err.println("Failed to create custom error writer: " + string + ". Using default.");
    }

    private void customLoggerError(String string) {
        System.err.println("Failed to create custom logger: " + string + ".");
    }

    private InputStream readConfigFileFromClassPath(String string) {
        if (string.startsWith("/")) {
            string = "/" + string;
        }
        Thread thread = Thread.currentThread();
        InputStream inputStream = null;
        try {
            Method method = thread.getClass().getMethod("getContextClassLoader", null);
            ClassLoader classLoader = (ClassLoader)method.invoke((Object)thread, null);
            inputStream = classLoader.getResourceAsStream(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = this.getClass().getResourceAsStream(string);
        }
        return inputStream;
    }
}

