/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLHttpUtil;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLPageRequestImpl;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLServlet;
import oracle.xml.xsql.XSQLUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class XSQLServletPageRequest
extends XSQLPageRequestImpl {
    static final String INCLUDED_REQUEST_URI = "javax.servlet.include.request_uri";
    static final String INCLUDED_SERVLET_PATH = "javax.servlet.include.servlet_path";
    static final String GNUJSP_REQUEST = "javax.servlet.include.path";
    static final String POSTED_HTML_FORM = "application/x-www-form-urlencoded";
    static final String POSTED_XML_DOCUMENT = "text/xml";
    static final String ROOT = "/";
    static final String FILEURLPREF = "file:///";
    static final String XSQLCONFIGPARAMNAME = "xsql.config";
    private ServletConfig config = null;
    private Dictionary cookies = null;
    private HttpServletRequest req = null;
    private HttpServletResponse resp = null;
    private XSQLPageRequest topReq = null;
    private Dictionary extraParams = null;

    private XSQLServletPageRequest(String string, URL uRL, Dictionary dictionary, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletConfig servletConfig, Dictionary dictionary2, Document document, XSQLPageRequest xSQLPageRequest, PrintWriter printWriter, OutputStream outputStream) {
        this.baseuri = string;
        this.setTopRequest(xSQLPageRequest);
        this.req = httpServletRequest;
        this.config = servletConfig;
        this.resp = httpServletResponse;
        this.extraParams = dictionary;
        this.cookies = dictionary2;
        this.pageurl = XSQLUtil.safeURLAsString(uRL);
        this.setPostedDocument(document);
        this.err = new PrintWriter(new StringWriter());
        if (printWriter != null) {
            this.out = printWriter;
        } else if (outputStream != null) {
            this.outStream = outputStream;
        }
    }

    public XSQLServletPageRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServletConfig servletConfig) {
        this.req = httpServletRequest;
        this.resp = httpServletResponse;
        this.config = servletConfig;
        this.collectCookies();
        this.setupPageURL();
    }

    public String getParameter(String string) {
        Object object;
        boolean bl = false;
        String string2 = super.getParameter(string);
        if (string2 == null) {
            String string3 = string2 = this.cookies != null ? (String)this.cookies.get(string) : null;
            if (string2 != null) {
                bl = false;
            }
        }
        if (string2 == null) {
            Object object2;
            object = this.req.getSession(false);
            if (object != null && (object2 = object.getValue(string)) != null) {
                if (object2 instanceof String[]) {
                    String[] stringArray = (String[])object2;
                    if (stringArray.length > 0) {
                        string2 = stringArray[0];
                    }
                } else if (object2 instanceof Object[]) {
                    Object[] objectArray = (Object[])object2;
                    if (objectArray.length > 0) {
                        string2 = objectArray[0].toString();
                    }
                } else {
                    string2 = object2.toString();
                }
            }
            if (string2 != null) {
                bl = false;
            }
        }
        if (string2 == null) {
            if (this.extraParams != null) {
                string2 = XSQLUtil.stringParamValue(this.extraParams.get(string));
            }
            if (!(string2 != null || string.equals("xml-stylesheet") && this.isIncluded)) {
                string2 = this.req.getParameter(string);
            }
            if (string2 != null) {
                bl = true;
            }
        }
        object = this.getPageEncoding();
        if (string2 != null) {
            if (object != null && bl) {
                return XSQLUtil.XL(string2, (String)object);
            }
            return string2;
        }
        return null;
    }

    public String[] getParameterValues(String string) {
        Object object;
        boolean bl = false;
        String[] stringArray = super.getParameterValues(string);
        if (stringArray == null) {
            Object object2 = object = this.cookies != null ? (String)this.cookies.get(string) : null;
            if (object != null) {
                bl = false;
                stringArray = new String[]{object};
            }
        }
        if (stringArray == null) {
            Object object3;
            object = this.req.getSession(false);
            if (object != null && (object3 = object.getValue(string)) != null) {
                if (object3 instanceof String[]) {
                    String[] stringArray2 = (String[])object3;
                    if (stringArray2.length > 0) {
                        stringArray = stringArray2;
                    }
                } else if (object3 instanceof Object[]) {
                    Object[] objectArray = (Object[])object3;
                    int n = objectArray.length;
                    if (n > 0) {
                        stringArray = new String[n];
                        for (int i = 0; i < n; ++i) {
                            stringArray[i] = objectArray[i].toString();
                        }
                    }
                } else {
                    stringArray = new String[]{object3.toString()};
                }
            }
            if (stringArray != null) {
                bl = false;
            }
        }
        if (stringArray == null) {
            if (this.extraParams != null) {
                stringArray = XSQLUtil.stringParamValues(this.extraParams.get(string));
            }
            if (!(stringArray != null || string.equals("xml-stylesheet") && this.isIncluded)) {
                stringArray = this.req.getParameterValues(string);
            }
            if (stringArray != null) {
                bl = true;
            }
        }
        object = this.getPageEncoding();
        if (stringArray != null) {
            if (object != null && bl) {
                return XSQLUtil.XLArr(stringArray, (String)object);
            }
            return stringArray;
        }
        return null;
    }

    private void setupPageURL() {
        String string = null;
        if (XSQLServlet.inJServ()) {
            this.pageurl = this.req.getPathTranslated();
            this.baseuri = XSQLUtil.baseUriOf(this.req.getRequestURI());
        } else {
            string = (String)this.req.getAttribute(INCLUDED_SERVLET_PATH);
            if (string != null) {
                this.pageurl = this.req.getRealPath(string);
                this.baseuri = XSQLUtil.baseUriOf(string);
            } else {
                this.baseuri = this.req.getServletPath();
                String string2 = this.pageurl = this.baseuri != null ? this.req.getRealPath(this.baseuri) : null;
                if (this.pageurl != null) {
                    this.baseuri = XSQLUtil.baseUriOf(this.baseuri);
                }
                if (this.pageurl == null) {
                    try {
                        URL uRL = this.config.getServletContext().getResource(this.baseuri);
                        if (uRL != null) {
                            this.pageurl = uRL.toExternalForm();
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                    if (this.pageurl != null) {
                        this.baseuri = XSQLUtil.baseUriOf(this.baseuri);
                    }
                }
                if (this.pageurl == null) {
                    this.pageurl = this.req.getPathTranslated();
                    this.baseuri = XSQLUtil.baseUriOf(this.req.getRequestURI());
                }
            }
        }
        this.pageurl = this.pageurl != null ? this.pageurl.replace('\\', '/') : null;
    }

    protected void setupWriter() {
        if (this.out == null) {
            try {
                XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
                int n = xSQLConfigManager.getOutputBufferSize();
                this.out = n == 0 ? this.resp.getWriter() : new PrintWriter(new BufferedWriter(this.resp.getWriter(), n));
            }
            catch (IOException iOException) {
                super.setupWriter();
            }
        }
    }

    protected void setupOutputStream() {
        try {
            if (this.outStream == null) {
                this.outStream = this.resp.getOutputStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void setupErrorWriter() {
        try {
            if (this.err == null) {
                this.err = this.resp.getWriter();
            }
        }
        catch (IOException iOException) {
            super.setupErrorWriter();
        }
    }

    public String getUserAgent() {
        return this.req.getHeader("User-Agent");
    }

    public void setContentType(String string) {
        this.resp.setContentType(string);
    }

    public boolean useHTMLErrors() {
        return true;
    }

    public String translateURL(String string) {
        if (string.startsWith("http:/") || string.startsWith("file:/")) {
            return string;
        }
        String string2 = XSQLUtil.relativize(string, this.getBaseURI());
        if (XSQLServlet.inJServ()) {
            Object object;
            if (string.charAt(0) != '/') {
                String string3;
                String string4;
                String string5;
                int n;
                String string6;
                String string7;
                object = this.getTopRequest();
                String string8 = string7 = object != null ? object.getBaseURI() : this.getBaseURI();
                if (!string7.equals(ROOT) && string2.startsWith(string6 = string7.substring(0, (n = string7.substring(1).indexOf(47)) + 2)) && (string5 = XSQLServletPageRequest.firstPathPartIgnoringFileUrl(string4 = XSQLUtil.translate(this.pageurl, string))).equals(string3 = XSQLServletPageRequest.firstPathPartIgnoringFileUrl(this.pageurl))) {
                    return string4;
                }
            }
            object = XSQLUtil.translate(this.req.getRealPath(ROOT), string2.substring(1));
            return object;
        }
        String string9 = this.req.getRealPath(string2);
        if (string9 == null) {
            try {
                this.pageurl = this.config.getServletContext().getResource(string2).toExternalForm();
                return this.pageurl;
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        return string9 != null ? FILEURLPREF + string9.replace('\\', '/') : null;
    }

    private static String firstPathPartIgnoringFileUrl(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith(FILEURLPREF) && (string = string.substring(7)).length() > 2 && Character.isLetter(string.charAt(1)) && string.charAt(2) == ':') {
            string = string.substring(1);
        }
        int n = string.indexOf(47);
        int n2 = 0;
        if (string.charAt(n + 1) == '/') {
            ++n;
            ++n2;
        }
        int n3 = string.substring(n + 1).indexOf(47);
        String string2 = string.substring(n2, n + n3 + 2);
        return string2;
    }

    public String getRequestType() {
        return "Servlet";
    }

    public Document getRequestParamsAsXMLDocument() {
        XMLDocument xMLDocument = XSQLHttpUtil.HttpRequestAsXMLDocument(this.req, this.getPageEncoding());
        return xMLDocument;
    }

    public Document getPostedDocument() {
        Document document = super.getPostedDocument();
        if (document != null) {
            return document;
        }
        String string = this.req.getContentType();
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase(POSTED_XML_DOCUMENT)) {
            try {
                this.setPostedDocument(this.XMLDocumentFromServletInputStream());
            }
            catch (SAXException sAXException) {
                return null;
            }
        } else if (string.equalsIgnoreCase(POSTED_HTML_FORM)) {
            this.setPostedDocument((Document)XSQLHttpUtil.HttpRequestAsXMLDocument(this.req, this.getPageEncoding()));
        }
        return super.getPostedDocument();
    }

    /*
     * Loose catch block
     */
    private Document XMLDocumentFromServletInputStream() throws SAXException {
        Document document;
        block13: {
            ServletInputStream servletInputStream = null;
            document = null;
            servletInputStream = this.req.getInputStream();
            PrintWriter printWriter = new PrintWriter(new StringWriter());
            document = XSQLParserHelper.parse((InputStream)servletInputStream, null, printWriter);
            Object var6_6 = null;
            try {
                if (servletInputStream != null) {
                    servletInputStream.close();
                }
                break block13;
            }
            catch (IOException iOException) {}
            break block13;
            {
                catch (IOException iOException) {
                    Document document2 = null;
                    Object var6_7 = null;
                    try {
                        if (servletInputStream != null) {
                            servletInputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return document2;
                }
                catch (SAXException sAXException) {
                    try {
                        throw sAXException;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        try {
                            if (servletInputStream != null) {
                                servletInputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
        return document;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.req;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.resp;
    }

    public ServletContext getServletContext() {
        return this.config.getServletContext();
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void setPageEncoding(String string) {
        this.requestedPageEncoding = string;
    }

    public void setCookie(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (string != null && string2 != null) {
            Cookie cookie = new Cookie(string, string2);
            if (string3 != null && !string3.equals("")) {
                try {
                    int n = Integer.parseInt(string3);
                    cookie.setMaxAge(n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (string4 != null && !string4.equals("")) {
                cookie.setDomain(string4);
            }
            if (string5 != null && !string5.equals("")) {
                cookie.setPath(string5);
            }
            this.resp.addCookie(cookie);
            if (bl) {
                if (this.cookies == null) {
                    this.cookies = new Hashtable(5);
                }
                this.cookies.put(string, string2);
            }
        }
    }

    public String getCookie(String string) {
        return this.cookies != null ? (String)this.cookies.get(string) : null;
    }

    private void collectCookies() {
        int n;
        Cookie[] cookieArray = this.req.getCookies();
        int n2 = n = cookieArray != null ? cookieArray.length : 0;
        if (n > 0) {
            this.cookies = new Hashtable(n);
            for (int i = 0; i < n; ++i) {
                Cookie cookie = cookieArray[i];
                String string = cookie.getName();
                String string2 = cookie.getValue();
                this.cookies.put(string, string2);
            }
        }
    }

    public XSQLPageRequest createNestedRequest(String string, URL uRL, Dictionary dictionary, PrintWriter printWriter, OutputStream outputStream) {
        Object object;
        Dictionary dictionary2 = null;
        if (this.extraParams != null) {
            if (dictionary == null) {
                dictionary2 = this.extraParams;
            } else {
                object = this.extraParams.keys();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    if (dictionary.get(string2) != null) continue;
                    dictionary.put(string2, this.extraParams.get(string2));
                }
                dictionary2 = dictionary;
            }
        } else {
            dictionary2 = dictionary;
        }
        object = this.getTopRequest();
        return new XSQLServletPageRequest(string, uRL, dictionary2, this.req, this.resp, this.config, this.cookies, this.postedDocument, (XSQLPageRequest)(object != null ? object : this), printWriter, outputStream);
    }

    String getCustomConfigFileName() {
        return this.config.getInitParameter(XSQLCONFIGPARAMNAME);
    }
}

