/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql.actions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleCallableStatement;
import oracle.xml.sql.query.OracleXMLQuery;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLActionHandlerImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XSQLRefCursorFunctionHandler
extends XSQLActionHandlerImpl {
    private static final String STYLE_PI = "xml-stylesheet";
    private static final String DATE_FORMAT = "date-format";
    private static final String MAX_ROWS = "max-rows";
    private static final String SKIP_ROWS = "skip-rows";
    private static final String ROWSET_ELT = "rowset-element";
    private static final String DOC_ELT = "doc-element";
    private static final String ROW_ELT = "row-element";
    private static final String ID_ATTR = "id-attribute";
    private static final String ID_ATTR_COL = "id-attribute-column";
    private static final String FETCH_SIZE = "fetch-size";
    private static final String NULL_IND = "null-indicator";
    private static final String TAG_CASE = "tag-case";
    private static final String SCHEMA = "include-schema";
    private static final String NO_ROWS_QRY = "no-rows-query";
    private static final String EMPTY = "";
    private static final String YES = "yes";
    private static final String Y = "y";
    private static final String NO = "no";
    private static final String N = "n";
    private static final String UPPER = "upper";
    private static final String LOWER = "lower";
    private static final String SEMI = ";";
    private static final String REFBEGIN = "begin ? := ";
    private static final String REFEND = " end;";

    public void handleAction(Node node) throws SQLException {
        int n;
        int n2 = -1;
        int n3 = 0;
        boolean bl = false;
        Element element = this.getActionElement();
        String string = this.getAttributeAllowingParam(MAX_ROWS, element);
        String string2 = this.getAttributeAllowingParam(DATE_FORMAT, element);
        String string3 = this.getAttributeAllowingParam(SKIP_ROWS, element);
        String string4 = this.getAttributeAllowingParam(ROWSET_ELT, element);
        String string5 = this.getAttributeAllowingParam(ROW_ELT, element);
        String string6 = this.getAttributeAllowingParam(ID_ATTR, element);
        String string7 = this.getAttributeAllowingParam(ID_ATTR_COL, element);
        String string8 = this.getAttributeAllowingParam(NULL_IND, element);
        String string9 = this.getAttributeAllowingParam(TAG_CASE, element);
        String string10 = this.getAttributeAllowingParam(SCHEMA, element);
        if (!this.requiredConnectionProvided(node)) {
            return;
        }
        String string11 = this.getActionElementContent();
        if (string11 == null || string11.equals(EMPTY)) {
            this.reportError(node, Res.getString(25117));
            return;
        }
        char c = (string11 = string11.trim()).charAt((n = string11.length()) - 1);
        if (c != ';') {
            string11 = string11 + SEMI;
        }
        Statement statement = null;
        OracleXMLQuery oracleXMLQuery = null;
        ResultSet resultSet = null;
        try {
            Connection connection = this.getPageRequest().getJDBCConnection();
            statement = connection.prepareCall(REFBEGIN + string11 + REFEND);
            statement.registerOutParameter(1, -10);
            this.handleBindVariables((PreparedStatement)statement, 1);
            statement.execute();
            resultSet = ((OracleCallableStatement)statement).getCursor(1);
            oracleXMLQuery = new OracleXMLQuery(connection, resultSet);
            if (string != null) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    n2 = -1;
                }
            }
            if (string3 != null) {
                try {
                    n3 = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    n3 = 0;
                }
            }
            if (n2 >= 0) {
                oracleXMLQuery.setMaxRows(n2);
            }
            if (n3 > 0) {
                oracleXMLQuery.setSkipRows(n3);
            }
            if (string4 != null) {
                oracleXMLQuery.setRowsetTag(string4);
            }
            if (string5 != null) {
                oracleXMLQuery.setRowTag(string5);
            }
            if (string8 != null && !string8.equals(EMPTY)) {
                if (string8.equalsIgnoreCase(Y) || string8.equalsIgnoreCase(YES)) {
                    oracleXMLQuery.useNullAttributeIndicator(true);
                } else if (string8.equalsIgnoreCase(N) || string8.equalsIgnoreCase(NO)) {
                    oracleXMLQuery.useNullAttributeIndicator(false);
                }
            }
            if (string9 != null && !string9.equals(EMPTY)) {
                if (string9.equalsIgnoreCase(UPPER)) {
                    oracleXMLQuery.useUpperCaseTagNames();
                } else if (string9.equalsIgnoreCase(LOWER)) {
                    oracleXMLQuery.useLowerCaseTagNames();
                }
            }
            if (string7 != null) {
                oracleXMLQuery.setRowIdColumn(string7);
            }
            if (string6 != null) {
                oracleXMLQuery.setRowIdAttrName(string6);
            }
            if (string2 != null && !string2.equals(EMPTY)) {
                oracleXMLQuery.setDateFormat(string2);
            }
            boolean bl2 = bl = string10 != null && (string10.equalsIgnoreCase(YES) || string10.equalsIgnoreCase(Y));
            if (bl) {
                oracleXMLQuery.getXMLDOM(node, 2);
            } else {
                oracleXMLQuery.getXMLDOM(node);
            }
            oracleXMLQuery.close();
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
            if (oracleXMLQuery != null) {
                try {
                    oracleXMLQuery.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException3) {
                    // empty catch block
                }
            }
            this.reportErrorIncludingStatement(node, string11, sQLException.getErrorCode(), sQLException.getMessage());
        }
    }
}

