/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FolderList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.ShadowChangeAdapter;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

final class DataObjectPool
implements ChangeListener {
    private static final ThreadLocal<Collection<Item>> FIND = new ThreadLocal();
    private static final Validator VALIDATOR = new Validator();
    private static final Collection<Item> TOKEN = Collections.unmodifiableList(new ArrayList());
    private DoubleHashMap map = new DoubleHashMap();
    private Map<FileObject, List<Item>> children = new HashMap<FileObject, List<Item>>();
    private final Set<FileSystem> knownFileSystems = new WeakSet();
    private static final Logger err = Logger.getLogger("org.openide.loaders.DataObject.find");
    private static DataObjectPool POOL;
    private static final Object lockPOOL;
    private volatile long inWaitNotified = -1L;
    private Thread atomic;
    private RequestProcessor privileged;
    private FileObject blocked;
    private Set<Item> toNotify = new HashSet<Item>();
    private final Map<FileObject, Integer> registrationCounts = new WeakHashMap<FileObject, Integer>();
    private static final DataLoaderPool lp;
    private static final Logger LISTENER;

    static final void fastCache(boolean bl) {
        DataObjectPool.POOL.children = bl ? null : new HashMap<FileObject, List<Item>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DataObjectPool getPOOL() {
        Object object = lockPOOL;
        synchronized (object) {
            if (POOL != null) {
                return POOL;
            }
            POOL = new DataObjectPool();
        }
        lp.addChangeListener(POOL);
        return POOL;
    }

    private static Collection<Item> enterAllowConstructor() {
        Collection<Item> collection = FIND.get();
        FIND.set(TOKEN);
        return collection;
    }

    private static void exitAllowConstructor(Collection<Item> collection) {
        Collection<Item> collection2 = FIND.get();
        FIND.set(collection);
        if (collection2 != TOKEN) {
            DataObjectPool.getPOOL().notifyCreationAll(collection2);
        }
    }

    static final boolean isConstructorAllowed() {
        return FIND.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataObject handleFindDataObject(DataLoader dataLoader, FileObject fileObject, DataLoader.RecognizedFiles recognizedFiles) throws IOException {
        DataObject dataObject;
        Collection<Item> collection = DataObjectPool.enterAllowConstructor();
        try {
            DataObjectPool.getPOOL().enterRecognition(fileObject);
            dataObject = dataLoader.handleFindDataObject(fileObject, recognizedFiles);
        }
        finally {
            DataObjectPool.exitAllowConstructor(collection);
        }
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataObject handleFindDataObject(DataObject.Factory factory, FileObject fileObject, Set<? super FileObject> set) throws IOException {
        DataObject dataObject;
        Collection<Item> collection = DataObjectPool.enterAllowConstructor();
        try {
            DataObjectPool.getPOOL().enterRecognition(fileObject);
            dataObject = factory.findDataObject(fileObject, set);
        }
        finally {
            DataObjectPool.exitAllowConstructor(collection);
        }
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiDataObject createMultiObject(MultiFileLoader multiFileLoader, FileObject fileObject) throws IOException {
        MultiDataObject multiDataObject;
        Collection<Item> collection = DataObjectPool.enterAllowConstructor();
        try {
            multiDataObject = multiFileLoader.createMultiObject(fileObject);
        }
        finally {
            DataObjectPool.exitAllowConstructor(collection);
        }
        return multiDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiDataObject createMultiObject(DataLoaderPool.FolderLoader folderLoader, FileObject fileObject, DataFolder dataFolder) throws IOException {
        MultiDataObject multiDataObject;
        Collection<Item> collection = DataObjectPool.enterAllowConstructor();
        try {
            multiDataObject = folderLoader.createMultiObject(fileObject, dataFolder);
        }
        finally {
            DataObjectPool.exitAllowConstructor(collection);
        }
        return multiDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomicActionSimple(FileObject fileObject, FileSystem.AtomicAction atomicAction) throws IOException {
        Collection<Item> collection = DataObjectPool.enterAllowConstructor();
        try {
            fileObject.getFileSystem().runAtomicAction(atomicAction);
        }
        finally {
            DataObjectPool.exitAllowConstructor(collection);
        }
    }

    public void runAtomicAction(final FileObject fileObject, final FileSystem.AtomicAction atomicAction) throws IOException {
        class WrapAtomicAction
        implements FileSystem.AtomicAction {
            WrapAtomicAction() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject fileObject2;
                Thread thread;
                Object object = DataObjectPool.this;
                synchronized (object) {
                    DataObjectPool.this.enterRecognition(null);
                    thread = DataObjectPool.this.atomic;
                    fileObject2 = DataObjectPool.this.blocked;
                    DataObjectPool.this.atomic = Thread.currentThread();
                    DataObjectPool.this.blocked = fileObject;
                }
                object = DataObjectPool.enterAllowConstructor();
                try {
                    atomicAction.run();
                }
                finally {
                    DataObjectPool dataObjectPool = DataObjectPool.this;
                    synchronized (dataObjectPool) {
                        DataObjectPool.this.atomic = thread;
                        DataObjectPool.this.blocked = fileObject2;
                        DataObjectPool.this.notifyAll();
                    }
                    DataObjectPool.exitAllowConstructor((Collection)object);
                }
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                return atomicAction.equals(object) || object.equals(atomicAction);
            }

            public int hashCode() {
                return atomicAction.hashCode();
            }
        }
        fileObject.getFileSystem().runAtomicAction((FileSystem.AtomicAction)new WrapAtomicAction());
    }

    public synchronized void enterPrivilegedProcessor(RequestProcessor requestProcessor) {
        if (this.atomic == Thread.currentThread()) {
            if (this.privileged != null) {
                throw new IllegalStateException("Previous privileged is not null: " + this.privileged + " now: " + requestProcessor);
            }
            this.privileged = requestProcessor;
        }
        this.notifyAll();
    }

    public synchronized void exitPrivilegedProcessor(RequestProcessor requestProcessor) {
        if (this.atomic == Thread.currentThread()) {
            if (this.privileged != requestProcessor) {
                throw new IllegalStateException("Trying to unregister wrong privileged. Prev: " + this.privileged + " now: " + requestProcessor);
            }
            this.privileged = null;
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void enterRecognition(FileObject fileObject) {
        while (!(this.atomic == null || this.atomic == Thread.currentThread() || this.privileged != null && this.privileged.isRequestProcessorThread() || fileObject != null && this.blocked != null && !this.blocked.equals(fileObject.getParent()))) {
            if (err.isLoggable(Level.FINE)) {
                err.fine("Enter recognition block: " + Thread.currentThread());
                err.fine("            waiting for: " + fileObject);
                err.fine("        blocking thread: " + this.atomic);
                err.fine("             blocked on: " + this.blocked);
            }
            try {
                if (FolderList.isFolderRecognizerThread()) {
                    this.inWaitNotified = System.currentTimeMillis();
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
            continue;
            finally {
                if (!FolderList.isFolderRecognizerThread()) continue;
                this.inWaitNotified = -1L;
            }
        }
    }

    private DataObjectPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataObject find(FileObject fileObject) {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            Collection<Item> collection;
            Item item = (Item)this.map.get(fileObject);
            if (item == null || !fileObject.isValid()) {
                return null;
            }
            if (this.toNotify.contains(item) && ((collection = FIND.get()) == null || !collection.contains(item))) {
                return null;
            }
            return item.getDataObjectOrNull();
        }
    }

    void countRegistration(FileObject fileObject) {
        Integer n = this.registrationCounts.get(fileObject);
        Integer n2 = n == null ? Integer.valueOf(0) : Integer.valueOf(n + 1);
        this.registrationCounts.put(fileObject, n2);
    }

    int registrationCount(FileObject fileObject) {
        Integer n = this.registrationCounts.get(fileObject);
        if (n == null) {
            return 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAllFolders() {
        HashSet hashSet;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            hashSet = new HashSet(this.map.keySet());
        }
        for (FileObject fileObject : hashSet) {
            DataObject dataObject;
            if (!fileObject.isFolder() || !((dataObject = this.find(fileObject)) instanceof DataFolder)) continue;
            DataFolder dataFolder = (DataFolder)dataObject;
            FileObject fileObject2 = dataFolder.getPrimaryFile();
            DataObjectPool dataObjectPool2 = this;
            synchronized (dataObjectPool2) {
                if (this.toNotify.isEmpty() || !this.toNotify.contains(this.map.get(fileObject2))) {
                    FolderList.changedDataSystem(fileObject2);
                }
            }
        }
    }

    public Set<DataObject> revalidate(Set<FileObject> set) {
        return VALIDATOR.revalidate(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataObject> revalidate() {
        HashSet<Item> hashSet;
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            hashSet = new HashSet<Item>(this.map.values());
        }
        return this.revalidate(DataObjectPool.createSetOfAllFiles(hashSet));
    }

    public void notifyCreation(DataObject dataObject) {
        this.notifyCreation(dataObject.item());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCreation(Item item) {
        Object object = this;
        synchronized (object) {
            if (err.isLoggable(Level.FINE)) {
                err.fine("Notify created: " + item + " by " + Thread.currentThread());
            }
            if (this.toNotify.isEmpty()) {
                if (err.isLoggable(Level.FINE)) {
                    err.fine("  but toNotify is empty");
                }
                return;
            }
            if (!this.toNotify.remove(item)) {
                if (err.isLoggable(Level.FINE)) {
                    err.fine("  the item is not there: " + this.toNotify);
                }
                return;
            }
            this.notifyAll();
        }
        object = item.getDataObjectOrNull();
        if (object != null) {
            lp.fireOperationEvent(new OperationEvent((DataObject)object), 7);
        }
    }

    private void notifyCreationAll(Collection<Item> collection) {
        if (collection.isEmpty()) {
            return;
        }
        for (Item item : collection) {
            this.notifyCreation(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitNotified(DataObject dataObject) {
        while (true) {
            DataObjectPool dataObjectPool = this;
            synchronized (dataObjectPool) {
                try {
                    this.enterRecognition(dataObject.getPrimaryFile().getParent());
                    if (this.toNotify.isEmpty()) {
                        return;
                    }
                    Collection<Item> collection = FIND.get();
                    Item item = dataObject.item();
                    if (collection != null && collection.contains(item)) {
                        return;
                    }
                    if (!this.toNotify.contains(item)) {
                        return;
                    }
                    if (err.isLoggable(Level.FINE)) {
                        err.fine("waitTillNotified: " + Thread.currentThread());
                        err.fine("      waitingFor: " + dataObject.getPrimaryFile().getPath());
                    }
                    if (FolderList.isFolderRecognizerThread()) {
                        this.inWaitNotified = System.currentTimeMillis();
                    }
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    if (FolderList.isFolderRecognizerThread()) {
                        this.inWaitNotified = -1L;
                    }
                }
            }
        }
    }

    final long timeInWaitNotified() {
        long l = this.inWaitNotified;
        if (l == -1L) {
            return -1L;
        }
        l = System.currentTimeMillis() - l;
        if (l < 0L) {
            l = 0L;
        }
        return l;
    }

    private void notifyAdd(Item item) {
        this.toNotify.add(item);
        Collection<Item> collection = FIND.get();
        if (collection == TOKEN) {
            collection = new ArrayList<Item>();
            FIND.set(collection);
        }
        collection.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Item> getTargets(FileEvent fileEvent, boolean bl) {
        FileObject fileObject = fileEvent.getFile();
        FileObject[] fileObjectArray = null;
        FileObject fileObject2 = null;
        while (true) {
            block11: {
                DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
                synchronized (dataObjectPool) {
                    Item item = (Item)DataObjectPool.POOL.map.get(fileObject);
                    if (item != null) {
                        return Collections.singleton(item);
                    }
                    List<Item> list = DataObjectPool.POOL.children.get(fileObject.getParent());
                    if (list != null) {
                        return new ArrayList<Item>(list);
                    }
                    if (!bl) {
                        return Collections.emptySet();
                    }
                    LinkedList<Item> linkedList = new LinkedList<Item>();
                    if (fileObject2 == null) {
                        fileObject2 = fileObject.getParent();
                    }
                    if (fileObject2 != null) {
                        if (fileObjectArray == null) {
                            break block11;
                        }
                        for (int i = 0; i < fileObjectArray.length; ++i) {
                            DataObject dataObject;
                            item = (Item)DataObjectPool.POOL.map.get(fileObjectArray[i]);
                            if (item == null || (dataObject = item.getDataObjectOrNull()) == null) continue;
                            linkedList.add(item);
                        }
                    }
                    return linkedList;
                }
            }
            fileObjectArray = fileObject2.getChildren();
        }
    }

    public static void checkAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        if (LISTENER.isLoggable(Level.FINE)) {
            LISTENER.fine("fileAttributeChanged: " + fileAttributeEvent);
        }
        for (Item item : DataObjectPool.getTargets((FileEvent)fileAttributeEvent, false)) {
            DataObject dataObject = item.getDataObjectOrNull();
            if (LISTENER.isLoggable(Level.FINE)) {
                LISTENER.fine("  to: " + dataObject);
            }
            if (dataObject == null) continue;
            dataObject.notifyAttributeChanged(fileAttributeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item register(FileObject fileObject, DataLoader dataLoader) throws DataObjectExistsException {
        Object object;
        Object object2;
        if (FIND.get() == null) {
            throw new IllegalStateException("DataObject constructor can be called only thru DataObject.find - use that method");
        }
        try {
            object2 = fileObject.getFileSystem();
            object = this.knownFileSystems;
            synchronized (object) {
                if (!this.knownFileSystems.contains(object2)) {
                    object2.addFileChangeListener((FileChangeListener)new FSListener());
                    this.knownFileSystems.add((FileSystem)object2);
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        FileObject fileObject2 = fileObject.getParent();
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            object2 = (Item)this.map.get(fileObject);
            if (object2 == null) {
                object2 = new Item(fileObject);
                this.map.putWithParent(fileObject, fileObject2, (Item)object2);
                this.countRegistration(fileObject);
                this.notifyAdd((Item)object2);
                VALIDATOR.notifyRegistered(fileObject);
                return object2;
            }
            object = ((Item)object2).getDataObjectOrNull();
            if (object == null) {
                object2 = new Item(fileObject);
                this.map.putWithParent(fileObject, fileObject2, (Item)object2);
                this.countRegistration(fileObject);
                this.notifyAdd((Item)object2);
                return object2;
            }
            if (!VALIDATOR.reregister((DataObject)object, dataLoader)) {
                throw new DataObjectExistsException((DataObject)object);
            }
        }
        try {
            ((DataObject)object).setValid(false);
            dataObjectPool = this;
            synchronized (dataObjectPool) {
                Item item = (Item)this.map.get(fileObject);
                if (item == null) {
                    object2 = new Item(fileObject);
                    this.map.putWithParent(fileObject, fileObject2, (Item)object2);
                    this.countRegistration(fileObject);
                    this.notifyAdd((Item)object2);
                    return object2;
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            VALIDATOR.refusingObjects.add(object);
        }
        throw new DataObjectExistsException((DataObject)object);
    }

    private synchronized void deregister(Item item, FileObject fileObject, FileObject fileObject2, boolean bl) {
        DataFolder dataFolder;
        Item item2;
        Item item3 = this.map.remove(fileObject);
        if (item3 != null && item3 != item) {
            this.map.putWithParent(fileObject, fileObject2, item3);
            if (this.toNotify.remove(item)) {
                this.notifyAll();
            }
            return;
        }
        if (bl && (fileObject = fileObject.getParent()) != null && (item2 = (Item)this.map.get(fileObject)) != null && (dataFolder = (DataFolder)item2.getDataObjectOrNull()) != null) {
            VALIDATOR.refreshFolderOf(dataFolder);
        }
    }

    private synchronized Item changePrimaryFile(Item item, FileObject fileObject, FileObject fileObject2) {
        if (item.primaryFile == fileObject) {
            return item;
        }
        Item item2 = this.map.remove(item.primaryFile);
        if (item2 == null && item.getDataObjectOrNull() == null) {
            return item;
        }
        assert (item2 == item) : "Item: " + item;
        Item item3 = new Item(item, fileObject);
        this.map.putWithParent(fileObject, fileObject2, item3);
        this.countRegistration(fileObject);
        return item3;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.revalidate();
    }

    private static Set<FileObject> createSetOfAllFiles(Collection<Item> collection) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>(collection.size() * 7);
        for (Item item : collection) {
            DataObject dataObject = item.getDataObjectOrNull();
            if (dataObject == null) continue;
            DataObjectPool.getPOOL().waitNotified(dataObject);
            hashSet.addAll(dataObject.files());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<Item> getActiveDataObjects() {
        DataObjectPool dataObjectPool = this;
        synchronized (dataObjectPool) {
            return new ArrayList(this.map.values()).iterator();
        }
    }

    static {
        lockPOOL = new Object();
        lp = DataLoaderPool.getDefault();
        LISTENER = Logger.getLogger("org.openide.loaders.DataObjectPool.Listener");
    }

    private final class DoubleHashMap
    extends HashMap<FileObject, Item> {
        public DoubleHashMap() {
            super(512);
        }

        @Override
        public Item put(FileObject fileObject, Item item) {
            return this.putWithParent(fileObject, fileObject.getParent(), item);
        }

        final Item putWithParent(FileObject fileObject, FileObject fileObject2, Item item) {
            Item item2 = super.put(fileObject, item);
            if (DataObjectPool.this.children == null) {
                return item2;
            }
            if (fileObject2 == null) {
                return item2;
            }
            ArrayList<Item> arrayList = (ArrayList<Item>)DataObjectPool.this.children.get(fileObject2);
            if (arrayList == null) {
                arrayList = new ArrayList<Item>();
            }
            arrayList.add(item);
            return item2;
        }

        @Override
        public Item remove(Object object) {
            Item item = (Item)super.remove(object);
            if (!(object instanceof FileObject)) {
                return item;
            }
            if (DataObjectPool.this.children == null) {
                return item;
            }
            FileObject fileObject = ((FileObject)object).getParent();
            if (fileObject == null) {
                return item;
            }
            List list = (List)DataObjectPool.this.children.get(fileObject);
            if (list != null) {
                list.remove(object);
                if (list.isEmpty()) {
                    DataObjectPool.this.children.remove(fileObject);
                }
            }
            return item;
        }
    }

    private static final class Validator
    implements DataLoader.RecognizedFiles {
        private static final Logger err = Logger.getLogger("org.openide.loaders.DataObject.Validator");
        private Set<FileObject> files;
        private Thread current;
        private int waiters;
        private int reenterCount;
        private Set<FileObject> recognizedFiles;
        private Set<DataObject> refusingObjects;
        private Set<FileObject> createdFiles;

        Validator() {
        }

        private synchronized Set<FileObject> enter(Set<FileObject> set) {
            boolean bl = err.isLoggable(Level.FINE);
            if (bl) {
                err.fine("enter: " + set + " on thread: " + Thread.currentThread());
            }
            if (this.current == Thread.currentThread()) {
                ++this.reenterCount;
                if (bl) {
                    err.fine("current thread, rentered: " + this.reenterCount);
                }
            } else {
                ++this.waiters;
                if (bl) {
                    err.fine("Waiting as waiter: " + this.waiters);
                }
                while (this.current != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.current = Thread.currentThread();
                --this.waiters;
                if (bl) {
                    err.fine("Wait finished, waiters: " + this.waiters + " new current: " + this.current);
                }
            }
            if (this.files == null) {
                if (bl) {
                    err.fine("New files: " + set);
                }
                this.files = set;
            } else {
                this.files.addAll(set);
                if (bl) {
                    err.fine("Added files: " + set);
                    err.fine("So they are: " + this.files);
                }
            }
            return this.files;
        }

        private synchronized void exit() {
            boolean bl = err.isLoggable(Level.FINE);
            if (this.reenterCount == 0) {
                this.current = null;
                if (this.waiters == 0) {
                    this.files = null;
                }
                this.notify();
                if (bl) {
                    err.fine("Exit and notify from " + Thread.currentThread());
                }
            } else {
                --this.reenterCount;
                if (bl) {
                    err.fine("Exit reentrant: " + this.reenterCount);
                }
            }
        }

        private synchronized boolean goOn() {
            return this.waiters == 0;
        }

        public void refreshFolderOf(DataFolder dataFolder) {
            if (this.createdFiles == null) {
                FolderList.changedDataSystem(dataFolder.getPrimaryFile());
            }
        }

        @Override
        public void markRecognized(FileObject fileObject) {
            this.recognizedFiles.add(fileObject);
        }

        public void notifyRegistered(FileObject fileObject) {
            if (this.createdFiles != null) {
                this.createdFiles.add(fileObject);
            }
        }

        public boolean reregister(DataObject dataObject, DataLoader dataLoader) {
            if (this.recognizedFiles == null) {
                return false;
            }
            if (dataObject.getLoader() == dataLoader) {
                return false;
            }
            if (this.createdFiles.contains(dataObject.getPrimaryFile())) {
                return false;
            }
            return !this.refusingObjects.contains(dataObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<DataObject> revalidate(Set<FileObject> set) {
            if (set.size() == 1 && this.current == Thread.currentThread() && this.files != null && this.files.contains(set.iterator().next())) {
                return new HashSet<DataObject>();
            }
            LinkedList<DataObject> linkedList = new LinkedList<DataObject>();
            boolean bl = err.isLoggable(Level.FINE);
            try {
                FileObject fileObject;
                set = this.enter(set);
                this.recognizedFiles = new HashSet<FileObject>();
                this.refusingObjects = new HashSet<DataObject>();
                this.createdFiles = new HashSet<FileObject>();
                DataLoaderPool dataLoaderPool = lp;
                Iterator<FileObject> iterator = set.iterator();
                while (iterator.hasNext() && this.goOn()) {
                    try {
                        fileObject = iterator.next();
                        if (bl) {
                            err.fine("Iterate: " + fileObject);
                        }
                        if (this.recognizedFiles.contains(fileObject)) continue;
                        boolean bl2 = false;
                        DataObject dataObject = DataObjectPool.getPOOL().find(fileObject);
                        if (bl) {
                            err.fine("Original: " + dataObject);
                        }
                        if (dataObject == null) continue;
                        DataObject dataObject2 = dataLoaderPool.findDataObject(fileObject, this);
                        linkedList.add(dataObject2);
                        bl2 = dataObject2 != dataObject;
                        if (!bl2) continue;
                        if (bl) {
                            err.fine("Invalidate: " + dataObject2);
                        }
                        iterator.remove();
                        try {
                            dataObject.setValid(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            this.refusingObjects.add(dataObject);
                            if (!bl) continue;
                            err.fine("  Refusing: " + dataObject);
                        }
                    }
                    catch (DataObjectExistsException dataObjectExistsException) {
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(DataObjectPool.class.getName()).log(Level.WARNING, null, iOException);
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        iterator = set.iterator();
                        if (!bl) continue;
                        err.log(Level.FINE, null, concurrentModificationException);
                        err.fine("New iterator over: " + set);
                    }
                }
                fileObject = this.refusingObjects;
                return fileObject;
            }
            finally {
                this.recognizedFiles = null;
                this.refusingObjects = null;
                this.createdFiles = null;
                this.exit();
                if (bl) {
                    err.fine("will do refreshAllFolders: " + set.size());
                }
                DataObjectPool.getPOOL().refreshAllFolders();
                if (bl) {
                    err.fine("refreshAllFolders done");
                }
            }
        }
    }

    static final class ItemReference
    extends WeakReference<DataObject>
    implements Runnable {
        private Item item;

        ItemReference(DataObject dataObject, Item item) {
            super(dataObject, Utilities.activeReferenceQueue());
            this.item = item;
        }

        @Override
        public void run() {
            this.item.deregister(false);
            this.item = null;
        }
    }

    static final class Item {
        private static final Reference<DataObject> REFERENCE_NOT_SET = new WeakReference<Object>(null);
        private Reference<DataObject> obj;
        final FileObject primaryFile;

        public Item(FileObject fileObject) {
            assert (Thread.holdsLock(DataObjectPool.getPOOL()));
            this.primaryFile = fileObject;
            this.obj = REFERENCE_NOT_SET;
        }

        private Item(Item item, FileObject fileObject) {
            assert (Thread.holdsLock(DataObjectPool.getPOOL()));
            this.primaryFile = fileObject;
            this.obj = item.obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDataObject(DataObject dataObject) {
            DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
            synchronized (dataObjectPool) {
                this.obj = new ItemReference(dataObject, this);
                if (dataObject != null && !dataObject.getPrimaryFile().isValid()) {
                    DataObjectPool.getPOOL().countRegistration(dataObject.getPrimaryFile());
                    this.deregister(false);
                }
                DataObjectPool.getPOOL().notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DataObject getDataObjectOrNull() {
            DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
            synchronized (dataObjectPool) {
                while (this.obj == REFERENCE_NOT_SET) {
                    try {
                        DataObjectPool.getPOOL().wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return this.obj.get();
            }
        }

        public DataObject getDataObject() {
            DataObject dataObject = this.getDataObjectOrNull();
            if (dataObject == null) {
                throw new IllegalStateException();
            }
            return dataObject;
        }

        public void deregister(boolean bl) {
            DataObjectPool.getPOOL().deregister(this, this.primaryFile, this.primaryFile.getParent(), bl);
        }

        public Item changePrimaryFile(FileObject fileObject) {
            return DataObjectPool.getPOOL().changePrimaryFile(this, fileObject, fileObject.getParent());
        }

        public boolean isValid() {
            if (DataObjectPool.getPOOL().map.get(this.primaryFile) == this) {
                return this.primaryFile.isValid();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            DataObjectPool dataObjectPool = DataObjectPool.getPOOL();
            synchronized (dataObjectPool) {
                DataObject dataObject = this.obj.get();
                if (dataObject == null) {
                    return "nothing[" + this.primaryFile + "]";
                }
                return dataObject.toString();
            }
        }
    }

    private final class FSListener
    extends FileChangeAdapter {
        FSListener() {
        }

        public void fileChanged(FileEvent fileEvent) {
            if (LISTENER.isLoggable(Level.FINE)) {
                LISTENER.fine("fileChanged: " + fileEvent);
            }
            for (Item item : DataObjectPool.getTargets(fileEvent, false)) {
                DataObject dataObject = item.getDataObjectOrNull();
                if (LISTENER.isLoggable(Level.FINE)) {
                    LISTENER.fine("  to: " + dataObject);
                }
                if (dataObject == null) continue;
                dataObject.notifyFileChanged(fileEvent);
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (LISTENER.isLoggable(Level.FINE)) {
                LISTENER.fine("fileRenamed: " + fileRenameEvent);
            }
            for (Item item : DataObjectPool.getTargets((FileEvent)fileRenameEvent, false)) {
                DataObject dataObject = item.getDataObjectOrNull();
                if (LISTENER.isLoggable(Level.FINE)) {
                    LISTENER.fine("  to: " + dataObject);
                }
                if (dataObject == null) continue;
                dataObject.notifyFileRenamed(fileRenameEvent);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (LISTENER.isLoggable(Level.FINE)) {
                LISTENER.fine("fileDeleted: " + fileEvent);
            }
            for (Item item : DataObjectPool.getTargets(fileEvent, true)) {
                DataObject dataObject = item.getDataObjectOrNull();
                if (LISTENER.isLoggable(Level.FINE)) {
                    LISTENER.fine("  to: " + dataObject);
                }
                if (dataObject == null) continue;
                dataObject.notifyFileDeleted(fileEvent);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            if (LISTENER.isLoggable(Level.FINE)) {
                LISTENER.fine("fileDataCreated: " + fileEvent);
            }
            for (Item item : DataObjectPool.getTargets(fileEvent, true)) {
                DataObject dataObject = item.getDataObjectOrNull();
                if (LISTENER.isLoggable(Level.FINE)) {
                    LISTENER.fine("  to: " + dataObject);
                }
                if (dataObject == null) continue;
                dataObject.notifyFileDataCreated(fileEvent);
            }
            ShadowChangeAdapter.checkBrokenDataShadows((EventObject)fileEvent);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            DataObjectPool.checkAttributeChanged(fileAttributeEvent);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            if (LISTENER.isLoggable(Level.FINE)) {
                LISTENER.fine("fileFolderCreated: " + fileEvent);
            }
            ShadowChangeAdapter.checkBrokenDataShadows((EventObject)fileEvent);
        }
    }
}

