/*
 * Decompiled with CFR 0.152.
 */
package com.sun.swup.client.notification;

import com.sun.swup.client.common.CCRUtils;
import com.sun.swup.client.common.I18NHelper;
import com.sun.swup.client.common.LocalCache;
import com.sun.swup.client.common.NAUtils;
import com.sun.swup.client.common.UpdateMgrProperties;
import com.sun.swup.client.common.UpdateMgrUtil;
import com.sun.swup.client.common.environment.Environment;
import com.sun.swup.client.notification.Timer;
import com.sun.swup.client.notification.TimerListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.jdesktop.jdic.tray.SystemTray;
import org.jdesktop.jdic.tray.TrayIcon;

public class NotIcon
implements ActionListener,
ItemListener,
TimerListener {
    static final int REG_4UPDATES_ACTION = 1;
    static final int LEARN_MORE_ACTION = 2;
    static final int REMOVE_ICON_ACTION = 3;
    static final int LAUNCH_UPDATEMGR_ACTION = 4;
    static final int MANAGE_ATSUNUPDCON_ACTION = 5;
    static final int CLOSE_MENU_ACTION = 6;
    static final int NOT_REGISTERED = 0;
    static final int NO_UPDATE = 1;
    static final int UPDATE_EXIST = 2;
    static final int SECURITY_EXIST = 3;
    static final int READ_STATE = 99;
    static final String UPDATESMGR = "/usr/bin/updatemanager";
    static final String UPDATESMGR_REG4PORTALMGMT = "/usr/bin/updatemanager regForPortalMgmt";
    static final int NOT_REG_4UPDATES_MSG = 100;
    static final int REG_SYS_4UPDATES_MSG = 101;
    static final int LEARN_MORE_MSG = 102;
    static final int HAVE_NO_UPDATES_MSG = 103;
    static final int HAVE_NEW_UPDATES_MSG = 104;
    static final int LAUNCH_UM_MSG = 105;
    static final int HAVE_SEC_UPDATES_MSG = 106;
    static final int MANAGE_AT_PORTAL_MSG = 107;
    static final int REMOVE_ICON_MSG = 108;
    static final int CLOSE_MENU_MSG = 109;
    static final int BLANK_MSG = 110;
    static int[][] menuLabelIndex = new int[][]{{100, 110, 101, 102, 108, 109, 0}, {103, 110, 105, 107, 108, 109, 0}, {104, 110, 105, 107, 108, 109, 0}, {106, 110, 105, 107, 108, 109, 0}};
    static int[][] menuAction = new int[][]{{0, 0, 1, 2, 3, 6, 0}, {0, 0, 4, 5, 3, 6, 0}, {0, 0, 4, 5, 3, 6, 0}, {0, 0, 4, 5, 3, 6, 0}};
    static boolean[][] menuSelectable = new boolean[][]{{false, false, true, true, true, true, false}, {false, false, true, true, true, true, false}, {false, false, true, true, true, true, false}, {false, false, true, true, true, true, false}};
    static int wakeEvery = 43000;
    static Integer debugLevel;
    static boolean debug;
    static I18NHelper I18N;
    int row = 0;
    int state = 1;
    int numUpdates = 0;
    int numSecurityUpdates = 0;
    Timer timer;
    boolean registered;
    boolean refreshIcon = false;
    ImageIcon noSecPulIcon;
    ImageIcon secPulIcon;
    ImageIcon unRegPulIcon;
    ImageIcon noUpdIcon;
    JPopupMenu menu;
    TrayIcon ti;
    SystemTray tray;
    static /* synthetic */ Class class$com$sun$swup$client$notification$NotIcon;

    public NotIcon(boolean notificationIcon, int sleepTime, boolean debug, Integer debugLevel) {
        NotIcon.debugLevel = debugLevel;
        NotIcon.debug = debug;
        if (sleepTime != 0) {
            wakeEvery = sleepTime;
        }
        Environment.initializeEnvironment();
        I18N = new I18NHelper(class$com$sun$swup$client$notification$NotIcon == null ? (class$com$sun$swup$client$notification$NotIcon = NotIcon.class$("com.sun.swup.client.notification.NotIcon")) : class$com$sun$swup$client$notification$NotIcon, "resources/strings/swupnotapp");
        LocalCache.initInfo((boolean)debug);
        LocalCache.testAndCreateSaveDir((boolean)debug);
        LocalCache.refreshFQNewAnalysisFile((boolean)debug);
        LocalCache.refreshFQSaveAnalysisFile((boolean)debug);
        if (debug) {
            System.out.println(" new analysis file=" + LocalCache.getFullyQualifiedNewAnalysisFile((boolean)debug));
        }
        if (debug) {
            System.out.println(" save analysis file=" + LocalCache.getFullyQualifiedSaveAnalysisFile((boolean)debug));
        }
        this.checkRegistration(debug);
        if (notificationIcon) {
            this.tray = SystemTray.getDefaultSystemTray();
            this.row = this.state = 1;
            if (debug) {
                System.out.println("NotIcon: constructor()");
            }
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.noSecPulIcon = new ImageIcon(Environment.getImageIcon((String)"30x30-available_3.gif").getImage());
            this.secPulIcon = new ImageIcon(Environment.getImageIcon((String)"30x30-security_3.gif").getImage());
            this.unRegPulIcon = new ImageIcon(Environment.getImageIcon((String)"30x30-unregistered.gif").getImage());
            this.noUpdIcon = new ImageIcon(Environment.getImageIcon((String)"30x30-noupdates.gif").getImage());
            this.menu = new JPopupMenu(null);
            this.ti = new TrayIcon((Icon)this.unRegPulIcon, null, this.menu);
            this.ti.setIconAutoSize(true);
            this.ti.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    NotIcon.this.launchUpdateMgr();
                }
            });
            if (debug) {
                System.out.println("kick off the very first poll ");
            }
            this.refreshIcon = true;
            this.queryAndProcessNewUpdates();
            this.tray.addTrayIcon(this.ti);
            this.setImageIcon();
            this.timer = new Timer(wakeEvery * 1000, this);
            this.setImageIcon();
        }
    }

    private void checkRegistration(boolean debug) {
        if (CCRUtils.isSystemRegistered()) {
            if (debug) {
                System.out.println("registration exists");
            }
            this.registered = true;
        } else {
            if (debug) {
                System.out.println("NO registration exists");
            }
            this.registered = false;
        }
    }

    private void createNewPopupMenu() {
        this.row = this.state;
        this.menu = null;
        System.gc();
        this.menu = new JPopupMenu(null);
        int j = 0;
        while (menuLabelIndex[this.row][j] != 0) {
            if (j != 0) {
                this.menu.addSeparator();
            }
            Vector msgV = this.getMsgString(menuLabelIndex[this.row][j]);
            for (int i = 0; i < msgV.size(); ++i) {
                JMenuItem menuItem = new JMenuItem((String)msgV.elementAt(i));
                menuItem.addActionListener(this);
                menuItem.setEnabled(menuSelectable[this.row][j]);
                this.menu.add(menuItem);
            }
            ++j;
        }
        this.ti.setPopupMenu(this.menu);
    }

    protected String getClassName(Object o) {
        if (debug) {
            System.out.println("getClassName()");
        }
        String classString = o.getClass().getName();
        int dotIndex = classString.lastIndexOf(".");
        return classString.substring(dotIndex + 1);
    }

    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        String t = source.getText();
        if (debug) {
            System.out.println("actionPerformed()");
            String s = "Action event detected.\n    Event source: " + source + " (an instance of " + this.getClassName(source) + ")";
            System.out.println(s);
        }
        int col = 0;
        if (debug) {
            System.out.println("state=" + this.state + ", row=" + this.row);
        }
        while (menuLabelIndex[this.row][col] != 0) {
            Vector msgV = this.getMsgString(menuLabelIndex[this.row][col]);
            if (msgV.size() == 0) {
                ++col;
                continue;
            }
            if (t.equals(msgV.elementAt(0))) break;
            ++col;
        }
        if (menuLabelIndex[this.row][col] != 0) {
            this.execUserSelection(menuAction[this.row][col]);
        }
    }

    private Vector getMsgString(int index) {
        String msg = new String(I18N.getString("sun-notification-application"));
        Vector<String> msgV = new Vector<String>();
        switch (index) {
            case 110: {
                break;
            }
            case 100: {
                msgV.addElement(I18N.getString("not-registered-for-updates"));
                break;
            }
            case 101: {
                msgV.addElement(I18N.getString("register-this-system-for-update"));
                break;
            }
            case 102: {
                msgV.addElement(I18N.getString("learn-more"));
                break;
            }
            case 103: {
                this.ti.setCaption(msg);
                msgV.addElement(I18N.getString("you-have-no-new-updates"));
                break;
            }
            case 104: {
                String msgS = this.numUpdates == 1 ? I18N.getString("you-have-1-new-updates") : I18N.getString("you-have-n-new-updates");
                MessageFormat msgFmt = new MessageFormat(msgS);
                Object[] msgArgs = new Object[]{Integer.toString(this.numUpdates)};
                msg = new String(msgFmt.format(msgArgs));
                this.ti.setCaption(msg);
                msgV.addElement(msg);
                break;
            }
            case 105: {
                msgV.addElement(I18N.getString("launch-update-manager"));
                break;
            }
            case 106: {
                String msg2;
                String msg1;
                if (this.numUpdates == 1 & this.numSecurityUpdates == 1) {
                    msg1 = "you-have-1-new-updates";
                    msg2 = "including-1-security-update";
                } else {
                    msg1 = "you-have-n-new-updates";
                    msg2 = this.numUpdates != 1 & this.numSecurityUpdates == 1 ? "including-1-security-update" : "including-m-security-updates";
                }
                MessageFormat msgFmt = new MessageFormat(I18N.getString(msg1));
                Object[] msgArgs = new Object[]{Integer.toString(this.numUpdates)};
                msg = new String(msgFmt.format(msgArgs));
                this.ti.setCaption(msg);
                msgV.addElement(msg);
                msgFmt = new MessageFormat(I18N.getString(msg2));
                Object[] msgArgs2 = new Object[]{Integer.toString(this.numSecurityUpdates)};
                msg = new String(msgFmt.format(msgArgs2));
                msgV.addElement(msg);
                break;
            }
            case 107: {
                msgV.addElement(I18N.getString("manage-at-portal"));
                break;
            }
            case 108: {
                msgV.addElement(I18N.getString("remove-icon"));
                break;
            }
            case 109: {
                msgV.addElement(I18N.getString("close-menu"));
                break;
            }
            default: {
                msgV.addElement(msg);
            }
        }
        return msgV;
    }

    private void execUserSelection(int action) {
        if (debug) {
            System.out.println("execAction: action=" + action);
        }
        switch (action) {
            case 1: {
                this.register4Updates();
                break;
            }
            case 2: {
                this.learnMore();
                break;
            }
            case 3: {
                this.removeApplication();
                break;
            }
            case 4: {
                this.launchUpdateMgr();
                break;
            }
            case 5: {
                this.manageAtSunUpdateConnection();
                break;
            }
            case 6: {
                this.bringDownMenu();
            }
        }
    }

    private void checkForUpdates() {
        String old;
        String current;
        String last;
        String line;
        int newAVCount = 0;
        int oldAVCount = 0;
        Vector<String> newAV = new Vector<String>();
        Vector<String> oldAV = new Vector<String>();
        if (debug) {
            System.out.println("checkForUpdates()");
        }
        LocalCache.initInfo((boolean)debug);
        BufferedReader oldAnalysis = null;
        BufferedReader newAnalysis = null;
        String file = LocalCache.getFullyQualifiedNewAnalysisFile((boolean)debug);
        try {
            newAnalysis = new BufferedReader(new FileReader(file));
            if (debug) {
                System.out.println("success open newAnalysis=" + file);
            }
            file = LocalCache.getFullyQualifiedSaveAnalysisFile((boolean)debug);
            oldAnalysis = new BufferedReader(new FileReader(file));
            if (debug) {
                System.out.println("success open oldAnalysis=" + file);
            }
        }
        catch (FileNotFoundException err) {
            if (debug) {
                System.out.println("file " + file + " not found");
            }
            if (file == LocalCache.getFullyQualifiedNewAnalysisFile((boolean)debug)) {
                this.numSecurityUpdates = 0;
                this.numUpdates = 0;
                return;
            }
            oldAnalysis = null;
        }
        if (debug) {
            System.out.println("start read file");
        }
        if (newAnalysis != null) {
            try {
                while ((line = newAnalysis.readLine()) != null) {
                    newAV.add(new String(line));
                }
            }
            catch (IOException err) {
                if (debug) {
                    System.out.println("IO Exception occurs while readline.");
                }
                err.printStackTrace();
            }
        }
        if (oldAnalysis != null) {
            try {
                while ((line = oldAnalysis.readLine()) != null) {
                    oldAV.add(new String(line));
                }
            }
            catch (IOException err) {
                if (debug) {
                    System.out.println("IO Exception occurs while readline.");
                }
                err.printStackTrace();
            }
        }
        if (debug) {
            System.out.println("end read files, new has " + newAV.size() + ", old has " + oldAV.size());
        }
        if ((newAVCount = newAV.size()) > 0) {
            last = (String)newAV.elementAt(0);
            int i = 1;
            while (i < newAVCount) {
                current = (String)newAV.elementAt(i);
                if (current.regionMatches(0, last, 0, 9) & !current.regionMatches(9, ".real=", 0, 6)) {
                    newAV.removeElementAt(i);
                    --newAVCount;
                    continue;
                }
                ++i;
                last = current;
                current = null;
            }
        }
        if (debug) {
            System.out.println("newAV count=" + newAVCount + ", newAV.size()=" + newAV.size());
        }
        if ((oldAVCount = oldAV.size()) > 0) {
            last = (String)oldAV.elementAt(0);
            int i = 1;
            while (i < oldAVCount) {
                current = (String)oldAV.elementAt(i);
                if (current.regionMatches(0, last, 0, 9)) {
                    oldAV.removeElementAt(i);
                    --oldAVCount;
                    continue;
                }
                ++i;
                last = current;
                current = null;
            }
        }
        if (debugLevel == 1) {
            int i;
            System.out.println("oldAV count=" + oldAVCount + ", oldAV.size()=" + oldAV.size());
            for (i = 0; i < newAVCount; ++i) {
                System.out.println("line=" + i + ", " + (String)newAV.elementAt(i));
            }
            for (i = 0; i < oldAVCount; ++i) {
                System.out.println("line=" + i + ", " + (String)oldAV.elementAt(i));
            }
        }
        int i = 0;
        while (i < newAVCount) {
            String newl = (String)newAV.elementAt(i);
            boolean delete = false;
            for (int j = 0; j < oldAVCount; ++j) {
                old = (String)oldAV.elementAt(j);
                if (!newl.regionMatches(0, old, 0, 9)) continue;
                newAV.removeElementAt(i);
                --newAVCount;
                j = oldAVCount;
                delete = true;
            }
            if (delete) continue;
            ++i;
        }
        if (debugLevel == 1) {
            for (i = 0; i < newAVCount; ++i) {
                System.out.println("line=" + i + ", " + (String)newAV.elementAt(i));
            }
        }
        this.numUpdates = 0;
        this.numSecurityUpdates = 0;
        for (i = 0; i < newAVCount; ++i) {
            String newl = (String)newAV.elementAt(i);
            if (newl.regionMatches(9, ".id=", 0, 4)) {
                ++this.numUpdates;
            }
            if (!(newl.regionMatches(9, ".real=", 0, 6) & newl.indexOf("Security") != -1)) continue;
            ++this.numSecurityUpdates;
        }
        if (debug) {
            System.out.println(" numSecurityUpdates=" + this.numSecurityUpdates);
        }
        if (debug) {
            System.out.println(" numUpdates=" + this.numUpdates);
        }
        old = null;
        Object newl = null;
        newAV.removeAllElements();
        oldAV.removeAllElements();
        oldAV = null;
        newAV = null;
        try {
            if (newAnalysis != null) {
                newAnalysis.close();
            }
            if (oldAnalysis != null) {
                oldAnalysis.close();
            }
        }
        catch (IOException err) {
            if (debug) {
                System.out.println("IO Exception occurs while read/write.");
            }
            err.printStackTrace();
        }
        oldAnalysis = null;
        newAnalysis = null;
    }

    public void itemStateChanged(ItemEvent e) {
        if (debug) {
            System.out.println("itemStateChanged()");
        }
        JMenuItem source = (JMenuItem)e.getSource();
        String s = "Item event detected.\n    Event source: " + source.getText() + " (an instance of " + this.getClassName(source) + ")" + "\n" + "    New state: " + (e.getStateChange() == 1 ? "selected" : "unselected");
        if (debugLevel == 1) {
            System.out.println(s);
        }
    }

    private int confirmDialog(String title, String question, Object[] options, Object def) {
        try {
            int rc = JOptionPane.showOptionDialog(null, question, title, 0, 3, Environment.getImageIcon((String)"help_large.gif"), options, def);
            return rc;
        }
        catch (Exception err) {
            if (debug) {
                System.out.println("Exception occurs bringing up confirm dialog");
            }
            err.printStackTrace();
            return 0;
        }
    }

    private void register4Updates() {
        if (debug) {
            System.out.println("Register this System for Updates");
        }
        if (!NAUtils.execCmd((String)new String(UPDATESMGR), (boolean)debug)) {
            System.out.println("failed to execute 'Update Manager REG'");
        }
        this.setState(1);
        this.refreshIcon = true;
        this.buildMenuAndIcon();
    }

    private void learnMore() {
        if (debug) {
            System.out.println("Learn More...");
        }
        try {
            String url = UpdateMgrProperties.getInstance().getProperty("learnURL");
            if (url != null) {
                this.browseURL(url);
            } else {
                MessageFormat msgFmt = new MessageFormat(I18N.getString("url-properties-error-null"));
                Object[] msgArgs = new Object[]{"/usr/lib/patch/com/sun/swup/client/UpdateMgr.properties", "learnURL"};
                JOptionPane.showMessageDialog(null, msgFmt.format(msgArgs), I18N.getString("url-properties-error-title"), 2);
            }
        }
        catch (IOException io) {
            MessageFormat msgFmt = new MessageFormat(I18N.getString("url-properties-error-file"));
            Object[] msgArgs = new Object[]{"/usr/lib/patch/com/sun/swup/client/UpdateMgr.properties"};
            JOptionPane.showMessageDialog(null, msgFmt.format(msgArgs), I18N.getString("url-properties-error-title"), 2);
        }
    }

    private void browseURL(String url) {
        UpdateMgrUtil umUtil = UpdateMgrUtil.getInstance();
        umUtil.launchWebClient(null, url);
    }

    private void removeApplication() {
        if (debug) {
            System.out.println("Remove this application");
        }
        Object[] options = new Object[]{I18N.getString("cancel-option"), I18N.getString("remove-option")};
        int choice = this.confirmDialog(I18N.getString("remove-not-menu-title"), I18N.getString("remove-question"), options, options[0]);
        if (choice == 1) {
            NAUtils.disableNotApp((boolean)debug);
            System.exit(0);
        }
    }

    private void bringDownMenu() {
        if (debug) {
            System.out.println("Bring down this menu");
        }
    }

    private void launchUpdateMgr() {
        if (debug) {
            System.out.println("launch UpdateMgr");
        }
        if (!NAUtils.execCmd((String)new String(UPDATESMGR), (boolean)debug) && debug) {
            System.out.println("failed to execute 'Update Manager NOREG'");
        }
        this.setState(1);
        this.refreshIcon = true;
        this.buildMenuAndIcon();
        LocalCache.initInfo((boolean)debug);
        LocalCache.saveAnalysisResult((boolean)debug);
        this.numSecurityUpdates = 0;
        this.numUpdates = 0;
    }

    private void manageAtSunUpdateConnection() {
        block7: {
            if (debug) {
                System.out.println("Manage at Portal...");
            }
            if (CCRUtils.isPortalManagementEnabled()) {
                try {
                    String url = UpdateMgrProperties.getInstance().getProperty("manageURL");
                    if (url != null) {
                        this.browseURL(url);
                        break block7;
                    }
                    MessageFormat msgFmt = new MessageFormat(I18N.getString("url-properties-error-null"));
                    Object[] msgArgs = new Object[]{"/usr/lib/patch/com/sun/swup/client/UpdateMgr.properties", "manageURL"};
                    JOptionPane.showMessageDialog(null, msgFmt.format(msgArgs), I18N.getString("url-properties-error-title"), 2);
                }
                catch (IOException io) {
                    MessageFormat msgFmt = new MessageFormat(I18N.getString("url-properties-error-null"));
                    Object[] msgArgs = new Object[]{"/usr/lib/patch/com/sun/swup/client/UpdateMgr.properties"};
                    JOptionPane.showMessageDialog(null, msgFmt.format(msgArgs), I18N.getString("url-properties-error-title"), 2);
                }
            } else if (!NAUtils.execCmd((String)new String(UPDATESMGR_REG4PORTALMGMT), (boolean)debug) && debug) {
                System.out.println("failed to execute 'Update Manager Register for Portal Management'");
            }
        }
        this.setState(1);
        this.refreshIcon = true;
        this.buildMenuAndIcon();
        LocalCache.initInfo((boolean)debug);
        LocalCache.saveAnalysisResult((boolean)debug);
        this.numSecurityUpdates = 0;
        this.numUpdates = 0;
    }

    public void timeElapsed() {
        this.queryAndProcessNewUpdates();
    }

    private void queryAndProcessNewUpdates() {
        int prevState = this.state;
        int prevNumUpd = this.numUpdates;
        int prevNumSecUpd = this.numSecurityUpdates;
        if (debug) {
            System.out.println("qapnu(), BEFORE state=" + this.state + ", numUpdates=" + this.numUpdates + ", numSecurityUpdates=" + this.numSecurityUpdates);
        }
        String preAssetId = new String(NAUtils.getAssetId((boolean)debug));
        if (debug) {
            System.out.println("previous assetid =" + preAssetId + "|");
        }
        LocalCache.initInfo((boolean)debug);
        LocalCache.refreshFQNewAnalysisFile((boolean)debug);
        LocalCache.refreshFQSaveAnalysisFile((boolean)debug);
        if (debug) {
            System.out.println(" new analysis file=" + LocalCache.getFullyQualifiedNewAnalysisFile((boolean)debug));
        }
        if (debug) {
            System.out.println(" save analysis file=" + LocalCache.getFullyQualifiedSaveAnalysisFile((boolean)debug));
        }
        this.checkForUpdates();
        this.setState(99);
        if (debug) {
            System.out.println("qapnu(), AFTER , state=" + this.state + ", prevState=" + prevState + ", numSecurityUpdates=" + this.numSecurityUpdates + ", prevNumSecUpd=" + prevNumSecUpd + ", numUpdates=" + this.numUpdates + ", prevNumUpd=" + prevNumUpd + ", refreshIcon=" + this.refreshIcon);
        }
        if (prevNumSecUpd != this.numSecurityUpdates | prevNumUpd != this.numUpdates | prevState != this.state | this.refreshIcon) {
            this.buildMenuAndIcon();
            this.refreshIcon = false;
        }
        String newAssetId = new String(NAUtils.getAssetId((boolean)debug));
        if (debug) {
            System.out.println("new assetid =" + newAssetId + "|");
        }
        if (!newAssetId.equals(preAssetId)) {
            if (preAssetId.equals("") && !newAssetId.equals("")) {
                NAUtils.copyPidFromHost2AssetidDir((boolean)debug);
            } else if (newAssetId.equals("") && !preAssetId.equals("")) {
                NAUtils.copyPidFromAssetid2HostDir((String)preAssetId, (boolean)debug);
            }
        }
    }

    private void buildMenuAndIcon() {
        if (debug) {
            System.out.println("buildMenuAndIcon()");
        }
        this.createNewPopupMenu();
        this.setImageIcon();
    }

    private void setState(int nState) {
        if (debug) {
            System.out.println("---->setState(" + nState + ")");
        }
        switch (nState) {
            case 0: {
                this.state = 0;
                break;
            }
            case 1: {
                this.state = 1;
                break;
            }
            case 2: {
                this.state = 2;
                break;
            }
            case 3: {
                this.state = 3;
                break;
            }
            default: {
                this.checkRegistration(debug);
                if (!this.registered) {
                    this.state = 0;
                    this.ti.setCaption(I18N.getString("sun-notification-application"));
                    break;
                }
                this.state = this.numUpdates == 0 ? 1 : (this.numSecurityUpdates == 0 ? 2 : 3);
            }
        }
        this.row = this.state;
    }

    private void setImageIcon() {
        if (debugLevel == 1) {
            System.out.println("setImageIcon()");
        }
        switch (this.state) {
            case 0: {
                this.ti.setIcon((Icon)this.unRegPulIcon);
                break;
            }
            case 1: {
                this.ti.setIcon((Icon)this.noUpdIcon);
                break;
            }
            case 2: {
                this.ti.setIcon((Icon)this.noSecPulIcon);
                break;
            }
            case 3: {
                this.ti.setIcon((Icon)this.secPulIcon);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        debug = false;
    }
}

