/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.internal.ClassLogger;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

abstract class HtmlPage {
    private static final String[] allowed = new String[]{"<BR>", "<UL>", "</UL>", "<LI>", "</LI>", "<OL>", "</OL>", "<HR>", "<P>", "</P>"};
    protected StringBuffer htmlPage = new StringBuffer();
    protected MBeanServer mbs = null;
    protected boolean readPerm = false;
    protected boolean writePerm = false;
    private String bgColor = null;
    final ClassLogger logger;

    public HtmlPage(MBeanServer mBeanServer, boolean bl, boolean bl2) {
        this.mbs = mBeanServer;
        this.readPerm = bl;
        this.writePerm = bl2;
        this.logger = new ClassLogger("com.sun.jdmk.html.adaptor", this.getClass());
    }

    public String getPage() {
        return this.htmlPage.toString();
    }

    public void setBgColor(String string) {
        this.bgColor = string != null && !string.equals("") ? (string.startsWith("#") ? "BGCOLOR=\"" + string + "\"" : (string.endsWith("gif") ? "BACKGROUND=\"" + string + "\"" : string)) : null;
    }

    public abstract void buildPage(String var1);

    protected void add2Page(String string) {
        this.htmlPage.append(string + "\r\n");
    }

    private String replace(String string, String string2, String string3) {
        while (string.indexOf(string2) != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = string.indexOf(string2);
            int n2 = n + string2.length();
            if (n > 0) {
                stringBuffer.append(string.substring(0, n));
            }
            stringBuffer.append(string3);
            if (n2 < string.length()) {
                stringBuffer.append(string.substring(n2, string.length()));
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    protected void buildError(String string, String string2) {
        if (string == null) {
            string = "";
        }
        string = this.translateNameToHtmlFormat(string);
        for (int i = 0; i < allowed.length; ++i) {
            String string3 = allowed[i];
            string = this.replace(string, this.translateNameToHtmlFormat(string3), string3);
            string = this.replace(string, this.translateNameToHtmlFormat(string3.toLowerCase()), string3);
        }
        this.htmlPage = new StringBuffer();
        this.htmlPage.append(this.buildHead(string2));
        this.htmlPage.append(this.startBody(null));
        this.htmlPage.append("<HR><P>\r\n<FONT SIZE=+3 COLOR=red><B>" + string2 + "</B></FONT><P><HR><P>" + string + "\r\n");
        this.htmlPage.append("<P><TABLE WIDTH=100%><TR>");
        this.htmlPage.append("<TD ALIGN=RIGHT><A HREF=\"/\">Back to Agent View</A></TD>");
        this.htmlPage.append("</TR></TABLE>");
        this.htmlPage.append(this.stopBody());
    }

    protected String buildHead(String string) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\r\n");
        stringBuffer.append("<HTML>\r\n");
        stringBuffer.append("<HEAD>\r\n");
        stringBuffer.append("<TITLE>" + string + "</TITLE>" + "\r\n");
        stringBuffer.append("</HEAD>\r\n");
        return stringBuffer.toString();
    }

    protected String buildHeadMeta(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("<HTML>\r\n");
        stringBuffer.append("<HEAD>\r\n");
        stringBuffer.append("<TITLE>" + string + "</TITLE>" + "\r\n");
        stringBuffer.append(string2);
        stringBuffer.append("</HEAD>\r\n");
        return stringBuffer.toString();
    }

    protected String startBody(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<BODY");
        if (this.bgColor != null) {
            stringBuffer.append(" " + this.bgColor + " ");
        }
        if (string != null) {
            stringBuffer.append(" " + string + " ");
        }
        stringBuffer.append(">\r\n");
        return stringBuffer.toString();
    }

    protected String stopBody() {
        return "</BODY>\r\n</HTML>\r\n";
    }

    protected String encodeUrl(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[byArray.length * 3];
        int n2 = 0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            if (by == 32) {
                bl = false;
                byArray2[n2++] = 43;
                continue;
            }
            if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by >= 48 && by <= 57) {
                byArray2[n2++] = by;
                continue;
            }
            bl = false;
            byArray2[n2++] = 37;
            byte by2 = (byte)((by & 0xF0) >> 4);
            byArray2[n2++] = by2 >= 10 ? (byte)(65 + by2 - 10) : (byte)(48 + by2);
            by2 = (byte)(by & 0xF);
            byArray2[n2++] = by2 >= 10 ? (byte)(65 + by2 - 10) : (byte)(48 + by2);
        }
        if (bl) {
            return string;
        }
        try {
            return new String(byArray2, 0, n2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray2, 0, n2);
        }
    }

    protected String decodeUrl(String string) {
        int n = string.length();
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[n];
        int n2 = 0;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c < '\u0000' || c > '\u007f') {
                throw new IllegalArgumentException("Not encoded");
            }
            int n3 = 0x7F & c;
            if (c == '+') {
                bl = false;
                n3 = 32;
            } else if (c == '%' && i + 2 < n) {
                bl = false;
                n3 = (byte)(0xFF & Integer.parseInt(string.substring(i + 1, i + 3), 16));
                i += 2;
            }
            byArray[n2++] = n3;
        }
        if (bl) {
            return string;
        }
        try {
            return new String(byArray, 0, n2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, 0, n2);
        }
    }

    protected String toUrlName(String string) {
        return "//" + this.encodeUrl(string);
    }

    protected String fromUrlName(String string) {
        int n = string.indexOf("/");
        if (n < 0) {
            return string;
        }
        int n2 = string.indexOf("/", n + 1);
        if (n2 < 0) {
            return string;
        }
        string = string.substring(n2 + 1);
        return this.decodeUrl(string);
    }

    protected boolean isArrayType(String string) {
        if (string == null) {
            return false;
        }
        return string.endsWith("[]");
    }

    protected String usualType(String string) {
        int n;
        String string2 = "";
        if (string == null) {
            return null;
        }
        if (string.startsWith("[Z")) {
            string = "boolean[]";
        }
        if (string.startsWith("[C")) {
            string = "char[]";
        }
        if (string.startsWith("[D")) {
            string = "double[]";
        }
        if (string.startsWith("[F")) {
            string = "float[]";
        }
        if (string.startsWith("[I")) {
            string = "int[]";
        }
        if (string.startsWith("[S")) {
            string = "short[]";
        }
        if (string.startsWith("[J")) {
            string = "long[]";
        }
        if (string.startsWith("[B")) {
            string = "byte[]";
        }
        if (string.startsWith("[L")) {
            string2 = "[]";
            string = string.substring(2, string.length() - 1);
        }
        if ((n = string.lastIndexOf(46)) == -1) {
            return string + string2;
        }
        return string + string2;
    }

    protected String translateNameToHtmlFormat(String string) {
        return HtmlPage.encodeHtmlTags(string);
    }

    public static String encodeHtmlTags(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        block9: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                case '\'': {
                    stringBuffer.append("&#39;");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block9;
                }
                case '\\': {
                    stringBuffer.append("&#92;");
                    continue block9;
                }
                case '\u0085': {
                    stringBuffer.append("&#133;");
                    continue block9;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected String boolToHtml(String string, String string2, String string3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("<INPUT TYPE=RADIO NAME=\"");
        stringBuffer.append(string + "+" + string2 + "\" ");
        if (string3 != null && string3.equals("true") && bl) {
            stringBuffer.append("CHECKED ");
        }
        stringBuffer.append("VALUE=\"true\">True ");
        stringBuffer.append("<INPUT TYPE=RADIO NAME=\"");
        stringBuffer.append(string + "+" + string2 + "\" ");
        if (string3 != null && string3.equals("false") && bl) {
            stringBuffer.append("CHECKED ");
        }
        stringBuffer.append("VALUE=\"false\">False ");
        return stringBuffer.toString();
    }

    protected ObjectName getObjectNameByObjNameStr(String string) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName(string);
        Set<ObjectName> set = this.mbs.queryNames(objectName, null);
        if (set.size() <= 0) {
            this.buildError("Unable to get MBean [" + string + "]", "459 Instance Not Found");
            return null;
        }
        return (ObjectName)set.toArray()[0];
    }

    protected boolean checkType(String string) {
        if (string == null) {
            return false;
        }
        String string2 = new String("String String[] Integer Integer[] int int[] Double Double[] double double[] Float Float[] float float[] Short Short[] short Character Character[] char char[] Boolean Boolean[] boolean boolean[] javax.management.ObjectName javax.management.ObjectName[] Date Date[] Byte byte Long long Byte[] Long[] Number");
        int n = 0;
        boolean bl = false;
        while (!bl) {
            String string3;
            n = string2.indexOf(32);
            if (n < 0) {
                string3 = string2;
                bl = true;
            } else {
                string3 = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            }
            if (!string.equals(string3) && !string.endsWith(string3)) continue;
            return true;
        }
        return false;
    }

    protected void quicksort(String[] stringArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            String string = stringArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && this.lt(stringArray[n3], string)) {
                    ++n3;
                }
                while (n4 > n && this.lt(string, stringArray[n4])) {
                    --n4;
                }
                if (n3 > n4) continue;
                this.inverseS(stringArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.quicksort(stringArray, n, n4);
            }
            if (n3 < n2) {
                this.quicksort(stringArray, n3, n2);
            }
        }
    }

    protected boolean lt(String string, String string2) {
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return true;
        }
        return string.compareTo(string2) < 0;
    }

    protected void inverseS(String[] stringArray, int n, int n2) {
        String string = stringArray[n];
        stringArray[n] = stringArray[n2];
        stringArray[n2] = string;
    }
}

