/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.BASE64Decoder;
import com.sun.jdmk.comm.ClientHandler;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.jdmk.comm.HtmlAdminPage;
import com.sun.jdmk.comm.HtmlArrayPage;
import com.sun.jdmk.comm.HtmlInvokePage;
import com.sun.jdmk.comm.HtmlMasterPage;
import com.sun.jdmk.comm.HtmlObjectPage;
import com.sun.jdmk.comm.HtmlPage;
import com.sun.jdmk.comm.HttpBody;
import com.sun.jdmk.comm.HttpRequest;
import com.sun.jdmk.comm.HttpResponse;
import com.sun.jdmk.comm.MalformedHttpException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Date;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class HtmlRequestHandler
extends ClientHandler {
    private Socket sockClient = null;
    private static final String InterruptSysCallMsg = "Interrupted system call";

    public HtmlRequestHandler(Socket socket, HtmlAdaptorServer htmlAdaptorServer, MBeanServer mBeanServer, ObjectName objectName, int n) {
        super(htmlAdaptorServer, n, mBeanServer, objectName);
        this.sockClient = socket;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doRun() {
        block37: {
            if (this.logger.finerOn()) {
                this.logger.finer("doRun", "Start Html request handler");
            }
            HttpRequest httpRequest = new HttpRequest(new HttpBody());
            boolean bl = true;
            while (bl) {
                HttpResponse httpResponse = null;
                try {
                    httpRequest.readFrom(this.sockClient.getInputStream());
                    httpResponse = this.processRequest(httpRequest);
                }
                catch (MalformedHttpException malformedHttpException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "Malformed HTTP request rejected. [Exception=" + malformedHttpException + "]");
                    }
                    httpResponse = this.makeErrorResponse(400);
                }
                httpResponse.writeTo(this.sockClient.getOutputStream());
                bl = httpRequest.hasKeepAliveFlag() && httpResponse.statusCode == 200 && !this.interruptCalled;
            }
            Object var6_9 = null;
            try {
                this.sockClient.close();
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket is now closed");
                }
                break block37;
            }
            catch (IOException iOException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("doRun", "Socket closed with [Exception=" + iOException + "]");
                }
                break block37;
            }
            {
                catch (InterruptedIOException interruptedIOException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "Request handler interrupted");
                    }
                    Object var6_10 = null;
                    try {
                        this.sockClient.close();
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Socket is now closed");
                        }
                        break block37;
                    }
                    catch (IOException iOException) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Socket closed with [Exception=" + iOException + "]");
                        }
                        break block37;
                    }
                }
                catch (EOFException eOFException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "Connection closed by peer");
                    }
                    Object var6_11 = null;
                    try {
                        this.sockClient.close();
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Socket is now closed");
                        }
                        break block37;
                    }
                    catch (IOException iOException) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Socket closed with [Exception=" + iOException + "]");
                        }
                        break block37;
                    }
                }
                catch (SocketException socketException) {
                    if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Request handler interrupted");
                        }
                    } else if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "I/O exception. [Exception=" + socketException + "]");
                    }
                    Object var6_12 = null;
                    try {
                        this.sockClient.close();
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Socket is now closed");
                        }
                        break block37;
                    }
                    catch (IOException iOException) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Socket closed with [Exception=" + iOException + "]");
                        }
                        break block37;
                    }
                }
                catch (IOException iOException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("doRun", "I/O exception. [Exception=" + iOException + "]");
                    }
                    Object var6_13 = null;
                    try {
                        this.sockClient.close();
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Socket is now closed");
                        }
                        break block37;
                    }
                    catch (IOException iOException2) {
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Socket closed with [Exception=" + iOException2 + "]");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block38: {
                    Object var6_14 = null;
                    try {
                        this.sockClient.close();
                        if (this.logger.finestOn()) {
                            this.logger.finest("doRun", "Socket is now closed");
                        }
                    }
                    catch (IOException iOException) {
                        if (!this.logger.finestOn()) break block38;
                        this.logger.finest("doRun", "Socket closed with [Exception=" + iOException + "]");
                    }
                }
                throw throwable;
            }
        }
    }

    protected HttpResponse processRequest(HttpRequest httpRequest) throws IOException {
        if (this.logger.finerOn()) {
            this.logger.finer("processRequest", "Process the Html request");
        }
        HttpResponse httpResponse = null;
        if (!this.authenticateRequest(httpRequest)) {
            if (this.logger.finerOn()) {
                this.logger.finer("processRequest", "Authentication failed");
            }
            httpResponse = this.makeErrorResponse(401);
        } else if (httpRequest.method == 1) {
            httpResponse = this.processGetRequest(httpRequest);
        } else {
            if (this.logger.finerOn()) {
                this.logger.finer("processRequest", "Bad request: request not supported");
            }
            httpResponse = this.makeErrorResponse(400);
        }
        httpResponse.setHeader(3, httpRequest.getHeader(3));
        return httpResponse;
    }

    protected boolean authenticateRequest(HttpRequest httpRequest) throws IOException {
        HtmlAdaptorServer htmlAdaptorServer;
        if (this.logger.finerOn()) {
            this.logger.finer("authenticateRequest", "Authenticate the HTML request, using the 'Basic Authentication Scheme'");
        }
        if (!(htmlAdaptorServer = (HtmlAdaptorServer)this.adaptorServer).isAuthenticationOn()) {
            return true;
        }
        String string = httpRequest.getHeader(5);
        if (string == null || !string.startsWith("Basic ")) {
            return false;
        }
        String string2 = string.substring(6);
        byte[] byArray = new BASE64Decoder().decodeBuffer(string2);
        String string3 = new String(byArray);
        return htmlAdaptorServer.checkChallengeResponse(string3);
    }

    protected HttpResponse processGetRequest(HttpRequest httpRequest) throws IOException {
        String string;
        int n;
        block45: {
            String string2;
            Object object;
            Object object2;
            HtmlAdaptorServer htmlAdaptorServer;
            String string3;
            block44: {
                string3 = httpRequest.getURIPath();
                n = 200;
                string = null;
                htmlAdaptorServer = (HtmlAdaptorServer)this.adaptorServer;
                Object var6_6 = null;
                if (this.logger.finerOn()) {
                    this.logger.finer("processGetRequest", "Process a GET request = " + string3);
                }
                if (htmlAdaptorServer.getParser() == null) break block44;
                object2 = new String[]{string3};
                object = new String[]{"java.lang.String"};
                try {
                    string = (String)this.mbs.invoke(htmlAdaptorServer.getParser(), "parseRequest", (Object[])object2, (String[])object);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "Invalid user's parser = " + instanceNotFoundException);
                    }
                    String string4 = "Instance Not Found<P>Invalid user's parser: " + HtmlPage.encodeHtmlTags(htmlAdaptorServer.getParser().toString()) + " is unknown";
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(459, string4);
                }
                catch (MBeanException mBeanException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "Parser exception = " + mBeanException.getTargetException());
                    }
                    String string5 = "MBean Failure<P>" + HtmlPage.encodeHtmlTags(htmlAdaptorServer.getParser().toString()) + " throws <BR>" + HtmlPage.encodeHtmlTags(String.valueOf(mBeanException.getTargetException()));
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(472, string5);
                }
                catch (ReflectionException reflectionException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "MBeanServer reflection exception = " + reflectionException.getTargetException());
                    }
                    String string6 = "Reflection<P>MBeanServer throws:<BR>" + HtmlPage.encodeHtmlTags(String.valueOf(reflectionException.getTargetException())) + "<BR> when reflecting: " + HtmlPage.encodeHtmlTags(htmlAdaptorServer.getParser().toString());
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(470, string6);
                }
                if (string != null) break block45;
            }
            if (string3.startsWith("/Request/")) {
                object2 = string3.substring(9);
                if (((String)object2).equals("getDomain")) {
                    string = this.mbs.getDefaultDomain() + ":";
                } else {
                    n = 400;
                }
            } else if (string3.startsWith("/ViewObjectRes")) {
                object2 = string3.substring("/ViewObjectRes".length());
                object = new HtmlObjectPage(this.mbs, true, true, htmlAdaptorServer);
                ((HtmlObjectPage)object).buildPage((String)object2);
                string = ((HtmlPage)object).getPage();
            } else if (string3.startsWith("/AutoRefresh")) {
                object2 = string3.substring("/AutoRefresh".length());
                object = new HtmlObjectPage(this.mbs, true, true, htmlAdaptorServer);
                ((HtmlObjectPage)object).buildMeta((String)object2);
                ((HtmlObjectPage)object).buildPage(((String)object2).substring(0, ((String)object2).indexOf("?period=")));
                string = ((HtmlPage)object).getPage();
            } else if (string3.startsWith("/ViewProperty")) {
                object2 = string3.substring("/ViewProperty".length());
                object = new HtmlArrayPage(this.mbs, true, true, htmlAdaptorServer);
                ((HtmlArrayPage)object).buildPage((String)object2);
                string = ((HtmlPage)object).getPage();
            } else if (string3.startsWith("/SetForm")) {
                string2 = string3.substring("/SetForm".length());
                int n2 = string2.indexOf(47, 1);
                int n3 = string2.indexOf(63);
                if (n2 < 0 || n3 < 0) {
                    n = 400;
                } else {
                    String string7 = string2.substring(n3);
                    string2 = string2.substring(0, n3);
                    HtmlObjectPage htmlObjectPage = new HtmlObjectPage(this.mbs, true, true, htmlAdaptorServer);
                    if (this.logger.finerOn()) {
                        this.logger.finer("processGetRequest", "SetForm for [objName=" + string2 + " ,request=" + string7 + "]");
                    }
                    if (!htmlObjectPage.setObjectValue(string2, string7)) {
                        string = htmlObjectPage.getPage();
                    } else {
                        htmlObjectPage.buildPage(string2);
                        string = htmlObjectPage.getPage();
                    }
                }
            } else if (string3.startsWith("/Admin")) {
                object2 = string3.substring("/Admin".length());
                object2 = ((String)object2).trim();
                object = new HtmlAdminPage(this.mbs, true, true);
                ((HtmlAdminPage)object).buildPage((String)object2);
                string = ((HtmlPage)object).getPage();
            } else if (string3.startsWith("/InvokeAction")) {
                object2 = string3.substring("/InvokeAction".length());
                object2 = ((String)object2).trim();
                object = new HtmlInvokePage(this.mbs, true, true);
                ((HtmlInvokePage)object).buildPage((String)object2);
                string = ((HtmlPage)object).getPage();
            } else if (string3.equals("/") || string3.startsWith("/Filter")) {
                object2 = new HtmlMasterPage(this.mbs, true, true);
                ((HtmlMasterPage)object2).buildPage(string3);
                string = ((HtmlPage)object2).getPage();
            } else {
                n = 400;
            }
            if (htmlAdaptorServer.getParser() != null) {
                Object[] objectArray = new String[]{string};
                String[] stringArray = new String[]{"java.lang.String"};
                try {
                    string = (String)this.mbs.invoke(htmlAdaptorServer.getParser(), "parsePage", objectArray, stringArray);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "Invalid user's parser [" + instanceNotFoundException + "]");
                    }
                    string2 = "Instance Not Found<P>Invalid user's parser: " + HtmlPage.encodeHtmlTags(htmlAdaptorServer.getParser().toString()) + " is unknown";
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(459, string2);
                }
                catch (MBeanException mBeanException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "Parser exception = " + mBeanException.getTargetException());
                    }
                    string2 = "MBean Failure<P>" + htmlAdaptorServer.getParser().toString() + " throws <BR>" + HtmlPage.encodeHtmlTags(String.valueOf(mBeanException.getTargetException()));
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(472, string2);
                }
                catch (ReflectionException reflectionException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("processGetRequest", "MBeanServer reflection exception = " + reflectionException.getTargetException());
                    }
                    string2 = "Reflection<P>MBeanServer throws:<BR>" + HtmlPage.encodeHtmlTags(String.valueOf(reflectionException.getTargetException())) + "<BR> when reflecting: " + HtmlPage.encodeHtmlTags(htmlAdaptorServer.getParser().toString());
                    htmlAdaptorServer.resetParser();
                    return this.makeErrorResponse(470, string2);
                }
            }
        }
        if (string != null && n == 200) {
            return this.makeOkResponse(string);
        }
        if (this.logger.finestOn()) {
            this.logger.finest("processGetRequest", "Bad request: request not supported or HTML page empty");
        }
        return this.makeErrorResponse(400);
    }

    protected HttpResponse makeErrorResponse(int n) {
        return this.makeErrorResponse(n, null);
    }

    protected HttpResponse makeErrorResponse(int n, String string) {
        String string2 = "<HTML>\r\n<BODY>\r\n<HR><P><FONT SIZE=+3 COLOR=red><B>" + n + "</B></FONT><P>" + "\r\n" + "<HR><P>" + string + "</P>" + "\r\n" + "</BODY>" + "\r\n" + "</HTML>" + "\r\n";
        HttpResponse httpResponse = new HttpResponse(new HttpBody(string2.getBytes()));
        httpResponse.statusCode = n;
        httpResponse.setHeader(1, "text/html");
        httpResponse.setHeader(2, new Date().toString());
        String string3 = n == 401 ? "Basic realm=\"JDMK\"" : null;
        httpResponse.setHeader(4, string3);
        return httpResponse;
    }

    protected HttpResponse makeOkResponse(String string) {
        HttpBody httpBody = new HttpBody(string.getBytes());
        HttpResponse httpResponse = new HttpResponse(httpBody);
        httpResponse.statusCode = 200;
        httpResponse.setHeader(1, "text/html");
        httpResponse.setHeader(2, new Date().toString());
        return httpResponse;
    }

    protected String makeDebugTag() {
        return "HtmlRequestHandler[" + this.adaptorServer.getProtocol() + ":" + this.adaptorServer.getPort() + "][" + this.requestId + "]";
    }
}

