/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.comm.GenericHttpSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

class HttpSocket
extends GenericHttpSocket {
    private int backlog = 10;
    private Socket sckAccept = null;
    private Socket clientSocket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private ServerSocket serverSocket = null;

    public HttpSocket() {
    }

    public HttpSocket(int n) {
        this.port = n;
    }

    public HttpSocket(int n, InetAddress inetAddress) {
        this.port = n;
        this.bindAddr = inetAddress;
    }

    public GenericHttpSocket createServerSocket(int n) {
        HttpSocket httpSocket = new HttpSocket(n);
        httpSocket.setTimeout(this.getTimeout());
        return httpSocket;
    }

    public GenericHttpSocket createServerSocket(int n, InetAddress inetAddress) {
        HttpSocket httpSocket = new HttpSocket(n, inetAddress);
        httpSocket.setTimeout(this.getTimeout());
        return httpSocket;
    }

    public GenericHttpSocket createClientSocket() {
        HttpSocket httpSocket = new HttpSocket(0);
        httpSocket.setTimeout(this.getTimeout());
        return httpSocket;
    }

    public String getProtocol() {
        return "http";
    }

    public void doBind() throws IOException {
        this.serverSocket = this.bindAddr == null ? new ServerSocket(this.port, this.backlog) : new ServerSocket(this.port, this.backlog, this.bindAddr);
    }

    public void doUnbind() throws IOException {
        this.serverSocket.close();
    }

    public void doConnect(String string, int n) throws UnknownHostException, IOException, CommunicationException {
        this.clientSocket = new Socket(string, n);
        this.clientSocket.setSoTimeout(this.getTimeout());
    }

    public void doDisconnect() throws IOException, CommunicationException {
        if (this.serverSocket != null) {
            this.sckAccept.close();
            this.sckAccept = null;
        } else if (this.clientSocket != null) {
            this.clientSocket.close();
            this.clientSocket = null;
        }
    }

    public void doSend(String string, byte[] byArray) throws IOException {
        this.outputStream = this.serverSocket != null ? this.sckAccept.getOutputStream() : this.clientSocket.getOutputStream();
        this.outputStream.write(string.getBytes());
        if (byArray != null) {
            this.outputStream.write(byArray);
        }
        this.outputStream.flush();
    }

    public InputStream doReceive() throws IOException {
        if (this.serverSocket != null) {
            this.sckAccept = this.serverSocket.accept();
            this.sckAccept.setSoTimeout(this.getTimeout());
            this.inputStream = this.sckAccept.getInputStream();
        } else {
            this.inputStream = this.clientSocket.getInputStream();
        }
        return this.inputStream;
    }

    public InputStream doGetInputStream() throws IOException {
        this.inputStream = this.serverSocket != null ? this.sckAccept.getInputStream() : this.clientSocket.getInputStream();
        return this.inputStream;
    }

    public OutputStream doGetOutputStream() throws IOException {
        this.outputStream = this.serverSocket != null ? this.sckAccept.getOutputStream() : this.clientSocket.getOutputStream();
        return this.outputStream;
    }

    public InetAddress getLocalAddress() {
        if (this.serverSocket != null) {
            return this.serverSocket.getInetAddress();
        }
        return this.clientSocket.getLocalAddress();
    }

    public int getLocalPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return this.clientSocket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        if (this.serverSocket != null) {
            return this.sckAccept.getInetAddress();
        }
        return this.clientSocket.getInetAddress();
    }

    public int getRemotePort() {
        if (this.serverSocket != null) {
            return this.sckAccept.getPort();
        }
        return this.clientSocket.getPort();
    }

    public String toString() {
        return this.serverSocket.toString();
    }
}

