/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.internal;

import com.sun.jdmk.internal.ClassLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class BackupFileHandler {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "BackupFileHandler");

    public static File createBackupFile(File file, String string) {
        if (string == null) {
            string = ".bak";
        }
        String string2 = file.getName();
        File file2 = file.getParentFile() == null ? new File("." + File.separator) : file.getParentFile();
        File file3 = new File(file2, string2 + string);
        if (logger.finestOn()) {
            logger.finest("createBackupFile", "backup file : " + file3 + ".");
        }
        try {
            file3.delete();
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("createBackupFile", exception);
            }
            if (logger.finestOn()) {
                logger.finest("createBackupFile", "Unable to delete the previous backup file");
            }
            return null;
        }
        if (logger.finestOn()) {
            logger.finest("createBackupFile", "Previous backup file : " + file3 + " deleted.");
        }
        try {
            BackupFileHandler.copyFile(file, file3);
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("createBackupFile", exception);
            }
            if (logger.finestOn()) {
                logger.finest("createBackupFile", "Unable to copy the file in a bak file.");
            }
            return null;
        }
        return file3;
    }

    public static void deleteBackupFile(File file) {
        try {
            file.delete();
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("deleteBackupFile", exception);
            }
            return;
        }
        if (logger.finestOn()) {
            logger.finest("deleteBackupFile", "backup file " + file + " deleted.");
        }
    }

    private static void copyFile(File file, File file2) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }
}

