/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.comm.CommunicationException;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.jdmk.internal.ModifiableClassLogger;
import com.sun.jdmk.internal.ThreadService;
import com.sun.management.comm.CommunicatorServer;
import com.sun.management.comm.SnmpAdaptorServerMBean;
import com.sun.management.comm.SnmpInformHandler;
import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpMibTree;
import com.sun.management.comm.SnmpRequestHandler;
import com.sun.management.comm.SnmpSession;
import com.sun.management.comm.SnmpSubRequestHandler;
import com.sun.management.snmp.IPAcl.JdmkAcl;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpIpAddress;
import com.sun.management.snmp.SnmpMessage;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduFactoryBER;
import com.sun.management.snmp.SnmpPduPacket;
import com.sun.management.snmp.SnmpPduRequest;
import com.sun.management.snmp.SnmpPduTrap;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTimeticks;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.agent.SnmpErrorHandlerAgent;
import com.sun.management.snmp.agent.SnmpMibAgent;
import com.sun.management.snmp.agent.SnmpMibHandler;
import com.sun.management.snmp.agent.SnmpUserDataFactory;
import com.sun.management.snmp.manager.SnmpParameters;
import com.sun.management.snmp.manager.SnmpPeer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SnmpAdaptorServer
extends CommunicatorServer
implements SnmpAdaptorServerMBean,
MBeanRegistration,
SnmpDefinitions,
SnmpMibHandler {
    private int trapPort;
    private int informPort;
    InetAddress address;
    private Object ipacl;
    private SnmpPduFactory pduFactory;
    private SnmpUserDataFactory userDataFactory;
    private boolean authRespEnabled;
    private boolean authTrapEnabled;
    private SnmpOid enterpriseOid;
    int bufferSize;
    private transient long startUpTime;
    private volatile transient DatagramSocket socket;
    transient DatagramSocket trapSocket;
    private transient SnmpSession informSession;
    private transient DatagramPacket packet;
    transient Vector mibs;
    private transient SnmpMibTree root;
    private transient boolean useAcl;
    private int maxTries;
    private int timeout;
    int snmpOutTraps;
    private int snmpOutGetResponses;
    private int snmpOutGenErrs;
    private int snmpOutBadValues;
    private int snmpOutNoSuchNames;
    private int snmpOutTooBigs;
    int snmpOutPkts;
    private int snmpInASNParseErrs;
    private int snmpInBadCommunityUses;
    private int snmpInBadCommunityNames;
    private int snmpInBadVersions;
    private int snmpInGetRequests;
    private int snmpInGetNexts;
    private int snmpInSetRequests;
    private int snmpInPkts;
    private int snmpInTotalReqVars;
    private int snmpInTotalSetVars;
    private int snmpSilentDrops;
    private static final String InterruptSysCallMsg = "Interrupted system call";
    static final SnmpOid sysUpTimeOid = new SnmpOid("1.3.6.1.2.1.1.3.0");
    static final SnmpOid snmpTrapOidOid = new SnmpOid("1.3.6.1.6.3.1.1.4.1.0");
    private ThreadService threadService;
    private static int threadNumber = 6;
    private static final String THREAD_NUMBER_PROPERTY = "com.sun.management.snmp.threadnumber";
    private SnmpMibAgent defaultAgent;

    public SnmpAdaptorServer() {
        this(null, 161, null);
    }

    public SnmpAdaptorServer(int n) {
        this(null, n, null);
    }

    public SnmpAdaptorServer(InetAddressAcl inetAddressAcl) {
        this(inetAddressAcl, 161, null);
    }

    public SnmpAdaptorServer(InetAddress inetAddress) {
        this(null, 161, inetAddress);
    }

    public SnmpAdaptorServer(InetAddressAcl inetAddressAcl, int n) {
        this(inetAddressAcl, n, null);
    }

    public SnmpAdaptorServer(int n, InetAddress inetAddress) {
        this(null, n, inetAddress);
    }

    public SnmpAdaptorServer(InetAddressAcl inetAddressAcl, InetAddress inetAddress) {
        this(inetAddressAcl, 161, inetAddress);
    }

    public SnmpAdaptorServer(InetAddressAcl inetAddressAcl, int n, InetAddress inetAddress) {
        block3: {
            super(4);
            this.trapPort = 162;
            this.informPort = 162;
            this.address = null;
            this.ipacl = null;
            this.pduFactory = null;
            this.userDataFactory = null;
            this.authRespEnabled = true;
            this.authTrapEnabled = true;
            this.enterpriseOid = new SnmpOid("1.3.6.1.4.1.42");
            this.bufferSize = 1024;
            this.startUpTime = 0L;
            this.socket = null;
            this.trapSocket = null;
            this.informSession = null;
            this.packet = null;
            this.mibs = new Vector();
            this.useAcl = true;
            this.maxTries = 3;
            this.timeout = 3000;
            this.snmpOutTraps = 0;
            this.snmpOutGetResponses = 0;
            this.snmpOutGenErrs = 0;
            this.snmpOutBadValues = 0;
            this.snmpOutNoSuchNames = 0;
            this.snmpOutTooBigs = 0;
            this.snmpOutPkts = 0;
            this.snmpInASNParseErrs = 0;
            this.snmpInBadCommunityUses = 0;
            this.snmpInBadCommunityNames = 0;
            this.snmpInBadVersions = 0;
            this.snmpInGetRequests = 0;
            this.snmpInGetNexts = 0;
            this.snmpInSetRequests = 0;
            this.snmpInPkts = 0;
            this.snmpInTotalReqVars = 0;
            this.snmpInTotalSetVars = 0;
            this.snmpSilentDrops = 0;
            this.defaultAgent = null;
            if (inetAddressAcl == null) {
                try {
                    inetAddressAcl = new JdmkAcl("SNMP protocol adaptor IP ACL");
                }
                catch (UnknownHostException unknownHostException) {
                    if (!this.logger.finestOn()) break block3;
                    this.logger.finest("constructor", "UnknowHostException when creating ACL");
                    this.logger.finest("constructor", unknownHostException);
                }
            }
        }
        this.init(inetAddressAcl, n, inetAddress);
    }

    public SnmpAdaptorServer(boolean bl, int n, InetAddress inetAddress) {
        JdmkAcl jdmkAcl;
        block3: {
            super(4);
            this.trapPort = 162;
            this.informPort = 162;
            this.address = null;
            this.ipacl = null;
            this.pduFactory = null;
            this.userDataFactory = null;
            this.authRespEnabled = true;
            this.authTrapEnabled = true;
            this.enterpriseOid = new SnmpOid("1.3.6.1.4.1.42");
            this.bufferSize = 1024;
            this.startUpTime = 0L;
            this.socket = null;
            this.trapSocket = null;
            this.informSession = null;
            this.packet = null;
            this.mibs = new Vector();
            this.useAcl = true;
            this.maxTries = 3;
            this.timeout = 3000;
            this.snmpOutTraps = 0;
            this.snmpOutGetResponses = 0;
            this.snmpOutGenErrs = 0;
            this.snmpOutBadValues = 0;
            this.snmpOutNoSuchNames = 0;
            this.snmpOutTooBigs = 0;
            this.snmpOutPkts = 0;
            this.snmpInASNParseErrs = 0;
            this.snmpInBadCommunityUses = 0;
            this.snmpInBadCommunityNames = 0;
            this.snmpInBadVersions = 0;
            this.snmpInGetRequests = 0;
            this.snmpInGetNexts = 0;
            this.snmpInSetRequests = 0;
            this.snmpInPkts = 0;
            this.snmpInTotalReqVars = 0;
            this.snmpInTotalSetVars = 0;
            this.snmpSilentDrops = 0;
            this.defaultAgent = null;
            this.useAcl = bl;
            jdmkAcl = null;
            if (bl) {
                try {
                    jdmkAcl = new JdmkAcl("SNMP protocol adaptor IP ACL");
                }
                catch (UnknownHostException unknownHostException) {
                    if (!this.logger.finestOn()) break block3;
                    this.logger.finest("constructor", "UnknowHostException when creating ACL");
                    this.logger.finest("constructor", unknownHostException);
                }
            }
        }
        this.init(jdmkAcl, n, inetAddress);
    }

    public int getServedClientCount() {
        return super.getServedClientCount();
    }

    public int getActiveClientCount() {
        return super.getActiveClientCount();
    }

    public int getMaxActiveClientCount() {
        return super.getMaxActiveClientCount();
    }

    public void setMaxActiveClientCount(int n) throws IllegalStateException {
        super.setMaxActiveClientCount(n);
    }

    public InetAddressAcl getInetAddressAcl() {
        return (InetAddressAcl)this.ipacl;
    }

    public Integer getTrapPort() {
        return new Integer(this.trapPort);
    }

    public void setTrapPort(Integer n) {
        int n2 = n;
        if (n2 < 0) {
            throw new IllegalArgumentException("Trap port cannot be a negative value");
        }
        this.trapPort = n2;
    }

    public int getInformPort() {
        return this.informPort;
    }

    public void setInformPort(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Inform request port cannot be a negative value");
        }
        this.informPort = n;
    }

    public String getProtocol() {
        return "snmp";
    }

    public Integer getBufferSize() {
        return new Integer(this.bufferSize);
    }

    public void setBufferSize(Integer n) throws IllegalStateException {
        if (this.state == 0 || this.state == 3) {
            throw new IllegalStateException("Stop server before carrying out this operation");
        }
        this.bufferSize = n;
    }

    public final int getMaxTries() {
        return this.maxTries;
    }

    public final synchronized void setMaxTries(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.maxTries = n;
    }

    public final int getTimeout() {
        return this.timeout;
    }

    public final synchronized void setTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.timeout = n;
    }

    public SnmpPduFactory getPduFactory() {
        return this.pduFactory;
    }

    public void setPduFactory(SnmpPduFactory snmpPduFactory) {
        this.pduFactory = snmpPduFactory == null ? new SnmpPduFactoryBER() : snmpPduFactory;
    }

    public void setUserDataFactory(SnmpUserDataFactory snmpUserDataFactory) {
        this.userDataFactory = snmpUserDataFactory;
    }

    public SnmpUserDataFactory getUserDataFactory() {
        return this.userDataFactory;
    }

    public boolean getAuthTrapEnabled() {
        return this.authTrapEnabled;
    }

    public void setAuthTrapEnabled(boolean bl) {
        this.authTrapEnabled = bl;
    }

    public boolean getAuthRespEnabled() {
        return this.authRespEnabled;
    }

    public void setAuthRespEnabled(boolean bl) {
        this.authRespEnabled = bl;
    }

    public String getEnterpriseOid() {
        return this.enterpriseOid.toString();
    }

    public void setEnterpriseOid(String string) throws IllegalArgumentException {
        this.enterpriseOid = new SnmpOid(string);
    }

    public String[] getMibs() {
        String[] stringArray = new String[this.mibs.size()];
        int n = 0;
        Enumeration enumeration = this.mibs.elements();
        while (enumeration.hasMoreElements()) {
            SnmpMibAgent snmpMibAgent = (SnmpMibAgent)enumeration.nextElement();
            stringArray[n++] = snmpMibAgent.getMibName();
        }
        return stringArray;
    }

    public Long getSnmpOutTraps() {
        return new Long(this.snmpOutTraps);
    }

    public Long getSnmpOutGetResponses() {
        return new Long(this.snmpOutGetResponses);
    }

    public Long getSnmpOutGenErrs() {
        return new Long(this.snmpOutGenErrs);
    }

    public Long getSnmpOutBadValues() {
        return new Long(this.snmpOutBadValues);
    }

    public Long getSnmpOutNoSuchNames() {
        return new Long(this.snmpOutNoSuchNames);
    }

    public Long getSnmpOutTooBigs() {
        return new Long(this.snmpOutTooBigs);
    }

    public Long getSnmpInASNParseErrs() {
        return new Long(this.snmpInASNParseErrs);
    }

    public Long getSnmpInBadCommunityUses() {
        return new Long(this.snmpInBadCommunityUses);
    }

    public Long getSnmpInBadCommunityNames() {
        return new Long(this.snmpInBadCommunityNames);
    }

    public Long getSnmpInBadVersions() {
        return new Long(this.snmpInBadVersions);
    }

    public Long getSnmpOutPkts() {
        return new Long(this.snmpOutPkts);
    }

    public Long getSnmpInPkts() {
        return new Long(this.snmpInPkts);
    }

    public Long getSnmpInGetRequests() {
        return new Long(this.snmpInGetRequests);
    }

    public Long getSnmpInGetNexts() {
        return new Long(this.snmpInGetNexts);
    }

    public Long getSnmpInSetRequests() {
        return new Long(this.snmpInSetRequests);
    }

    public Long getSnmpInTotalSetVars() {
        return new Long(this.snmpInTotalSetVars);
    }

    public Long getSnmpInTotalReqVars() {
        return new Long(this.snmpInTotalReqVars);
    }

    public Long getSnmpSilentDrops() {
        return new Long(this.snmpSilentDrops);
    }

    public Long getSnmpProxyDrops() {
        return new Long(0L);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (objectName == null) {
            objectName = new ObjectName(mBeanServer.getDefaultDomain() + ":" + "name=SnmpAdaptorServer");
        }
        return super.preRegister(mBeanServer, objectName);
    }

    public void postRegister(Boolean bl) {
        super.postRegister(bl);
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
    }

    public void postDeregister() {
        super.postDeregister();
    }

    public SnmpMibHandler addMib(SnmpMibAgent snmpMibAgent) throws IllegalArgumentException {
        if (this.logger.finerOn()) {
            this.logger.finer("addMib", "Mib [" + snmpMibAgent + "]");
        }
        if (snmpMibAgent == null) {
            throw new IllegalArgumentException();
        }
        if (!this.mibs.contains(snmpMibAgent)) {
            this.mibs.addElement(snmpMibAgent);
        }
        this.root.register(snmpMibAgent);
        return this;
    }

    public SnmpMibHandler addMib(SnmpMibAgent snmpMibAgent, SnmpOid[] snmpOidArray) throws IllegalArgumentException {
        if (this.logger.finerOn()) {
            this.logger.finer("addMib", "Mib [" + snmpMibAgent + "]");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < snmpOidArray.length; ++i) {
                stringBuffer.append(snmpOidArray[i] + " ");
            }
            this.logger.finer("addMib", "Oid[] = " + stringBuffer.toString());
        }
        if (snmpMibAgent == null) {
            throw new IllegalArgumentException();
        }
        if (snmpOidArray == null || snmpOidArray.length == 0) {
            return this.addMib(snmpMibAgent);
        }
        if (!this.mibs.contains(snmpMibAgent)) {
            this.mibs.addElement(snmpMibAgent);
        }
        for (int i = 0; i < snmpOidArray.length; ++i) {
            this.root.register(snmpMibAgent, snmpOidArray[i].longValue());
        }
        return this;
    }

    public SnmpMibHandler addMib(SnmpMibAgent snmpMibAgent, String string) throws IllegalArgumentException {
        return this.addMib(snmpMibAgent);
    }

    public SnmpMibHandler addMib(SnmpMibAgent snmpMibAgent, String string, SnmpOid[] snmpOidArray) throws IllegalArgumentException {
        return this.addMib(snmpMibAgent, snmpOidArray);
    }

    public boolean removeMib(SnmpMibAgent snmpMibAgent, String string) {
        return this.removeMib(snmpMibAgent);
    }

    public boolean removeMib(SnmpMibAgent snmpMibAgent) {
        if (this.logger.finerOn()) {
            this.logger.finer("removeMib", "Mib [ " + snmpMibAgent + "]");
        }
        this.root.unregister(snmpMibAgent);
        return this.mibs.removeElement(snmpMibAgent);
    }

    public boolean removeMib(SnmpMibAgent snmpMibAgent, SnmpOid[] snmpOidArray) {
        if (this.logger.finerOn()) {
            this.logger.finer("removeMib", "Mib [" + snmpMibAgent + "]");
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < snmpOidArray.length; ++i) {
                stringBuffer.append(snmpOidArray[i] + " ");
            }
            this.logger.finer("removeMib", "Oid[] = " + stringBuffer.toString());
        }
        if (snmpOidArray == null || snmpOidArray.length == 0) {
            return this.removeMib(snmpMibAgent);
        }
        boolean bl = this.mibs.contains(snmpMibAgent);
        if (bl) {
            this.root.unregister(snmpMibAgent, snmpOidArray);
            if (!this.root.isMibReferenced(snmpMibAgent)) {
                if (this.logger.finerOn()) {
                    this.logger.finer("removeMib", "Mib removed");
                }
                this.mibs.removeElement(snmpMibAgent);
            } else if (this.logger.finerOn()) {
                this.logger.finer("removeMib", "Mib NOT removed, still referenced");
            }
        }
        return bl;
    }

    public boolean removeMib(SnmpMibAgent snmpMibAgent, String string, SnmpOid[] snmpOidArray) {
        return this.removeMib(snmpMibAgent, snmpOidArray);
    }

    public void setPort(int n) throws IllegalStateException {
        super.setPort(n);
        this.updateLogger();
    }

    protected void doBind() throws CommunicationException, InterruptedException {
        try {
            this.socket = new DatagramSocket(this.port, this.address);
            this.updateLogger();
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            if (this.logger.finestOn()) {
                this.logger.finest("doBind", "cannot bind on port " + this.port);
            }
            throw new CommunicationException(socketException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnbind() throws CommunicationException, InterruptedException {
        if (this.logger.finerOn()) {
            this.logger.finer("doUnbind", "Finally close the socket");
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        finally {
            this.closeTrapSocketIfNeeded();
            this.closeInformSocketIfNeeded();
        }
    }

    void createSnmpRequestHandler(SnmpAdaptorServer snmpAdaptorServer, int n, DatagramSocket datagramSocket, DatagramPacket datagramPacket, SnmpMibTree snmpMibTree, Vector vector, Object object, SnmpPduFactory snmpPduFactory, SnmpUserDataFactory snmpUserDataFactory, MBeanServer mBeanServer, ObjectName objectName) {
        SnmpRequestHandler snmpRequestHandler = new SnmpRequestHandler(this, n, datagramSocket, datagramPacket, snmpMibTree, vector, object, snmpPduFactory, snmpUserDataFactory, mBeanServer, objectName);
        this.threadService.submitTask(snmpRequestHandler);
    }

    protected void doReceive() throws CommunicationException, InterruptedException {
        try {
            this.packet = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
            this.socket.receive(this.packet);
            int n = this.getState();
            if (n != 0) {
                if (this.logger.finerOn()) {
                    this.logger.finer("doReceive", "received a message but state not online, reruning.");
                }
                return;
            }
            this.createSnmpRequestHandler(this, this.servedClientCount, this.socket, this.packet, this.root, this.mibs, this.ipacl, this.pduFactory, this.userDataFactory, this.topMBS, this.objectName);
        }
        catch (SocketException socketException) {
            if (socketException.getMessage().equals(InterruptSysCallMsg)) {
                throw new InterruptedException(socketException.toString());
            }
            throw new CommunicationException(socketException);
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedException(interruptedIOException.toString());
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (Exception exception) {
            throw new CommunicationException(exception);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("doReceive", "received a message");
        }
    }

    protected void doError(Exception exception) throws CommunicationException {
    }

    protected void doProcess() throws CommunicationException, InterruptedException {
    }

    public void stop() {
        block6: {
            InetAddress inetAddress = this.getAddress();
            int n = this.getPort();
            if (this.state == 0 || this.state == 3) {
                if (this.logger.finerOn()) {
                    this.logger.finer("stop", "Stopping: using port " + n);
                }
                super.stop();
                try {
                    DatagramSocket datagramSocket = new DatagramSocket(0);
                    byte[] byArray = new byte[1];
                    DatagramPacket datagramPacket = inetAddress != null && !inetAddress.isAnyLocalAddress() ? new DatagramPacket(byArray, 1, inetAddress, n) : new DatagramPacket(byArray, 1, InetAddress.getLocalHost(), n);
                    if (n > 0) {
                        if (this.logger.finerOn()) {
                            this.logger.finer("stop", "Sending: using port " + n);
                        }
                        datagramSocket.send(datagramPacket);
                        datagramSocket.close();
                    }
                }
                catch (Throwable throwable) {
                    if (!this.logger.finestOn()) break block6;
                    this.logger.finest("stop", throwable);
                }
            }
        }
    }

    public void snmpV1Trap(int n, int n2, SnmpVarBindList snmpVarBindList) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV1Trap", "generic=" + n + ", specific=" + n2);
        }
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.address = null;
        snmpPduTrap.port = this.trapPort;
        snmpPduTrap.type = 164;
        snmpPduTrap.version = 0;
        snmpPduTrap.community = null;
        snmpPduTrap.enterprise = this.enterpriseOid;
        snmpPduTrap.genericTrap = n;
        snmpPduTrap.specificTrap = n2;
        snmpPduTrap.timeStamp = this.getSysUpTime();
        if (snmpVarBindList != null) {
            snmpPduTrap.varBindList = new SnmpVarBind[snmpVarBindList.size()];
            snmpVarBindList.copyInto(snmpPduTrap.varBindList);
        } else {
            snmpPduTrap.varBindList = null;
        }
        try {
            snmpPduTrap.agentAddr = this.address != null ? this.handleMultipleIpVersion(this.address.getAddress()) : this.handleMultipleIpVersion(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            byte[] byArray = new byte[4];
            snmpPduTrap.agentAddr = this.handleMultipleIpVersion(byArray);
        }
        this.sendTrapPdu(snmpPduTrap);
    }

    private SnmpIpAddress handleMultipleIpVersion(byte[] byArray) {
        if (byArray.length == 4) {
            return new SnmpIpAddress(byArray);
        }
        if (this.logger.finestOn()) {
            this.logger.finest("handleMultipleIPVersion", "Not an IPv4 address, return null");
        }
        return null;
    }

    public void snmpV1Trap(InetAddress inetAddress, String string, int n, int n2, SnmpVarBindList snmpVarBindList) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV1Trap", "generic=" + n + ", specific=" + n2);
        }
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.address = null;
        snmpPduTrap.port = this.trapPort;
        snmpPduTrap.type = 164;
        snmpPduTrap.version = 0;
        snmpPduTrap.community = (byte[])(string != null ? string.getBytes() : null);
        snmpPduTrap.enterprise = this.enterpriseOid;
        snmpPduTrap.genericTrap = n;
        snmpPduTrap.specificTrap = n2;
        snmpPduTrap.timeStamp = this.getSysUpTime();
        if (snmpVarBindList != null) {
            snmpPduTrap.varBindList = new SnmpVarBind[snmpVarBindList.size()];
            snmpVarBindList.copyInto(snmpPduTrap.varBindList);
        } else {
            snmpPduTrap.varBindList = null;
        }
        try {
            snmpPduTrap.agentAddr = this.address != null ? this.handleMultipleIpVersion(this.address.getAddress()) : this.handleMultipleIpVersion(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            byte[] byArray = new byte[4];
            snmpPduTrap.agentAddr = this.handleMultipleIpVersion(byArray);
        }
        if (inetAddress != null) {
            this.sendTrapPdu(inetAddress, snmpPduTrap);
        } else {
            this.sendTrapPdu(snmpPduTrap);
        }
    }

    public void snmpV1Trap(InetAddress inetAddress, SnmpIpAddress snmpIpAddress, String string, SnmpOid snmpOid, int n, int n2, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        this.snmpV1Trap(inetAddress, this.trapPort, snmpIpAddress, string, snmpOid, n, n2, snmpVarBindList, snmpTimeticks);
    }

    public void snmpV1Trap(SnmpPeer snmpPeer, SnmpIpAddress snmpIpAddress, SnmpOid snmpOid, int n, int n2, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        SnmpParameters snmpParameters = (SnmpParameters)snmpPeer.getParams();
        this.snmpV1Trap(snmpPeer.getDestAddr(), snmpPeer.getDestPort(), snmpIpAddress, snmpParameters.getRdCommunity(), snmpOid, n, n2, snmpVarBindList, snmpTimeticks);
    }

    private void snmpV1Trap(InetAddress inetAddress, int n, SnmpIpAddress snmpIpAddress, String string, SnmpOid snmpOid, int n2, int n3, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV1Trap", "generic=" + n2 + ", specific=" + n3);
        }
        SnmpPduTrap snmpPduTrap = new SnmpPduTrap();
        snmpPduTrap.address = null;
        snmpPduTrap.port = n;
        snmpPduTrap.type = 164;
        snmpPduTrap.version = 0;
        snmpPduTrap.community = (byte[])(string != null ? string.getBytes() : null);
        snmpPduTrap.enterprise = snmpOid != null ? snmpOid : this.enterpriseOid;
        snmpPduTrap.genericTrap = n2;
        snmpPduTrap.specificTrap = n3;
        snmpPduTrap.timeStamp = snmpTimeticks != null ? snmpTimeticks.longValue() : this.getSysUpTime();
        if (snmpVarBindList != null) {
            snmpPduTrap.varBindList = new SnmpVarBind[snmpVarBindList.size()];
            snmpVarBindList.copyInto(snmpPduTrap.varBindList);
        } else {
            snmpPduTrap.varBindList = null;
        }
        if (snmpIpAddress != null) {
            snmpPduTrap.agentAddr = snmpIpAddress;
        } else {
            try {
                snmpPduTrap.agentAddr = this.address != null ? this.handleMultipleIpVersion(this.address.getAddress()) : this.handleMultipleIpVersion(InetAddress.getLocalHost().getAddress());
            }
            catch (UnknownHostException unknownHostException) {
                byte[] byArray = new byte[4];
                snmpPduTrap.agentAddr = this.handleMultipleIpVersion(byArray);
            }
        }
        if (inetAddress != null) {
            this.sendTrapPdu(inetAddress, snmpPduTrap);
        } else {
            this.sendTrapPdu(snmpPduTrap);
        }
    }

    public void snmpV2Trap(SnmpPeer snmpPeer, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        SnmpParameters snmpParameters = (SnmpParameters)snmpPeer.getParams();
        this.snmpV2Trap(snmpPeer.getDestAddr(), snmpPeer.getDestPort(), snmpParameters.getRdCommunity(), snmpOid, snmpVarBindList, snmpTimeticks);
    }

    public void snmpV2Trap(SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV2Trap", "trapOid=" + snmpOid);
        }
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.address = null;
        snmpPduRequest.port = this.trapPort;
        snmpPduRequest.type = 167;
        snmpPduRequest.version = 1;
        snmpPduRequest.community = null;
        SnmpVarBindList snmpVarBindList2 = SnmpAdaptorServer.completeTrapVarBindList(snmpVarBindList, snmpOid, new SnmpTimeticks(this.getSysUpTime()));
        snmpPduRequest.varBindList = new SnmpVarBind[snmpVarBindList2.size()];
        snmpVarBindList2.copyInto(snmpPduRequest.varBindList);
        this.sendTrapPdu(snmpPduRequest);
    }

    public void snmpV2Trap(InetAddress inetAddress, String string, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV2Trap", "trapOid=" + snmpOid);
        }
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.address = null;
        snmpPduRequest.port = this.trapPort;
        snmpPduRequest.type = 167;
        snmpPduRequest.version = 1;
        snmpPduRequest.community = (byte[])(string != null ? string.getBytes() : null);
        SnmpVarBindList snmpVarBindList2 = SnmpAdaptorServer.completeTrapVarBindList(snmpVarBindList, snmpOid, new SnmpTimeticks(this.getSysUpTime()));
        snmpPduRequest.varBindList = new SnmpVarBind[snmpVarBindList2.size()];
        snmpVarBindList2.copyInto(snmpPduRequest.varBindList);
        if (inetAddress != null) {
            this.sendTrapPdu(inetAddress, snmpPduRequest);
        } else {
            this.sendTrapPdu(snmpPduRequest);
        }
    }

    public void snmpV2Trap(InetAddress inetAddress, String string, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        this.snmpV2Trap(inetAddress, this.trapPort, string, snmpOid, snmpVarBindList, snmpTimeticks);
    }

    private void snmpV2Trap(InetAddress inetAddress, int n, String string, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV2Trap", "trapOid=" + snmpOid + "\ncommunity=" + string + "\naddr=" + inetAddress + "\nvarBindList=" + snmpVarBindList + "\ntime=" + snmpTimeticks + "\ntrapPort=" + n);
        }
        SnmpPduRequest snmpPduRequest = new SnmpPduRequest();
        snmpPduRequest.address = null;
        snmpPduRequest.port = n;
        snmpPduRequest.type = 167;
        snmpPduRequest.version = 1;
        snmpPduRequest.community = (byte[])(string != null ? string.getBytes() : null);
        SnmpTimeticks snmpTimeticks2 = null;
        snmpTimeticks2 = snmpTimeticks != null ? snmpTimeticks : new SnmpTimeticks(this.getSysUpTime());
        SnmpVarBindList snmpVarBindList2 = SnmpAdaptorServer.completeTrapVarBindList(snmpVarBindList, snmpOid, snmpTimeticks2);
        snmpPduRequest.varBindList = new SnmpVarBind[snmpVarBindList2.size()];
        snmpVarBindList2.copyInto(snmpPduRequest.varBindList);
        if (inetAddress != null) {
            this.sendTrapPdu(inetAddress, snmpPduRequest);
        } else {
            this.sendTrapPdu(snmpPduRequest);
        }
    }

    public void snmpPduTrap(InetAddress inetAddress, SnmpPduPacket snmpPduPacket) throws IOException, SnmpStatusException {
        if (inetAddress != null) {
            this.sendTrapPdu(inetAddress, snmpPduPacket);
        } else {
            this.sendTrapPdu(snmpPduPacket);
        }
    }

    public void snmpPduTrap(SnmpPeer snmpPeer, SnmpPduPacket snmpPduPacket) throws IOException, SnmpStatusException {
        if (snmpPeer != null) {
            snmpPduPacket.port = snmpPeer.getDestPort();
            this.sendTrapPdu(snmpPeer.getDestAddr(), snmpPduPacket);
        } else {
            snmpPduPacket.port = this.getTrapPort();
            this.sendTrapPdu(snmpPduPacket);
        }
    }

    static SnmpVarBindList completeTrapVarBindList(SnmpVarBindList snmpVarBindList, SnmpOid snmpOid, SnmpTimeticks snmpTimeticks) {
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList != null ? (SnmpVarBindList)snmpVarBindList.clone() : new SnmpVarBindList(2);
        int n = snmpVarBindList2.size();
        if (n == 0 || !snmpVarBindList2.getVarBindAt(0).getOid().equals(sysUpTimeOid)) {
            snmpVarBindList2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        }
        if (n <= 1 || !snmpVarBindList2.getVarBindAt(1).getOid().equals(snmpTrapOidOid)) {
            snmpVarBindList2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 1);
        }
        return snmpVarBindList2;
    }

    private void sendTrapPdu(SnmpPduPacket snmpPduPacket) throws SnmpStatusException, IOException {
        block14: {
            SnmpMessage snmpMessage = null;
            try {
                snmpMessage = (SnmpMessage)this.pduFactory.encodeSnmpPdu(snmpPduPacket, this.bufferSize);
                if (snmpMessage == null) {
                    throw new SnmpStatusException(16);
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("sendTrapPdu", "trap pdu is too big");
                    this.logger.finest("sendTrapPdu", "trap hasn't been sent to anyone");
                }
                throw new SnmpStatusException(1);
            }
            int n = 0;
            this.openTrapSocketIfNeeded();
            if (this.ipacl != null) {
                Enumeration enumeration = ((InetAddressAcl)this.ipacl).getTrapDestinations();
                while (enumeration.hasMoreElements()) {
                    snmpMessage.address = (InetAddress)enumeration.nextElement();
                    Enumeration enumeration2 = ((InetAddressAcl)this.ipacl).getTrapCommunities(snmpMessage.address);
                    while (enumeration2.hasMoreElements()) {
                        snmpMessage.community = ((String)enumeration2.nextElement()).getBytes();
                        try {
                            this.sendTrapMessage(snmpMessage);
                            ++n;
                        }
                        catch (SnmpTooBigException snmpTooBigException) {
                            if (!this.logger.finestOn()) continue;
                            this.logger.finest("sendTrapPdu", "trap pdu is too big");
                            this.logger.finest("sendTrapPdu", "trap hasn't been sent to " + snmpMessage.address);
                        }
                    }
                }
            }
            if (n == 0) {
                try {
                    snmpMessage.address = InetAddress.getLocalHost();
                    this.sendTrapMessage(snmpMessage);
                }
                catch (SnmpTooBigException snmpTooBigException) {
                    if (this.logger.finestOn()) {
                        this.logger.finest("sendTrapPdu", "trap pdu is too big");
                        this.logger.finest("sendTrapPdu", "trap hasn't been sent");
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (!this.logger.finestOn()) break block14;
                    this.logger.finest("sendTrapPdu", "cannot get the local host");
                    this.logger.finest("sendTrapPdu", "trap hasn't been sent");
                }
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    private void sendTrapPdu(InetAddress inetAddress, SnmpPduPacket snmpPduPacket) throws SnmpStatusException, IOException {
        block7: {
            SnmpMessage snmpMessage = null;
            try {
                snmpMessage = (SnmpMessage)this.pduFactory.encodeSnmpPdu(snmpPduPacket, this.bufferSize);
                if (snmpMessage == null) {
                    throw new SnmpStatusException(16);
                }
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("sendTrapPdu", "trap pdu is too big");
                    this.logger.finest("sendTrapPdu", "trap hasn't been sent to the specified host");
                }
                throw new SnmpStatusException(1);
            }
            this.openTrapSocketIfNeeded();
            if (inetAddress != null) {
                snmpMessage.address = inetAddress;
                try {
                    this.sendTrapMessage(snmpMessage);
                }
                catch (SnmpTooBigException snmpTooBigException) {
                    if (!this.logger.finestOn()) break block7;
                    this.logger.finest("sendTrapPdu", "trap pdu is too big");
                    this.logger.finest("sendTrapPdu", "trap hasn't been sent to " + snmpMessage.address);
                }
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    private void sendTrapMessage(SnmpMessage snmpMessage) throws IOException, SnmpTooBigException {
        byte[] byArray = new byte[this.bufferSize];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        int n = snmpMessage.encodeMessage(byArray);
        datagramPacket.setLength(n);
        datagramPacket.setAddress(snmpMessage.address);
        datagramPacket.setPort(snmpMessage.port);
        if (this.logger.finerOn()) {
            this.logger.finer("sendTrapMessage", "sending trap to " + snmpMessage.address + ":" + snmpMessage.port);
        }
        this.trapSocket.send(datagramPacket);
        if (this.logger.finerOn()) {
            this.logger.finer("sendTrapMessage", "sent to " + snmpMessage.address + ":" + snmpMessage.port);
        }
        ++this.snmpOutTraps;
        ++this.snmpOutPkts;
    }

    synchronized void openTrapSocketIfNeeded() throws SocketException {
        if (this.trapSocket == null) {
            this.trapSocket = new DatagramSocket(0, this.address);
            if (this.logger.finerOn()) {
                this.logger.finer("openTrapSocketIfNeeded", "using port " + this.trapSocket.getLocalPort() + " to send traps");
            }
        }
    }

    synchronized void closeTrapSocketIfNeeded() {
        if (this.trapSocket != null && this.state != 0) {
            this.trapSocket.close();
            this.trapSocket = null;
        }
    }

    public Vector snmpInformRequest(SnmpInformHandler snmpInformHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (this.logger.finerOn()) {
            this.logger.finer("snmpInformRequest", "trapOid=" + snmpOid);
        }
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList != null ? (SnmpVarBindList)snmpVarBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        snmpVarBindList2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        snmpVarBindList2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        this.openInformSocketIfNeeded();
        Vector<SnmpInformRequest> vector = new Vector<SnmpInformRequest>();
        InetAddress inetAddress = null;
        String string = null;
        if (this.ipacl != null) {
            Enumeration enumeration = ((InetAddressAcl)this.ipacl).getInformDestinations();
            while (enumeration.hasMoreElements()) {
                inetAddress = (InetAddress)enumeration.nextElement();
                Enumeration enumeration2 = ((InetAddressAcl)this.ipacl).getInformCommunities(inetAddress);
                while (enumeration2.hasMoreElements()) {
                    string = (String)enumeration2.nextElement();
                    vector.addElement(this.informSession.makeAsyncRequest(inetAddress, string, snmpInformHandler, snmpVarBindList2, this.getInformPort()));
                }
            }
        }
        return vector;
    }

    public SnmpInformRequest snmpInformRequest(InetAddress inetAddress, String string, SnmpInformHandler snmpInformHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IOException, SnmpStatusException {
        return this.snmpInformRequest(inetAddress, this.getInformPort(), string, snmpInformHandler, snmpOid, snmpVarBindList);
    }

    public SnmpInformRequest snmpInformRequest(SnmpPeer snmpPeer, SnmpInformHandler snmpInformHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IOException, SnmpStatusException {
        SnmpParameters snmpParameters = (SnmpParameters)snmpPeer.getParams();
        return this.snmpInformRequest(snmpPeer.getDestAddr(), snmpPeer.getDestPort(), snmpParameters.getInformCommunity(), snmpInformHandler, snmpOid, snmpVarBindList);
    }

    public static final int mapErrorStatus(int n, int n2, int n3) {
        return SnmpSubRequestHandler.mapErrorStatus(n, n2, n3);
    }

    private SnmpInformRequest snmpInformRequest(InetAddress inetAddress, int n, String string, SnmpInformHandler snmpInformHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (this.logger.finerOn()) {
            this.logger.finer("snmpInformRequest", "trapOid=" + snmpOid);
        }
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList != null ? (SnmpVarBindList)snmpVarBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        snmpVarBindList2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        snmpVarBindList2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        this.openInformSocketIfNeeded();
        return this.informSession.makeAsyncRequest(inetAddress, string, snmpInformHandler, snmpVarBindList2, n);
    }

    synchronized void openInformSocketIfNeeded() throws SocketException {
        if (this.informSession == null) {
            this.informSession = new SnmpSession(this);
            if (this.logger.finerOn()) {
                this.logger.finer("openInformSocketIfNeeded", "to send inform requests and receive inform responses");
            }
        }
    }

    synchronized void closeInformSocketIfNeeded() {
        if (this.informSession != null && this.state != 0) {
            this.informSession.destroySession();
            this.informSession = null;
        }
    }

    InetAddress getAddress() {
        return this.address;
    }

    public String getHost() {
        InetAddress inetAddress = this.socket != null ? this.socket.getLocalAddress() : (this.address != null ? this.address : null);
        if (inetAddress == null) {
            return super.getHost();
        }
        if (inetAddress.isAnyLocalAddress()) {
            try {
                return inetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                this.logger.debug("getHost", "Can't determine local host name: " + unknownHostException);
                return "localhost";
            }
        }
        return inetAddress.getHostName();
    }

    public int getPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return super.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        finally {
            try {
                this.threadService.terminate();
            }
            catch (Exception exception) {}
        }
    }

    String makeDebugTag() {
        return "SnmpAdaptorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }

    ClassLogger makeLogger(String string) {
        return new ModifiableClassLogger("com.sun.jdmk.snmp.adaptor", string);
    }

    void updateRequestCounters(int n) {
        switch (n) {
            case 160: {
                ++this.snmpInGetRequests;
                break;
            }
            case 161: {
                ++this.snmpInGetNexts;
                break;
            }
            case 163: {
                ++this.snmpInSetRequests;
                break;
            }
        }
        ++this.snmpInPkts;
    }

    void updateErrorCounters(int n) {
        switch (n) {
            case 0: {
                ++this.snmpOutGetResponses;
                break;
            }
            case 5: {
                ++this.snmpOutGenErrs;
                break;
            }
            case 3: {
                ++this.snmpOutBadValues;
                break;
            }
            case 2: {
                ++this.snmpOutNoSuchNames;
                break;
            }
            case 1: {
                ++this.snmpOutTooBigs;
                break;
            }
        }
        ++this.snmpOutPkts;
    }

    void updateVarCounters(int n, int n2) {
        switch (n) {
            case 160: 
            case 161: 
            case 165: {
                this.snmpInTotalReqVars += n2;
                break;
            }
            case 163: {
                this.snmpInTotalSetVars += n2;
            }
        }
    }

    void incSnmpInASNParseErrs(int n) {
        this.snmpInASNParseErrs += n;
    }

    void incSnmpInBadVersions(int n) {
        this.snmpInBadVersions += n;
    }

    void incSnmpInBadCommunityUses(int n) {
        this.snmpInBadCommunityUses += n;
    }

    void incSnmpInBadCommunityNames(int n) {
        this.snmpInBadCommunityNames += n;
    }

    void incSnmpSilentDrops(int n) {
        this.snmpSilentDrops += n;
    }

    public long getSysUpTime() {
        return (System.currentTimeMillis() - this.startUpTime) / 10L;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.mibs = new Vector();
    }

    private void updateLogger() {
        ((ModifiableClassLogger)this.logger).setClassName(this.makeDebugTag());
    }

    private void init(Object object, int n, InetAddress inetAddress) {
        this.root = new SnmpMibTree();
        this.defaultAgent = new SnmpErrorHandlerAgent();
        this.root.setDefaultAgent(this.defaultAgent);
        this.startUpTime = System.currentTimeMillis();
        this.maxActiveClientCount = 10;
        this.pduFactory = new SnmpPduFactoryBER();
        this.setPort(n);
        this.ipacl = object;
        this.address = inetAddress;
        if (this.logger.finerOn()) {
            this.logger.finer("init", "SnmpAdaptorServer will bind to " + this.address);
        }
        if (this.ipacl == null && this.useAcl) {
            throw new IllegalArgumentException("ACL object cannot be null");
        }
        this.threadService = new ThreadService(threadNumber);
    }

    SnmpMibAgent getDefaultAgent() {
        return this.defaultAgent;
    }

    static int getThreadNumber() {
        return threadNumber;
    }

    static {
        String string = System.getProperty(THREAD_NUMBER_PROPERTY);
        if (string != null) {
            try {
                threadNumber = Integer.parseInt(string);
            }
            catch (Exception exception) {
                System.err.println("Got wrong value for com.sun.management.snmp.threadnumber: " + string);
                System.err.println("Using the default value: " + threadNumber);
            }
        }
    }
}

