/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ThreadService;
import com.sun.management.comm.SnmpAdaptorServer;
import com.sun.management.comm.SnmpInformHandler;
import com.sun.management.comm.SnmpMibContextName;
import com.sun.management.comm.SnmpMibTree;
import com.sun.management.comm.SnmpV3AdaptorServerMBean;
import com.sun.management.comm.SnmpV3InformRequest;
import com.sun.management.comm.SnmpV3RequestHandler;
import com.sun.management.comm.SnmpV3Session;
import com.sun.management.internal.snmp.SnmpAccessControlModel;
import com.sun.management.internal.snmp.SnmpAccessControlSubSystem;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpMsgProcessingModel;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpOutgoingRequest;
import com.sun.management.internal.snmp.SnmpSecuritySubSystem;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.JdmkEngineFactory;
import com.sun.management.snmp.SnmpBadSecurityLevelException;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineFactory;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTimeticks;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpUnknownModelException;
import com.sun.management.snmp.SnmpUnknownMsgProcModelException;
import com.sun.management.snmp.SnmpUnknownSecModelException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.agent.SnmpMibAgent;
import com.sun.management.snmp.agent.SnmpMibAgentMBean;
import com.sun.management.snmp.agent.SnmpMibHandler;
import com.sun.management.snmp.agent.SnmpRequestForwarder;
import com.sun.management.snmp.agent.SnmpUserDataFactory;
import com.sun.management.snmp.manager.usm.SnmpUsmParameters;
import com.sun.management.snmp.manager.usm.SnmpUsmPeer;
import com.sun.management.snmp.mpm.SnmpMsgProcessingModelV1V2;
import com.sun.management.snmp.mpm.SnmpMsgTranslatorCs2Ctxt;
import com.sun.management.snmp.mpm.SnmpMsgTranslatorV1V2;
import com.sun.management.snmp.usm.SnmpUsm;
import com.sun.management.snmp.usm.SnmpUsmAlgorithmManager;
import com.sun.management.snmp.usm.SnmpUsmLcd;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;
import com.sun.management.snmp.usm.usmmib.SNMP_USER_BASED_SM_MIB;
import com.sun.management.snmp.usm.usmmib.SNMP_USER_BASED_SM_MIBImpl;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class SnmpV3AdaptorServer
extends SnmpAdaptorServer
implements SnmpV3AdaptorServerMBean {
    private Hashtable contexts = new Hashtable();
    private Hashtable forwarders = new Hashtable();
    SnmpMsgTranslatorV1V2 v1v2translator = null;
    SnmpMsgTranslatorCs2Ctxt cs2ctxttranslator = null;
    SnmpMsgProcessingModel v1v2mpm = null;
    SnmpAccessControlModel v3acm = null;
    SNMP_USER_BASED_SM_MIB usmmib = null;
    private Hashtable peers = new Hashtable();
    private SnmpEngineImpl engine = null;
    private SnmpV3Session sessionV3 = null;
    private int snmpUnknownSecurityModels = 0;
    private int snmpInvalidMsgs = 0;
    private int snmpUnknownContexts = 0;
    private ThreadService threadService;

    public SnmpV3AdaptorServer() throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), null, 161, null);
    }

    public SnmpV3AdaptorServer(int n) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), null, n, null);
    }

    public SnmpV3AdaptorServer(InetAddressAcl inetAddressAcl) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), inetAddressAcl, 161, null);
    }

    public SnmpV3AdaptorServer(InetAddress inetAddress) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), null, 161, inetAddress);
    }

    public SnmpV3AdaptorServer(InetAddressAcl inetAddressAcl, int n) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), inetAddressAcl, n, null);
    }

    public SnmpV3AdaptorServer(int n, InetAddress inetAddress) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), null, n, inetAddress);
    }

    public SnmpV3AdaptorServer(InetAddressAcl inetAddressAcl, InetAddress inetAddress) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), inetAddressAcl, 161, inetAddress);
    }

    public SnmpV3AdaptorServer(InetAddressAcl inetAddressAcl, int n, InetAddress inetAddress) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), inetAddressAcl, n, inetAddress);
    }

    public SnmpV3AdaptorServer(boolean bl, int n, InetAddress inetAddress) throws IllegalArgumentException {
        this(new SnmpEngineParameters(), (SnmpEngineFactory)new JdmkEngineFactory(), bl, n, inetAddress);
    }

    public SnmpV3AdaptorServer(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory, InetAddressAcl inetAddressAcl, int n, InetAddress inetAddress) throws IllegalArgumentException {
        super(inetAddressAcl, n, inetAddress);
        this.createEngine(snmpEngineParameters, snmpEngineFactory);
    }

    public SnmpV3AdaptorServer(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory, boolean bl, int n, InetAddress inetAddress) throws IllegalArgumentException {
        super(bl, n, inetAddress);
        this.createEngine(snmpEngineParameters, snmpEngineFactory);
    }

    public Long getSnmpUnknownSecurityModels() {
        return new Long(this.snmpUnknownSecurityModels);
    }

    public Long getSnmpInvalidMsgs() {
        return new Long(this.snmpInvalidMsgs);
    }

    public Long getSnmpUnknownContexts() {
        return new Long(this.snmpUnknownContexts);
    }

    public Long getSnmpUnknownPDUHandlers() {
        return new Long(0L);
    }

    void incSnmpUnknownContexts(int n) {
        this.snmpUnknownContexts += n;
    }

    void incSnmpUnknownSecurityModels(int n) {
        this.snmpUnknownSecurityModels += n;
    }

    void incSnmpInvalidMsgs(int n) {
        this.snmpInvalidMsgs += n;
    }

    private void createEngine(SnmpEngineParameters snmpEngineParameters, SnmpEngineFactory snmpEngineFactory) throws IllegalArgumentException {
        block13: {
            SnmpEngineId snmpEngineId;
            if (snmpEngineParameters == null) {
                snmpEngineParameters = new SnmpEngineParameters();
            }
            if (snmpEngineFactory == null) {
                snmpEngineFactory = new JdmkEngineFactory();
            }
            if ((snmpEngineId = snmpEngineParameters.getEngineId()) == null) {
                if (this.address != null) {
                    snmpEngineId = SnmpEngineId.createEngineId(this.address, this.getPort());
                    snmpEngineParameters.setEngineId(snmpEngineId);
                } else {
                    try {
                        snmpEngineId = SnmpEngineId.createEngineId(InetAddress.getLocalHost(), this.getPort());
                        snmpEngineParameters.setEngineId(snmpEngineId);
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw new IllegalArgumentException("Unknown host: " + unknownHostException.getMessage());
                    }
                }
            }
            this.engine = (SnmpEngineImpl)snmpEngineFactory.createEngine(snmpEngineParameters, this.getInetAddressAcl());
            if (this.engine == null) {
                throw new IllegalArgumentException("The factory returned a null engine. SnmpV3AdaptorServer initilization failed");
            }
            this.createUsmMib(this.engine);
            if (this.logger.finestOn()) {
                this.logger.finest("createEngine", "Engine created.");
            }
            try {
                SnmpAccessControlSubSystem snmpAccessControlSubSystem;
                SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = this.engine.getMsgProcessingSubSystem();
                if (snmpMsgProcessingSubSystem != null) {
                    this.v1v2mpm = (SnmpMsgProcessingModelV1V2)snmpMsgProcessingSubSystem.getModel(1);
                    this.v1v2translator = new SnmpMsgTranslatorV1V2(this.engine);
                    this.cs2ctxttranslator = new SnmpMsgTranslatorCs2Ctxt(this.engine);
                }
                if ((snmpAccessControlSubSystem = this.engine.getAccessControlSubSystem()) != null) {
                    this.v3acm = (SnmpAccessControlModel)snmpAccessControlSubSystem.getModel(3);
                }
            }
            catch (SnmpUnknownModelException snmpUnknownModelException) {
                if (!this.logger.finestOn()) break block13;
                this.logger.finest("createEngine", "SNMP V2 translation not activated, translation not activable");
            }
        }
        this.threadService = new ThreadService(SnmpAdaptorServer.getThreadNumber());
    }

    public SnmpEngine getEngine() {
        return this.engine;
    }

    public SnmpEngineId getEngineId() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getEngineId();
    }

    public SnmpMibHandler addMib(SnmpMibAgent snmpMibAgent, String string) throws IllegalArgumentException {
        if (this.logger.finerOn()) {
            this.logger.finer("addMib", "Mib [" + snmpMibAgent + "] in context [" + string + "]");
        }
        if (snmpMibAgent == null) {
            throw new IllegalArgumentException();
        }
        if (string == null || string.length() == 0) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Mib [" + snmpMibAgent + "] in default context");
            }
            return this.addMib(snmpMibAgent);
        }
        SnmpMibContextName snmpMibContextName = (SnmpMibContextName)this.contexts.get(string);
        if (snmpMibContextName == null) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Unknown context [" + string + "]");
            }
            snmpMibContextName = new SnmpMibContextName();
            snmpMibContextName.root.setDefaultAgent(this.getDefaultAgent());
            this.contexts.put(string, snmpMibContextName);
        }
        if (!snmpMibContextName.mibs.contains(snmpMibAgent)) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Adding MIB [" + snmpMibAgent + "]");
            }
            snmpMibContextName.mibs.addElement(snmpMibAgent);
            snmpMibContextName.root.register(snmpMibAgent);
        } else if (this.logger.finerOn()) {
            this.logger.finer("addMib", "MIB [" + snmpMibAgent + "] already registered");
        }
        return this;
    }

    public boolean enableCommunityStringAtContext() {
        if (this.v1v2mpm == null) {
            return false;
        }
        this.v1v2mpm.setMsgTranslator(this.cs2ctxttranslator);
        return true;
    }

    public boolean disableCommunityStringAtContext() {
        if (this.v1v2mpm == null) {
            return false;
        }
        this.v1v2mpm.setMsgTranslator(this.v1v2translator);
        return true;
    }

    public boolean isCommunityStringAtContextEnabled() {
        if (this.v1v2mpm == null) {
            return false;
        }
        return this.v1v2mpm.getMsgTranslator() instanceof SnmpMsgTranslatorCs2Ctxt;
    }

    public synchronized boolean enableSnmpV1V2SetRequest() {
        if (this.v3acm == null) {
            return false;
        }
        return this.v3acm.enableSnmpV1V2SetRequest();
    }

    public synchronized boolean disableSnmpV1V2SetRequest() {
        if (this.v3acm == null) {
            return false;
        }
        return this.v3acm.disableSnmpV1V2SetRequest();
    }

    public synchronized boolean isSnmpV1V2SetRequestAuthorized() {
        if (this.v3acm == null) {
            return false;
        }
        return this.v3acm.isSnmpV1V2SetRequestAuthorized();
    }

    public void addRequestForwarder(SnmpRequestForwarder snmpRequestForwarder, SnmpEngineId snmpEngineId) {
        if (snmpRequestForwarder == null || snmpEngineId == null) {
            throw new IllegalArgumentException();
        }
        this.forwarders.put(snmpEngineId.toString(), snmpRequestForwarder);
    }

    public boolean removeRequestForwarder(SnmpEngineId snmpEngineId) {
        if (snmpEngineId == null) {
            throw new IllegalArgumentException();
        }
        Object v = this.forwarders.remove(snmpEngineId.toString());
        return v != null;
    }

    public SnmpMibHandler addMib(SnmpMibAgent snmpMibAgent, String string, SnmpOid[] snmpOidArray) throws IllegalArgumentException {
        int n;
        Object object;
        if (this.logger.finerOn()) {
            this.logger.finer("addMib", "Mib [" + snmpMibAgent + "] in context " + string + "]");
            object = new StringBuffer();
            for (n = 0; n < snmpOidArray.length; ++n) {
                ((StringBuffer)object).append(snmpOidArray[n] + " ");
            }
            this.logger.finer("addMib", "Oid[] = " + ((StringBuffer)object).toString());
        }
        if (snmpMibAgent == null) {
            throw new IllegalArgumentException();
        }
        if (string == null || string.length() == 0) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Mib [" + snmpMibAgent + "] in default context");
            }
            return this.addMib(snmpMibAgent, snmpOidArray);
        }
        if (snmpOidArray == null || snmpOidArray.length == 0) {
            return this.addMib(snmpMibAgent, string);
        }
        object = (SnmpMibContextName)this.contexts.get(string);
        if (object == null) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Unknown context [" + string + "]");
            }
            object = new SnmpMibContextName();
            ((SnmpMibContextName)object).root.setDefaultAgent(this.getDefaultAgent());
            this.contexts.put(string, object);
        }
        if (!((SnmpMibContextName)object).mibs.contains(snmpMibAgent)) {
            if (this.logger.finerOn()) {
                this.logger.finer("addMib", "Adding MIB [" + snmpMibAgent + "]");
            }
            ((SnmpMibContextName)object).mibs.addElement(snmpMibAgent);
        } else if (this.logger.finerOn()) {
            this.logger.finer("addMib", "MIB [" + snmpMibAgent + "] already registered");
        }
        for (n = 0; n < snmpOidArray.length; ++n) {
            ((SnmpMibContextName)object).root.register(snmpMibAgent, snmpOidArray[n].longValue());
        }
        return this;
    }

    public boolean removeMib(SnmpMibAgent snmpMibAgent, String string) {
        if (this.logger.finerOn()) {
            this.logger.finer("removeMib", "Mib [ " + snmpMibAgent + "] in context " + string);
        }
        if (string == null || string.length() == 0) {
            return this.removeMib(snmpMibAgent);
        }
        SnmpMibContextName snmpMibContextName = (SnmpMibContextName)this.contexts.get(string);
        if (snmpMibContextName == null) {
            return false;
        }
        boolean bl = snmpMibContextName.mibs.removeElement(snmpMibAgent);
        if (bl) {
            if (this.logger.finestOn()) {
                this.logger.finest("removeMib", "Mib : " + snmpMibAgent + " removed from context :" + string);
            }
            snmpMibContextName.root.unregister(snmpMibAgent);
            if (snmpMibContextName.mibs.size() == 0) {
                if (this.logger.finerOn()) {
                    this.logger.finer("removeMib", "No more mib in context name. Remove contextName");
                }
                this.contexts.remove(string);
            }
        } else if (this.logger.finerOn()) {
            this.logger.finer("removeMib", "Mib : " + snmpMibAgent + " not removed from context :" + string);
        }
        return bl;
    }

    public boolean removeMib(SnmpMibAgent snmpMibAgent, String string, SnmpOid[] snmpOidArray) {
        int n;
        Object object;
        if (this.logger.finerOn()) {
            this.logger.finer("removeMib", "Mib [" + snmpMibAgent + "] from context " + string);
            object = new StringBuffer();
            for (n = 0; n < snmpOidArray.length; ++n) {
                ((StringBuffer)object).append(snmpOidArray[n] + " ");
            }
            this.logger.finer("removeMib", "Oid[] = " + ((StringBuffer)object).toString());
        }
        if (string == null || string.length() == 0) {
            return this.removeMib(snmpMibAgent, snmpOidArray);
        }
        if (snmpOidArray == null || snmpOidArray.length == 0) {
            return this.removeMib(snmpMibAgent, string);
        }
        object = (SnmpMibContextName)this.contexts.get(string);
        if (object == null) {
            return false;
        }
        n = ((SnmpMibContextName)object).mibs.contains(snmpMibAgent);
        if (n != 0) {
            ((SnmpMibContextName)object).root.unregister(snmpMibAgent, snmpOidArray);
            if (!((SnmpMibContextName)object).root.isMibReferenced(snmpMibAgent)) {
                this.logger.finer("removeMib", "Mib removed");
                ((SnmpMibContextName)object).mibs.removeElement(snmpMibAgent);
                if (((SnmpMibContextName)object).mibs.size() == 0) {
                    if (this.logger.finerOn()) {
                        this.logger.finer("removeMib", "No more mib in contest name.Remove " + string);
                    }
                    this.contexts.remove(string);
                }
            } else if (this.logger.finerOn()) {
                this.logger.finer("removeMib", "Mib NOT removed, still referenced");
            }
        }
        return n != 0;
    }

    public void registerUsmMib(MBeanServer mBeanServer, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName objectName2;
        block4: {
            objectName2 = null;
            if (objectName != null) {
                objectName2 = objectName;
            } else {
                try {
                    objectName2 = this.createUsmMibObjectName(this.engine);
                }
                catch (Exception exception) {
                    if (!this.logger.finestOn()) break block4;
                    this.logger.finer("registerUsmMib", exception.toString());
                }
            }
        }
        mBeanServer.registerMBean(this.usmmib, objectName2);
        this.addMib(this.usmmib);
    }

    public void registerUsmMib() throws IllegalAccessException {
        this.usmmib.init();
        this.addMib(this.usmmib);
    }

    void createSnmpRequestHandler(SnmpAdaptorServer snmpAdaptorServer, int n, DatagramSocket datagramSocket, DatagramPacket datagramPacket, SnmpMibTree snmpMibTree, Vector vector, Object object, SnmpPduFactory snmpPduFactory, SnmpUserDataFactory snmpUserDataFactory, MBeanServer mBeanServer, ObjectName objectName) {
        SnmpV3RequestHandler snmpV3RequestHandler = new SnmpV3RequestHandler(this, this.engine, n, datagramSocket, datagramPacket, this.contexts, this.forwarders, snmpMibTree, vector, object, snmpPduFactory, snmpUserDataFactory, mBeanServer, objectName);
        this.threadService.submitTask(snmpV3RequestHandler);
    }

    public int[] getSecurityModelIds() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getSecuritySubSystem().getModelIds();
    }

    public String[] getSecurityModelNames() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getSecuritySubSystem().getModelNames();
    }

    public int[] getMsgProcessingModelIds() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getMsgProcessingSubSystem().getModelIds();
    }

    public String[] getMsgProcessingModelNames() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getMsgProcessingSubSystem().getModelNames();
    }

    public int[] getAccessControlModelIds() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getAccessControlSubSystem().getModelIds();
    }

    public String[] getAccessControlModelNames() {
        if (this.engine == null) {
            return null;
        }
        return this.engine.getAccessControlSubSystem().getModelNames();
    }

    public String[] getUsmSecurityAlgorithms() {
        if (this.engine == null) {
            return null;
        }
        SnmpSecuritySubSystem snmpSecuritySubSystem = this.engine.getSecuritySubSystem();
        SnmpUsm snmpUsm = null;
        try {
            snmpUsm = (SnmpUsm)snmpSecuritySubSystem.getModel(3);
        }
        catch (SnmpUnknownModelException snmpUnknownModelException) {
            return null;
        }
        SnmpUsmLcd snmpUsmLcd = snmpUsm.getLcd();
        SnmpUsmAlgorithmManager snmpUsmAlgorithmManager = snmpUsmLcd.getAlgorithmManager();
        return snmpUsmAlgorithmManager.getManagedAlgorithms();
    }

    public String[] getMibs() {
        HashSet hashSet = new HashSet(this.mibs);
        Iterator iterator = hashSet.iterator();
        String[] stringArray = this.contexts.elements();
        while (stringArray.hasMoreElements()) {
            SnmpMibContextName snmpMibContextName = (SnmpMibContextName)stringArray.nextElement();
            hashSet.addAll(snmpMibContextName.mibs);
        }
        stringArray = new String[hashSet.size()];
        iterator = hashSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = ((SnmpMibAgentMBean)iterator.next()).getMibName();
            ++n;
        }
        return stringArray;
    }

    public String[] getMibs(String string) {
        if (string == null) {
            return null;
        }
        SnmpMibContextName snmpMibContextName = (SnmpMibContextName)this.contexts.get(string);
        if (snmpMibContextName == null) {
            return null;
        }
        if (snmpMibContextName.mibs == null) {
            return null;
        }
        int n = snmpMibContextName.mibs.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((SnmpMibAgentMBean)snmpMibContextName.mibs.elementAt(i)).getMibName();
        }
        return stringArray;
    }

    public String[] getContexts() {
        String[] stringArray = new String[this.contexts.size()];
        int n = 0;
        Enumeration enumeration = this.contexts.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public void snmpV3Trap(SnmpUsmPeer snmpUsmPeer, SnmpScopedPduRequest snmpScopedPduRequest) throws IOException, SnmpStatusException {
        if (snmpUsmPeer != null) {
            snmpScopedPduRequest.port = snmpUsmPeer.getDestPort();
            this.snmpV3Trap(snmpUsmPeer.getDestAddr(), snmpScopedPduRequest);
        } else {
            snmpScopedPduRequest.port = this.getTrapPort();
            this.snmpV3Trap((InetAddress)null, snmpScopedPduRequest);
        }
    }

    public void snmpV3Trap(InetAddress inetAddress, SnmpScopedPduRequest snmpScopedPduRequest) throws IOException, SnmpStatusException {
        SnmpOutgoingRequest snmpOutgoingRequest = null;
        SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = this.engine.getMsgProcessingSubSystem();
        try {
            snmpOutgoingRequest = snmpMsgProcessingSubSystem.getOutgoingRequest(3, this.getPduFactory());
        }
        catch (SnmpUnknownMsgProcModelException snmpUnknownMsgProcModelException) {
            if (this.logger.finestOn()) {
                this.logger.finest("snmpV3Trap", "Unknown Msg Processing Model:3");
            }
            throw new SnmpStatusException(242);
        }
        SnmpMsg snmpMsg = this.prepareMsg(snmpOutgoingRequest, snmpScopedPduRequest);
        if (snmpMsg == null) {
            return;
        }
        if (inetAddress != null) {
            snmpMsg.address = inetAddress;
            try {
                this.sendTrapMessage(snmpOutgoingRequest, snmpMsg);
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("snmpV3Trap", "trap pdu is too big");
                    this.logger.finest("snmpV3Trap", "trap hasn't been sent to " + snmpMsg.address);
                }
                this.closeTrapSocketIfNeeded();
                throw new SnmpStatusException(1);
            }
        }
        int n = 0;
        this.openTrapSocketIfNeeded();
        if (this.getInetAddressAcl() != null) {
            Enumeration enumeration = this.getInetAddressAcl().getTrapDestinations();
            while (enumeration.hasMoreElements()) {
                snmpMsg.address = (InetAddress)enumeration.nextElement();
                try {
                    this.sendTrapMessage(snmpOutgoingRequest, snmpMsg);
                    ++n;
                }
                catch (SnmpTooBigException snmpTooBigException) {
                    if (!this.logger.finestOn()) continue;
                    this.logger.finest("snmpV3Trap", "trap pdu is too big");
                    this.logger.finest("snmpV3Trap", "trap hasn't been sent to " + snmpMsg.address);
                    this.closeTrapSocketIfNeeded();
                    throw new SnmpStatusException(1);
                }
            }
        }
        if (n == 0) {
            try {
                snmpMsg.address = InetAddress.getLocalHost();
                this.sendTrapMessage(snmpOutgoingRequest, snmpMsg);
            }
            catch (SnmpTooBigException snmpTooBigException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("snmpV3Trap", "trap pdu is too big");
                    this.logger.finest("snmpV3Trap", "trap hasn't been sent");
                }
                this.closeTrapSocketIfNeeded();
                throw new SnmpStatusException(1);
            }
            catch (UnknownHostException unknownHostException) {
                if (this.logger.finestOn()) {
                    this.logger.finest("snmpV3Trap", "cannot get the local host");
                    this.logger.finest("snmpV3Trap", "trap hasn't been sent");
                }
                throw new SnmpStatusException(242);
            }
        }
        this.closeTrapSocketIfNeeded();
    }

    public void snmpV3Trap(SnmpScopedPduRequest snmpScopedPduRequest) throws IOException, SnmpStatusException {
        this.snmpV3Trap((InetAddress)null, snmpScopedPduRequest);
    }

    public void snmpV3UsmTrap(String string, int n, String string2, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IOException, SnmpStatusException {
        byte[] byArray = string2 == null ? null : string2.getBytes();
        SnmpScopedPduRequest snmpScopedPduRequest = this.createScopedUsmPdu(string, n, byArray, this.engine.getEngineId(), this.engine.getEngineBoots(), this.engine.getEngineTime(), snmpVarBindList, snmpOid, null, this.getTrapPort());
        this.snmpV3Trap(snmpScopedPduRequest);
    }

    public void snmpV3UsmTrap(InetAddress inetAddress, String string, int n, String string2, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IOException, SnmpStatusException {
        byte[] byArray = string2 == null ? null : string2.getBytes();
        SnmpScopedPduRequest snmpScopedPduRequest = this.createScopedUsmPdu(string, n, byArray, this.engine.getEngineId(), this.engine.getEngineBoots(), this.engine.getEngineTime(), snmpVarBindList, snmpOid, null, this.getTrapPort());
        this.snmpV3Trap(inetAddress, snmpScopedPduRequest);
    }

    public void snmpV3UsmTrap(InetAddress inetAddress, String string, int n, String string2, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException {
        byte[] byArray = string2 == null ? null : string2.getBytes();
        SnmpScopedPduRequest snmpScopedPduRequest = this.createScopedUsmPdu(string, n, byArray, this.engine.getEngineId(), this.engine.getEngineBoots(), this.engine.getEngineTime(), snmpVarBindList, snmpOid, snmpTimeticks, this.getTrapPort());
        this.snmpV3Trap(inetAddress, snmpScopedPduRequest);
    }

    public void snmpV3UsmTrap(SnmpUsmPeer snmpUsmPeer, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList, SnmpTimeticks snmpTimeticks) throws IOException, SnmpStatusException, IllegalArgumentException {
        SnmpUsmParameters snmpUsmParameters = (SnmpUsmParameters)snmpUsmPeer.getParams();
        if (snmpUsmParameters == null) {
            throw new IllegalArgumentException("No Usm parameters set");
        }
        SnmpScopedPduRequest snmpScopedPduRequest = this.createScopedUsmPdu(snmpUsmParameters.getPrincipal(), snmpUsmParameters.getSecurityLevel(), snmpUsmParameters.getContextName(), this.engine.getEngineId(), this.engine.getEngineBoots(), this.engine.getEngineTime(), snmpVarBindList, snmpOid, snmpTimeticks, snmpUsmPeer.getDestPort());
        this.snmpV3Trap(snmpUsmPeer.getDestAddr(), snmpScopedPduRequest);
    }

    public SnmpV3InformRequest snmpV3UsmInformRequest(SnmpUsmPeer snmpUsmPeer, SnmpInformHandler snmpInformHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IOException, SnmpStatusException {
        return this.usmInformRequest(snmpUsmPeer, snmpInformHandler, snmpOid, snmpVarBindList);
    }

    private SnmpV3InformRequest usmInformRequest(SnmpUsmPeer snmpUsmPeer, SnmpInformHandler snmpInformHandler, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IllegalArgumentException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (snmpUsmPeer.isAuthoritative()) {
            throw new SnmpStatusException("SnmpUsmPeer is an authoritative one. Not usable for informs.");
        }
        SnmpUsmParameters snmpUsmParameters = (SnmpUsmParameters)snmpUsmPeer.getParams();
        SnmpScopedPduRequest snmpScopedPduRequest = this.createScopedUsmPdu(snmpUsmParameters.getPrincipal(), snmpUsmParameters.getSecurityLevel(), snmpUsmParameters.getContextName(), snmpUsmPeer.getEngineId(), snmpUsmPeer.getEngineBoots(), snmpUsmPeer.getEngineTime(), snmpVarBindList, null, null, snmpUsmPeer.getDestPort());
        SnmpV3InformRequest snmpV3InformRequest = this.snmpV3InformRequest(snmpUsmPeer.getDestAddr(), snmpInformHandler, snmpScopedPduRequest, snmpOid, snmpVarBindList);
        return snmpV3InformRequest;
    }

    private Vector snmpV3InformRequest(SnmpInformHandler snmpInformHandler, SnmpScopedPduRequest snmpScopedPduRequest, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (this.sessionV3 == null) {
            this.sessionV3 = new SnmpV3Session(this);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV3InformRequest", "trapOid=" + snmpOid);
        }
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList != null ? (SnmpVarBindList)snmpVarBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        snmpVarBindList2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        snmpVarBindList2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        this.openInformSocketIfNeeded();
        Vector<SnmpV3InformRequest> vector = new Vector<SnmpV3InformRequest>();
        int n = 0;
        InetAddress inetAddress = null;
        if (this.getInetAddressAcl() != null) {
            Enumeration enumeration = this.getInetAddressAcl().getInformDestinations();
            while (enumeration.hasMoreElements()) {
                inetAddress = (InetAddress)enumeration.nextElement();
                vector.addElement(this.sessionV3.makeAsyncRequest(inetAddress, snmpScopedPduRequest, snmpInformHandler, snmpVarBindList2));
                ++n;
            }
        }
        if (n == 0) {
            vector.addElement(this.sessionV3.makeAsyncRequest(InetAddress.getLocalHost(), snmpScopedPduRequest, snmpInformHandler, snmpVarBindList2));
        }
        return vector;
    }

    public SnmpV3InformRequest snmpV3InformRequest(InetAddress inetAddress, SnmpInformHandler snmpInformHandler, SnmpScopedPduRequest snmpScopedPduRequest, SnmpOid snmpOid, SnmpVarBindList snmpVarBindList) throws IllegalStateException, IOException, SnmpStatusException {
        if (!this.isActive()) {
            throw new IllegalStateException("Start SNMP adaptor server before carrying out this operation");
        }
        if (this.sessionV3 == null) {
            this.sessionV3 = new SnmpV3Session(this);
        }
        if (this.logger.finerOn()) {
            this.logger.finer("snmpV3InformRequest", "trapOid=" + snmpOid);
        }
        SnmpVarBindList snmpVarBindList2 = snmpVarBindList != null ? (SnmpVarBindList)snmpVarBindList.clone() : new SnmpVarBindList(2);
        SnmpTimeticks snmpTimeticks = new SnmpTimeticks(this.getSysUpTime());
        snmpVarBindList2.insertElementAt(new SnmpVarBind(snmpTrapOidOid, snmpOid), 0);
        snmpVarBindList2.insertElementAt(new SnmpVarBind(sysUpTimeOid, snmpTimeticks), 0);
        this.openInformSocketIfNeeded();
        return this.sessionV3.makeAsyncRequest(inetAddress, snmpScopedPduRequest, snmpInformHandler, snmpVarBindList2);
    }

    private SnmpScopedPduRequest createScopedUsmPdu(String string, int n, byte[] byArray, SnmpEngineId snmpEngineId, int n2, int n3, SnmpVarBindList snmpVarBindList, SnmpOid snmpOid, SnmpTimeticks snmpTimeticks, int n4) throws SnmpStatusException {
        SnmpUsm snmpUsm = null;
        try {
            snmpUsm = (SnmpUsm)this.engine.getSecuritySubSystem().getModel(3);
        }
        catch (SnmpUnknownModelException snmpUnknownModelException) {
            if (this.logger.finestOn()) {
                this.logger.finest("createScopedUsmPdu", "SnmpUnknownModelException", snmpUnknownModelException);
            }
            throw new SnmpStatusException(242);
        }
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = snmpUsm.createUsmSecurityParameters();
        snmpUsmSecurityParameters.setAuthoritativeEngineId(snmpEngineId);
        snmpUsmSecurityParameters.setAuthoritativeEngineBoots(n2);
        snmpUsmSecurityParameters.setAuthoritativeEngineTime(n3);
        snmpUsmSecurityParameters.setUserName(string);
        SnmpScopedPduRequest snmpScopedPduRequest = new SnmpScopedPduRequest();
        snmpScopedPduRequest.port = n4;
        snmpScopedPduRequest.version = 3;
        snmpScopedPduRequest.type = 167;
        snmpScopedPduRequest.msgFlags = (byte)n;
        snmpScopedPduRequest.msgSecurityModel = 3;
        snmpScopedPduRequest.msgMaxSize = this.bufferSize;
        snmpScopedPduRequest.contextEngineId = snmpEngineId.getBytes();
        snmpScopedPduRequest.contextName = byArray;
        snmpScopedPduRequest.securityParameters = snmpUsmSecurityParameters;
        SnmpTimeticks snmpTimeticks2 = null;
        snmpTimeticks2 = snmpTimeticks != null ? snmpTimeticks : new SnmpTimeticks(this.getSysUpTime());
        SnmpVarBindList snmpVarBindList2 = SnmpV3AdaptorServer.completeTrapVarBindList(snmpVarBindList, snmpOid, snmpTimeticks2);
        snmpScopedPduRequest.varBindList = new SnmpVarBind[snmpVarBindList2.size()];
        snmpVarBindList2.copyInto(snmpScopedPduRequest.varBindList);
        return snmpScopedPduRequest;
    }

    private void sendTrapMessage(SnmpOutgoingRequest snmpOutgoingRequest, SnmpMsg snmpMsg) throws IOException, SnmpTooBigException, SnmpStatusException {
        byte[] byArray = new byte[this.bufferSize];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        int n = 0;
        try {
            n = snmpOutgoingRequest.encodeMessage(byArray);
        }
        catch (SnmpSecurityException snmpSecurityException) {
            if (this.logger.finerOn()) {
                this.logger.finer("sendTrapMessage", snmpSecurityException.toString());
            }
            throw new SnmpStatusException(snmpSecurityException.status);
        }
        catch (SnmpUnknownSecModelException snmpUnknownSecModelException) {
            if (this.logger.finerOn()) {
                this.logger.finer("sendTrapMessage", snmpUnknownSecModelException.toString());
            }
            throw new SnmpStatusException(snmpUnknownSecModelException.toString());
        }
        catch (SnmpBadSecurityLevelException snmpBadSecurityLevelException) {
            if (this.logger.finerOn()) {
                this.logger.finer("sendTrapMessage", snmpBadSecurityLevelException.toString());
            }
            throw new SnmpStatusException(249);
        }
        datagramPacket.setLength(n);
        datagramPacket.setAddress(snmpMsg.address);
        datagramPacket.setPort(snmpMsg.port);
        if (this.logger.finerOn()) {
            this.logger.finer("sendTrapMessage", "sending trap to " + snmpMsg.address + ":" + snmpMsg.port);
        }
        this.trapSocket.send(datagramPacket);
        if (this.logger.finerOn()) {
            this.logger.fine("sendTrapMessage", "trap sent to " + snmpMsg.address + ":" + snmpMsg.port);
        }
        ++this.snmpOutTraps;
        ++this.snmpOutPkts;
    }

    private SnmpMsg prepareMsg(SnmpOutgoingRequest snmpOutgoingRequest, SnmpPdu snmpPdu) throws IOException, SnmpStatusException {
        SnmpPduFactory snmpPduFactory = this.getPduFactory();
        SnmpMsg snmpMsg = null;
        try {
            snmpMsg = snmpOutgoingRequest.encodeSnmpPdu(snmpPdu, this.bufferSize);
        }
        catch (SnmpTooBigException snmpTooBigException) {
            if (this.logger.finestOn()) {
                this.logger.finest("prepareMsg", snmpTooBigException);
            }
            throw new SnmpStatusException(1);
        }
        if (snmpMsg == null) {
            if (this.logger.finestOn()) {
                this.logger.finest("prepareMsg", "pdu factory returned a null value");
            }
            throw new SnmpStatusException(242);
        }
        byte[] byArray = new byte[this.bufferSize];
        int n = 0;
        try {
            n = snmpOutgoingRequest.encodeMessage(byArray);
        }
        catch (SnmpTooBigException snmpTooBigException) {
            if (this.logger.finestOn()) {
                this.logger.finest("prepareMsg", snmpTooBigException.toString());
            }
            throw new SnmpStatusException(1);
        }
        catch (SnmpSecurityException snmpSecurityException) {
            if (this.logger.finerOn()) {
                this.logger.finer("prepareMsg", snmpSecurityException.toString());
            }
            throw new SnmpStatusException(snmpSecurityException.status);
        }
        catch (SnmpUnknownSecModelException snmpUnknownSecModelException) {
            if (this.logger.finestOn()) {
                this.logger.finest("prepareMsg", snmpUnknownSecModelException.toString());
            }
            throw new SnmpStatusException(242);
        }
        catch (SnmpBadSecurityLevelException snmpBadSecurityLevelException) {
            if (this.logger.finerOn()) {
                this.logger.finer("prepareMsg", snmpBadSecurityLevelException.toString());
            }
            throw new SnmpStatusException(249);
        }
        this.openTrapSocketIfNeeded();
        return snmpMsg;
    }

    protected ObjectName createUsmMibObjectName(SnmpEngine snmpEngine) throws MalformedObjectNameException {
        return new ObjectName(snmpEngine.getEngineId().toString() + "/SNMP_USER_BASED_SM_MIB:" + "name=Usm-MIB-RFC2574");
    }

    private void createUsmMib(SnmpEngineImpl snmpEngineImpl) throws IllegalArgumentException {
        SnmpUsm snmpUsm = null;
        SnmpUsmLcd snmpUsmLcd = null;
        try {
            snmpUsm = (SnmpUsm)snmpEngineImpl.getSecuritySubSystem().getModel(3);
            snmpUsmLcd = snmpUsm.getLcd();
        }
        catch (SnmpUnknownModelException snmpUnknownModelException) {
            if (this.logger.finerOn()) {
                this.logger.finer("init", "The Usm can't be added, no Usm model: " + snmpUnknownModelException);
            }
            throw new IllegalArgumentException(snmpUnknownModelException.toString());
        }
        this.usmmib = new SNMP_USER_BASED_SM_MIBImpl(snmpEngineImpl, snmpUsmLcd, snmpUsm);
    }

    String makeDebugTag() {
        return "SnmpV3AdaptorServer[" + this.getProtocol() + ":" + this.getPort() + "]";
    }
}

