/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpQManager;
import com.sun.management.comm.SnmpResponseHandler;
import com.sun.management.comm.SnmpV3AdaptorServer;
import com.sun.management.comm.SnmpV3InformRequest;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpIncomingResponse;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpSecurityCache;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpSecurityException;
import java.net.DatagramPacket;

class SnmpV3ResponseHandler
extends SnmpResponseHandler {
    SnmpV3AdaptorServer v3adaptor = null;
    SnmpSecurityCache cache = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpV3ResponseHandler");

    public SnmpV3ResponseHandler(SnmpV3AdaptorServer snmpV3AdaptorServer, SnmpQManager snmpQManager) {
        super(snmpV3AdaptorServer, snmpQManager);
        this.v3adaptor = snmpV3AdaptorServer;
    }

    public void setSecurityCache(SnmpSecurityCache snmpSecurityCache) {
        this.cache = snmpSecurityCache;
    }

    public synchronized void processDatagram(DatagramPacket datagramPacket) {
        block12: {
            byte[] byArray = datagramPacket.getData();
            int n = datagramPacket.getLength();
            if (logger.finerOn()) {
                logger.finer("processDatagram", "Received from peer " + datagramPacket.getAddress().toString() + " Length = " + n + "\nDump : \n" + SnmpMsg.dumpHexBuffer(byArray, 0, n));
            }
            try {
                SnmpEngineImpl snmpEngineImpl = (SnmpEngineImpl)this.v3adaptor.getEngine();
                int n2 = SnmpMsg.getProtocolVersion(datagramPacket.getData());
                SnmpPduFactory snmpPduFactory = this.v3adaptor.getPduFactory();
                if (snmpPduFactory == null) {
                    if (logger.finestOn()) {
                        logger.finest("processDatagram", "Dropping packet. Unable to find the pdu factory of the SNMP adaptor server");
                    }
                    break block12;
                }
                SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = snmpEngineImpl.getMsgProcessingSubSystem();
                SnmpIncomingResponse snmpIncomingResponse = snmpMsgProcessingSubSystem.getIncomingResponse(n2, snmpPduFactory);
                int n3 = snmpIncomingResponse.getRequestId(byArray);
                SnmpV3InformRequest snmpV3InformRequest = (SnmpV3InformRequest)this.snmpq.removeRequest(n3);
                snmpIncomingResponse.setSecurityCache(this.cache);
                try {
                    snmpIncomingResponse.decodeMessage(byArray, n, datagramPacket.getAddress(), datagramPacket.getPort());
                }
                catch (SnmpSecurityException snmpSecurityException) {
                    if (logger.finestOn()) {
                        logger.finest("processDatagram", "Security Exception when unmarshalling, status: " + snmpSecurityException.status);
                    }
                    snmpV3InformRequest.setErrorStatusAndIndex(snmpSecurityException.status, 0);
                    snmpV3InformRequest.invokeOnResponse(null);
                    return;
                }
                SnmpPdu snmpPdu = snmpIncomingResponse.decodeSnmpPdu();
                if (snmpPdu == null) {
                    if (logger.finestOn()) {
                        logger.finest("processDatagram", "Dropping packet. Pdu factory returned a null value");
                    }
                    return;
                }
                if (!(snmpPdu instanceof SnmpPduRequestType)) {
                    if (logger.finestOn()) {
                        logger.finest("processDatagram", "Dropping packet. The packet does not contain a response");
                    }
                    snmpPdu = null;
                    return;
                }
                SnmpPdu snmpPdu2 = snmpPdu;
                snmpV3InformRequest.invokeOnResponse(snmpPdu2);
            }
            catch (Exception exception) {
                if (!logger.finestOn()) break block12;
                logger.finest("processDatagram", "Exception while processsing");
                logger.finest("processDatagram", exception);
            }
        }
    }
}

