/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.IPAcl;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.IPAcl.AclEntryImpl;
import com.sun.management.snmp.IPAcl.AclImpl;
import com.sun.management.snmp.IPAcl.ParseException;
import com.sun.management.snmp.IPAcl.Parser;
import com.sun.management.snmp.IPAcl.PermissionImpl;
import com.sun.management.snmp.IPAcl.PrincipalImpl;
import com.sun.management.snmp.IPAcl.SimpleNode;
import com.sun.management.snmp.InetAddressAcl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class JdmkAcl
implements InetAddressAcl,
Serializable {
    private static final long serialVersionUID = -1731776149894734768L;
    static final PermissionImpl READ = new PermissionImpl("READ");
    static final PermissionImpl WRITE = new PermissionImpl("WRITE");
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "JdmkAcl");
    String dbgTag;
    private AclImpl acl;
    private boolean alwaysAuthorized;
    private String authorizedListFile;
    private Hashtable trapDestList;
    private Hashtable informDestList;
    private PrincipalImpl owner;

    public JdmkAcl(String string, String string2) throws UnknownHostException, IllegalArgumentException {
        block4: {
            this.dbgTag = "JdmkAcl";
            this.acl = null;
            this.alwaysAuthorized = false;
            this.authorizedListFile = null;
            this.trapDestList = null;
            this.informDestList = null;
            this.owner = null;
            this.trapDestList = new Hashtable();
            this.informDestList = new Hashtable();
            this.owner = new PrincipalImpl();
            try {
                this.acl = new AclImpl(this.owner, string);
                AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
                aclEntryImpl.addPermission(READ);
                aclEntryImpl.addPermission(WRITE);
                this.acl.addEntry(this.owner, aclEntryImpl);
            }
            catch (NotOwnerException notOwnerException) {
                if (!logger.finestOn()) break block4;
                logger.finest("constructor", "Should never get NotOwnerException as the owner is built in this constructor");
            }
        }
        if (string2 == null) {
            this.setDefautFileName();
        } else {
            this.authorizedListFile = string2;
        }
        this.readAuthorisedListFile();
    }

    public JdmkAcl(String string) throws UnknownHostException, IllegalArgumentException {
        this(string, null);
    }

    public synchronized Enumeration entries() {
        return this.acl.entries();
    }

    public synchronized Enumeration communities() {
        HashSet<String> hashSet = new HashSet<String>();
        Vector<Object> vector = new Vector<Object>();
        Object[] objectArray = this.acl.entries();
        while (objectArray.hasMoreElements()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)objectArray.nextElement();
            Enumeration enumeration = aclEntryImpl.communities();
            while (enumeration.hasMoreElements()) {
                hashSet.add((String)enumeration.nextElement());
            }
        }
        objectArray = hashSet.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector.elements();
    }

    public synchronized String getName() {
        return this.acl.getName();
    }

    public static PermissionImpl getREAD() {
        return READ;
    }

    public static PermissionImpl getWRITE() {
        return WRITE;
    }

    public synchronized void setAuthorizedListFile(String string) throws IllegalArgumentException, NotOwnerException, UnknownHostException {
        if (string == null) {
            throw new IllegalArgumentException("The specified file is null");
        }
        File file = new File(string);
        if (!file.isFile()) {
            if (logger.finestOn()) {
                logger.finest("setAuthorizedListFile", "Ip ACL file not found. Wrong passed file : " + string);
            }
            throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist or is not a file, no configuration loaded");
        }
        if (logger.finerOn()) {
            logger.finer("setAuthorizedListFile", "Default file set to " + string);
        }
        this.authorizedListFile = string;
        this.rereadTheFile();
    }

    public synchronized void rereadTheFile() throws NotOwnerException, UnknownHostException {
        this.alwaysAuthorized = false;
        this.acl.removeAll(this.owner);
        this.trapDestList.clear();
        this.informDestList.clear();
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
        aclEntryImpl.addPermission(READ);
        aclEntryImpl.addPermission(WRITE);
        this.acl.addEntry(this.owner, aclEntryImpl);
        this.readAuthorisedListFile();
    }

    public synchronized String getAuthorizedListFile() {
        return this.authorizedListFile;
    }

    public synchronized boolean checkReadPermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, READ);
    }

    public synchronized boolean checkReadPermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, READ);
    }

    public synchronized boolean checkCommunity(String string) {
        return this.acl.checkCommunity(string);
    }

    public synchronized boolean checkWritePermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, WRITE);
    }

    public synchronized boolean checkWritePermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, WRITE);
    }

    public synchronized Enumeration getTrapDestinations() {
        return this.trapDestList.keys();
    }

    public synchronized Enumeration getTrapCommunities(InetAddress inetAddress) {
        Vector vector = null;
        vector = (Vector)this.trapDestList.get(inetAddress);
        if (vector != null) {
            if (logger.finerOn()) {
                logger.finer("getTrapCommunities", "[" + inetAddress.toString() + "] is in list");
            }
            return vector.elements();
        }
        vector = new Vector();
        if (logger.finerOn()) {
            logger.finer("getTrapCommunities", "[" + inetAddress.toString() + "] is not in list");
        }
        return vector.elements();
    }

    public synchronized Enumeration getInformDestinations() {
        return this.informDestList.keys();
    }

    public synchronized Enumeration getInformCommunities(InetAddress inetAddress) {
        Vector vector = null;
        vector = (Vector)this.informDestList.get(inetAddress);
        if (vector != null) {
            if (logger.finerOn()) {
                logger.finer("getInformCommunities", "[" + inetAddress.toString() + "] is in list");
            }
            return vector.elements();
        }
        vector = new Vector();
        if (logger.finerOn()) {
            logger.finer("getInformCommunities", "[" + inetAddress.toString() + "] is not in list");
        }
        return vector.elements();
    }

    private static void checkCanRead(String string) throws IllegalArgumentException {
        File file = new File(string);
        if (file.isFile() && !file.canRead()) {
            throw new IllegalArgumentException("IP ACL file is not readable.");
        }
    }

    private void readAuthorisedListFile() {
        this.alwaysAuthorized = false;
        if (this.authorizedListFile == null) {
            if (logger.finerOn()) {
                logger.finer("readAuthorisedListFile", "alwaysAuthorized set to true");
            }
            this.alwaysAuthorized = true;
        } else {
            Object object;
            Parser parser = null;
            try {
                JdmkAcl.checkCanRead(this.getAuthorizedListFile());
                parser = new Parser(new FileInputStream(this.getAuthorizedListFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "The specified file was not found, authorize everybody");
                }
                this.alwaysAuthorized = true;
                return;
            }
            try {
                object = parser.SecurityDefs();
                ((SimpleNode)object).buildAclEntries(this.owner, this.acl);
                ((SimpleNode)object).buildTrapEntries(this.trapDestList);
                ((SimpleNode)object).buildInformEntries(this.informDestList);
            }
            catch (ParseException parseException) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "Parsing exception " + parseException);
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Syntax error: " + parseException);
                Utils.initCause(illegalArgumentException, parseException);
                throw illegalArgumentException;
            }
            catch (Error error) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "Error exception " + error);
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error: " + error);
                Utils.initCause(illegalArgumentException, error);
                throw illegalArgumentException;
            }
            object = this.acl.entries();
            while (object.hasMoreElements()) {
                AclEntryImpl aclEntryImpl = (AclEntryImpl)object.nextElement();
                if (logger.finerOn()) {
                    logger.finer("readAuthorisedListFile", "===> " + ((Object)aclEntryImpl.getPrincipal()).toString());
                }
                Enumeration enumeration = aclEntryImpl.permissions();
                while (enumeration.hasMoreElements()) {
                    Permission permission = (Permission)enumeration.nextElement();
                    if (!logger.finerOn()) continue;
                    logger.finer("readAuthorisedListFile", "perm = " + permission);
                }
            }
        }
    }

    private void setDefautFileName() throws IllegalArgumentException {
        String string = null;
        File file = null;
        string = System.getProperty("jdmk.acl.file");
        if (string == null) {
            string = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.acl");
            if (logger.finestOn()) {
                logger.finest("setDefautFileName", "Default File name is : " + string);
            }
            if ((file = new File(string)).isFile()) {
                if (logger.finerOn()) {
                    logger.finer("setDefautFileName", "Default Ip ACL file found : " + string);
                }
            } else if (logger.finestOn()) {
                logger.finest("setDefautFileName", "Default Ip ACL file not found.");
            }
        } else {
            file = new File(string);
            if (!file.isFile()) {
                if (logger.finestOn()) {
                    logger.finest("setDefautFileName", "Ip ACL file not found. Wrong java property : jdmk.acl.file=" + string);
                }
                throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist or is not a file, no configuration loaded");
            }
            if (logger.finerOn()) {
                logger.finer("setDefautFileName", "Ip ACL file found : " + string);
            }
        }
        this.authorizedListFile = string;
    }
}

