/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp;

import com.sun.jdmk.UnsignedLong;
import com.sun.management.snmp.SnmpCounter;
import com.sun.management.snmp.SnmpCounter64;
import com.sun.management.snmp.SnmpDataTypeEnums;
import com.sun.management.snmp.SnmpGauge;
import com.sun.management.snmp.SnmpInt;
import com.sun.management.snmp.SnmpIpAddress;
import com.sun.management.snmp.SnmpNull;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpOidRecord;
import com.sun.management.snmp.SnmpOidTable;
import com.sun.management.snmp.SnmpOpaque;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpString;
import com.sun.management.snmp.SnmpStringFixed;
import com.sun.management.snmp.SnmpTimeticks;
import com.sun.management.snmp.SnmpValue;
import java.io.Serializable;

public class SnmpVarBind
implements SnmpDataTypeEnums,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5059006593897949375L;
    public static final String[] statusLegend = new String[]{"Status Mapper", "Value not initialized", "Valid Value", "No such object", "No such Instance", "End of Mib View"};
    public static final int stValueUnspecified = 1;
    public static final int stValueOk = 2;
    public static final int stValueNoSuchObject = 3;
    public static final int stValueNoSuchInstance = 4;
    public static final int stValueEndOfMibView = 5;
    public static final SnmpNull noSuchObject = new SnmpNull(128);
    public static final SnmpNull noSuchInstance = new SnmpNull(129);
    public static final SnmpNull endOfMibView = new SnmpNull(130);
    private SnmpOid oid = null;
    private SnmpValue value = null;
    public int status = 1;

    public SnmpVarBind() {
    }

    public SnmpVarBind(SnmpOid snmpOid) {
        this.oid = snmpOid;
    }

    public SnmpVarBind(SnmpOid snmpOid, SnmpValue snmpValue) {
        this.oid = snmpOid;
        this.setSnmpValue(snmpValue);
    }

    public SnmpVarBind(String string) throws SnmpStatusException {
        if (string.startsWith(".")) {
            this.oid = new SnmpOid(string);
        } else {
            SnmpOidRecord snmpOidRecord = null;
            try {
                int n = string.indexOf(46);
                this.handleLong(string, n);
                this.oid = new SnmpOid(string);
            }
            catch (NumberFormatException numberFormatException) {
                int n = string.indexOf(46);
                if (n <= 0) {
                    snmpOidRecord = this.resolveVarName(string);
                    this.oid = new SnmpOid(snmpOidRecord.getName());
                }
                snmpOidRecord = this.resolveVarName(string.substring(0, n));
                this.oid = new SnmpOid(snmpOidRecord.getName() + string.substring(n));
            }
        }
    }

    public final SnmpOid getOid() {
        return this.oid;
    }

    public final void setOid(SnmpOid snmpOid) {
        this.setOid(snmpOid, true);
    }

    public final void setOid(SnmpOid snmpOid, boolean bl) {
        this.oid = snmpOid;
        if (bl) {
            this.clearValue();
        }
    }

    public final synchronized SnmpValue getSnmpValue() {
        return this.value;
    }

    public final void setSnmpValue(SnmpValue snmpValue) {
        this.value = snmpValue;
        this.setValueValid();
    }

    public final SnmpCounter64 getSnmpCounter64Value() throws ClassCastException {
        return (SnmpCounter64)this.value;
    }

    public final void setSnmpCounter64Value(long l) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpCounter64(l);
        this.setValueValid();
    }

    public final void setSnmpCounter64Value(UnsignedLong unsignedLong) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpCounter64(unsignedLong);
        this.setValueValid();
    }

    public final SnmpInt getSnmpIntValue() throws ClassCastException {
        return (SnmpInt)this.value;
    }

    public final void setSnmpIntValue(long l) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpInt(l);
        this.setValueValid();
    }

    public final SnmpCounter getSnmpCounterValue() throws ClassCastException {
        return (SnmpCounter)this.value;
    }

    public final void setSnmpCounterValue(long l) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpCounter(l);
        this.setValueValid();
    }

    public final SnmpGauge getSnmpGaugeValue() throws ClassCastException {
        return (SnmpGauge)this.value;
    }

    public final void setSnmpGaugeValue(long l) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpGauge(l);
        this.setValueValid();
    }

    public final SnmpTimeticks getSnmpTimeticksValue() throws ClassCastException {
        return (SnmpTimeticks)this.value;
    }

    public final void setSnmpTimeticksValue(long l) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpTimeticks(l);
        this.setValueValid();
    }

    public final SnmpOid getSnmpOidValue() throws ClassCastException {
        return (SnmpOid)this.value;
    }

    public final void setSnmpOidValue(String string) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpOid(string);
        this.setValueValid();
    }

    public final SnmpIpAddress getSnmpIpAddressValue() throws ClassCastException {
        return (SnmpIpAddress)this.value;
    }

    public final void setSnmpIpAddressValue(String string) throws IllegalArgumentException {
        this.clearValue();
        this.value = new SnmpIpAddress(string);
        this.setValueValid();
    }

    public final SnmpString getSnmpStringValue() throws ClassCastException {
        return (SnmpString)this.value;
    }

    public final void setSnmpStringValue(String string) {
        this.clearValue();
        this.value = new SnmpString(string);
        this.setValueValid();
    }

    public final SnmpOpaque getSnmpOpaqueValue() throws ClassCastException {
        return (SnmpOpaque)this.value;
    }

    public final void setSnmpOpaqueValue(byte[] byArray) {
        this.clearValue();
        this.value = new SnmpOpaque(byArray);
        this.setValueValid();
    }

    public final SnmpStringFixed getSnmpStringFixedValue() throws ClassCastException {
        return (SnmpStringFixed)this.value;
    }

    public final void setSnmpStringFixedValue(String string) {
        this.clearValue();
        this.value = new SnmpStringFixed(string);
        this.setValueValid();
    }

    public SnmpOidRecord resolveVarName(String string) throws SnmpStatusException {
        SnmpVarBind snmpVarBind = this;
        SnmpOidTable snmpOidTable = snmpVarBind.oid.getSnmpOidTable();
        if (snmpOidTable == null) {
            throw new SnmpStatusException(2);
        }
        int n = string.indexOf(46);
        if (n < 0) {
            return snmpOidTable.resolveVarName(string);
        }
        return snmpOidTable.resolveVarOid(string);
    }

    public final int getValueStatus() {
        return this.status;
    }

    public final String getValueStatusLegend() {
        return statusLegend[this.status];
    }

    public final boolean isValidValue() {
        return this.status == 2;
    }

    public final boolean isUnspecifiedValue() {
        return this.status == 1;
    }

    public final void clearValue() {
        this.value = null;
        this.status = 1;
    }

    public final boolean isOidEqual(SnmpVarBind snmpVarBind) {
        return this.oid.equals(snmpVarBind.oid);
    }

    public final void addInstance(long l) {
        this.oid.append(l);
    }

    public final void addInstance(long[] lArray) throws SnmpStatusException {
        this.oid.addToOid(lArray);
    }

    public final void addInstance(String string) throws SnmpStatusException {
        if (string != null) {
            this.oid.addToOid(string);
        }
    }

    public void insertInOid(int n) {
        this.oid.insert(n);
    }

    public void appendInOid(SnmpOid snmpOid) {
        this.oid.append(snmpOid);
    }

    public final synchronized boolean hasVarBindException() {
        switch (this.status) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public void copyValueAndOid(SnmpVarBind snmpVarBind) {
        this.setOid((SnmpOid)snmpVarBind.oid.clone());
        this.copyValue(snmpVarBind);
    }

    public void copyValue(SnmpVarBind snmpVarBind) {
        if (snmpVarBind.isValidValue()) {
            this.value = snmpVarBind.getSnmpValue().duplicate();
            this.setValueValid();
        } else {
            this.status = snmpVarBind.getValueStatus();
            this.value = this.status == 5 ? endOfMibView : (this.status == 3 ? noSuchObject : (this.status == 4 ? noSuchInstance : null));
        }
    }

    public Object cloneWithoutValue() {
        SnmpOid snmpOid = (SnmpOid)this.oid.clone();
        return new SnmpVarBind(snmpOid);
    }

    public Object clone() {
        SnmpVarBind snmpVarBind = new SnmpVarBind();
        snmpVarBind.copyValueAndOid(this);
        return snmpVarBind;
    }

    public final String getStringValue() {
        return this.value.toString();
    }

    public final void setNoSuchObject() {
        this.value = noSuchObject;
        this.status = 3;
    }

    public final void setNoSuchInstance() {
        this.value = noSuchInstance;
        this.status = 4;
    }

    public final void setEndOfMibView() {
        this.value = endOfMibView;
        this.status = 5;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append("Object ID : " + this.oid.toString());
        if (this.isValidValue()) {
            stringBuffer.append("  (Syntax : " + this.value.getTypeName() + ")\n");
            stringBuffer.append("Value : " + this.value.toString());
        } else {
            stringBuffer.append("\nValue Exception : " + this.getValueStatusLegend());
        }
        return stringBuffer.toString();
    }

    private void setValueValid() {
        this.status = this.value == endOfMibView ? 5 : (this.value == noSuchObject ? 3 : (this.value == noSuchInstance ? 4 : 2));
    }

    private void handleLong(String string, int n) throws NumberFormatException, SnmpStatusException {
        String string2 = n > 0 ? string.substring(0, n) : string;
        Long.parseLong(string2);
    }
}

