/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.AcmChecker;
import com.sun.management.snmp.agent.SnmpMibAgent;
import com.sun.management.snmp.agent.SnmpMibNode;
import com.sun.management.snmp.agent.SnmpMibOid;
import com.sun.management.snmp.agent.SnmpMibRequest;
import com.sun.management.snmp.agent.SnmpMibRequestImpl;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.agent.SnmpRequestTree;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public abstract class SnmpMib
extends SnmpMibAgent
implements Serializable {
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpMib");
    protected SnmpMibOid root = new SnmpMibOid();
    private transient long[] rootOid = null;

    protected String getGroupOid(String string, String string2) {
        return string2;
    }

    protected ObjectName getGroupObjectName(String string, String string2, String string3) throws MalformedObjectNameException {
        return new ObjectName(string3);
    }

    protected void registerGroupNode(String string, String string2, ObjectName objectName, SnmpMibNode snmpMibNode, Object object, MBeanServer mBeanServer) throws NotCompliantMBeanException, MBeanRegistrationException, InstanceAlreadyExistsException, IllegalAccessException {
        this.root.registerNode(string2, snmpMibNode);
        if (mBeanServer != null && objectName != null && object != null) {
            mBeanServer.registerMBean(object, objectName);
        }
    }

    public abstract void registerTableMeta(String var1, SnmpMibTable var2);

    public abstract SnmpMibTable getRegisteredTableMeta(String var1);

    public void get(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = this.getHandlers(snmpMibRequest, false, false, 160);
        SnmpRequestTree.Handler handler = null;
        SnmpMibNode snmpMibNode = null;
        boolean bl = logger.finestOn();
        if (bl) {
            logger.finest("get", "Processing handlers for GET... ");
        }
        Enumeration enumeration = snmpRequestTree.getHandlers();
        while (enumeration.hasMoreElements()) {
            handler = (SnmpRequestTree.Handler)enumeration.nextElement();
            if (bl) {
                logger.finest("get", "Got handler: " + handler);
            }
            snmpMibNode = snmpRequestTree.getMetaNode(handler);
            if (bl) {
                logger.finest("get", "Retrieved handler's meta: " + snmpMibNode);
            }
            int n = snmpRequestTree.getOidDepth(handler);
            if (bl) {
                logger.finest("get", "Retrieved meta's depth: " + n);
            }
            Enumeration enumeration2 = snmpRequestTree.getSubRequests(handler);
            while (enumeration2.hasMoreElements()) {
                if (bl) {
                    logger.finest("get", "invoke get for subrequest");
                }
                snmpMibNode.get((SnmpMibSubRequest)enumeration2.nextElement(), n);
            }
        }
    }

    public void set(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = null;
        if (snmpMibRequest instanceof SnmpMibRequestImpl) {
            snmpRequestTree = ((SnmpMibRequestImpl)snmpMibRequest).getRequestTree();
        }
        if (snmpRequestTree == null) {
            snmpRequestTree = this.getHandlers(snmpMibRequest, false, true, 163);
        }
        snmpRequestTree.switchCreationFlag(false);
        snmpRequestTree.setPduType(163);
        SnmpRequestTree.Handler handler = null;
        SnmpMibNode snmpMibNode = null;
        if (logger.finestOn()) {
            logger.finest("set", "Processing handlers for SET... ");
        }
        Enumeration enumeration = snmpRequestTree.getHandlers();
        while (enumeration.hasMoreElements()) {
            handler = (SnmpRequestTree.Handler)enumeration.nextElement();
            snmpMibNode = snmpRequestTree.getMetaNode(handler);
            int n = snmpRequestTree.getOidDepth(handler);
            Enumeration enumeration2 = snmpRequestTree.getSubRequests(handler);
            while (enumeration2.hasMoreElements()) {
                snmpMibNode.set((SnmpMibSubRequest)enumeration2.nextElement(), n);
            }
        }
    }

    public void check(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = this.getHandlers(snmpMibRequest, true, true, 253);
        SnmpRequestTree.Handler handler = null;
        SnmpMibNode snmpMibNode = null;
        if (logger.finestOn()) {
            logger.finest("check", "Processing handlers for CHECK... ");
        }
        Enumeration enumeration = snmpRequestTree.getHandlers();
        while (enumeration.hasMoreElements()) {
            handler = (SnmpRequestTree.Handler)enumeration.nextElement();
            snmpMibNode = snmpRequestTree.getMetaNode(handler);
            int n = snmpRequestTree.getOidDepth(handler);
            Enumeration enumeration2 = snmpRequestTree.getSubRequests(handler);
            while (enumeration2.hasMoreElements()) {
                snmpMibNode.check((SnmpMibSubRequest)enumeration2.nextElement(), n);
            }
        }
        if (snmpMibRequest instanceof SnmpMibRequestImpl) {
            ((SnmpMibRequestImpl)snmpMibRequest).setRequestTree(snmpRequestTree);
        }
    }

    public void getNext(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = this.getGetNextHandlers(snmpMibRequest);
        SnmpRequestTree.Handler handler = null;
        SnmpMibNode snmpMibNode = null;
        if (logger.finestOn()) {
            logger.finest("getNext", "Processing handlers for GET-NEXT... ");
        }
        Enumeration enumeration = snmpRequestTree.getHandlers();
        while (enumeration.hasMoreElements()) {
            handler = (SnmpRequestTree.Handler)enumeration.nextElement();
            snmpMibNode = snmpRequestTree.getMetaNode(handler);
            int n = snmpRequestTree.getOidDepth(handler);
            Enumeration enumeration2 = snmpRequestTree.getSubRequests(handler);
            while (enumeration2.hasMoreElements()) {
                snmpMibNode.get((SnmpMibSubRequest)enumeration2.nextElement(), n);
            }
        }
    }

    public void getBulk(SnmpMibRequest snmpMibRequest, int n, int n2) throws SnmpStatusException {
        this.getBulkWithGetNext(snmpMibRequest, n, n2);
    }

    public long[] getRootOid() {
        if (this.rootOid == null) {
            Vector vector = new Vector(10);
            this.root.getRootOid(vector);
            this.rootOid = new long[vector.size()];
            int n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                this.rootOid[n++] = n2.longValue();
            }
        }
        return this.rootOid;
    }

    private SnmpRequestTree getHandlers(SnmpMibRequest snmpMibRequest, boolean bl, boolean bl2, int n) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = new SnmpRequestTree(snmpMibRequest, bl, n);
        int n2 = 0;
        SnmpVarBind snmpVarBind = null;
        int n3 = snmpMibRequest.getVersion();
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            if (logger.finestOn()) {
                logger.finest("getHandlers", "Processing subrequest varbind #" + (n2 + 1));
            }
            snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            try {
                this.root.findHandlingNode(snmpVarBind, snmpVarBind.getOid().longValue(false), 0, snmpRequestTree);
            }
            catch (SnmpStatusException snmpStatusException) {
                SnmpStatusException snmpStatusException2;
                int n4;
                if (logger.finestOn()) {
                    logger.finest("getHandlers", "Couldn't find a handling node for " + snmpVarBind.getOid().toString());
                    logger.finest("getHandlers", "\tcaused by: " + snmpStatusException);
                }
                if (n3 == 0) {
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tV1: Throwing exception");
                    }
                    throw new SnmpStatusException(snmpStatusException, n2 + 1);
                }
                if (n == 253 || n == 163) {
                    n4 = SnmpRequestTree.mapSetException(snmpStatusException.getStatus(), n3);
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tSET: Throwing exception");
                    }
                    snmpStatusException2 = new SnmpStatusException(n4, n2 + 1);
                    Utils.initCause(snmpStatusException2, snmpStatusException);
                    throw snmpStatusException2;
                }
                if (bl2) {
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tATOMIC: Throwing exception");
                    }
                    throw new SnmpStatusException(snmpStatusException, n2 + 1);
                }
                n4 = SnmpRequestTree.mapGetException(snmpStatusException.getStatus(), n3);
                if (n4 == 224) {
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tGET: Registering noSuchInstance");
                        logger.finest("getHandlers", "\tcaused by: " + snmpStatusException);
                        logger.finest("getHandlers", snmpStatusException);
                    }
                    snmpVarBind.setSnmpValue(SnmpVarBind.noSuchInstance);
                } else if (n4 == 225) {
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tGET: Registering noSuchObject");
                        logger.finest("getHandlers", "\tcaused by: " + snmpStatusException);
                        logger.finest("getHandlers", snmpStatusException);
                    }
                    snmpVarBind.setSnmpValue(SnmpVarBind.noSuchObject);
                } else {
                    if (logger.finestOn()) {
                        logger.finest("getHandlers", "\tGET: Registering global error: " + n4);
                    }
                    snmpStatusException2 = new SnmpStatusException(n4, n2 + 1);
                    Utils.initCause(snmpStatusException2, snmpStatusException);
                }
            }
            catch (RuntimeException runtimeException) {
                if (logger.finestOn()) {
                    logger.finest("getHandlers", "failed for varbind #" + (n2 + 1) + ": " + runtimeException, runtimeException);
                }
                throw runtimeException;
            }
            ++n2;
        }
        return snmpRequestTree;
    }

    private SnmpRequestTree getGetNextHandlers(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        SnmpRequestTree snmpRequestTree = new SnmpRequestTree(snmpMibRequest, false, 161);
        snmpRequestTree.setGetNextFlag();
        if (logger.finestOn()) {
            logger.finest("getGetNextHandlers", "Received MIB request : " + snmpMibRequest);
        }
        AcmChecker acmChecker = new AcmChecker(snmpMibRequest);
        int n = 0;
        SnmpVarBind snmpVarBind = null;
        int n2 = snmpMibRequest.getVersion();
        Object var7_7 = null;
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            SnmpOid snmpOid = null;
            try {
                if (logger.finestOn()) {
                    logger.finest("getGetNextHandlers", " Next Oid of :" + snmpVarBind.getOid());
                }
                snmpOid = new SnmpOid(this.root.findNextHandlingNode(snmpVarBind, snmpVarBind.getOid().longValue(false), 0, 0, snmpRequestTree, acmChecker));
                if (logger.finestOn()) {
                    logger.finest("getGetNextHandlers", " is :" + snmpOid);
                }
                snmpVarBind.setOid(snmpOid, false);
            }
            catch (SnmpStatusException snmpStatusException) {
                if (n2 == 0) {
                    if (logger.finestOn()) {
                        logger.finest("getGetNextHandlers", "\tThrowing exception" + snmpStatusException.toString());
                    }
                    throw new SnmpStatusException(snmpStatusException, n + 1);
                }
                if (logger.finestOn()) {
                    logger.finest("getGetNextHandlers", "Exception : " + snmpStatusException.getStatus());
                    logger.finest("getHandlers", "\tcaused by: " + snmpStatusException);
                }
                snmpVarBind.setSnmpValue(SnmpVarBind.endOfMibView);
            }
            ++n;
        }
        return snmpRequestTree;
    }
}

