/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpScopedPduPacket;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpUnknownModelException;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.agent.SnmpV3Proxy;
import com.sun.management.snmp.manager.SnmpParams;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.usm.SnmpUsmParameters;
import com.sun.management.snmp.manager.usm.SnmpUsmPeer;

public class SnmpUsmProxy
extends SnmpV3Proxy {
    private static final long serialVersionUID = -6442234160949252976L;
    String user = null;
    boolean timelinessRetry = true;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.proxy", "SnmpUsmProxy");
    String dbgTag = "SnmpUsmProxy";

    public SnmpUsmProxy(SnmpEngine snmpEngine, SnmpUsmPeer snmpUsmPeer, String string) throws SnmpStatusException {
        super(snmpEngine, snmpUsmPeer, string, "SnmpUsmProxy");
    }

    public SnmpUsmProxy(SnmpEngine snmpEngine, SnmpUsmPeer snmpUsmPeer, String string, String string2) throws SnmpStatusException {
        super(snmpEngine, snmpUsmPeer, string, string2);
    }

    public SnmpEngineId getEngineId() {
        return ((SnmpUsmPeer)this.getPeer()).getEngineId();
    }

    public void resyncOnTimelinessReport(boolean bl) {
        this.timelinessRetry = bl;
    }

    protected boolean handleReport(SnmpRequest snmpRequest) {
        if (logger.finestOn()) {
            logger.finest("handleReport", "Received a report");
        }
        if (!this.timelinessRetry) {
            if (logger.finestOn()) {
                logger.finest("handleReport", "No retrying, return false");
            }
            return false;
        }
        SnmpVarBindList snmpVarBindList = snmpRequest.getReportVarBindList();
        SnmpOid snmpOid = null;
        try {
            snmpOid = new SnmpOid("1.3.6.1.6.3.15.1.1.2.0");
        }
        catch (Exception exception) {
            return false;
        }
        if (snmpVarBindList.indexOfOid(snmpOid) != -1) {
            if (logger.finestOn()) {
                logger.finest("handleReport", "Received a Not in Time Window report");
            }
            SnmpUsmPeer snmpUsmPeer = (SnmpUsmPeer)snmpRequest.getPeer();
            try {
                snmpUsmPeer.processUsmTimelinessDiscovery();
                if (logger.finestOn()) {
                    logger.finest("handleReport", " synchro done. EngineId : " + snmpUsmPeer.getEngineId() + " time : " + snmpUsmPeer.getEngineTime() + " boot : " + snmpUsmPeer.getEngineBoots());
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                if (logger.finestOn()) {
                    logger.finest("handleReport", "Time Window synchro failed.");
                }
                return false;
            }
            return true;
        }
        if (logger.finestOn()) {
            logger.finest("handleReport", "Received a report that is not usmStatsNotInTimeWindows");
        }
        return false;
    }

    protected final SnmpParams createParameters(SnmpPdu snmpPdu) throws SnmpStatusException {
        SnmpUsmPeer snmpUsmPeer = (SnmpUsmPeer)this.getPeer();
        if (snmpPdu == null || !(snmpPdu instanceof SnmpScopedPduPacket)) {
            if (logger.finestOn()) {
                logger.finest("createParameters", "pdu :" + snmpPdu);
            }
            return snmpUsmPeer.getParams();
        }
        SnmpScopedPduPacket snmpScopedPduPacket = (SnmpScopedPduPacket)snmpPdu;
        if (logger.finestOn()) {
            logger.finest("createParameters", "pdu security parameters :" + snmpScopedPduPacket.securityParameters);
        }
        String string = snmpScopedPduPacket.securityParameters.getPrincipal();
        if (logger.finestOn()) {
            logger.finest("createParameters", "pdu principal :" + string);
        }
        SnmpUsmParameters snmpUsmParameters = null;
        try {
            snmpUsmParameters = new SnmpUsmParameters(this.getEngine(), string);
        }
        catch (SnmpUnknownModelException snmpUnknownModelException) {
            if (logger.finerOn()) {
                logger.finer("createParameters", "Failed " + snmpUnknownModelException);
            }
            throw new SnmpStatusException(snmpUnknownModelException.toString());
        }
        snmpUsmParameters.setContextEngineId(snmpUsmPeer.getEngineId().getBytes());
        return snmpUsmParameters;
    }
}

