/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpTools;
import com.sun.management.snmp.SnmpPduRequest;
import com.sun.management.snmp.SnmpPduTrap;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.SnmpTrapReceiver;
import com.sun.management.snmp.manager.SnmpTrapListener;

class TrapListener
implements SnmpTrapListener {
    private static final String dbgTag = "TrapListener";
    private SnmpTrapReceiver forwarder = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "TrapListener");

    TrapListener(SnmpTrapReceiver snmpTrapReceiver) {
        this.forwarder = snmpTrapReceiver;
    }

    public void processSnmpTrapV1(SnmpPduTrap snmpPduTrap) {
        this.printV1Trap(snmpPduTrap);
        this.forwarder.receivedV1(snmpPduTrap);
    }

    public void processSnmpTrapV2(SnmpPduRequest snmpPduRequest) {
        this.printV2Trap(snmpPduRequest);
        this.forwarder.receivedV2(snmpPduRequest);
    }

    public void processSnmpTrapV3(SnmpScopedPduRequest snmpScopedPduRequest) {
        this.printV3Trap(snmpScopedPduRequest);
        this.forwarder.receivedV3(snmpScopedPduRequest);
    }

    private void printV1Trap(SnmpPduTrap snmpPduTrap) {
        if (logger.finerOn()) {
            logger.finer("printV1Trap", "received V1 trap :");
            logger.finer("printV1Trap", "\tCommunity " + new String(snmpPduTrap.community));
            logger.finer("printV1Trap", "\tEnterprise " + snmpPduTrap.enterprise);
            logger.finer("printV1Trap", "\tGeneric " + snmpPduTrap.genericTrap);
            logger.finer("printV1Trap", "\tSpecific " + snmpPduTrap.specificTrap);
            logger.finer("printV1Trap", "\tTimeStamp " + snmpPduTrap.timeStamp);
            logger.finer("printV1Trap", "\tAgent adress " + snmpPduTrap.agentAddr.stringValue());
            for (int i = 0; i < snmpPduTrap.varBindList.length; ++i) {
                logger.finer("printV1Trap", "oid : " + snmpPduTrap.varBindList[i].getOid() + " val : " + snmpPduTrap.varBindList[i].getSnmpValue() + "\n");
            }
            logger.finer("printV1Trap", "************************************************\n");
        }
    }

    private void printV2Trap(SnmpPduRequest snmpPduRequest) {
        if (logger.finerOn()) {
            logger.finer("printV2Trap", "received V2 trap :");
            logger.finer("printV2Trap", "\tCommunity " + new String(snmpPduRequest.community));
            SnmpVarBind[] snmpVarBindArray = snmpPduRequest.varBindList;
            for (int i = 0; i < snmpVarBindArray.length; ++i) {
                logger.finer("printV2Trap", "OID " + snmpVarBindArray[i].getOid());
                logger.finer("printV2Trap", "Value " + snmpVarBindArray[i].getSnmpValue());
            }
            logger.finer("printV2Trap", "************************************************\n");
        }
    }

    private void printV3Trap(SnmpScopedPduRequest snmpScopedPduRequest) {
        if (logger.finerOn()) {
            logger.finer("printV3Trap", "received V3 trap :");
            logger.finer("printV3Trap", "\tContextEngineId : " + new String(SnmpTools.binary2ascii(snmpScopedPduRequest.contextEngineId)) + "\n");
            logger.finer("printV3Trap", "\tContextName : " + new String(snmpScopedPduRequest.contextName) + "\n");
            logger.finer("printV3Trap", "\tMsgFlags : " + snmpScopedPduRequest.msgFlags + "\n");
            logger.finer("printV3Trap", "\tMsgMaxSize : " + snmpScopedPduRequest.msgMaxSize + "\n");
            logger.finer("printV3Trap", "\tMsgSecurityModel : " + snmpScopedPduRequest.msgSecurityModel + "\n");
            logger.finer("printV3Trap", "\tAgent list :\n");
            for (int i = 0; i < snmpScopedPduRequest.varBindList.length; ++i) {
                logger.finer("printV3Trap", "oid : " + snmpScopedPduRequest.varBindList[i].getOid() + " val : " + snmpScopedPduRequest.varBindList[i].getSnmpValue() + "\n");
            }
            logger.finer("printV3Trap", "************************************************\n");
        }
    }
}

