/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.Timestamp;
import com.sun.management.snmp.manager.ReqRedirectSrv;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpRequestHandler;
import com.sun.management.snmp.manager.SnmpSession;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

final class MultiplexRequest
implements Serializable,
SnmpRequestHandler,
SnmpDefinitions,
ReqRedirectSrv {
    private static final long serialVersionUID = 7456830883773007669L;
    private SnmpPeer thepeer;
    private SnmpSession asession;
    private int command;
    private SnmpRequest multiplexReq;
    private Vector vbmuxList = null;
    static final String nl = "\n";
    SnmpVarBindList multiplexVb;
    String dbgTag = "MultiplexRequest";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "MultiplexRequest");

    public MultiplexRequest(SnmpPeer snmpPeer, SnmpSession snmpSession, int n) {
        this.thepeer = snmpPeer;
        this.asession = snmpSession;
        this.command = n;
        this.multiplexVb = new SnmpVarBindList("Multiplexed varBind list");
        this.vbmuxList = new Vector();
    }

    public final SnmpPeer getPeer() {
        return this.thepeer;
    }

    public final SnmpSession getSnmpSession() {
        return this.asession;
    }

    public final int getCommand() {
        return this.command;
    }

    public Enumeration getElements() {
        return this.vbmuxList.elements();
    }

    public synchronized boolean addRequest(SnmpRequest snmpRequest) {
        if (this.multiplexVb.size() + snmpRequest.getVarBindList().size() > this.getPeer().getVarBindLimit()) {
            return false;
        }
        this.buildMultiplexVblist(snmpRequest);
        return true;
    }

    public synchronized void action() {
        block6: {
            if (this.vbmuxList.isEmpty()) {
                return;
            }
            if (this.vbmuxList.size() == 1) {
                VbMultiplexMap vbMultiplexMap = (VbMultiplexMap)this.vbmuxList.firstElement();
                this.deleteFromMuxPool(vbMultiplexMap);
                SnmpRequest snmpRequest = vbMultiplexMap.getRequest();
                snmpRequest.action();
                return;
            }
            try {
                if (this.multiplexReq == null) {
                    this.multiplexReq = new SnmpRequest(this.getSnmpSession(), this.getPeer(), this, this.getCommand());
                    this.multiplexReq.setOptions(6);
                    this.multiplexReq.setInternalRequest();
                }
                if (logger.finerOn()) {
                    logger.finer("action", "Multiplex request just before firing\n" + this.debugMultiplexing());
                }
                this.multiplexReq.start(this.multiplexVb, false, 0L);
            }
            catch (Exception exception) {
                if (!logger.finestOn()) break block6;
                logger.finest("action", exception);
            }
        }
    }

    public final synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(500);
        int n = 0;
        Enumeration enumeration = this.getElements();
        stringBuffer.append(this.getPeer().toString());
        stringBuffer.append(" -> Requests being Multiplexed = ");
        while (enumeration.hasMoreElements()) {
            VbMultiplexMap vbMultiplexMap = (VbMultiplexMap)enumeration.nextElement();
            SnmpRequest snmpRequest = vbMultiplexMap.getRequest();
            stringBuffer.append(snmpRequest.getRequestId() + ", ");
            n += snmpRequest.getVarBindList().size();
        }
        stringBuffer.append("\nTotal varBind count of all requests = " + n);
        if (this.multiplexVb == null) {
            stringBuffer.append("   Multiplexed varBind not initialized.");
        } else {
            stringBuffer.append("    Multiplexed varBind count = " + this.multiplexVb.size());
        }
        stringBuffer.append("\nCorresponding Multiplex Request Status : \n");
        if (this.multiplexReq != null) {
            stringBuffer.append(this.multiplexReq.toString());
        } else {
            stringBuffer.append("Not created yet!! ");
        }
        return stringBuffer.toString();
    }

    public synchronized void cancel(SnmpRequest snmpRequest) {
        this.deleteFromMuxPool(snmpRequest);
        SnmpVarBindList snmpVarBindList = snmpRequest.getVarBindList().cloneWithoutValue();
        snmpRequest.setVarBindList(snmpVarBindList);
    }

    public synchronized void processSnmpPollData(SnmpRequest snmpRequest, int n, int n2, SnmpVarBindList snmpVarBindList) {
        switch (n) {
            case 0: {
                this.handleSuccess(snmpVarBindList);
                break;
            }
            case 1: {
                if (logger.finestOn()) {
                    logger.finest("processSnmpPollData", "Too-big error while multiplexing");
                }
            }
            default: {
                this.handleError(snmpVarBindList, n, n2);
            }
        }
    }

    public synchronized void processSnmpPollTimeout(SnmpRequest snmpRequest) {
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            VbMultiplexMap vbMultiplexMap = (VbMultiplexMap)enumeration.nextElement();
            SnmpRequest snmpRequest2 = vbMultiplexMap.getRequest();
            if (!snmpRequest2.inProgress()) continue;
            snmpRequest2.setErrorStatusAndIndex(224, 0);
            snmpRequest2.setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
            if (logger.finestOn()) {
                logger.finest("processSnmpPollTimeout", "Timeout occured while processing multiplexed request");
            }
            snmpRequest2.invokeOnResponse(null);
        }
        this.clearMuxPool();
    }

    public synchronized void processSnmpInternalError(SnmpRequest snmpRequest, String string) {
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            VbMultiplexMap vbMultiplexMap = (VbMultiplexMap)enumeration.nextElement();
            SnmpRequest snmpRequest2 = vbMultiplexMap.getRequest();
            if (!snmpRequest2.inProgress()) continue;
            snmpRequest2.setErrorStatusAndIndex(240, 0);
            snmpRequest2.setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
            if (logger.finestOn()) {
                logger.finest("processSnmpInternalError", "Internal error while processing multiplexed request");
            }
            snmpRequest2.invokeOnResponse(null);
        }
        this.clearMuxPool();
    }

    public synchronized String debugMultiplexing() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("\nMultiplex Object Description BEGIN=> \n");
        stringBuffer.append(this.toString() + nl);
        stringBuffer.append("\nMultiplex VarBindList-> \n");
        stringBuffer.append(this.multiplexVb.oidListToString());
        stringBuffer.append("\nIndividual Request Description .....\n");
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            VbMultiplexMap vbMultiplexMap = (VbMultiplexMap)enumeration.nextElement();
            SnmpRequest snmpRequest = vbMultiplexMap.getRequest();
            stringBuffer.append("\nRequestId = " + snmpRequest.getRequestId());
            stringBuffer.append(nl + snmpRequest.getVarBindList().oidListToString());
        }
        stringBuffer.append("\nMultiplex Object Description ENDS=> \n");
        return stringBuffer.toString();
    }

    private synchronized void buildMultiplexVblist(SnmpRequest snmpRequest) {
        VbMultiplexMap vbMultiplexMap = new VbMultiplexMap(snmpRequest);
        vbMultiplexMap.compress(this.multiplexVb);
        snmpRequest.setProxyObject(this);
        this.addToMuxPool(vbMultiplexMap);
    }

    private void addToMuxPool(VbMultiplexMap vbMultiplexMap) {
        this.vbmuxList.addElement(vbMultiplexMap);
    }

    private void deleteFromMuxPool(VbMultiplexMap vbMultiplexMap) {
        this.vbmuxList.removeElement(vbMultiplexMap);
        vbMultiplexMap.getRequest().setProxyObject(null);
    }

    private void deleteFromMuxPool(SnmpRequest snmpRequest) {
        this.vbmuxList.removeElement(snmpRequest);
        snmpRequest.setProxyObject(null);
    }

    private void clearMuxPool() {
        this.vbmuxList.removeAllElements();
    }

    synchronized void handleError(SnmpVarBindList snmpVarBindList, int n, int n2) {
        SnmpRequest snmpRequest;
        Object object;
        Enumeration enumeration = this.getElements();
        Vector<SnmpRequest> vector = new Vector<SnmpRequest>();
        while (enumeration.hasMoreElements()) {
            object = (VbMultiplexMap)enumeration.nextElement();
            snmpRequest = ((VbMultiplexMap)object).getRequest();
            if (!snmpRequest.inProgress()) continue;
            int n3 = ((VbMultiplexMap)object).findMatchIndex(n2);
            if (n3 < 0) {
                vector.addElement(snmpRequest);
                continue;
            }
            snmpRequest.setErrorStatusAndIndex(n, n3);
            snmpRequest.setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
            snmpRequest.invokeOnResponse(null);
        }
        if (vector.isEmpty()) {
            return;
        }
        this.clearMuxPool();
        object = vector.elements();
        while (object.hasMoreElements()) {
            snmpRequest = (SnmpRequest)object.nextElement();
            this.buildMultiplexVblist(snmpRequest);
        }
        this.action();
    }

    synchronized void handleSuccess(SnmpVarBindList snmpVarBindList) {
        Object object;
        Object object2;
        Object object3;
        Enumeration enumeration = this.getElements();
        Timestamp timestamp = snmpVarBindList.getTimestamp();
        while (enumeration.hasMoreElements()) {
            object3 = (VbMultiplexMap)enumeration.nextElement();
            object2 = ((VbMultiplexMap)object3).getRequest();
            if (!((SnmpRequest)object2).inProgress()) continue;
            ((SnmpRequest)object2).setErrorStatusAndIndex(0, 0);
            if (this.command == 161) {
                ((VbMultiplexMap)object3).uncompressAndCopyVar(this.multiplexVb);
            } else {
                ((VbMultiplexMap)object3).uncompressAndCopyValue(this.multiplexVb);
            }
            ((SnmpRequest)object2).getVarBindList().setTimestamp(timestamp);
            ((SnmpRequest)object2).setPreviousPollTimestamp(this.multiplexReq.getPollTimestamp());
        }
        if (logger.finestOn()) {
            object3 = new StringBuffer(1024);
            ((StringBuffer)object3).append("Received successsful response to demultiplexed request...\n");
            ((StringBuffer)object3).append(snmpVarBindList.varBindListToString());
            ((StringBuffer)object3).append("Individual requestBreakup follows :::\n");
            object2 = this.getElements();
            while (object2.hasMoreElements()) {
                object = (VbMultiplexMap)object2.nextElement();
                SnmpRequest snmpRequest = ((VbMultiplexMap)object).getRequest();
                if (!snmpRequest.inProgress()) continue;
                ((StringBuffer)object3).append("\nDemultiplexed Request = " + snmpRequest.getRequestId());
                ((StringBuffer)object3).append(nl + snmpRequest.getVarBindList().varBindListToString() + nl);
            }
            logger.finest("handleSuccess", "Demultiplexing Request as follows:\n" + ((StringBuffer)object3).toString());
        }
        object3 = this.getElements();
        while (object3.hasMoreElements()) {
            object2 = (VbMultiplexMap)object3.nextElement();
            object = ((VbMultiplexMap)object2).getRequest();
            ((SnmpRequest)object).invokeOnResponse(null);
        }
    }

    final class VbMultiplexMap {
        SnmpRequest thereq;
        SnmpVarBindList vblst;
        int[] mapidx;
        int size = 0;

        public VbMultiplexMap(SnmpRequest snmpRequest) {
            this.thereq = snmpRequest;
            this.vblst = this.thereq.getVarBindList();
            this.size = this.vblst.size();
            this.mapidx = new int[this.size];
        }

        synchronized SnmpRequest getRequest() {
            return this.thereq;
        }

        public final synchronized boolean equals(Object object) {
            if (object instanceof SnmpRequest) {
                return this.thereq == object;
            }
            return super.equals(object);
        }

        synchronized void compress(SnmpVarBindList snmpVarBindList) {
            int n = snmpVarBindList.size();
            if (n == 0) {
                snmpVarBindList.concat(this.vblst);
                this.mapidx = null;
                return;
            }
            for (int i = 0; i < this.size; ++i) {
                SnmpVarBind snmpVarBind = this.vblst.getVarBindAt(i);
                int n2 = snmpVarBindList.indexOfOid(snmpVarBind, 0, n);
                if (n2 < 0) {
                    snmpVarBindList.addVarBind(snmpVarBind);
                    this.mapidx[i] = snmpVarBindList.size() * -1;
                    continue;
                }
                this.mapidx[i] = n2;
            }
        }

        synchronized void uncompressAndCopyValue(SnmpVarBindList snmpVarBindList) {
            if (this.mapidx == null) {
                return;
            }
            for (int i = 0; i < this.mapidx.length; ++i) {
                int n = this.mapidx[i];
                if (n < 0) continue;
                SnmpVarBind snmpVarBind = snmpVarBindList.getVarBindAt(n);
                this.vblst.getVarBindAt(i).copyValue(snmpVarBind);
            }
        }

        synchronized void uncompressAndCopyVar(SnmpVarBindList snmpVarBindList) {
            if (this.mapidx == null) {
                return;
            }
            for (int i = 0; i < this.mapidx.length; ++i) {
                int n = this.mapidx[i];
                if (n < 0) continue;
                SnmpVarBind snmpVarBind = snmpVarBindList.getVarBindAt(n);
                this.vblst.getVarBindAt(i).copyValueAndOid(snmpVarBind);
            }
        }

        synchronized int findMatchIndex(int n) {
            if (this.mapidx == null) {
                if (n < this.size) {
                    return n;
                }
                return -1;
            }
            for (int i = 0; i < this.mapidx.length; ++i) {
                int n2 = this.mapidx[i];
                if (n2 != n && -n2 != n) continue;
                return i;
            }
            return -1;
        }
    }
}

