/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpResponseHandler;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

final class SnmpSocket
implements Runnable {
    int responseBufSize = SnmpPeer.defaultSnmpResponsePktSize;
    int _socketPort = 0;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpSocket");
    String dbgTag = "SnmpSocket";
    boolean isBeingDestroyed = false;
    private int _pktsSent = 0;
    private int _pktsRecvd = 0;
    private int _errors = 0;
    private final SnmpResponseHandler _dgramHdlr;
    private Thread _sockThread = null;
    private transient boolean isClosing = false;
    private DatagramSocket _socket;
    private byte[] _buffer = null;

    public SnmpSocket(SnmpResponseHandler snmpResponseHandler) throws SocketException {
        this(snmpResponseHandler, null, 0);
    }

    public SnmpSocket(SnmpResponseHandler snmpResponseHandler, InetAddress inetAddress, int n) throws SocketException {
        if (logger.finerOn()) {
            logger.finer("constructor", "Creating new SNMP datagram socket");
        }
        this._socket = inetAddress == null ? new DatagramSocket() : new DatagramSocket(n, inetAddress);
        this._socketPort = this._socket.getLocalPort();
        this._buffer = new byte[this.responseBufSize];
        this._dgramHdlr = snmpResponseHandler;
        this._sockThread = new Thread(this);
        this._sockThread.start();
    }

    public final synchronized int getPktsErrors() {
        return this._errors;
    }

    public final synchronized int getInPkts() {
        return this._pktsRecvd;
    }

    public final synchronized int getOutPkts() {
        return this._pktsSent;
    }

    public final synchronized void performResetPktStatistics() {
        this._pktsSent = 0;
        this._pktsRecvd = 0;
        this._errors = 0;
    }

    public synchronized String toString() {
        String string = "SnmpSocket : ";
        string = this.isValid() ? string + this._socket.toString() : string + "Socket invalid state. ";
        string = string + " Pkts Sent = " + this._pktsSent + " Pkts Recvd = " + this._pktsRecvd + " Errors = " + this._errors;
        return string;
    }

    public final int getResponsePktSize() {
        return this.responseBufSize;
    }

    public final synchronized void setResponsePktSize(int n) {
        if (this.responseBufSize != n) {
            this.responseBufSize = n;
            this._buffer = new byte[this.responseBufSize];
        }
    }

    public synchronized void sendPacket(byte[] byArray, int n, InetAddress inetAddress, int n2) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n, inetAddress, n2);
        this.sendPacket(datagramPacket);
    }

    public synchronized void sendPacket(DatagramPacket datagramPacket) throws IOException {
        block5: {
            try {
                if (this.isValid()) {
                    if (logger.finerOn()) {
                        logger.finer("sendPacket", "Sending DatagramPacket. Length = " + datagramPacket.getLength() + " through socket = " + this._socket.toString());
                    }
                    this._socket.send(datagramPacket);
                    ++this._pktsSent;
                    break block5;
                }
                throw new IOException("Invalid state of SNMP datagram socket.");
            }
            catch (IOException iOException) {
                if (logger.finestOn()) {
                    logger.finest("sendPacket", "Io error while sending");
                    logger.finest("sendPacket", iOException);
                }
                ++this._errors;
                throw iOException;
            }
        }
    }

    public synchronized boolean isValid() {
        return this._socket != null && this._sockThread != null && this._sockThread.isAlive();
    }

    public synchronized void close() {
        this.isClosing = true;
        if (logger.finerOn()) {
            logger.finer("close", "Closing and destroying the SNMP datagram socket -> " + this.toString());
        }
        try {
            DatagramSocket datagramSocket = new DatagramSocket(0);
            byte[] byArray = new byte[1];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, 1, InetAddress.getLocalHost(), this._socketPort);
            datagramSocket.send(datagramPacket);
            datagramSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (this._sockThread != null && this._sockThread.isAlive()) {
            this._sockThread.interrupt();
            try {
                this._sockThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._sockThread = null;
        }
    }

    private synchronized void handleJavaError(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            if (logger.finestOn()) {
                logger.finest("handleJavaError", throwable);
            }
            Thread.currentThread();
            Thread.yield();
            return;
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (logger.finestOn()) {
            logger.finest("handleJavaError", "Global Internal error");
        }
        Thread.currentThread();
        Thread.yield();
    }

    public void run() {
        Thread.currentThread().setPriority(8);
        block5: while (true) {
            try {
                while (true) {
                    DatagramPacket datagramPacket = new DatagramPacket(this._buffer, this._buffer.length);
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Blocking for receiving packet");
                    }
                    this._socket.receive(datagramPacket);
                    if (this.isBeingDestroyed || this.isClosing) break block5;
                    ++this._pktsRecvd;
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet");
                    }
                    if (datagramPacket.getLength() <= 0) continue;
                    if (logger.finerOn()) {
                        logger.finer("run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet from : " + datagramPacket.getAddress().toString() + ", Length = " + datagramPacket.getLength());
                    }
                    this.handleDatagram(datagramPacket);
                    if (this.isClosing) break;
                }
            }
            catch (IOException iOException) {
                if (this.isClosing) break;
                ++this._errors;
                if (!logger.finestOn()) continue;
                logger.finest("run", iOException);
                continue;
            }
            catch (Exception exception) {
                if (this.isClosing) break;
                ++this._errors;
                if (!logger.finestOn()) continue;
                logger.finest("run", "Exception in socket thread...");
                logger.finest("run", exception);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                ++this._errors;
                if (logger.finestOn()) {
                    logger.finest("run", "Socket Thread DEAD..." + this.toString());
                    logger.finest("run", threadDeath);
                }
                this.close();
                throw threadDeath;
            }
            catch (Error error) {
                ++this._errors;
                if (logger.finestOn()) {
                    logger.finest("run", error);
                }
                this.handleJavaError(error);
                continue;
            }
            break;
        }
    }

    private void handleDatagram(DatagramPacket datagramPacket) {
        this._dgramHdlr.processDatagram(datagramPacket);
    }

    public synchronized void finalize() {
        this.close();
    }
}

