/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager.usm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpUnknownModelException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.manager.SnmpParams;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpSession;
import com.sun.management.snmp.manager.SnmpV3Parameters;
import com.sun.management.snmp.manager.usm.SnmpUsmParameters;
import com.sun.management.snmp.usm.SnmpUsm;
import com.sun.management.snmp.usm.SnmpUsmEnginePeer;
import com.sun.management.snmp.usm.SnmpUsmSecurityParameters;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpUsmPeer
extends SnmpPeer {
    private static final long serialVersionUID = -4395909104949922299L;
    SnmpUsmEnginePeer peer = null;
    SnmpEngineImpl engine = null;
    SnmpUsm model = null;
    private boolean authoritative = false;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpUsmPeer");
    String dbgTag = "SnmpUsmPeer";

    public SnmpUsmPeer(SnmpEngine snmpEngine, String string) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(string);
        this.init(snmpEngine, null, true);
    }

    public SnmpUsmPeer(SnmpEngine snmpEngine, InetAddress inetAddress) throws SnmpUnknownModelException, SnmpStatusException {
        super(inetAddress);
        this.init(snmpEngine, null, true);
    }

    public SnmpUsmPeer(SnmpEngine snmpEngine, String string, int n) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(string, n);
        this.init(snmpEngine, null, true);
    }

    public SnmpUsmPeer(SnmpEngine snmpEngine, String string, SnmpEngineId snmpEngineId) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(string);
        if (snmpEngineId == null) {
            this.authoritative = true;
        }
        this.init(snmpEngine, snmpEngineId, false);
    }

    public SnmpUsmPeer(SnmpEngine snmpEngine, InetAddress inetAddress, SnmpEngineId snmpEngineId) throws SnmpUnknownModelException, SnmpStatusException {
        super(inetAddress);
        if (snmpEngineId == null) {
            this.authoritative = true;
        }
        this.init(snmpEngine, snmpEngineId, false);
    }

    public SnmpUsmPeer(SnmpEngine snmpEngine, String string, int n, SnmpEngineId snmpEngineId) throws UnknownHostException, SnmpUnknownModelException, SnmpStatusException {
        super(string, n);
        if (snmpEngineId == null) {
            this.authoritative = true;
        }
        this.init(snmpEngine, snmpEngineId, false);
    }

    private void init(SnmpEngine snmpEngine, SnmpEngineId snmpEngineId, boolean bl) throws SnmpUnknownModelException, SnmpStatusException {
        this.engine = (SnmpEngineImpl)snmpEngine;
        this.model = (SnmpUsm)this.engine.getSecuritySubSystem().getModel(3);
        if (bl) {
            this.processEngineIdDiscovery();
        } else {
            this.setEngineId(snmpEngineId);
        }
        if (this.engine.getEngineId().equals(this.getEngineId())) {
            if (logger.finerOn()) {
                logger.finer("init", "Warning, discovered engine id [" + this.getEngineId() + "] is equal to local one [" + this.engine.getEngineId() + "] \n");
            }
            throw new SnmpStatusException("Discovered engine id [ " + this.getEngineId() + "] is equal to local one [" + this.engine.getEngineId() + "]");
        }
    }

    public boolean isTimelinessSynchronized() {
        if (this.peer == null) {
            return false;
        }
        return this.peer.getAuthoritativeEngineBoots() != 0 || this.peer.getAuthoritativeEngineTime() != 0;
    }

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    public int getEngineBoots() {
        if (this.peer == null) {
            return 0;
        }
        return this.peer.getAuthoritativeEngineBoots();
    }

    public int getEngineTime() {
        if (this.peer == null) {
            return 0;
        }
        return this.peer.getAuthoritativeEngineTime();
    }

    private void setEngineId(SnmpEngineId snmpEngineId) {
        if (snmpEngineId != null) {
            this.peer = this.model.getEnginePeer(snmpEngineId);
        }
    }

    public SnmpEngineId getEngineId() {
        if (this.peer == null) {
            return null;
        }
        return this.peer.getAuthoritativeEngineId();
    }

    public void processUsmTimelinessDiscovery() throws SnmpStatusException {
        if (this.peer == null) {
            throw new IllegalArgumentException("No engine Id, this peer can't be used for timeliness discovery.");
        }
        if (this.getParams() instanceof SnmpUsmParameters) {
            SnmpUsmParameters snmpUsmParameters = (SnmpUsmParameters)this.getParams();
            if ((snmpUsmParameters.getSecurityLevel() & 1) != 0) {
                if (snmpUsmParameters.getPrincipal() != null) {
                    this.processUsmDiscovery(snmpUsmParameters.getPrincipal());
                    return;
                }
            } else {
                if (logger.finestOn()) {
                    logger.finest("processUsmTimelinessDiscovery", "Discovery must be done in an authenticated way.");
                }
                throw new SnmpStatusException(249, 0);
            }
        }
        if (logger.finestOn()) {
            logger.finest("processUsmTimelinessDiscovery", "Parameters are not SnmpUsmParameters. Can't process discovery");
        }
        throw new SnmpStatusException("Parameters are not SnmpUsmParameters. Can't process discovery");
    }

    public void setParams(SnmpParams snmpParams) {
        if (snmpParams instanceof SnmpUsmParameters) {
            SnmpUsmParameters snmpUsmParameters = (SnmpUsmParameters)snmpParams;
            snmpUsmParameters.setEngineId(this.getEngineId());
        }
        super.setParams(snmpParams);
    }

    SnmpUsm getSecurityModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEngineIdDiscovery() throws SnmpStatusException {
        SnmpParams snmpParams = null;
        SnmpSession snmpSession = null;
        if (this.peer == null) {
            try {
                snmpParams = this.getParams();
                SnmpUsmParameters snmpUsmParameters = null;
                try {
                    snmpUsmParameters = new SnmpUsmParameters(this.engine);
                }
                catch (SnmpUnknownModelException snmpUnknownModelException) {
                    if (logger.finerOn()) {
                        logger.finer("processEngineIdDiscovery", "Failed " + snmpUnknownModelException);
                    }
                    this.setParams(snmpParams);
                    snmpSession.destroySession();
                    return;
                }
                SnmpUsmSecurityParameters snmpUsmSecurityParameters = (SnmpUsmSecurityParameters)snmpUsmParameters.getSecurityParameters();
                this.setParams(snmpUsmParameters);
                snmpSession = new SnmpSession(this.engine, "Discovery session", this);
                this.discoverEngineId(snmpSession, snmpUsmParameters);
                if (logger.finerOn()) {
                    logger.finer("processEngineIdDiscovery", "Engine Id : " + this.getEngineId());
                }
            }
            finally {
                this.setParams(snmpParams);
                snmpSession.destroySession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUsmDiscovery(String string) throws SnmpStatusException {
        SnmpParams snmpParams = this.getParams();
        SnmpUsmParameters snmpUsmParameters = null;
        try {
            snmpUsmParameters = new SnmpUsmParameters(this.engine, string);
        }
        catch (SnmpUnknownModelException snmpUnknownModelException) {
            if (logger.finerOn()) {
                logger.finer("processUsmDiscovery", "Failed. Can't happen." + snmpUnknownModelException);
            }
            return;
        }
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = (SnmpUsmSecurityParameters)snmpUsmParameters.getSecurityParameters();
        this.setParams(snmpUsmParameters);
        SnmpSession snmpSession = new SnmpSession(this.engine, "Discovery session", this);
        try {
            if (this.peer == null) {
                this.discoverEngineId(snmpSession, snmpUsmParameters);
            } else {
                this.peer.reset();
            }
            snmpUsmSecurityParameters.setAuthoritativeEngineId(this.getEngineId());
            this.discoverTimelinessParams(snmpSession, snmpUsmParameters);
            if (logger.finerOn()) {
                logger.finer("processUsmDiscovery", "Result :\nEngine Id : " + this.getEngineId() + "\n" + "Engine nb boots : " + this.getEngineBoots() + "\n" + "Engine time : " + this.getEngineTime());
            }
        }
        finally {
            this.setParams(snmpParams);
            snmpSession.destroySession();
        }
    }

    private void discoverEngineId(SnmpSession snmpSession, SnmpV3Parameters snmpV3Parameters) throws SnmpStatusException {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = (SnmpUsmSecurityParameters)snmpV3Parameters.getSecurityParameters();
        snmpUsmSecurityParameters.setAuthoritativeEngineBoots(0);
        snmpUsmSecurityParameters.setAuthoritativeEngineTime(0);
        snmpV3Parameters.setSecurityLevel(0);
        SnmpRequest snmpRequest = snmpSession.snmpGetRequest(this, null, snmpVarBindList);
        boolean bl = snmpRequest.waitForCompletion(this.getTimeout());
        if (!bl || snmpRequest.getErrorStatus() != 0 || !snmpRequest.isReport()) {
            if (logger.finestOn()) {
                logger.finest("discoverEngineId", "An error occurred when processing Engine discovery. Request status : " + SnmpRequest.snmpErrorToString(snmpRequest.getErrorStatus()));
            }
            if (snmpRequest.getErrorStatus() == 247 && logger.finestOn()) {
                logger.finest("discoverEngineId", "The received engine Id is invalid or is equal to the local one.");
            }
            throw new SnmpStatusException(snmpRequest.getErrorStatus());
        }
        SnmpUsmSecurityParameters snmpUsmSecurityParameters2 = (SnmpUsmSecurityParameters)snmpRequest.getResponseSecurityParameters();
        this.setEngineId(snmpUsmSecurityParameters2.getAuthoritativeEngineId());
        if (logger.finestOn()) {
            logger.finest("discoverEngineId", "Result :\nEngine Id : " + this.getEngineId());
        }
    }

    private void discoverTimelinessParams(SnmpSession snmpSession, SnmpV3Parameters snmpV3Parameters) throws SnmpStatusException {
        SnmpVarBindList snmpVarBindList = new SnmpVarBindList();
        SnmpUsmSecurityParameters snmpUsmSecurityParameters = (SnmpUsmSecurityParameters)snmpV3Parameters.getSecurityParameters();
        snmpUsmSecurityParameters.setAuthoritativeEngineBoots(0);
        snmpUsmSecurityParameters.setAuthoritativeEngineTime(0);
        snmpV3Parameters.setSecurityLevel(1);
        SnmpRequest snmpRequest = snmpSession.snmpGetRequest(this, null, snmpVarBindList);
        boolean bl = snmpRequest.waitForCompletion(this.getTimeout());
        if (!bl || snmpRequest.getErrorStatus() != 0 || !snmpRequest.isReport()) {
            if (logger.finestOn()) {
                logger.finest("discoverTimelinessParams", "An error occurred when processing Engine discovery. Request status : " + SnmpRequest.snmpErrorToString(snmpRequest.getErrorStatus()));
            }
            throw new SnmpStatusException(snmpRequest.getErrorStatus());
        }
        if (snmpRequest.isReport()) {
            SnmpVarBind snmpVarBind;
            SnmpOid snmpOid;
            SnmpOid snmpOid2;
            SnmpVarBindList snmpVarBindList2 = snmpRequest.getReportVarBindList();
            if (snmpVarBindList2.size() == 0) {
                throw new SnmpStatusException("Received an empty report");
            }
            if (logger.finestOn()) {
                logger.finest("discoverTimelinessParams", "Received a report, list size is : " + snmpVarBindList2.size());
            }
            if ((snmpOid2 = new SnmpOid("1.3.6.1.6.3.15.1.1.2.0")).equals(snmpOid = (snmpVarBind = snmpVarBindList2.getVarBindAt(0)).getOid())) {
                if (logger.finestOn()) {
                    logger.finest("discoverTimelinessParams", "Received a notInTimeWindow report. Discovery suceeded.");
                }
            } else {
                throw new SnmpStatusException("An error occurred when processing Engine discovery. Not received the right report : " + snmpOid + ". Expected notInTimeWindow [1.3.6.1.6.3.15.1.1.2.0]");
            }
        }
        if (logger.finestOn()) {
            logger.finest("discoverTimelinessParams", "Result :\nEngine nb boots : " + this.getEngineBoots() + "\n" + "Engine time : " + this.getEngineTime());
        }
    }
}

