/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.uacl;

import com.sun.jdmk.defaults.DefaultPaths;
import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.snmp.UserAcl;
import com.sun.management.snmp.uacl.AclEntryImpl;
import com.sun.management.snmp.uacl.AclImpl;
import com.sun.management.snmp.uacl.ParseException;
import com.sun.management.snmp.uacl.Parser;
import com.sun.management.snmp.uacl.PermissionImpl;
import com.sun.management.snmp.uacl.PrincipalImpl;
import com.sun.management.snmp.uacl.SimpleNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;

public class JdmkUserAcl
implements UserAcl,
Serializable {
    private static final long serialVersionUID = 792943185727781789L;
    static final PermissionImpl READ = new PermissionImpl("READ");
    static final PermissionImpl WRITE = new PermissionImpl("WRITE");
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "JdmkUserAcl");
    String dbgTag;
    private AclImpl acl;
    private boolean alwaysAuthorized;
    private String authorizedListFile;
    private Hashtable trapDestList;
    private Hashtable informDestList;
    private PrincipalImpl owner;

    public JdmkUserAcl(String string, String string2) throws IllegalArgumentException {
        block4: {
            this.dbgTag = "JdmkUserAcl";
            this.acl = null;
            this.alwaysAuthorized = false;
            this.authorizedListFile = null;
            this.trapDestList = null;
            this.informDestList = null;
            this.owner = null;
            this.trapDestList = new Hashtable();
            this.informDestList = new Hashtable();
            this.owner = new PrincipalImpl();
            try {
                this.acl = new AclImpl(this.owner, string);
                AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
                aclEntryImpl.addPermission(READ);
                aclEntryImpl.addPermission(WRITE);
                this.acl.addEntry(this.owner, aclEntryImpl);
            }
            catch (NotOwnerException notOwnerException) {
                if (!logger.finestOn()) break block4;
                logger.finest("constructor", "Should never get NotOwnerException as the owner is built in this constructor");
            }
        }
        if (string2 == null) {
            this.setDefautFileName();
        } else {
            this.authorizedListFile = string2;
        }
        this.readAuthorisedListFile();
    }

    public JdmkUserAcl(String string) throws IllegalArgumentException {
        this(string, null);
    }

    public synchronized Enumeration entries() {
        return this.acl.entries();
    }

    public synchronized String getName() {
        return this.acl.getName();
    }

    public static PermissionImpl getREAD() {
        return READ;
    }

    public static PermissionImpl getWRITE() {
        return WRITE;
    }

    public synchronized void setAuthorizedListFile(String string) throws IllegalArgumentException, NotOwnerException {
        if (string == null) {
            throw new IllegalArgumentException("The specified file is null");
        }
        File file = new File(string);
        if (!file.isFile()) {
            if (logger.finestOn()) {
                logger.finest("setAuthorizedListFile", "User ACL file not found. Wrong passed file : " + string);
            }
            throw new IllegalArgumentException("The specified file [" + string + "] doesn't exist or is not a file, no configuration loaded");
        }
        if (logger.finerOn()) {
            logger.finer("setAuthorizedListFile", "Default file set to " + string);
        }
        this.authorizedListFile = string;
        this.rereadTheFile();
    }

    public synchronized void rereadTheFile() throws NotOwnerException {
        this.alwaysAuthorized = false;
        this.acl.removeAll(this.owner);
        this.trapDestList.clear();
        this.informDestList.clear();
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
        aclEntryImpl.addPermission(READ);
        aclEntryImpl.addPermission(WRITE);
        this.acl.addEntry(this.owner, aclEntryImpl);
        this.readAuthorisedListFile();
    }

    public synchronized String getAuthorizedListFile() {
        return this.authorizedListFile;
    }

    public synchronized boolean checkReadPermission(String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(string);
        return this.acl.checkPermission(principalImpl, READ);
    }

    public synchronized boolean checkReadPermission(String string, String string2, int n) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(string);
        return this.acl.checkPermission(principalImpl, string2, n, READ);
    }

    public synchronized boolean checkContextName(String string) {
        return this.acl.checkContextName(string);
    }

    public synchronized boolean checkWritePermission(String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(string);
        return this.acl.checkPermission(principalImpl, WRITE);
    }

    public synchronized boolean checkWritePermission(String string, String string2, int n) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(string);
        return this.acl.checkPermission(principalImpl, string2, n, WRITE);
    }

    private static void checkCanRead(String string) throws IllegalArgumentException {
        File file = new File(string);
        if (file.isFile() && !file.canRead()) {
            throw new IllegalArgumentException("User ACL file is not readable.");
        }
    }

    private void readAuthorisedListFile() {
        this.alwaysAuthorized = false;
        if (this.authorizedListFile == null) {
            if (logger.finerOn()) {
                logger.finer("readAuthorisedListFile", "alwaysAuthorized set to true");
            }
            this.alwaysAuthorized = true;
        } else {
            Object object;
            Parser parser = null;
            try {
                JdmkUserAcl.checkCanRead(this.getAuthorizedListFile());
                parser = new Parser(new FileInputStream(this.getAuthorizedListFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "The specified file was not found, authorize everybody");
                }
                this.alwaysAuthorized = true;
                return;
            }
            try {
                object = parser.SecurityDefs();
                ((SimpleNode)object).buildAclEntries(this.owner, this.acl);
                ((SimpleNode)object).buildTrapEntries(this.trapDestList);
                ((SimpleNode)object).buildInformEntries(this.informDestList);
            }
            catch (ParseException parseException) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "Parsing exception " + parseException);
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Syntax error: " + parseException);
                Utils.initCause(illegalArgumentException, parseException);
                throw illegalArgumentException;
            }
            catch (Error error) {
                if (logger.finestOn()) {
                    logger.finest("readAuthorisedListFile", "Error exception " + error);
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error: " + error);
                Utils.initCause(illegalArgumentException, error);
                throw illegalArgumentException;
            }
            object = this.acl.entries();
            while (object.hasMoreElements()) {
                AclEntryImpl aclEntryImpl = (AclEntryImpl)object.nextElement();
                if (logger.finerOn()) {
                    logger.finer("readAuthorisedListFile", "===> " + ((Object)aclEntryImpl.getPrincipal()).toString());
                }
                Enumeration enumeration = aclEntryImpl.permissions();
                while (enumeration.hasMoreElements()) {
                    Permission permission = (Permission)enumeration.nextElement();
                    if (!logger.finerOn()) continue;
                    logger.finer("readAuthorisedListFile", "perm = " + permission);
                }
            }
        }
    }

    private void setDefautFileName() throws IllegalArgumentException {
        String string = null;
        File file = null;
        string = System.getProperty("jdmk.uacl.file");
        if (string == null) {
            string = DefaultPaths.getEtcDir("conf" + File.separator + "jdmk.uacl");
            if (logger.finestOn()) {
                logger.finest("setDefautFileName", "Default File name is : " + string);
            }
            if ((file = new File(string)).isFile()) {
                if (logger.finerOn()) {
                    logger.finer("setDefautFileName", "Default User ACL file found : " + string);
                }
            } else if (logger.finestOn()) {
                logger.finest("setDefautFileName", "Default User ACL file not found.");
            }
        } else {
            file = new File(string);
            if (!file.isFile()) {
                if (logger.finestOn()) {
                    logger.finest("setDefautFileName", "User ACL file not found. Wrong java property : jdmk.uacl.file=" + string);
                }
                throw new IllegalArgumentException("The specified file [" + file + "] doesn't exist or is not a file, no configuration loaded");
            }
            if (logger.finerOn()) {
                logger.finer("setDefautFileName", "User ACL file found : " + string);
            }
        }
        this.authorizedListFile = string;
    }
}

